/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.mm.qm.QIBizTypeInfo;
import com.kingdee.eas.basedata.mm.qm.QIItemInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardCollection;
import com.kingdee.eas.basedata.mm.qm.QIStandardEntryCollection;
import com.kingdee.eas.basedata.mm.qm.QIStandardEntryFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardEntryInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardInfo;
import com.kingdee.eas.basedata.mm.qm.QIStdMaterialCollection;
import com.kingdee.eas.basedata.mm.qm.QIStdMaterialFactory;
import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;

public abstract class QIStandardUtils {
    public static QIStandardInfo getQIStandardByMaterial(MaterialInfo material) throws BOSException {
        if (null == material || null == material.getId()) {
            return null;
        }
        return QIStandardFactory.getRemoteInstance().getQIStandardByMaterial(material.getId().toString());
    }

    public static QIStandardInfo getQIStandardByMaterial(MaterialInfo material, QIBizTypeInfo qibiztype) throws BOSException {
        if (null == material || null == material.getId()) {
            return null;
        }
        String qibiztypeid = null;
        if (null != qibiztype && null != qibiztype.getId()) {
            qibiztypeid = qibiztype.getId().toString();
        }
        return QIStandardFactory.getRemoteInstance().getQIStandardByMaterial(material.getId().toString(), qibiztypeid);
    }

    public static QIStandardCollection getQIStandardsByMaterial(MaterialInfo material) throws BOSException {
        FilterItemInfo Item = new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS);
        FilterInfo Info = new FilterInfo();
        Info.getFilterItems().add(Item);
        EntityViewInfo fromView = new EntityViewInfo();
        fromView.setFilter(Info);
        fromView.getSelector().add(new SelectorItemInfo("*"));
        fromView.getSelector().add(new SelectorItemInfo("qIStandardEntry.qiItem.name"));
        fromView.getSelector().add(new SelectorItemInfo("qIStandardEntry.*"));
        QIStandardCollection col = QIStandardFactory.getRemoteInstance().getQIStandardCollection(fromView);
        return col;
    }

    public static boolean isValidQIStandards(QIStandardInfo qi, MaterialInfo material) throws BOSException {
        if (material == null || material.getId() == null || qi == null || qi.getId() == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qi.getId().toString(), CompareType.EQUALS));
        EntityViewInfo fromView = new EntityViewInfo();
        fromView.setFilter(filter);
        fromView.getSelector().add(new SelectorItemInfo("id"));
        QIStdMaterialCollection col = QIStdMaterialFactory.getRemoteInstance().getQIStdMaterialCollection(fromView);
        return col != null && col.size() > 0;
    }

    public static MaterialInfo getFirstMaterialByQIStandards(QIStandardInfo qiStandard) throws BOSException {
        throw new BOSException("\u8d28\u91cf\u6807\u51c6\u4ee3\u7801\u7b49\u5f85\u6539\u9020\u4e2d... this moth need modify,please check...");
    }

    public static boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception("table is null!");
        }
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    public static void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection != null && detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    public static QIStandardEntryInfo getQIStdEntryInfoByQIItem(QIStandardInfo qiStandard, QIItemInfo qiItem) {
        if (qiItem == null || qiStandard == null) {
            return null;
        }
        int size = qiStandard.getQIStandardEntry().size();
        for (int i = 0; i < size; ++i) {
            QIStandardEntryInfo qiStdEntryInfo = qiStandard.getQIStandardEntry().get(i);
            if (STQMUtils.isDiffrent(qiStdEntryInfo.getQiItem(), qiItem)) continue;
            return qiStdEntryInfo;
        }
        return null;
    }

    public static QIStandardInfo fullQIStandard(String qiStandardId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)qiStandardId)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("material.*"));
            selector.add(new SelectorItemInfo("type.*"));
            selector.add(new SelectorItemInfo("qIStandardEntry.*"));
            selector.add(new SelectorItemInfo("qIStandardEntry.*"));
            selector.add(new SelectorItemInfo("qIStandardEntry.qiItem.*"));
            selector.add(new SelectorItemInfo("qIStandardEntry.unit.*"));
            selector.add(new SelectorItemInfo("qiStandardGroup.*"));
            selector.add(new SelectorItemInfo("qiBizType.*"));
            selector.add(new SelectorItemInfo("materialEntry.*"));
            selector.add(new SelectorItemInfo("materialEntry.material.*"));
            selector.add(new SelectorItemInfo("postState.*"));
            selector.add(new SelectorItemInfo("modifyType.*"));
            return QIStandardFactory.getRemoteInstance().getQIStandardInfo((IObjectPK)new ObjectStringPK(qiStandardId), selector);
        }
        return null;
    }

    public static QIStandardEntryInfo getQIStandardEntryInfoByItem(QIStandardInfo qiStandardInfo, QIItemInfo qiItemInfo) throws EASBizException, BOSException {
        if (qiStandardInfo == null || qiItemInfo == null) {
            return null;
        }
        QIStandardEntryCollection qiEntryCollection = qiStandardInfo.getQIStandardEntry();
        QIStandardEntryInfo qiEntry = null;
        Object item = null;
        int count1 = qiEntryCollection.size();
        for (int j = 0; j < count1; ++j) {
            qiEntry = QIStandardEntryFactory.getRemoteInstance().getQIStandardEntryInfo((IObjectPK)new ObjectUuidPK(qiEntryCollection.get(j).getId()));
            if (qiEntry.getQiItem().getId() == null || !qiEntry.getQiItem().getId().equals((Object)qiItemInfo.getId())) continue;
            return qiEntry;
        }
        return qiEntry;
    }
}

