/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;

public final class STBaseDataCache {
    private static HashMap materialMap = new HashMap();
    private static HashMap supplierMap = new HashMap();
    private static HashMap customerMap = new HashMap();
    private static HashMap measureUnitMap = new HashMap();

    public static synchronized MaterialInfo getMaterialInfo(Context ctx, String materialId) throws EASBizException {
        MaterialInfo material = (MaterialInfo)materialMap.get(materialId);
        if (material == null) {
            try {
                IMaterial iMaterial = null;
                iMaterial = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
                material = iMaterial.getMaterialInfo((IObjectPK)new ObjectStringPK(materialId));
                materialMap.put(materialId, material);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return material;
    }

    public static synchronized SupplierInfo getSupplierInfo(Context ctx, String supplierId) throws EASBizException {
        SupplierInfo supplier = (SupplierInfo)supplierMap.get(supplierId);
        if (supplier == null) {
            try {
                ISupplier iSupplier = null;
                iSupplier = ctx == null ? SupplierFactory.getRemoteInstance() : SupplierFactory.getLocalInstance((Context)ctx);
                supplier = iSupplier.getSupplierInfo((IObjectPK)new ObjectStringPK(supplierId));
                supplierMap.put(supplierId, supplier);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return supplier;
    }

    public static synchronized CustomerInfo getCustomerInfo(Context ctx, String customerId) throws EASBizException {
        CustomerInfo customer = (CustomerInfo)customerMap.get(customerId);
        if (customer == null) {
            try {
                ICustomer iCustomer = null;
                iCustomer = ctx == null ? CustomerFactory.getRemoteInstance() : CustomerFactory.getLocalInstance((Context)ctx);
                customer = iCustomer.getCustomerInfo((IObjectPK)new ObjectStringPK(customerId));
                customerMap.put(customerId, customer);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return customer;
    }

    public static synchronized MeasureUnitInfo getMeasureUnitInfoInfo(Context ctx, String unitId) throws EASBizException {
        MeasureUnitInfo unit = (MeasureUnitInfo)measureUnitMap.get(unitId);
        if (unit == null) {
            try {
                IMeasureUnit iSupplier = null;
                iSupplier = ctx == null ? MeasureUnitFactory.getRemoteInstance() : MeasureUnitFactory.getLocalInstance((Context)ctx);
                unit = iSupplier.getMeasureUnitInfo((IObjectPK)new ObjectStringPK(unitId));
                measureUnitMap.put(unitId, unit);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return unit;
    }
}

