/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class STQMUtils {
    private static final String resource = "com.kingdee.eas.st.common.STResource";
    private static final String VAR_LEFT = "left";
    private static final String VAR_RIGHT = "right";
    private static final String PATTERN_STRING_ADD = "left + right";
    private static final String PATTERN_STRING_SUBSTRACT = "left - right";

    public static String toIDString(String id) {
        if (id == null) {
            id = "";
        }
        return "'" + id + "'";
    }

    public static String toIDString(Object[] ids) {
        StringBuffer paramString = new StringBuffer();
        if (STQMUtils.isNotNull(ids) && ids.length != 0) {
            Object item = null;
            int j = 0;
            int c = ids.length;
            for (int i = 0; i < c; ++i) {
                item = ids[i];
                if (!STQMUtils.isNotNull(item) || item.toString().trim().length() == 0) continue;
                if (j > 0) {
                    paramString.append(",");
                }
                paramString.append("'");
                paramString.append(item.toString());
                paramString.append("'");
                ++j;
            }
        }
        if (paramString == null || paramString.length() == 0) {
            paramString.append("'0'");
        }
        return paramString.toString();
    }

    public static String toIDString(Iterator itor) {
        int count = 0;
        int stringLen = 0;
        Object o = null;
        StringBuffer paramString = new StringBuffer();
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null || o.toString().trim().length() == 0) continue;
            paramString.append("'");
            paramString.append(o.toString());
            paramString.append("',");
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            stringLen = paramString.length() - 1;
            paramString.setLength(stringLen);
        }
        return paramString.toString();
    }

    public static String toIDStringLess(Iterator itor) {
        int count = 0;
        Object o = null;
        StringBuffer paramString = new StringBuffer();
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null || o.toString().trim().length() == 0) continue;
            if (count > 0) {
                paramString.append(",");
            }
            paramString.append(o.toString());
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        }
        return paramString.toString();
    }

    public static String toParamString(Object[] ids, List params) {
        StringBuffer paramString = new StringBuffer();
        if (STQMUtils.isNotNull(ids) && ids.length != 0) {
            Object item = null;
            int j = 0;
            int c = ids.length;
            for (int i = 0; i < c; ++i) {
                item = ids[i];
                if (!STQMUtils.isNotNull(item) || item.toString().trim().length() == 0) continue;
                if (j > 0) {
                    paramString.append(",");
                }
                paramString.append(" ? ");
                params.add(item.toString());
                ++j;
            }
        }
        return paramString.toString();
    }

    public static String toParamString(Iterator itor, List params) {
        int count = 0;
        Object o = null;
        if (params == null) {
            params = new ArrayList<String>();
        }
        StringBuffer paramString = new StringBuffer("(");
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null) continue;
            if (count > 0) {
                paramString.append(",");
            }
            paramString.append(" ? ");
            params.add(o.toString());
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            paramString.append(")");
        }
        return paramString.toString();
    }

    public static IObjectValue getDynamicObject(Context ctx, String bosId) throws BOSException {
        IObjectValue objectValue = null;
        if (bosId != null && bosId.trim().length() != 0) {
            BOSUuid uuid = BOSUuid.read((String)bosId);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            IDynamicObject dynamicObject = null;
            dynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
        }
        return objectValue;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotNull(Object o) {
        return !STQMUtils.isNull(o);
    }

    public static boolean isNullString(String s) {
        return STQMUtils.isNull(s) || s.equals("");
    }

    public static String getBOSTypeStringById(String objectId) {
        BOSObjectType bosType;
        BOSUuid id;
        String s = null;
        if (!StringUtils.isEmpty((String)objectId) && STQMUtils.isNotNull(id = BOSUuid.read((String)objectId)) && STQMUtils.isNotNull(bosType = id.getType())) {
            s = bosType.toString();
        }
        return s;
    }

    public static String getLocalePropertyName(Context ctx, String propertyName) {
        return STQMUtils.getLocaleName(propertyName, ctx.getLocale());
    }

    public static String getLocaleName(String propertyName, Locale locale) {
        String ln = propertyName;
        if (!StringUtils.isEmpty((String)propertyName) && STQMUtils.isNotNull(locale)) {
            ln = propertyName + "_" + LocaleUtils.getLocaleString((Locale)locale);
        }
        return ln;
    }

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)resource, (String)strKey);
    }

    public static boolean isDiffrent(Object arg0, Object arg1) {
        boolean isChanged = false;
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            isChanged = true;
        } else if (arg0 != null && arg1 != null) {
            isChanged = arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo ? !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString()) : !arg0.equals(arg1);
        }
        return isChanged;
    }

    public static void setSelectorOfView(EntityViewInfo view, SelectorItemCollection selector) {
        if (view != null && selector != null) {
            int size = selector.size();
            for (int i = 0; i < size; ++i) {
                view.getSelector().add(selector.get(i));
            }
        }
    }

    public static void setSorterOfView(EntityViewInfo view, SorterItemCollection sorter) {
        if (view != null && sorter != null) {
            int size = sorter.size();
            for (int i = 0; i < size; ++i) {
                view.getSorter().add(sorter.get(i));
            }
        }
    }

    public static Object numberCalc(Object left, Object right, String pattern) throws Exception {
        Object result = null;
        if (left instanceof Number || right instanceof Number) {
            Object object = result = left instanceof Number ? left : right;
        }
        if (left instanceof Number && right instanceof Number) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(VAR_LEFT, left);
            params.put(VAR_RIGHT, right);
            try {
                result = new Interpreter().eval(pattern, params);
            }
            catch (InterpreterException e) {
                throw e;
            }
            catch (ParserException e) {
                throw e;
            }
        }
        return result;
    }

    public static Object numberAdd(Object left, Object right) throws Exception {
        return STQMUtils.numberCalc(left, right, PATTERN_STRING_ADD);
    }

    public static Object numberSubstract(Object left, Object right) throws Exception {
        return STQMUtils.numberCalc(left, right, PATTERN_STRING_SUBSTRACT);
    }

    public static BigDecimal bigDecimalAdd(BigDecimal qty1, BigDecimal qty2) {
        if (qty1 == null) {
            qty1 = SysConstant.BIGZERO;
        }
        if (qty2 == null) {
            qty2 = SysConstant.BIGZERO;
        }
        return qty1.add(qty2);
    }

    public static BigDecimal bigDecimalSubtract(BigDecimal qty1, BigDecimal qty2) {
        if (qty1 == null) {
            qty1 = SysConstant.BIGZERO;
        }
        if (qty2 == null) {
            qty2 = SysConstant.BIGZERO;
        }
        return qty1.subtract(qty2);
    }

    public static String[] mergeStringArray(String[] s1, String[] s2) {
        int i;
        if (s1 == null && s2 == null) {
            return new String[0];
        }
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        HashSet<String> list = new HashSet<String>();
        for (i = 0; i < s1.length; ++i) {
            list.add(s1[i]);
        }
        for (i = 0; i < s2.length; ++i) {
            list.add(s2[i]);
        }
        return list.toArray(new String[0]);
    }

    public static String[] deleteElementFromStringArray(String[] strArray, String string) {
        if (strArray == null) {
            return new String[0];
        }
        if (string == null) {
            return strArray;
        }
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < strArray.length; ++i) {
            if (string.toString().equals(strArray[i])) continue;
            list.add(strArray[i]);
        }
        return list.toArray(new String[0]);
    }

    public static String[] addElementToStringArray(String[] strArray, String string) {
        if (strArray == null) {
            if (string == null) {
                return new String[0];
            }
            String[] s = new String[]{string};
            return s;
        }
        if (string == null) {
            return strArray;
        }
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < strArray.length; ++i) {
            if (string.toString().equals(strArray[i])) continue;
            list.add(strArray[i]);
        }
        list.add(string);
        return list.toArray(new String[0]);
    }
}

