/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.basedata.ncm.AUXOverheadCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.AUXOverheadCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.IAUXOverheadCompanyInfo;
import com.kingdee.eas.basedata.ncm.client.AUXOverheadEditUI;
import com.kingdee.eas.basedata.ncm.client.AUXOverheadListUI;
import com.kingdee.eas.basedata.ncm.client.AbstractAUXOverheadCompanyInfoEditUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.utils.client.NCMDefaultFilterInfoProducer;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AUXOverheadCompanyInfoEditUI
extends AbstractAUXOverheadCompanyInfoEditUI {
    private static final long serialVersionUID = -4275866218826468714L;

    public AUXOverheadCompanyInfoEditUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AUXOverheadCompanyInfoFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        AUXOverheadCompanyInfoInfo objectValue = new AUXOverheadCompanyInfoInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCompanyOrgUnit(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (dataObject instanceof AUXOverheadInfo) {
            super.setDataObject((IObjectValue)this.editData);
        } else {
            super.setDataObject(dataObject);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.companyPromptBox.getValue() == null) {
            this.companyPromptBox.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        }
        this.companyPromptBox.setEnabled(false);
        if (this.price.getNumberValue() == null) {
            this.price.setNumberValue((Number)new BigDecimal("0"));
        }
        this.pricePrecision.setModel((SpinnerModel)new SpinnerNumberModel(4, 0, 12, 1));
        if (this.pricePrecision.getValue() instanceof Integer) {
            this.price.setPrecision(((Integer)this.pricePrecision.getValue()).intValue());
            this.price.setRemoveingZeroInDispaly(false);
        }
        this.pricePrecision.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                KDSpinner spinner = (KDSpinner)evt.getSource();
                if (spinner.getValue() instanceof Integer) {
                    int precision = (Integer)spinner.getValue();
                    AUXOverheadCompanyInfoEditUI.this.price.setPrecision(precision);
                    AUXOverheadCompanyInfoEditUI.this.price.setRemoveingZeroInDispaly(false);
                }
            }
        });
        if (this.editData != null && this.editData.getId() != null && this.editData.getId().toString().length() != 0) {
            this.pricePrecision.setValue((Object)this.editData.getPricePrecision());
        }
        this.processCostCenterFilter();
        this.costCenterBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                AUXOverheadCompanyInfoEditUI.this.processCostCenterFilter();
            }
        });
        this.processFiTypeFilter();
        this.fiTypeBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                AUXOverheadCompanyInfoEditUI.this.processFiTypeFilter();
            }
        });
        this.processDefaultExpenseFilter();
        this.defaultExpense.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                AUXOverheadCompanyInfoEditUI.this.processDefaultExpenseFilter();
            }
        });
    }

    private void processCostCenterFilter() {
        String companyOrgID = this.getSelectedCompanyID();
        if (companyOrgID == null) {
            SysUtil.abort();
        }
        IOrgUnitRelation iOUR = null;
        OrgUnitCollection ccColl = null;
        try {
            iOUR = OrgUnitRelationFactory.getRemoteInstance();
            ccColl = iOUR.getFromUnit(companyOrgID, 1, 5);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int ccSize = 0;
        if (ccColl != null) {
            ccSize = ccColl.size();
        }
        if (ccSize == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"##########", CompareType.EQUALS));
            view.setFilter(filter);
            this.costCenterBizPromptBox.setFilterInfoProducer((IFilterInfoProducer)new NCMDefaultFilterInfoProducer(filter));
            this.costCenterBizPromptBox.setEntityViewInfo(view);
            return;
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.costCenterBizPromptBox.setFilterInfoProducer((IFilterInfoProducer)new NCMDefaultFilterInfoProducer(filter));
        this.costCenterBizPromptBox.setEntityViewInfo(view);
    }

    private void processFiTypeFilter() {
        String companyOrgID = this.getSelectedCompanyID();
        if (companyOrgID == null) {
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID, CompareType.EQUALS));
        view.setFilter(filter);
        this.fiTypeBizPromptBox.setFilterInfoProducer((IFilterInfoProducer)new NCMDefaultFilterInfoProducer(filter));
        this.fiTypeBizPromptBox.setEntityViewInfo(view);
    }

    private void processDefaultExpenseFilter() {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu == null) {
            SysUtil.abort();
        }
        try {
            BDCMClientUtils.filterDataBaseDF7("4A255827", this.defaultExpense, "ExpenseType", 1, CompareType.NOTEQUALS);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private String getSelectedCompanyID() {
        String companyOrgID = null;
        if (this.companyPromptBox.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.companyPromptBox.getValue();
            companyOrgID = company.getId().toString();
            return companyOrgID;
        }
        return null;
    }

    @Override
    public void loadFields() {
        EventListener[] prmtCompanyListners = this.companyPromptBox.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.companyPromptBox);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.companyPromptBox, prmtCompanyListners);
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        if (this.editData == null) {
            this.editData = (AUXOverheadCompanyInfoInfo)this.createNewData();
            this.setDataObject((IObjectValue)this.editData);
        }
        if (this.editData.getAUXOverhead() == null) {
            if (this.getUIContext().get("CURRENT.VO") instanceof AUXOverheadInfo) {
                this.editData.setAUXOverhead((AUXOverheadInfo)this.getUIContext().get("CURRENT.VO"));
            } else {
                String auxOverheadID = ((AUXOverheadInfo)this.getUIContext().get("AUXOverhead")).getId().toString();
                try {
                    AUXOverheadInfo info = AUXOverheadFactory.getRemoteInstance().getAUXOverheadInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)auxOverheadID)));
                    this.editData.setAUXOverhead(info);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        this.editData.put("adminCU", SysContext.getSysContext().getCurrentCtrlUnit());
        this.editData.setName(this.editData.getAUXOverhead().getName());
        super.storeFields();
    }

    protected void prmtcompanyOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo companyOrg = null;
        if (!(this.companyPromptBox.getData() instanceof CompanyOrgUnitInfo)) {
            return;
        }
        companyOrg = (CompanyOrgUnitInfo)this.companyPromptBox.getData();
        AUXOverheadCompanyInfoInfo info = this.getCompanyInfoByOrg(companyOrg.getId(), null);
        if (info == null) {
            return;
        }
        info.setCompanyOrgUnit(companyOrg);
        this.editData = info;
        this.setDataObject((IObjectValue)info);
        this.loadFields();
    }

    protected AUXOverheadCompanyInfoInfo getCompanyInfoByOrg(BOSUuid companyOrgPk, String auxOverheadID) throws Exception {
        if (auxOverheadID == null) {
            if (this.getUIContext().get("CURRENT.VO") instanceof AUXOverheadInfo) {
                auxOverheadID = (String)this.getUIContext().get("ID");
            } else if (this.editData.getAUXOverhead() != null) {
                auxOverheadID = this.editData.getAUXOverhead().getId().toString();
            } else {
                auxOverheadID = ((AUXOverheadListUI)((Object)this.getUIContext().get("Owner"))).getSelectedKeyForAll();
                if (auxOverheadID == null) {
                    return null;
                }
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AUXOverhead.id", (Object)auxOverheadID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgPk.toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        IAUXOverheadCompanyInfo iAuxOverHeadInfo = AUXOverheadCompanyInfoFactory.getRemoteInstance();
        AUXOverheadCompanyInfoCollection vo = iAuxOverHeadInfo.getAUXOverheadCompanyInfoCollection(ev);
        if (vo.size() > 0) {
            return vo.get(0);
        }
        return null;
    }

    public boolean isModify() {
        return super.isModify();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.companyPromptBox.getData() == null) {
            this.companyPromptBox.setData((Object)SysContext.getSysContext().getCurrentFIUnit());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.costCenterBizPromptBox.setData(null);
        this.fiTypeBizPromptBox.setData(null);
        this.defaultExpense.setData(null);
        this.pricePrecision.setValue((Object)new BigDecimal("0"));
        this.price.setValue(null);
        this.getUIContext().remove("InitDataObject");
    }

    protected void showSubmitSuccess() {
        this.setMainStatusBar(this.getParentUI().getMainStatusBar());
        super.showSubmitSuccess();
    }

    protected void showMessageForStatus() {
        this.setMainStatusBar(this.getParentUI().getMainStatusBar());
        super.showMessageForStatus();
    }

    private AUXOverheadEditUI getParentUI() {
        Object c;
        for (c = this.getParent(); c != null && !c.getClass().equals(AUXOverheadEditUI.class); c = c.getParent()) {
        }
        if (c == null) {
            c = (AUXOverheadEditUI)((Object)((NewWinMainUI)this.getUIContext().get("IMainUIObject")).getUiManager().getWinUiObjects().get(0));
        }
        return (AUXOverheadEditUI)((Object)c);
    }

    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((Object)this.companyPromptBox.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.companyLabel.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.costCenterBizPromptBox.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.costCenterLabel.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)this.defaultExpense.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.expenseLabel.getBoundLabelText()});
        }
        super.beforeStoreFields(arg0);
    }
}

