/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.ncm.ActivityChainEntryInfo;
import com.kingdee.eas.basedata.ncm.ActivityChainFactory;
import com.kingdee.eas.basedata.ncm.ActivityChainInfo;
import com.kingdee.eas.basedata.ncm.ActivityChainTreeInfo;
import com.kingdee.eas.basedata.ncm.ActivityFactory;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionCollection;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionFactory;
import com.kingdee.eas.basedata.ncm.ActivityResourceInfo;
import com.kingdee.eas.basedata.ncm.DataStatusEnum;
import com.kingdee.eas.basedata.ncm.IActivityChain;
import com.kingdee.eas.basedata.ncm.OrderTypeEnum;
import com.kingdee.eas.basedata.ncm.client.AbstractActivityChainEditUI;
import com.kingdee.eas.basedata.ncm.client.ActivityChainListUI;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class ActivityChainEditUI
extends AbstractActivityChainEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ActivityChainEditUI.class);
    private static final String RES_CLASSNAME = "com.kingdee.eas.basedata.ncm.ActivityChainResource";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    protected RuleStatus ruleStatus = null;
    private Map activityMap = new HashMap();
    protected DataBinder activityDataBinder = new DataBinder();
    private FilterInfo rootingDefaultFilter = null;
    private KDBizPromptBox prmtActivity = null;
    private int activityPrecision = -1;

    public ActivityChainEditUI() throws Exception {
        this.kDPanel1.setBorder((Border)new EmptyBorder(10, 0, 0, 0));
        this.kDPanel2.setBorder((Border)new EmptyBorder(10, 0, 0, 0));
        this.activityDataBinder.registerBinding("number", String.class, (Component)this.txtActivityNumber, "text");
        this.activityDataBinder.registerBinding("name", String.class, (Component)this.txtActivityName, "text");
        this.activityDataBinder.registerBinding("resource", ActivityResourceInfo.class, (Component)this.kdtActivities, "userObject");
        this.activityDataBinder.registerBinding("resource.costItem.number", String.class, (Component)this.kdtActivities, "costItem.number.text");
        this.activityDataBinder.registerBinding("resource.costItem.name", String.class, (Component)this.kdtActivities, "costItem.name.text");
        this.activityDataBinder.registerBinding("resource.unit.name", String.class, (Component)this.kdtActivities, "unit.name.text");
        this.activityDataBinder.registerBinding("resource.stdQty", String.class, (Component)this.kdtActivities, "stdQty.text");
        this.activityDataBinder.registerBinding("resource.stdRate", String.class, (Component)this.kdtActivities, "stdRate.text");
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarted(KDTEditEvent e) {
                try {
                    ActivityChainEditUI.this.tblMain_editStarted(e);
                }
                catch (Exception exc) {
                    ActivityChainEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.setBeforeAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                ActivityChainEditUI.this.tblMain_beforeAction(e);
            }
        });
    }

    private int getActivityPrecision() throws BOSException {
        if (this.activityPrecision > 0) {
            return this.activityPrecision;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ActivityPrecisionCollection coll = ActivityPrecisionFactory.getRemoteInstance().getActivityPrecisionCollection(view);
        if (coll.size() > 0) {
            this.activityPrecision = coll.get(0).getPrecision();
        }
        if (this.activityPrecision <= 0) {
            this.activityPrecision = 4;
        }
        return this.activityPrecision;
    }

    public void initLayout() {
        super.initLayout();
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)this.kDLabelContainer1);
        box.add(Box.createHorizontalStrut(40));
        box.add((Component)this.kDLabelContainer2);
        box.add(Box.createHorizontalStrut(40));
        box.add((Component)new KDLabelContainer(""));
        box.add(Box.createHorizontalStrut(100));
        box.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.kDPanel1.add((Component)box, (Object)"North");
        this.kDTabbedPane1.setForcedHide(true);
        this.kDTabbedPane2.setForcedHide(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemSave.setVisible(true);
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        this.kdtActivities.checkParsed();
        super.onLoad();
        this.initComponent();
        this.initNumber();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.setOprtState(this.getOprtState());
        this.kdtEntries.getSelectManager().select(0, 0, 2);
        this.kdtEntries_tableSelectChanged(null);
    }

    private void initComponent() throws EASBizException, BOSException {
        this.menuView.setVisible(false);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.prmtStandardRooting.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7RootingQuery");
        this.prmtStandardRooting.setEditFormat("$number$");
        this.prmtStandardRooting.setDisplayFormat("$name$");
        this.prmtStandardRooting.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)60));
        FilterInfo defaultFilter = this.getRootingDefaultFilter();
        filter.mergeFilter(defaultFilter, "and");
        view.setFilter(filter);
        this.prmtStandardRooting.setEntityViewInfo(view);
        this.prmtStandardRooting.getQueryAgent().resetRuntimeEntityView();
        this.formatEntryTable();
    }

    private FilterInfo getRootingDefaultFilter() throws BOSException, EASBizException {
        if (this.rootingDefaultFilter != null) {
            return this.rootingDefaultFilter;
        }
        this.rootingDefaultFilter = new FilterInfo();
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, this.companyId);
        if (storageOrgUnitIds.size() > 0) {
            this.rootingDefaultFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
        }
        return this.rootingDefaultFilter;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionCopy.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.actionAudit.setEnabled(false);
            this.actionUnaudit.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionCopyLine.setEnabled(true);
            this.setUITitle(EASResource.getString((String)RES_CLASSNAME, (String)"AC_TITLE_ADDNEW"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionCopy.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionAudit.setEnabled(false);
            this.actionUnaudit.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionCopyLine.setEnabled(true);
            if (this.editData != null && DataStatusEnum.SUBMITED.equals((Object)this.editData.getStatus())) {
                this.actionSave.setEnabled(false);
                this.actionAudit.setEnabled(true);
            }
            this.setUITitle(EASResource.getString((String)RES_CLASSNAME, (String)"AC_TITLE_EDIT"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionCopyLine.setEnabled(false);
            if (this.editData != null) {
                if (DataStatusEnum.TEMPORARILYSAVED.equals((Object)this.editData.getStatus())) {
                    this.actionEdit.setEnabled(true);
                    this.actionSubmit.setEnabled(false);
                    this.actionAudit.setEnabled(false);
                    this.actionUnaudit.setEnabled(false);
                } else if (DataStatusEnum.SUBMITED.equals((Object)this.editData.getStatus())) {
                    this.actionSubmit.setEnabled(false);
                    this.actionAudit.setEnabled(true);
                    this.actionUnaudit.setEnabled(false);
                } else if (DataStatusEnum.AUDITED.equals((Object)this.editData.getStatus())) {
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                    this.actionAudit.setEnabled(false);
                    this.actionUnaudit.setEnabled(true);
                }
            }
            this.setUITitle(EASResource.getString((String)RES_CLASSNAME, (String)"AC_TITLE_VIEW"));
        }
    }

    private void formatEntryTable() throws BOSException {
        if (this.prmtActivity == null) {
            this.prmtActivity = new KDBizPromptBox();
            this.prmtActivity.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ActivityQuery");
            this.prmtActivity.setEditable(true);
            this.prmtActivity.setDisplayFormat("$number$");
            this.prmtActivity.setEditFormat("$number$");
            this.prmtActivity.setCommitFormat("$number$");
            this.prmtActivity.setRequired(true);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)this.prmtActivity);
            this.kdtEntries.getColumn("activity.number").setEditor((ICellEditor)editor);
            ObjectValueRender render = new ObjectValueRender();
            render.setFormat((IDataFormat)new BizDataFormat("$number$"));
            this.kdtEntries.getColumn("activity.number").setRenderer((IBasicRender)render);
        }
        this.kdtEntries.getColumn("seq").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("activity.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("activity.baseUnit.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("activity.amount").getStyleAttributes().setLocked(true);
        NCMClientUtils.setBigDecimalFieldsPrecisionByColumn((IColumn)this.kdtEntries.getColumn("integratedQty"), (int)2, (boolean)false);
        this.kdtEntries.getColumn("integratedQty").getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn("integratedQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.kdtEntries.getColumn("activity.amount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.getActivityPrecision()));
        this.kdtActivities.getColumn("seq").getStyleAttributes().setLocked(true);
        this.kdtActivities.getColumn("costItem.number").getStyleAttributes().setLocked(true);
        this.kdtActivities.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.kdtActivities.getColumn("unit.name").getStyleAttributes().setLocked(true);
        this.kdtActivities.getColumn("stdQty").getStyleAttributes().setLocked(true);
        this.kdtActivities.getColumn("stdQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)8));
        this.kdtActivities.getColumn("stdRate").getStyleAttributes().setLocked(true);
        this.kdtActivities.getColumn("stdRate").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.getActivityPrecision()));
    }

    public void tblMain_editStarted(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (this.kdtEntries.getColumnIndex("activity.number") == colIndex) {
            this.filterActivity();
        }
    }

    private void prmtActivity_willShow(SelectorEvent e) throws EASBizException, BOSException {
        this.filterActivity();
    }

    private void filterActivity() {
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        HashSet<String> selectedIds = new HashSet<String>();
        Object value = null;
        for (int r = 0; r < this.kdtEntries.getExpandedRowCount(); ++r) {
            if (r == rowIndex || (value = this.kdtEntries.getRow(r).getCell("activity.number").getValue()) == null || !(value instanceof ActivityInfo)) continue;
            selectedIds.add(((ActivityInfo)value).getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        if (selectedIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.NOTINCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtActivity.getQueryAgent().resetRuntimeEntityView();
        this.prmtActivity.setEntityViewInfo(viewInfo);
    }

    private void tblMain_beforeAction(BeforeActionEvent e) {
        if (e.getType() != 7) {
            return;
        }
        int activityColIndex = this.kdtEntries.getColumnIndex("activity.number");
        int size = this.kdtEntries.getSelectManager().size();
        boolean clearActivity = false;
        for (int i = 0; i < size; ++i) {
            int rowIndex;
            KDTSelectBlock selectBlock = this.kdtEntries.getSelectManager().get(i);
            if (selectBlock == null) continue;
            if (8 == selectBlock.getMode()) {
                for (rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
                    IRow row = this.kdtEntries.getRow(rowIndex);
                    row.getCell("activity.name").setValue(null);
                    row.getCell("activity.baseUnit.name").setValue(null);
                    row.getCell("integratedQty").setValue(null);
                    row.getCell("activity.amount").setValue(null);
                }
                clearActivity = true;
                break;
            }
            int rowCount = selectBlock.getBottom();
            for (rowIndex = selectBlock.getTop(); rowIndex >= 0 && rowIndex <= rowCount; ++rowIndex) {
                IRow row = this.kdtEntries.getRow(rowIndex);
                if (2 == selectBlock.getMode()) {
                    row.getCell("activity.name").setValue(null);
                    row.getCell("activity.baseUnit.name").setValue(null);
                    row.getCell("integratedQty").setValue(null);
                    row.getCell("activity.amount").setValue(null);
                    clearActivity = true;
                    continue;
                }
                int colCount = selectBlock.getRight();
                for (int colIndex = selectBlock.getLeft(); colIndex >= 0 && colIndex <= colCount; ++colIndex) {
                    if (row.getCell(colIndex).getValue() == null || colIndex != activityColIndex) continue;
                    row.getCell("activity.name").setValue(null);
                    row.getCell("activity.baseUnit.name").setValue(null);
                    row.getCell("activity.amount").setValue(null);
                    clearActivity = true;
                }
            }
        }
        if (clearActivity) {
            this.showActivity(null);
        }
    }

    protected void initListener() {
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    ActivityChainEditUI.this.kdtEntries_editStopped(e);
                }
                catch (Exception exc) {
                    ActivityChainEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    ActivityChainEditUI.this.kdtEntries_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    ActivityChainEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntries.getRow(rowIndex);
        Object value = row.getCell(colIndex).getValue();
        if (this.kdtEntries.getColumn("activity.number").getColumnIndex() == colIndex) {
            ActivityInfo activity = null;
            if (value instanceof ActivityInfo) {
                activity = (ActivityInfo)value;
                activity = this.getActivityInfo(activity.getId().toString());
            }
            if (activity != null) {
                row.getCell("activity.name").setValue((Object)activity.getName());
                if (activity.getBaseUnit() != null) {
                    row.getCell("activity.baseUnit.name").setValue((Object)activity.getBaseUnit().getName());
                }
                if (activity.getTimeUnit() != null) {
                    row.getCell("timeUnit").setValue((Object)activity.getTimeUnit());
                }
                row.getCell("activity.amount").setValue((Object)activity.getAmount());
            } else {
                row.getCell("activity.name").setValue(null);
                row.getCell("activity.baseUnit.name").setValue(null);
                row.getCell("activity.amount").setValue(null);
            }
            this.showActivity(activity);
        }
    }

    protected void kdtEntries_tableSelectChanged(KDTSelectEvent e) throws Exception {
        Object value;
        ICell cell;
        IRow row;
        ActivityInfo activity = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        if (selectRows.length > 0 && (row = this.kdtEntries.getRow(selectRows[0])) != null && (cell = row.getCell("activity.number")) != null && (value = cell.getValue()) instanceof ActivityInfo) {
            activity = (ActivityInfo)value;
        }
        if (activity != null) {
            activity = this.getActivityInfo(activity.getId().toString());
        }
        this.showActivity(activity);
    }

    private ActivityInfo getActivityInfo(String id) throws EASBizException, BOSException {
        ActivityInfo activity = null;
        if (this.activityMap.containsKey(id)) {
            activity = (ActivityInfo)this.activityMap.get(id);
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("number");
            selector.add("name");
            selector.add("resource.*");
            selector.add("resource.costItem.number");
            selector.add("resource.costItem.name");
            selector.add("resource.unit.name");
            selector.add("baseUnit.name");
            selector.add("amount");
            SorterItemCollection sorter = new SorterItemCollection();
            try {
                activity = (ActivityInfo)ActivityFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id), selector, sorter);
                this.activityMap.put(id, activity);
            }
            catch (Exception e) {
                this.handUIException(e);
                this.abort();
            }
        }
        return activity;
    }

    private void showActivity(ActivityInfo activity) {
        if (activity == null) {
            activity = new ActivityInfo();
        }
        this.activityDataBinder.setValueObject((IObjectValue)activity);
        this.activityDataBinder.loadFields();
    }

    @Override
    public void storeFields() {
        ActivityChainListUI listUI = (ActivityChainListUI)((Object)this.getUIContext().get("Owner"));
        Object uo = listUI.getSelectedTreeNode().getUserObject();
        if (uo instanceof ActivityChainTreeInfo) {
            this.editData.setTree((ActivityChainTreeInfo)uo);
        }
        super.storeFields();
        for (int i = 0; i < this.editData.getEntries().size(); ++i) {
            this.editData.getEntries().get(i).setSeq(i + 1);
        }
    }

    protected IObjectValue createNewData() {
        ActivityChainInfo info = new ActivityChainInfo();
        info.setCompany(this.company);
        info.setStatus(DataStatusEnum.ADD);
        info.setOrderType(OrderTypeEnum.MANUFACTURE);
        info.setIsForbiden(false);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ActivityChainFactory.getRemoteInstance();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue(pk, this.getSelectors(), this.getSorters());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("tree.id");
        return selector;
    }

    public SorterItemCollection getSorters() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("entries.seq"));
        return sorter;
    }

    protected void initNumber() throws EASBizException, BOSException {
        this.ruleStatus = CodingRuleManagerFactory.getRemoteInstance().getRuleStatus((IObjectValue)this.editData, this.editData.getCompany().getId().toString());
        if (!this.ruleStatus.isExist() || this.ruleStatus.isModifiable()) {
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)this.editData.getNumber())) {
            return;
        }
        if (!this.ruleStatus.isExist()) {
            return;
        }
        if (this.ruleStatus.isAddView() || this.ruleStatus.isAddNoBreak()) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getId().toString();
            if (StringUtils.isEmpty((String)orgId)) {
                orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String number = "";
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (this.ruleStatus.isAddNoBreak()) {
                number = iCodingRuleManager.readNumber((IObjectValue)this.editData, orgId);
            } else if (this.ruleStatus.isAddView()) {
                number = iCodingRuleManager.getNumber((IObjectValue)this.editData, orgId);
            }
            if (!StringUtils.isEmpty((String)number)) {
                this.editData.setNumber(number);
                this.txtNumber.setText(number);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        block12: {
            boolean error;
            String activityId;
            ActivityInfo activity;
            HashSet<String> activityIds;
            Object temp;
            block11: {
                super.verifyInput(e);
                temp = null;
                activityIds = new HashSet<String>();
                activity = null;
                activityId = null;
                error = false;
                if (e.getSource() != this.btnSave) break block11;
                for (int i = 0; i < this.kdtEntries.getExpandedRowCount(); ++i) {
                    temp = this.kdtEntries.getRow(i).getCell("activity.number").getValue();
                    if (temp == null || !(temp instanceof ActivityInfo)) continue;
                    activity = (ActivityInfo)temp;
                    activityId = activity.getId().toString();
                    if (activityIds.contains(activityId)) {
                        this.kdtEntries.getEditManager().editCellAt(i, this.kdtEntries.getColumnIndex("activity.number"));
                        MsgBox.showInfo((Component)((Object)this), (String)"\u4f5c\u4e1a\u4e0d\u80fd\u91cd\u590d\u3002");
                        SysUtil.abort();
                        continue;
                    }
                    activityIds.add(activityId);
                }
                break block12;
            }
            if (e.getSource() != this.btnSubmit) break block12;
            if (StringUtils.isEmpty((String)this.editData.getNumber())) {
                this.txtNumber.requestFocus();
                throw new EASBizException(EASBizException.CHECKNUMBLANK);
            }
            if (StringUtils.isEmpty((String)this.editData.getName())) {
                this.txtName.requestFocus();
                throw new EASBizException(EASBizException.CHECKNAMEBLANK);
            }
            if (this.kdtEntries.getExpandedRowCount() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"CHECK_ENTRY_EMPTY"));
                SysUtil.abort();
            }
            for (int i = 0; i < this.kdtEntries.getExpandedRowCount(); ++i) {
                temp = this.kdtEntries.getRow(i).getCell("activity.number").getValue();
                if (temp == null) {
                    this.kdtEntries.getEditManager().editCellAt(i, this.kdtEntries.getColumnIndex("activity.number"));
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"CHECK_Activity_EMPTY"));
                    SysUtil.abort();
                }
                if (temp instanceof ActivityInfo) {
                    activity = (ActivityInfo)temp;
                    activityId = activity.getId().toString();
                    if (activityIds.contains(activityId)) {
                        this.kdtEntries.getEditManager().editCellAt(i, this.kdtEntries.getColumnIndex("activity.number"));
                        MsgBox.showInfo((Component)((Object)this), (String)"\u4f5c\u4e1a\u4e0d\u80fd\u91cd\u590d\u3002");
                        SysUtil.abort();
                    } else {
                        activityIds.add(activityId);
                    }
                }
                error = true;
                if (this.kdtEntries.getRow(i).getCell("integratedQty").getValue() != null && (temp = this.kdtEntries.getRow(i).getCell("integratedQty").getValue()) instanceof BigDecimal && ((BigDecimal)temp).compareTo(SysConstant.BIGZERO) > 0) {
                    error = false;
                }
                if (!error) continue;
                this.kdtEntries.getEditManager().editCellAt(i, this.kdtEntries.getColumnIndex("integratedQty"));
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"CHECK_IntegratedQty_MUSTMORETHAN_ZERO"));
                SysUtil.abort();
            }
        }
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected boolean isModifySave() {
        return this.editData != null && (this.editData.getStatus().equals((Object)DataStatusEnum.ADD) || this.editData.getStatus().equals((Object)DataStatusEnum.TEMPORARILYSAVED));
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.initNumber();
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        this.setOprtState(this.getOprtState());
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ActivityChainInfo info = (ActivityChainInfo)newData;
        info.setNumber(null);
        info.setStatus(DataStatusEnum.ADD);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.initNumber();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.initNumber();
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        this.setOprtState(this.getOprtState());
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            this.editData = (ActivityChainInfo)((IActivityChain)this.getBizInterface()).getValue((IObjectPK)iObjectPk, this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.setSaved(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.getEditManager().stopEditing();
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
        String id = this.editData.getId().toString();
        IActivityChain activityChain = (IActivityChain)this.getBizInterface();
        try {
            this.pubFireVOChangeListener(id);
            HashSet<String> pks = new HashSet<String>();
            pks.add(id);
            activityChain.audit(pks);
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"AUDIT_SUCCESS"));
            this.refreshCurPage();
            this.setOprtState("VIEW");
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.lockUIForViewStatus();
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.getEditManager().stopEditing();
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
        String id = this.editData.getId().toString();
        IActivityChain activityChain = (IActivityChain)this.getBizInterface();
        try {
            this.pubFireVOChangeListener(id);
            HashSet<String> pks = new HashSet<String>();
            pks.add(id);
            activityChain.unaudit(pks);
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"UNAUDIT_SUCCESS"));
            this.refreshCurPage();
            this.setOprtState("VIEW");
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            try {
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.lockUIForViewStatus();
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new ActivityChainEntryInfo();
    }

    protected String getSubKeyFieldName() {
        return "id";
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void afterAddLine(KDTable table, IRow row, IObjectValue lineData) {
        int rowIndex = row.getRowIndex();
        int colIndex = table.getColumnIndex("activity.number");
        table.getEditManager().editCellAt(rowIndex, colIndex);
    }

    protected void afterInsertLine(KDTable table, IRow row, IObjectValue lineData) {
        int rowIndex = row.getRowIndex();
        int colIndex = table.getColumnIndex("activity.number");
        table.getEditManager().editCellAt(rowIndex, colIndex);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        if (table.getRowCount() > 0) {
            int colIndex = table.getColumnIndex("activity.number");
            table.getEditManager().editCellAt(0, colIndex);
        } else {
            try {
                this.kdtEntries_tableSelectChanged(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void afterCopyLine(KDTable table, IRow row, IObjectValue lineData) {
        int rowIndex = row.getRowIndex();
        int colIndex = table.getColumnIndex("activity.number");
        row.getCell("activity.number").setValue(null);
        row.getCell("activity.name").setValue(null);
        row.getCell("activity.baseUnit.name").setValue(null);
        row.getCell("activity.amount").setValue(null);
        table.getEditManager().editCellAt(rowIndex, colIndex);
    }

    protected void afterSelectLine(KDTable table, IObjectValue lineData) {
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        if (detailData != null) {
            IRow row = table.addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
            this.afterAddLine(table, row, detailData);
        }
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, row, detailData);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr.length == 0) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(table, detailData);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.insertLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            if (this.getDetailTable().getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.getDetailTable()) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.getDetailTable());
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception ex) {
                            this.handUIException(ex);
                            this.abort();
                        }
                    }
                }
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        IRow copyToRowObj;
        KDTable table = this.getDetailTable();
        if (table == null) {
            return;
        }
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0 && table.getRowCount() > 0) {
            ICell cellId;
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            int beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            IRow copyFromRowObj = null;
            copyToRowObj = null;
            int copyFromRowIndex = 0;
            int copyToRowIndex = 0;
            copyFromRowIndex = selectedBlock.getEndRow();
            copyToRowIndex = KDTableUtil.getLastVisibleRowIndex((KDTable)table);
            copyFromRowObj = table.getRow(copyFromRowIndex);
            copyToRowObj = table.getRow(copyToRowIndex);
            for (int cellIndex = 0; cellIndex < table.getColumnCount(); ++cellIndex) {
                ICell copyFromCell = copyFromRowObj.getCell(cellIndex);
                ICell copyToCell = copyToRowObj.getCell(cellIndex);
                if (copyFromCell == null || copyToCell == null) continue;
                Object orgValue = copyFromCell.getValue();
                copyToCell.setValue(orgValue);
            }
            if (this.getSubKeyFieldName() != null && (cellId = copyToRowObj.getCell(this.getSubKeyFieldName())) != null) {
                cellId.setValue(null);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
        this.afterCopyLine(table, copyToRowObj, null);
    }
}

