/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.ncm.ActivityChainException;
import com.kingdee.eas.basedata.ncm.ActivityChainFactory;
import com.kingdee.eas.basedata.ncm.ActivityChainInfo;
import com.kingdee.eas.basedata.ncm.ActivityChainTreeFactory;
import com.kingdee.eas.basedata.ncm.ActivityChainTreeInfo;
import com.kingdee.eas.basedata.ncm.DataStatusEnum;
import com.kingdee.eas.basedata.ncm.IActivityChain;
import com.kingdee.eas.basedata.ncm.client.AbstractActivityChainListUI;
import com.kingdee.eas.basedata.ncm.client.ActivityChainEditUI;
import com.kingdee.eas.basedata.ncm.client.ActivityChainGenWizardUI;
import com.kingdee.eas.basedata.ncm.client.ActivityChainTreeEditUI;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMMaterialPromptBoxFactory;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActivityChainListUI
extends AbstractActivityChainListUI {
    private static final Logger logger = CoreUIObject.getLogger(ActivityChainListUI.class);
    private static final String RES_CLASSNAME = "com.kingdee.eas.basedata.ncm.ActivityChainResource";
    public static final String COL_ID = "id";
    public static final String COL_Tree_ID = "treeid";
    public static final String COL_Com_Name = "company.name";
    public static final String COL_Number = "number";
    public static final String COL_Name = "name";
    public static final String COL_OrderType = "orderType";
    public static final String COL_Status = "status";
    public static final String COL_SR_Number = "standardRooting.number";
    public static final String COL_SR_Name = "standardRooting.name";
    public static final String COL_IsForbiden = "isForbiden";
    public static final String COL_Description = "description";
    private static final Color FORBIDEN_COLOR = new Color(255, 255, 193);
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyId = this.company.getId().toString();
    private ActionManager actionManager;
    private CommonQueryDialog dialog = null;
    private FilterInfo rootingDefaultFilter = null;
    private IUIWindow wizardUIWindow = null;
    private ActivityChainGenWizardUI wizardUI = null;

    public ActivityChainListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.pnlMain.setDividerLocation(200);
    }

    protected String getGroupEditUIName() {
        return ActivityChainTreeEditUI.class.getName();
    }

    protected String getEditUIName() {
        return ActivityChainEditUI.class.getName();
    }

    protected String getRootName() {
        return EASResource.getString((String)RES_CLASSNAME, (String)"ACT");
    }

    protected String getKeyFieldName() {
        return COL_ID;
    }

    protected String getQueryFieldName() {
        return "tree.id";
    }

    protected String getSelectDetailTreeName() {
        return "tree";
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager((CoreUIObject)this){

                public void registerAction(String actionName, ItemAction itemAction) {
                    if ("actionGroupAddNew".equals(actionName)) {
                        ActivityChainListUI.this.actionGroupAddNew.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl alt N"));
                    }
                    super.registerAction(actionName, itemAction);
                }
            };
        }
        return this.actionManager;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow() + 1;
                int count = end;
                for (int i = start; i < count; ++i) {
                    boolean isForbiden;
                    Object value;
                    IRow row = ActivityChainListUI.this.tblMain.getRow(i);
                    if (row == null || row.getCell(ActivityChainListUI.COL_IsForbiden) == null || row.getCell(ActivityChainListUI.COL_IsForbiden).getValue() == null || !((value = row.getCell(ActivityChainListUI.COL_IsForbiden).getValue()) instanceof Boolean) || !(isForbiden = ((Boolean)value).booleanValue())) continue;
                    row.getStyleAttributes().setBackground(FORBIDEN_COLOR);
                }
            }
        });
    }

    protected String getSelectedKeyValue(String keyFiledName) {
        int[] selectRows;
        if (keyFiledName == null) {
            String string = keyFiledName = this.subKeyFieldName == null ? this.getKeyFieldName() : this.subKeyFieldName;
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length > 0) {
            return ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)keyFiledName);
        }
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        String treeid = this.getSelectedKeyValue(COL_Tree_ID);
        if (treeid != null) {
            ObjectUuidPK tree = new ObjectUuidPK(treeid);
            return tree;
        }
        this.treeMain.setSelectionRow(0);
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ActivityChainFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return ActivityChainTreeFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
        return filter;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
        return filter;
    }

    protected void beforeExcutQuery(EntityViewInfo evi) {
        super.beforeExcutQuery(evi);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sorter;
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if ((sorter = viewInfo.getSorter()) == null || sorter.size() <= 0 || sorter.size() == 1 && sorter.get(0).getPropertyName().equalsIgnoreCase(COL_ID)) {
            sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo(COL_Number));
        }
        viewInfo.setSorter(sorter);
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        return qe;
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node.isLeaf() && this.isRefByActivityChain(node)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"GroupAddNew_AC_EXISTS"));
            return;
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!node.isLeaf()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"GroupRemove_NOT_LEAF"));
            return;
        }
        if (this.isRefByActivityChain(node)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"GroupRemove_AC_EXISTS"));
            return;
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupMoveTree_actionPerformed(e);
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        try {
            if (this.isRefByActivityChain(e.getTargetNode())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"GroupMoveTree_AC_EXISTS"));
                return;
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            super.abort();
        }
        super.moveGroupTreeNode(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        ActivityChainTreeInfo target = (ActivityChainTreeInfo)e.getTargetTreeBaseInfo();
        if (target.isIsLeaf()) {
            super.moveTreeNode(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"MoveTree_NOT_LEAF"));
        }
    }

    private boolean isRefByActivityChain(KDTreeNode node) throws Exception {
        ActivityChainTreeInfo tree = null;
        if (node != null && node.getUserObject() != null && node.getUserObject() instanceof ActivityChainTreeInfo) {
            tree = (ActivityChainTreeInfo)node.getUserObject();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId, CompareType.EQUALS));
        if (tree != null) {
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tree.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("tree.id", null, CompareType.EQUALS));
        }
        boolean exists = this.getBizInterface().exists(filter);
        return exists;
    }

    private boolean isRefByActivityChainTree(KDTreeNode node) throws Exception {
        ActivityChainTreeInfo tree = null;
        if (node != null && node.getUserObject() != null && node.getUserObject() instanceof ActivityChainTreeInfo) {
            tree = (ActivityChainTreeInfo)node.getUserObject();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId, CompareType.EQUALS));
        if (tree != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)tree.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", null, CompareType.EQUALS));
        }
        boolean exists = this.getTreeInterface().exists(filter);
        return exists;
    }

    private Set getSelectedPks() {
        HashSet pks = new HashSet();
        ArrayList list = this.getSelectedIdValues();
        pks.addAll(list);
        return pks;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!node.isLeaf() || this.isRefByActivityChainTree(node)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"AddNew_NOT_LEAF"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String selectKeyValue = this.getSelectedKeyValue();
        if (selectKeyValue == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(COL_Name));
        sic.add(new SelectorItemInfo(COL_Number));
        sic.add(new SelectorItemInfo(COL_Description));
        sic.add(new SelectorItemInfo(COL_IsForbiden));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo(COL_OrderType));
        sic.add(new SelectorItemInfo("standardRooting.*"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.integratedQty"));
        sic.add(new SelectorItemInfo("entries.activity.*"));
        sic.add(new SelectorItemInfo("entries.activity.name"));
        sic.add(new SelectorItemInfo("entries.activity.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.activity.amount"));
        sic.add(new SelectorItemInfo(COL_Status));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("entries.seq"));
        ActivityChainInfo info = (ActivityChainInfo)((IActivityChain)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectKeyValue)), sic, sorter);
        if (info == null) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ObjectValueUtil.copy((AbstractObjectValue)info);
        info.setNumber(null);
        info.setStatus(DataStatusEnum.ADD);
        info.setCU(this.getCurrentCU());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", (Object)info);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ActionEvent", (Object)e);
        String editUIName = this.getEditUIName();
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, "ADDNEW") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(editUIName, (Map)uiContext, null, "ADDNEW");
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                this.prepareRefresh(null).callHandler();
            }
            this.setLocatePre(false);
            this.refresh(e);
            this.setPreSelecteRow();
            this.setLocatePre(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(COL_ID);
        selector.add(COL_Status);
        ActivityChainInfo activityChain = (ActivityChainInfo)this.getBizInterface().getValue((IObjectPK)pk, selector);
        if (!DataStatusEnum.TEMPORARILYSAVED.equals((Object)activityChain.getStatus()) && !DataStatusEnum.SUBMITED.equals((Object)activityChain.getStatus())) {
            throw new ActivityChainException(ActivityChainException.CHECK_EDIT_ERROR);
        }
        super.actionEdit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        if (list == null || list.size() <= 0) {
            return;
        }
        if (super.confirmRemove()) {
            try {
                IObjectPK[] arrayPK = new IObjectPK[list.size()];
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    this.setOprtState("REMOVE");
                    this.pubFireVOChangeListener((String)list.get(i));
                    arrayPK[i] = new ObjectUuidPK((String)list.get(i));
                }
                IActivityChain iActivityChain = (IActivityChain)this.getBizInterface();
                iActivityChain.delete(arrayPK);
                this.refresh(e);
            }
            catch (ObjectReferedException ex) {
                String error = "\u6709\u4f5c\u4e1a\u94fe\u88ab\u5f15\u7528\uff0c\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002";
                StringBuffer errorDetail = new StringBuffer();
                Object refObj = ex.getReferingObject();
                if (refObj != null && refObj instanceof Map) {
                    Map refMap = (Map)refObj;
                    Object key2 = null;
                    BizReference ref = null;
                    Locale locale = SysContext.getSysContext().getLocale();
                    for (Object key2 : ((Map)refObj).keySet()) {
                        ref = (BizReference)refMap.get(key2);
                        errorDetail.append("\u4f5c\u4e1a\u94fe " + key2 + " \u88ab [" + ref.getRefEntityAlias(locale) + "] \u5f15\u7528\n");
                    }
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)errorDetail.toString(), (int)2);
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
            finally {
                try {
                    int count = list.size();
                    for (int i = 0; i < count; ++i) {
                        this.setOprtState("RELEASEALL");
                        this.pubFireVOChangeListener((String)list.get(i));
                    }
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                }
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set pks = this.getSelectedPks();
        if (pks == null || pks.size() == 0) {
            return;
        }
        Map report = ((IActivityChain)this.getBizInterface()).submit(pks);
        if (report != null && report.size() > 0) {
            StringBuffer detail = new StringBuffer();
            Object[] numbers = report.keySet().toArray(new String[report.size()]);
            Arrays.sort(numbers);
            Object number = null;
            List errors = null;
            for (int i = 0; i < numbers.length; ++i) {
                number = numbers[i];
                errors = (List)report.get(number);
                detail.append(MessageFormat.format(EASResource.getString((String)RES_CLASSNAME, (String)"CHECK_AC_NUMBER"), number) + " \n");
                int size = errors.size();
                for (int j = 0; j < size; ++j) {
                    detail.append("     " + errors.get(j) + ";\n");
                }
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES_CLASSNAME, (String)"CHECK_BATCH_SUBMIT_ERROR"), (String)detail.toString(), (int)2);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"SUBMIT_SUCCESS"));
            this.refresh(e);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set pks = this.getSelectedPks();
        if (pks == null || pks.size() == 0) {
            return;
        }
        ((IActivityChain)this.getBizInterface()).audit(pks);
        MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"AUDIT_SUCCESS"));
        this.refresh(e);
    }

    @Override
    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set pks = this.getSelectedPks();
        if (pks == null || pks.size() == 0) {
            return;
        }
        ((IActivityChain)this.getBizInterface()).unaudit(pks);
        MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"UNAUDIT_SUCCESS"));
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set pks = this.getSelectedPks();
        if (pks == null || pks.size() == 0) {
            return;
        }
        ((IActivityChain)this.getBizInterface()).unforbid(pks);
        MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"UNFORBID_SUCCESS"));
        this.refresh(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set pks = this.getSelectedPks();
        if (pks == null || pks.size() == 0) {
            return;
        }
        ((IActivityChain)this.getBizInterface()).forbid(pks);
        MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"FORBID_SUCCESS"));
        this.refresh(e);
    }

    public Map showGenWizardUI() throws Exception {
        if (this.wizardUIWindow == null) {
            HashMap param = new HashMap();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"param", param);
            this.wizardUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ActivityChainGenWizardUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            this.wizardUI = (ActivityChainGenWizardUI)((Object)param.get("ui"));
        }
        this.wizardUI.init(null);
        ((UIModelDialog)this.wizardUIWindow).setVisible(true);
        return this.wizardUI.getParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionGen_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && (!node.isLeaf() || this.isRefByActivityChainTree(node))) {
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLASSNAME, (String)"AddNew_NOT_LEAF"));
            return;
        }
        Map param = this.showGenWizardUI();
        if (param != null) {
            if (node != null && node.getUserObject() != null && node.getUserObject() instanceof ActivityChainTreeInfo) {
                ActivityChainTreeInfo tree = (ActivityChainTreeInfo)node.getUserObject();
                param.put("tree.id", tree.getId().toString());
            }
            this.requestMutex(this.companyId);
            try {
                ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)new GenProgressHintListener(), (Map)param);
            }
            finally {
                this.releaseMutex(this.companyId);
            }
            this.refresh(e);
        }
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected int getCommonQueryDialogWidth() {
        return 450;
    }

    protected int getCommonQueryDialogHeight() {
        return 320;
    }

    protected CustomerQueryPanel getFilterUI() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        NCMMaterialPromptBoxFactory ncmF7Factory = new NCMMaterialPromptBoxFactory(this.getFilterUI(), OrgType.Storage);
        this.dialog.setPromptBoxFactory((IPromptBoxFactory)ncmF7Factory);
        this.dialog.setProcessor((IProcessor)this.getCustomerCommonQueryProcessor());
        this.dialog.setWidth(this.getCommonQueryDialogWidth());
        this.dialog.setHeight(this.getCommonQueryDialogHeight());
        return this.dialog;
    }

    private FilterInfo getRootingDefaultFilter() throws BOSException, EASBizException {
        if (this.rootingDefaultFilter != null) {
            return this.rootingDefaultFilter;
        }
        this.rootingDefaultFilter = new FilterInfo();
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, this.companyId);
        if (storageOrgUnitIds.size() > 0) {
            this.rootingDefaultFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
        }
        return this.rootingDefaultFilter;
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
                Object editor = this.get("CURRENT_EDITOR");
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if (editor instanceof KDBizPromptBox) {
                    KDBizPromptBox prmt = (KDBizPromptBox)editor;
                    EntityViewInfo view = prmt.getEntityViewInfo() == null ? new EntityViewInfo() : prmt.getEntityViewInfo();
                    FilterInfo filter = null;
                    if (ActivityChainListUI.COL_SR_Number.equals(fieldProperty) || ActivityChainListUI.COL_SR_Name.equals(fieldProperty)) {
                        filter = new FilterInfo();
                        HashSet<Integer> statuses = new HashSet<Integer>();
                        statuses.add(60);
                        filter.getFilterItems().add(new FilterItemInfo(ActivityChainListUI.COL_Status, statuses, CompareType.INCLUDE));
                        FilterInfo defaultFilter = ActivityChainListUI.this.getRootingDefaultFilter();
                        filter.mergeFilter(defaultFilter, "and");
                        view.setFilter(filter);
                        prmt.setEntityViewInfo(view);
                        prmt.getQueryAgent().resetRuntimeEntityView();
                    }
                }
            }
        };
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPk = LogUtil.beginLog(null, (String)"print", (BOSObjectType)this.getBizInterface().getType(), null, null, (String)"OC_ActivityChain_Print");
        super.actionPrintPreview_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)logPk);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPk = LogUtil.beginLog(null, (String)"print", (BOSObjectType)this.getBizInterface().getType(), null, null, (String)"OC_ActivityChain_Print");
        super.actionPrint_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)logPk);
    }

    private class GenProgressHintListener
    implements ProgressHintListener {
        private GenProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            ActivityChainFactory.getRemoteInstance().genData(param);
        }
    }
}

