/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.ncm.ActivityFactory;
import com.kingdee.eas.basedata.ncm.ActivityGroupInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.ActivityOperationInfo;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionCollection;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionFactory;
import com.kingdee.eas.basedata.ncm.ActivityResourceInfo;
import com.kingdee.eas.basedata.ncm.ActivityTypeEnum;
import com.kingdee.eas.basedata.ncm.DeletedStatusEnum;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractActivityEditUI;
import com.kingdee.eas.basedata.ncm.client.ActivityGroupTreeSelector;
import com.kingdee.eas.basedata.ncm.client.ActivityListUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ControlStrategyFactory;
import com.kingdee.eas.mm.basedata.ControlStrategyInfo;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ResourceInfo;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ActivityEditUI
extends AbstractActivityEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ActivityEditUI.class);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    int precision = 4;
    protected RuleStatus ruleStatus = null;
    private boolean viewStatus = false;

    public ActivityEditUI() throws Exception {
        this.comboType.setEnabled(false);
        this.prmtCostCenter.setEnabled(false);
        this.txtAmount.setEnabled(false);
    }

    public void onShow() throws Exception {
        BDCMClientUtils.setResizble(false, this.uiWindow);
    }

    public void onLoad() throws Exception {
        ActivityEditUI.checkLoginCompanyOrgIsVirtual();
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityEditUI.this.moveUp();
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityEditUI.this.moveDown();
            }
        });
        this.kdtOperation.checkParsed();
        this.kdtResource.checkParsed();
        super.onLoad();
        this.initNumber();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.menuBiz.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.menuTabPane.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionSave.setVisible(false);
        if (DeletedStatusEnum.OPEN.equals((Object)this.editData.getDeletedStatus())) {
            this.actionEdit.setEnabled(false);
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.viewStatus = true;
            this.setViewButtonDisplay();
        }
        this.initPrecision();
        this.txtAmount.setPrecision(this.precision);
        this.initActivityGroupTreeF7();
        this.initResourceEntry();
        this.initOperationEntry();
    }

    private void initPrecision() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ActivityPrecisionCollection coll = ActivityPrecisionFactory.getRemoteInstance().getActivityPrecisionCollection(view);
        if (coll.size() > 0) {
            this.precision = coll.get(0).getPrecision();
        }
    }

    private void initActivityGroupTreeF7() {
        ActivityGroupTreeSelector selector = new ActivityGroupTreeSelector((IUIObject)this, this.prmtGroup, null, true, false);
        selector.setTitle("\u4f5c\u4e1a\u5206\u7ec4");
        this.prmtGroup.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void moveUp() {
        KDTable tableMain = null;
        tableMain = this.tabPane.getSelectedIndex() == 0 ? this.kdtResource : this.kdtOperation;
        int n = tableMain.getSelectManager().getActiveRowIndex();
        if (n > 0) {
            tableMain.moveRow(n, n - 1);
            tableMain.getSelectManager().select(n - 1, 1, 2);
            tableMain.getSelectManager().setActiveRowIndex(n - 1);
        }
    }

    private void moveDown() {
        KDTable tableMain = null;
        tableMain = this.tabPane.getSelectedIndex() == 0 ? this.kdtResource : this.kdtOperation;
        int n = tableMain.getSelectManager().getActiveRowIndex();
        if (n < tableMain.getRowCount()) {
            tableMain.moveRow(n + 1, n);
            tableMain.getSelectManager().select(n + 1, 1, 2);
            tableMain.getSelectManager().setActiveRowIndex(n + 1);
        }
    }

    protected void initOperationEntry() throws Exception {
        this.kdtOperation.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ActivityEditUI.this.kdtOperation_editStarting(e);
                }
                catch (Exception exc) {
                    ActivityEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    ActivityEditUI.this.kdtOperation_editStopped(e);
                }
                catch (Exception exc) {
                    ActivityEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtOperation = new KDBizPromptBox();
        prmtOperation.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7OperationQuery");
        prmtOperation.setVisible(true);
        prmtOperation.setEditable(true);
        prmtOperation.setDisplayFormat("$number$");
        prmtOperation.setEditFormat("$number$");
        prmtOperation.setCommitFormat("$number$");
        EntityViewInfo eviOperation = new EntityViewInfo();
        eviOperation.setFilter(this.getOperationFilter());
        prmtOperation.setEntityViewInfo(eviOperation);
        prmtOperation.setRequired(true);
        ObjectValueRender ovrOperation = new ObjectValueRender();
        ovrOperation.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtOperation.getColumn("operation.number").setRenderer((IBasicRender)ovrOperation);
        this.kdtOperation.getColumn("operation.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtOperation));
        this.kdtOperation.getColumn("operation.number").setRequired(true);
        if ("ADDNEW".equals(this.getOprtState()) && this.kdtOperation.getRowCount() < 1) {
            this.addLine(this.kdtOperation);
        }
    }

    protected void initResourceEntry() throws Exception {
        this.kdtResource.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ActivityEditUI.this.kdtResource_editStarting(e);
                }
                catch (Exception exc) {
                    ActivityEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    ActivityEditUI.this.kdtResource_editStopped(e);
                }
                catch (Exception exc) {
                    ActivityEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtResource = new KDBizPromptBox();
        prmtResource.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ResourceQuery");
        prmtResource.setVisible(true);
        prmtResource.setEditable(true);
        prmtResource.setDisplayFormat("$number$");
        prmtResource.setEditFormat("$number$");
        prmtResource.setCommitFormat("$number$");
        EntityViewInfo eviResource = new EntityViewInfo();
        eviResource.setFilter(this.getResourceFilter());
        prmtResource.setEntityViewInfo(eviResource);
        prmtResource.setRequired(true);
        ObjectValueRender ovrResource = new ObjectValueRender();
        ovrResource.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtResource.getColumn("resource.number").setRenderer((IBasicRender)ovrResource);
        this.kdtResource.getColumn("resource.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtResource));
        this.kdtResource.getColumn("resource.name").getStyleAttributes().setLocked(true);
        this.kdtResource.getColumn("storage").getStyleAttributes().setLocked(true);
        KDBizPromptBox prmtExpense = new KDBizPromptBox();
        prmtExpense.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseFIQuery");
        prmtExpense.setVisible(true);
        prmtExpense.setEditable(true);
        prmtExpense.setDisplayFormat("$number$");
        prmtExpense.setEditFormat("$number$");
        prmtExpense.setCommitFormat("$number$");
        EntityViewInfo eviExpense = new EntityViewInfo();
        eviExpense.setFilter(this.getExpenseFilter());
        prmtExpense.setEntityViewInfo(eviExpense);
        prmtExpense.setRequired(true);
        ObjectValueRender ovrExpense = new ObjectValueRender();
        ovrExpense.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtResource.getColumn("expense.number").setRenderer((IBasicRender)ovrExpense);
        this.kdtResource.getColumn("expense.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtExpense));
        this.kdtResource.getColumn("expense.name").getStyleAttributes().setLocked(true);
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        EntityViewInfo eviCostItem = new EntityViewInfo();
        eviCostItem.setFilter(this.getCostItemFilter());
        prmtCostItem.setEntityViewInfo(eviCostItem);
        prmtCostItem.setRequired(true);
        ObjectValueRender avCostItem = new ObjectValueRender();
        avCostItem.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtResource.getColumn("costItem.number").setRenderer((IBasicRender)avCostItem);
        this.kdtResource.getColumn("costItem.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        this.kdtResource.getColumn("costItem.number").setRequired(true);
        this.kdtResource.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        KDBizPromptBox prmtUnit = new KDBizPromptBox();
        prmtUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtUnit.setVisible(true);
        prmtUnit.setEditable(true);
        prmtUnit.setDisplayFormat("$name$");
        prmtUnit.setEditFormat("$name$");
        prmtUnit.setCommitFormat("$name$");
        prmtUnit.setRequired(true);
        ObjectValueRender ovrUnit = new ObjectValueRender();
        ovrUnit.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtResource.getColumn("unit").setRenderer((IBasicRender)ovrUnit);
        this.kdtResource.getColumn("unit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtUnit));
        KDFormattedTextField stdQty = new KDFormattedTextField();
        stdQty.setDataType(1);
        stdQty.setRemoveingZeroInDispaly(false);
        stdQty.setNegatived(true);
        stdQty.setPrecision(4);
        this.kdtResource.getColumn("stdQty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)stdQty));
        KDFormattedTextField stdRate = new KDFormattedTextField();
        stdRate.setDataType(1);
        stdRate.setRemoveingZeroInDispaly(false);
        stdRate.setNegatived(true);
        stdRate.setPrecision(this.precision);
        this.kdtResource.getColumn("stdRate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)stdRate));
        this.kdtResource.getColumn("stdAmount").getStyleAttributes().setLocked(true);
        NCMClientUtils.changeTableColPrecisionByCol((int)this.precision, (KDTable)this.kdtResource, (String[])new String[]{"stdAmount"});
        this.kdtResource.getColumn("stdQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtResource.getColumn("stdRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtResource.getColumn("stdAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if ("ADDNEW".equals(this.getOprtState()) && this.kdtResource.getRowCount() < 1) {
            this.addLine(this.kdtResource);
        }
    }

    public void kdtOperation_editStarting(KDTEditEvent e) throws Exception {
    }

    public void kdtOperation_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtOperation.getColumn("operation.number").getColumnIndex() == colIndex) {
            ActivityEditUI.clearCells(this.kdtOperation, rowIndex, new String[]{"operation.id", "operation.name", "status", "storage", "controlStrategy", "workCenter.id", "workCenter.number", "workCenter.name", "costCenter.id", "costCenter.number", "costCenter.name"});
            if (e.getValue() instanceof OperationInfo) {
                OperationInfo operationInfo = (OperationInfo)e.getValue();
                this.kdtOperation.getCell(rowIndex, "operation.id").setValue((Object)operationInfo.getId());
                this.kdtOperation.getCell(rowIndex, "operation.name").setValue((Object)operationInfo.getName());
                this.kdtOperation.getCell(rowIndex, "status").setValue((Object)operationInfo.getStatus());
                if (operationInfo.getStorageOrgUnit() != null) {
                    StorageOrgUnitInfo storage = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(operationInfo.getStorageOrgUnit().getId()));
                    this.kdtOperation.getCell(rowIndex, "storage").setValue((Object)storage.getName());
                }
                if (operationInfo.getControlStrategy() != null) {
                    ControlStrategyInfo controlStrategyInfo = ControlStrategyFactory.getRemoteInstance().getControlStrategyInfo((IObjectPK)new ObjectUuidPK(operationInfo.getControlStrategy().getId()));
                    this.kdtOperation.getCell(rowIndex, "controlStrategy").setValue((Object)controlStrategyInfo.getName());
                }
                if (operationInfo.getWorkCenter() != null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("*"));
                    selector.add(new SelectorItemInfo("costCenter.*"));
                    selector.add(new SelectorItemInfo("costCenter.id"));
                    selector.add(new SelectorItemInfo("costCenter.number"));
                    selector.add(new SelectorItemInfo("costCenter.name"));
                    WorkCenterInfo workCenterInfo = WorkCenterFactory.getRemoteInstance().getWorkCenterInfo((IObjectPK)new ObjectUuidPK(operationInfo.getWorkCenter().getId()), selector);
                    this.kdtOperation.getCell(rowIndex, "workCenter.id").setValue((Object)workCenterInfo.getId());
                    this.kdtOperation.getCell(rowIndex, "workCenter.number").setValue((Object)workCenterInfo);
                    this.kdtOperation.getCell(rowIndex, "workCenter.name").setValue((Object)workCenterInfo.getName());
                    if (workCenterInfo.getCostCenter() != null) {
                        this.kdtOperation.getCell(rowIndex, "costCenter.id").setValue((Object)workCenterInfo.getCostCenter().getId());
                        this.kdtOperation.getCell(rowIndex, "costCenter.number").setValue((Object)workCenterInfo.getCostCenter());
                        this.kdtOperation.getCell(rowIndex, "costCenter.name").setValue((Object)workCenterInfo.getCostCenter().getName());
                        this.prmtCostCenter.setValue((Object)workCenterInfo.getCostCenter());
                    }
                }
            }
        }
    }

    public void kdtResource_editStarting(KDTEditEvent e) throws Exception {
    }

    public void kdtResource_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        BigDecimal stdQty = SysConstant.BIGZERO;
        BigDecimal stdRate = SysConstant.BIGZERO;
        BigDecimal stdAmount = SysConstant.BIGZERO;
        if (this.kdtResource.getColumn("resource.number").getColumnIndex() == colIndex) {
            ActivityEditUI.clearCells(this.kdtResource, rowIndex, new String[]{"resource.name", "storage"});
            if (e.getValue() instanceof ResourceInfo) {
                ResourceInfo resourceInfo = (ResourceInfo)e.getValue();
                this.kdtResource.getCell(rowIndex, "resource.name").setValue((Object)resourceInfo.getName());
                if (resourceInfo.getStorageOrgUnit() != null) {
                    StorageOrgUnitInfo storage = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(resourceInfo.getStorageOrgUnit().getId()));
                    this.kdtResource.getCell(rowIndex, "storage").setValue((Object)storage.getName());
                }
            }
        }
        if (this.kdtResource.getColumn("expense.number").getColumnIndex() == colIndex) {
            ActivityEditUI.clearCells(this.kdtResource, rowIndex, new String[]{"expense.name"});
            if (e.getValue() instanceof ExpenseInfo) {
                ExpenseCompanyInfoInfo expenseCompanyInfoInfo;
                CostItemInfo costItemInfo;
                ExpenseInfo expenseInfo = (ExpenseInfo)e.getValue();
                this.kdtResource.getCell(rowIndex, "expense.name").setValue((Object)expenseInfo.getName());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)expenseInfo.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyID, CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("costItem.*"));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                view.setSelector(selector);
                ExpenseCompanyInfoCollection expenseCompanyInfoColl = ExpenseCompanyInfoFactory.getRemoteInstance().getExpenseCompanyInfoCollection(view);
                if (expenseCompanyInfoColl.size() > 0 && (costItemInfo = (expenseCompanyInfoInfo = expenseCompanyInfoColl.get(0)).getCostItem()) != null) {
                    this.kdtResource.getCell(rowIndex, "costItem.number").setValue((Object)costItemInfo);
                    this.kdtResource.getCell(rowIndex, "costItem.name").setValue((Object)costItemInfo.getName());
                }
            }
        }
        if (this.kdtResource.getColumn("costItem.number").getColumnIndex() == colIndex) {
            ActivityEditUI.clearCells(this.kdtResource, rowIndex, new String[]{"costItem.name"});
            if (e.getValue() instanceof CostItemInfo) {
                CostItemInfo costItemInfo = (CostItemInfo)e.getValue();
                this.kdtResource.getCell(rowIndex, "costItem.name").setValue((Object)costItemInfo.getName());
            }
        }
        if (this.kdtResource.getCell(rowIndex, "stdQty").getValue() != null && this.kdtResource.getCell(rowIndex, "stdRate").getValue() != null) {
            stdQty = BDCMClientUtils.castToBigDecimal(this.kdtResource, rowIndex, "stdQty");
            stdRate = BDCMClientUtils.castToBigDecimal(this.kdtResource, rowIndex, "stdRate");
            stdAmount = stdQty.multiply(stdRate);
            this.kdtResource.getCell(rowIndex, "stdAmount").setValue((Object)stdAmount);
            BigDecimal amount = SysConstant.BIGZERO;
            for (int i = 0; i < this.kdtResource.getRowCount(); ++i) {
                IRow row = this.kdtResource.getRow(i);
                if (row.getCell("stdAmount").getValue() == null) continue;
                amount = amount.add(BDCMClientUtils.castToBigDecimal(this.kdtResource, row.getRowIndex(), "stdAmount"));
            }
            this.txtAmount.setValue((Object)amount);
        }
    }

    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        IRow row = kdt.getRow(rowIndex);
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                cell.setValue(null);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetail(table);
        IRow row = table.addRow();
        this.dataBinder.loadLineFields(table, row, detailData);
    }

    protected FilterInfo getOperationFilter() throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(this.companyID, 1, 4);
        int ccSize = ccColl.size();
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
        return filter;
    }

    protected FilterInfo getResourceFilter() throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(this.companyID, 1, 4);
        int ccSize = ccColl.size();
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
        return filter;
    }

    protected FilterInfo getExpenseFilter() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("companyOrgUnit.id", (Object)this.companyID);
        filter.getFilterItems().add(new FilterItemInfo("expenseType", (Object)1, CompareType.NOTEQUALS));
        return filter;
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable tableMain = null;
        tableMain = this.tabPane.getSelectedIndex() == 0 ? this.kdtResource : this.kdtOperation;
        IRow row = tableMain.addRow();
        this.initEntryRow(row);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable tableMain = null;
        tableMain = this.tabPane.getSelectedIndex() == 0 ? this.kdtResource : this.kdtOperation;
        int index = tableMain.getSelectManager().getActiveRowIndex();
        this.addLine(index, tableMain);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable tableMain = null;
        tableMain = this.tabPane.getSelectedIndex() == 0 ? this.kdtResource : this.kdtOperation;
        int index = tableMain.getSelectManager().getActiveRowIndex();
        if (index < 0 || index >= tableMain.getRowCount()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"61_CostObjectEditUI"));
            return;
        }
        tableMain.removeRow(index);
    }

    private void addLine(int index, KDTable kdtEntrys) throws EASBizException, BOSException {
        IRow row = null;
        row = index != -1 ? kdtEntrys.addRow(index) : kdtEntrys.addRow();
        this.initEntryRow(row);
    }

    private void initEntryRow(IRow row) {
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.initNumber();
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setViewButtonDisplay();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setViewButtonDisplay();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setViewButtonDisplay();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setViewButtonDisplay();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (DeletedStatusEnum.OPEN.equals((Object)this.editData.getDeletedStatus())) {
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u5904\u4e8e\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.initNumber();
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        this.setOprtState(this.getOprtState());
    }

    protected IObjectValue createNewData() {
        ActivityInfo activityInfo = new ActivityInfo();
        activityInfo.setCompany(this.currentCompany);
        activityInfo.setType(ActivityTypeEnum.MANUFACTURE);
        activityInfo.setDeletedStatus(DeletedStatusEnum.OPEN);
        activityInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        ActivityListUI activityListUI = (ActivityListUI)((Object)this.getUIContext().get("Owner"));
        if (activityListUI.getSelectedTreeNode().getUserObject() != null && activityListUI.getSelectedTreeNode().getUserObject() instanceof ActivityGroupInfo) {
            ActivityGroupInfo activityGroupInfo = (ActivityGroupInfo)activityListUI.getSelectedTreeNode().getUserObject();
            activityInfo.setGroup(activityGroupInfo);
        }
        return activityInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ActivityFactory.getRemoteInstance();
    }

    protected void initNumber() throws EASBizException, BOSException {
        this.ruleStatus = CodingRuleManagerFactory.getRemoteInstance().getRuleStatus((IObjectValue)this.editData, this.editData.getCompany().getId().toString());
        if (!this.ruleStatus.isExist() || this.ruleStatus.isModifiable()) {
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)this.editData.getNumber())) {
            return;
        }
        if (!this.ruleStatus.isExist()) {
            return;
        }
        if (this.editData.getCU() == null) {
            this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        }
        if (this.ruleStatus.isAddView() || this.ruleStatus.isAddNoBreak()) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getId().toString();
            if (StringUtils.isEmpty((String)orgId)) {
                orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String number = "";
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (this.ruleStatus.isAddNoBreak()) {
                number = iCodingRuleManager.readNumber((IObjectValue)this.editData, orgId);
            } else if (this.ruleStatus.isAddView()) {
                number = iCodingRuleManager.getNumber((IObjectValue)this.editData, orgId);
            }
            if (!StringUtils.isEmpty((String)number)) {
                this.editData.setNumber(number);
                this.txtNumber.setText(number);
            }
        }
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)ActivityEditUI.getResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)key);
    }

    private IObjectValue createNewDetail(KDTable table) {
        if (table.equals(this.kdtResource)) {
            ActivityResourceInfo activityResourceInfo = new ActivityResourceInfo();
            return activityResourceInfo;
        }
        ActivityOperationInfo activityOperationInfo = new ActivityOperationInfo();
        return activityOperationInfo;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.txtName.getText() == null || "".equals(this.txtName.getText())) {
            MsgBox.showInfo((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (this.comboType.getSelectedItem() == null) {
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (this.comboxTimeUnit.getSelectedItem() == null) {
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (this.prmtGroup.getValue() == null) {
            MsgBox.showInfo((String)"\u5bf9\u5e94\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        if (((ActivityTypeEnum)((Object)this.comboType.getSelectedItem())).equals((Object)ActivityTypeEnum.MANUFACTURE)) {
            this.checkOperation();
        }
        this.checkResource();
    }

    private void checkOperation() {
        if (this.kdtOperation.getRowCount() <= 0) {
            MsgBox.showInfo((String)"\u5de5\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            SysUtil.abort();
        }
        HashSet<String> ccIdSet = new HashSet<String>();
        HashSet<String> operationSet = new HashSet<String>();
        for (int i = 0; i < this.kdtOperation.getRowCount(); ++i) {
            IRow row = this.kdtOperation.getRow(i);
            if (row.getCell("operation.id").getValue() == null) {
                MsgBox.showInfo((String)"\u5de5\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                SysUtil.abort();
            }
            if (row.getCell("operation.number").getValue() != null) {
                OperationInfo info = (OperationInfo)row.getCell("operation.number").getValue();
                if (!operationSet.contains(info.getNumber())) {
                    operationSet.add(info.getNumber());
                } else {
                    MsgBox.showInfo((String)"\u5de5\u5e8f\u4e0d\u80fd\u91cd\u590d\u3002");
                    SysUtil.abort();
                }
            }
            if (row.getCell("workCenter.id").getValue() == null) {
                MsgBox.showInfo((String)"\u5de5\u5e8f\u5fc5\u987b\u6709\u5de5\u4f5c\u4e2d\u5fc3\u3002");
                SysUtil.abort();
            }
            if (row.getCell("costCenter.id").getValue() == null) {
                MsgBox.showInfo((String)"\u5de5\u4f5c\u4e2d\u5fc3\u5fc5\u987b\u6307\u5b9a\u6210\u672c\u4e2d\u5fc3\u3002");
                SysUtil.abort();
            }
            if (ccIdSet.isEmpty()) {
                ccIdSet.add(row.getCell("costCenter.id").getValue().toString());
            } else if (!ccIdSet.contains(row.getCell("costCenter.id").getValue().toString())) {
                MsgBox.showInfo((String)"\u6240\u6709\u5de5\u5e8f\u5fc5\u987b\u5bf9\u5e94\u540c\u4e00\u6210\u672c\u4e2d\u5fc3\u3002");
                SysUtil.abort();
            }
            this.prmtCostCenter.setValue(row.getCell("costCenter.number").getValue());
        }
    }

    private void checkResource() {
        HashSet<String> resourceSet = new HashSet<String>();
        BigDecimal amount = SysConstant.BIGZERO;
        for (int i = 0; i < this.kdtResource.getRowCount(); ++i) {
            IRow row = this.kdtResource.getRow(i);
            if (row.getCell("costItem.number").getValue() == null) {
                MsgBox.showInfo((String)"\u6210\u672c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                SysUtil.abort();
            }
            if (row.getCell("stdAmount").getValue() != null) {
                amount = amount.add(BDCMClientUtils.castToBigDecimal(this.kdtResource, row.getRowIndex(), "stdAmount"));
            }
            if (row.getCell("resource.number").getValue() == null) continue;
            ResourceInfo info = (ResourceInfo)row.getCell("resource.number").getValue();
            if (!resourceSet.contains(info.getNumber())) {
                resourceSet.add(info.getNumber());
                continue;
            }
            MsgBox.showInfo((String)"\u8d44\u6e90\u4e0d\u80fd\u91cd\u590d\u3002");
            SysUtil.abort();
        }
        this.txtAmount.setValue((Object)amount);
    }

    private void setViewButtonDisplay() {
        if (this.viewStatus) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
    }
}

