/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.ncm.ActivityFactory;
import com.kingdee.eas.basedata.ncm.ActivityGroupFactory;
import com.kingdee.eas.basedata.ncm.ActivityGroupInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionCollection;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionFactory;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionInfo;
import com.kingdee.eas.basedata.ncm.DeletedStatusEnum;
import com.kingdee.eas.basedata.ncm.IActivity;
import com.kingdee.eas.basedata.ncm.client.AbstractActivityListUI;
import com.kingdee.eas.basedata.ncm.client.ActivityCommonQueryProcess;
import com.kingdee.eas.basedata.ncm.client.ActivityEditUI;
import com.kingdee.eas.basedata.ncm.client.ActivityGenWizardUI;
import com.kingdee.eas.basedata.ncm.client.ActivityGroupEditUI;
import com.kingdee.eas.basedata.ncm.client.ActivityPrecisionUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class ActivityListUI
extends AbstractActivityListUI {
    private static final Logger logger = CoreUIObject.getLogger(ActivityListUI.class);
    private static final Color FORBIDEN_COLOR = new Color(255, 255, 193);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    int precision = 4;
    private KDTActiveCellListener activeCellListener = null;
    private IUIWindow wizardUIWindow = null;
    private ActivityGenWizardUI wizardUI = null;
    private CommonQueryDialog dialog = null;

    public void onLoad() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        super.onLoad();
        this.pnlMain.setDividerLocation((this.getWidth() - 500) / 2);
        this.initPrecision();
        this.addListeners();
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)ActivityListUI.getResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)key);
    }

    private void initPrecision() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ActivityPrecisionCollection coll = ActivityPrecisionFactory.getRemoteInstance().getActivityPrecisionCollection(view);
        if (coll.size() > 0) {
            this.precision = coll.get(0).getPrecision();
        } else {
            ActivityPrecisionInfo info = new ActivityPrecisionInfo();
            info.setCompany(this.currentCompany);
            info.setPrecision(this.precision);
            ActivityPrecisionFactory.getRemoteInstance().addnew(info);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncludeChild_itemStateChanged(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!node.isLeaf() || !(node.getUserObject() instanceof ActivityGroupInfo)) {
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u4e0d\u80fd\u5728\u975e\u53f6\u5b50\u5206\u7ec4\u65b0\u589e\u3002");
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        BizEnumValueDTO deletedStatusEnum = (BizEnumValueDTO)row.getCell("status").getValue();
        if (DeletedStatusEnum.OPEN.getAlias().equals(deletedStatusEnum.getAlias())) {
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u5904\u4e8e\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK[] pks = this.getSelectPKS();
        ((IActivity)this.getBizInterface()).cancel(pks);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            IObjectPK[] pks = this.getSelectPKS();
            ((IActivity)this.getBizInterface()).cancelCancel(pks);
        }
        this.refresh(e);
    }

    private IObjectPK[] getSelectPKS() {
        this.checkSelected();
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = null;
        if (count != 0) {
            pks = new IObjectPK[count];
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
        }
        return pks;
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!node.isRoot() && node.isLeaf() && this.tblMain.getRowCount() > 0) {
            MsgBox.showWarning((String)"\u5f53\u524d\u9009\u4e2d\u5206\u7c7b\u5df2\u6709\u4f5c\u4e1a,\u4e0d\u5141\u8bb8\u4e0b\u7ea7\u65b0\u589e\u5206\u7c7b\u3002");
            SysUtil.abort();
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            MsgBox.showError((Component)((Object)this), (String)"\u8be5\u5206\u7ec4\u4e0b\u5df2\u7ecf\u521b\u5efa\u4f5c\u4e1a\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
            return;
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupMoveTree_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    protected String getGroupEditUIName() {
        return ActivityGroupEditUI.class.getName();
    }

    protected String getRootName() {
        return "\u4f5c\u4e1a\u7ec4";
    }

    protected String getQueryFieldName() {
        return "group.id";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            ObjectUuidPK detail = new ObjectUuidPK(id);
            try {
                ActivityInfo treeInfo = (ActivityInfo)this.getBizInterface().getValue((IObjectPK)detail);
                if (treeInfo.getGroup().getId() != null) {
                    ObjectUuidPK tree = new ObjectUuidPK(treeInfo.getGroup().getId());
                    return tree;
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.treeMain.setSelectionRow(0);
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return ActivityGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ActivityEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ActivityFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        return filter;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo leafFilterInfo = new FilterInfo();
        leafFilterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID));
        return leafFilterInfo;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        return qe;
    }

    protected String getSelectDetailTreeName() {
        return "group";
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        ActivityGroupInfo target = (ActivityGroupInfo)e.getTargetTreeBaseInfo();
        if (target != null && target.isIsLeaf()) {
            super.moveTreeNode(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"76_CostObjectListUI"));
        }
    }

    private boolean isRefByActivity(TreeBaseInfo tree) throws EASBizException, BOSException {
        if (tree != null) {
            FilterInfo fiCU = new FilterInfo();
            fiCU.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
        }
        return false;
    }

    @Override
    public void actionPrecision_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ActivityPrecisionUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
        this.refresh(e);
    }

    public Map showGenWizardUI() throws Exception {
        if (this.wizardUIWindow == null) {
            HashMap param = new HashMap();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"param", param);
            this.wizardUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ActivityGenWizardUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            this.wizardUI = (ActivityGenWizardUI)((Object)param.get("ui"));
        }
        this.wizardUI.init(null);
        ((UIModelDialog)this.wizardUIWindow).setVisible(true);
        return this.wizardUI.getParam();
    }

    @Override
    public void actionGenGuide_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!(node == null || node.isLeaf() && node.getUserObject() instanceof ActivityGroupInfo)) {
            MsgBox.showInfo((String)"\u4f5c\u4e1a\u4e0d\u80fd\u5728\u975e\u53f6\u5b50\u5206\u7ec4\u65b0\u589e\u3002");
            return;
        }
        Map param = this.showGenWizardUI();
        if (param != null) {
            if (node != null && node.getUserObject() != null && node.getUserObject() instanceof ActivityGroupInfo) {
                ActivityGroupInfo group = (ActivityGroupInfo)node.getUserObject();
                param.put("group.id", group.getId().toString());
            }
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)new GenProgressHintListener(), (Map)param);
            this.refresh(e);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow() + 1;
                int count = end;
                for (int i = start; i < count; ++i) {
                    Object value;
                    IRow row = ActivityListUI.this.tblMain.getRow(i);
                    if (row == null || row.getCell("status") == null || row.getCell("status").getValue() == null || !((value = row.getCell("status").getValue()) instanceof BizEnumValueDTO) || !((BizEnumValueDTO)value).getValue().equals(String.valueOf(2))) continue;
                    row.getStyleAttributes().setBackground(FORBIDEN_COLOR);
                }
            }
        });
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        ActivityCommonQueryProcess cmcq = new ActivityCommonQueryProcess();
        cmcq.set("companyid", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected void addListeners() {
        if (this.activeCellListener == null) {
            this.activeCellListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    try {
                        ActivityListUI.this.tableCellActived(e);
                    }
                    catch (Exception exc) {
                        ActivityListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTActiveCellListener(this.activeCellListener);
    }

    protected void tableCellActived(KDTActiveCellEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return;
        }
        BizEnumValueDTO deletedStatusEnum = (BizEnumValueDTO)row.getCell("status").getValue();
        if (DeletedStatusEnum.OPEN.getAlias().equals(deletedStatusEnum.getAlias())) {
            this.actionEdit.setEnabled(false);
        } else if (DeletedStatusEnum.CLOSE.getAlias().equals(deletedStatusEnum.getAlias())) {
            this.actionEdit.setEnabled(true);
        }
    }

    private class GenProgressHintListener
    implements ProgressHintListener {
        private GenProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            ActivityFactory.getRemoteInstance().genData(param);
        }
    }
}

