/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionCollection;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionFactory;
import com.kingdee.eas.basedata.ncm.ActivityPrecisionInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractActivityPrecisionUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ActivityPrecisionUI
extends AbstractActivityPrecisionUI {
    private static final Logger logger = CoreUIObject.getLogger(ActivityPrecisionUI.class);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    ActivityPrecisionInfo info = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.spPrecision.setModel((SpinnerModel)new SpinnerNumberModel(4, 0, 10, 1));
        this.spPrecision.setEditable(false);
        this.initPrecisionValue();
        this.spPrecision.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ActivityPrecisionUI.this.actionSave.setEnabled(true);
            }
        });
    }

    private void initPrecisionValue() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ActivityPrecisionCollection coll = ActivityPrecisionFactory.getRemoteInstance().getActivityPrecisionCollection(view);
        if (coll.size() > 0) {
            this.info = coll.get(0);
            int precision = this.info.getPrecision();
            SpinnerModel model = this.spPrecision.getModel();
            model.setValue(precision);
            this.spPrecision.setModel(model);
            this.actionSave.setEnabled(false);
        } else {
            this.actionSave.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.info == null) {
            this.info = new ActivityPrecisionInfo();
            this.info.setPrecision(Integer.parseInt(this.spPrecision.getValue().toString()));
            this.info.setCompany(this.currentCompany);
            IObjectPK pk = ActivityPrecisionFactory.getRemoteInstance().addnew(this.info);
            this.info = ActivityPrecisionFactory.getRemoteInstance().getActivityPrecisionInfo(pk);
        } else {
            this.info.setPrecision(Integer.parseInt(this.spPrecision.getValue().toString()));
            ActivityPrecisionFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(this.info.getId()), this.info);
        }
        this.actionSave.setEnabled(false);
    }
}

