/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.ncm.AllocStdException;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTreeInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.AllocStdUnitCollection;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.client.AbstractAllocStdEditUI;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class AllocStdEditUI
extends AbstractAllocStdEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AllocStdEditUI.class);
    private AllocStdUnitCollection allocStdUnitList;

    public AllocStdEditUI() throws Exception {
        this.kdtxtName.getComponent(2).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AllocStdEditUI.this.kdtxtName_focusLost(e);
                }
                catch (Exception exc) {
                    AllocStdEditUI.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionSave.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCheckFormula.setVisible(false);
        if ("VIEW".equals(this.getOprtState())) {
            this.actionSubmit.setVisible(false);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionAddNew.setVisible(true);
        }
        this.initAllocStdUnitList();
        this.kdtxtName.setAutoscrolls(false);
        this.kdtxtName.setFocusCycleRoot(false);
        this.kdtxtName.setRequestFocusEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.updateFormulaLeftPart();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.updateFormulaForParse();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            AllocStdTreeInfo allocStdTreeInfo = (AllocStdTreeInfo)this.getUIContext().get("ParentNode");
            this.editData.put("Treeid", allocStdTreeInfo);
            if (allocStdTreeInfo != null) {
                this.editData.setAllocStdType(allocStdTreeInfo.getAllocStdType());
            }
        }
    }

    @Override
    protected IObjectValue createNewData() {
        AllocStdInfo objectValue = new AllocStdInfo();
        return objectValue;
    }

    private void initAllocStdUnitList() throws BOSException {
        StringBuffer sb;
        AllocStdTypeEnum allocStdType = this.editData.getAllocStdType();
        StringBuffer sbMain = new StringBuffer();
        sbMain.append("SELECT name WHERE ( allocStdType = ").append(allocStdType.getValue()).append("  AND adminCU.id = '").append(this.getBizCUPK()).append("') ");
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT dataBaseDID WHERE status = '0' AND bosObjectType = '9DD41AE3' AND assignCU.id = ").append("'").append(this.getBizCUPK().toString()).append("'");
        IDataBaseDAssign idbda = DataBaseDAssignFactory.getRemoteInstance();
        CoreBaseCollection entrys = idbda.getCollection(oql.toString());
        if (entrys.size() > 0 && (sb = BDCMUtils.splitPK((IObjectCollection)entrys, "databasedid")).toString().length() > 0) {
            sbMain.append(" OR (id in (").append(sb.toString()).append(") AND allocStdType = ").append(allocStdType.getValue()).append(") ");
        }
        sbMain.append(" order by name ");
        this.allocStdUnitList = AllocStdUnitFactory.getRemoteInstance().getAllocStdUnitCollection(sbMain.toString());
        int size = this.allocStdUnitList.size();
        for (int i = 0; i < size; ++i) {
            this.lstAllocStdUnit.addElement((Object)"[".concat(this.allocStdUnitList.get(i).getName().toString()).concat("]"));
        }
        this.lstAllocStdUnit.setAutoscrolls(true);
        this.lstAllocStdUnit.setVisibleRowCount(10);
        this.txtFormula.setSelectAllOnFocus(false);
        this.txtFormula.setAutoAdjustCaret(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.txtFormula.setText("[]=");
        }
    }

    @Override
    protected void lstAllocStdUnit_mouseClicked(MouseEvent e) throws Exception {
        super.lstAllocStdUnit_mouseClicked(e);
        if (this.lstAllocStdUnit.getSelectedIndex() != -1 && e.getClickCount() == 2) {
            String formula = this.txtFormula.getText(0, this.txtFormula.getSelectionStart());
            formula = formula.concat(this.lstAllocStdUnit.getElement(this.lstAllocStdUnit.getSelectedIndex()).toString());
            formula = formula.concat(this.txtFormula.getText(this.txtFormula.getSelectionEnd(), this.txtFormula.getText().length() - this.txtFormula.getSelectionEnd()));
            this.txtFormula.setText(formula);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("allocStdType"));
        sic.add(new SelectorItemInfo("formulaForParse"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    @Override
    public void actionOperator_actionPerformed(ActionEvent e) throws Exception {
        String formula = this.txtFormula.getText(0, this.txtFormula.getSelectionStart());
        formula = formula.concat(((KDButton)e.getSource()).getText());
        formula = formula.concat(this.txtFormula.getText(this.txtFormula.getSelectionEnd(), this.txtFormula.getText().length() - this.txtFormula.getSelectionEnd()));
        this.txtFormula.setText(formula);
    }

    @Override
    protected void kdtxtName_focusLost(FocusEvent e) throws Exception {
        super.kdtxtName_focusLost(e);
        this.updateFormulaLeftPart();
    }

    @Override
    protected void kdtxtName_keyTyped(KeyEvent e) {
        if ("[~@#[]+-*/><=()'|]".indexOf(String.valueOf(e.getKeyChar())) != -1) {
            e.setKeyChar('\uffff');
            e.setKeyCode(0);
        }
    }

    private void updateFormulaLeftPart() throws BadLocationException {
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        String leftPart = "[".concat(this.kdtxtName.getDefaultLangItemData().toString()).concat("]=");
        int idx = this.txtFormula.getText().indexOf("=");
        if (idx != -1) {
            this.txtFormula.setText(leftPart.concat(this.txtFormula.getText(idx + 1, this.txtFormula.getText().length() - idx - 1)));
        } else {
            this.txtFormula.setText(leftPart.concat(this.txtFormula.getText()));
        }
        this.txtFormula.setSelectionStart(this.txtFormula.getText().length());
    }

    private void checkAllocStdUnitName() throws AllocStdException {
        String name = this.kdtxtName.getDefaultLangItemData().toString();
        String reg = "[~@#\\[\\]+-/*//><=()'|]";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(name);
        if (m.find()) {
            this.kdtxtName.requestFocus();
            throw new AllocStdException(AllocStdException.EXC_ITEM_INVALID_CHAR);
        }
    }

    private void updateFormulaForParse() {
        String parse = this.ParseFormulaRightPart(false);
        if (!parse.equals(this.editData.getFormulaForParse())) {
            this.editData.setFormulaForParse(parse);
        }
    }

    private String ParseFormulaRightPart(boolean forTest) {
        String formulaForParse = this.txtFormula.getText();
        int pos = formulaForParse.indexOf("=");
        if (pos != -1) {
            formulaForParse = formulaForParse.substring(pos + 1, formulaForParse.length());
        }
        if (formulaForParse.equals("")) {
            return "";
        }
        int size = this.allocStdUnitList.size();
        for (int i = 0; i < size; ++i) {
            String oldPart = "[".concat(this.allocStdUnitList.get(i).getName().toString()).concat("]");
            String oldPartRegex = "\\[".concat(this.allocStdUnitList.get(i).getName().toString()).concat("\\]");
            String newPart = forTest ? " 1 " : " [".concat(this.allocStdUnitList.get(i).getId().toString()).concat("] ");
            if (formulaForParse.indexOf(oldPart) == -1) continue;
            formulaForParse = formulaForParse.replaceAll(oldPartRegex, newPart);
        }
        if (!forTest) {
            formulaForParse = formulaForParse.replaceAll("\\[", "~#");
            formulaForParse = formulaForParse.replaceAll("\\]", "~@");
        }
        return formulaForParse;
    }

    @Override
    public void actionCheckFormula_actionPerformed(ActionEvent e) throws Exception {
        this.checkFormula();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"formulaCheckSuccess"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BDCMClientUtils.verifyTextFieldInput(this.txtNumber, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"number"));
        BDCMClientUtils.verifyMutilTextFieldInput(this.kdtxtName, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"name"));
        this.checkAllocStdUnitName();
        this.checkFormula();
        super.verifyInput(e);
    }

    private void checkFormula() throws AllocStdException {
        if (this.txtFormula.getText().length() > 255) {
            throw new AllocStdException(AllocStdException.EXC_ITEM_LEN_OVER);
        }
        BDCMClientUtils.verifyTextAreaInput(this.txtFormula, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"formula"));
        String checkFormula = this.ParseFormulaRightPart(true);
        this.testFormula(checkFormula);
    }

    private void testFormula(String formula) throws AllocStdException {
        try {
            AllocStdFactory.getRemoteInstance().testFormula(formula);
        }
        catch (BOSException e) {
            throw new AllocStdException(AllocStdException.EXC_ITEM_FORMULA_INVALD);
        }
    }
}

