/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDCollection;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.BDCMCommonFacadeFactory;
import com.kingdee.eas.basedata.ncm.CostDriverFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.IAUXOverhead;
import com.kingdee.eas.basedata.ncm.IAllocStd;
import com.kingdee.eas.basedata.ncm.IBDCMCommonFacade;
import com.kingdee.eas.basedata.ncm.ICostDriver;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.ncm.client.AbstractBDCMMultiViewUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.utils.client.NCMDefaultFilterInfoProducer;
import com.kingdee.eas.util.SysUtil;
import java.util.Map;

public class BDCMMultiViewUI
extends AbstractBDCMMultiViewUI {
    private static final long serialVersionUID = 1987776890868348301L;
    public static final String ViewCategory = "0";
    public static final String ViewOrgByExpense = "1";
    public static final String ViewExpenseByOrg = "2";
    public static final String ViewOrgByCostItem = "3";
    public static final String ViewCostItemByOrg = "4";
    public static final String ViewOrgByAllocStd = "5";
    public static final String ViewAllocStdByOrg = "6";
    public static final String ViewOrgByAUXOverhead = "7";
    public static final String ViewAUXOverheadByOrg = "8";
    public static final String ViewCostDriverByOrg = "9";
    public static final String ViewOrgByCostDriver = "10";
    public static final String ExpenseBostype = "4A255827";
    public static final String CostItemBostype = "548C5A91";
    public static final String AllocStdBostype = "D9EA44BF";
    public static final String AUXOverheaBosType = "8CB367E7";
    public static final String CostDriverBosType = "5A3D9026";

    public void onShow() throws Exception {
        super.onShow();
        Map uictx = this.getUIContext();
        String viewCategory = (String)uictx.get(ViewCategory);
        if (viewCategory.equals(ViewOrgByExpense)) {
            this.initViewOrgByExpense();
        } else if (viewCategory.equals(ViewExpenseByOrg)) {
            this.initViewExpenseByOrg();
        } else if (viewCategory.equals(ViewOrgByCostItem)) {
            this.initViewOrgByCostItem();
        } else if (viewCategory.equals(ViewCostItemByOrg)) {
            this.initViewCostItemByOrg();
        } else if (viewCategory.equals(ViewOrgByAllocStd)) {
            this.initViewOrgByAllocStd();
        } else if (viewCategory.equals(ViewAllocStdByOrg)) {
            this.initViewAllocStdByOrg();
        } else if (viewCategory.equals(ViewOrgByAUXOverhead)) {
            this.initViewOrgByAUXOverhead();
        } else if (viewCategory.equals(ViewAUXOverheadByOrg)) {
            this.initViewAUXOverheadByOrg();
        } else if (viewCategory.equals(ViewCostDriverByOrg)) {
            this.initViewCostDriverByOrg();
        } else if (viewCategory.equals(ViewOrgByCostDriver)) {
            this.initViewOrgByCostDriver();
        }
    }

    private void initViewOrgByExpense() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewOrgByExpense"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("ExpenseNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        this.lblCostItem.setVisible(false);
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewExpenseByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewExpenseByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        BDCMClientUtils.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        this.lblCostItem.setVisible(false);
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("ExpenseNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("ExpenseName"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Remark"));
    }

    private void initViewOrgByCostItem() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewOrgByCostItem"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CostItemNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.ncm.CostItemTreeListQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        this.lblCostItem.setBoundLabelText(BDCMClientUtils.getNcmResource("RelatedCostItem"));
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewCostItemByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewCostItemByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        BDCMClientUtils.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        this.lblCostItem.setBoundLabelText(BDCMClientUtils.getNcmResource("RelatedCostItem"));
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("CostItemNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("CostItemName"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Remark"));
    }

    private void initViewOrgByAllocStd() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewOrgByAllocStd"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("AllocStdNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.ncm.app.AllocStdQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewAllocStdByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewAllocStdByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        BDCMClientUtils.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("AllocStdNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("AllocStdName"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Remark"));
    }

    private void initViewOrgByCostDriver() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewOrgByCostDriver"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CostDriverNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.ncm.app.CostDriverQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewCostDriverByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewCostDriverByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        BDCMClientUtils.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("CostDriverNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("CostDriverName"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Remark"));
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            return;
        }
        this.kDTable1.removeRows();
        Map uictx = this.getUIContext();
        String viewCategory = (String)uictx.get(ViewCategory);
        if (viewCategory.equals(ViewOrgByExpense)) {
            ExpenseInfo expenseInfo = (ExpenseInfo)e.getNewValue();
            this.txtCostItem.setVisible(false);
            this.doViewOrgByDataBaseD(expenseInfo.getId().toString());
        } else if (viewCategory.equals(ViewExpenseByOrg)) {
            CtrlUnitInfo adminCU = (CtrlUnitInfo)e.getNewValue();
            this.doViewExpenseByOrg(adminCU.getId().toString());
        } else if (viewCategory.equals(ViewOrgByAllocStd)) {
            AllocStdInfo allocStdInfo = (AllocStdInfo)e.getNewValue();
            this.doViewOrgByDataBaseD(allocStdInfo.getId().toString());
        } else if (viewCategory.equals(ViewAllocStdByOrg)) {
            CtrlUnitInfo adminCU = (CtrlUnitInfo)e.getNewValue();
            this.doViewAllocStdByOrg(adminCU.getId().toString());
        } else if (viewCategory.equals(ViewOrgByAUXOverhead)) {
            AUXOverheadInfo aUXOverheadInfo = (AUXOverheadInfo)e.getNewValue();
            this.doViewOrgByDataBaseD(aUXOverheadInfo.getId().toString());
        } else if (viewCategory.equals(ViewAUXOverheadByOrg)) {
            CtrlUnitInfo adminCU = (CtrlUnitInfo)e.getNewValue();
            this.doViewAUXOverheadByOrg(adminCU.getId().toString());
        } else if (viewCategory.equals(ViewOrgByCostDriver)) {
            CostDriverInfo costDriverInfo = (CostDriverInfo)e.getNewValue();
            this.doViewOrgByDataBaseD(costDriverInfo.getId().toString());
        } else if (viewCategory.equals(ViewCostDriverByOrg)) {
            CtrlUnitInfo adminCU = (CtrlUnitInfo)e.getNewValue();
            this.doViewCostDriverByOrg(adminCU.getId().toString());
        }
    }

    private void doViewExpenseByOrg(String currentCUID) throws BOSException, EASBizException {
        IExpense idbd = ExpenseFactory.getRemoteInstance();
        FilterInfo dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentCUID), "id", "adminCU.id");
        if (dbdFilter == null) {
            dbdFilter = new FilterInfo();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, true);
        }
    }

    private void doViewOrgByDataBaseD(String id) throws BOSException, EASBizException {
        IBDCMCommonFacade bdFacade = BDCMCommonFacadeFactory.getRemoteInstance();
        Object[][] data = bdFacade.getOrgsByDataBaseD(id);
        if (data != null) {
            KDTableUtil.insertRows((Object[][])data, null, (int)0, (KDTable)this.kDTable1);
        }
    }

    private void doViewAllocStdByOrg(String currentCUID) throws BOSException, EASBizException {
        IAllocStd idbd = AllocStdFactory.getRemoteInstance();
        FilterInfo dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentCUID), "id", "adminCU.id");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        SorterItemInfo costObjectSort = new SorterItemInfo("number");
        costObjectSort.setSortType(SortType.ASCEND);
        evi.getSorter().add(costObjectSort);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, true);
        }
    }

    private void doViewOrgByAllocStd(String id) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo dbdFilter = new FilterInfo();
        dbdFilter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        evi.setFilter(dbdFilter);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        IAllocStd idbd = AllocStdFactory.getRemoteInstance();
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, false);
        }
    }

    private void doViewCostDriverByOrg(String currentCUID) throws BOSException, EASBizException {
        ICostDriver idbd = CostDriverFactory.getRemoteInstance();
        FilterInfo dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentCUID), "id", "adminCU.id");
        if (dbdFilter == null) {
            dbdFilter = new FilterInfo();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        SorterItemInfo costObjectSort = new SorterItemInfo("number");
        costObjectSort.setSortType(SortType.ASCEND);
        evi.getSorter().add(costObjectSort);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, true);
        }
    }

    private void doViewOrgByCostDriver(String id) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo dbdFilter = new FilterInfo();
        dbdFilter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        evi.setFilter(dbdFilter);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        ICostDriver idbd = CostDriverFactory.getRemoteInstance();
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, false);
        }
    }

    private void initViewOrgByAUXOverhead() {
        this.setUITitle(BDCMClientUtils.getNcmResource("viewOrgByAUXOverhead"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("AUXOverheadNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.ncm.app.AUXOverheadQuery");
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu == null) {
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        Map uictx = this.getUIContext();
        if (uictx.get("filter") instanceof FilterInfo) {
            FilterInfo filter = (FilterInfo)uictx.get("filter");
            view.setFilter(filter);
            this.prmtNumber.setFilterInfoProducer((IFilterInfoProducer)new NCMDefaultFilterInfoProducer(filter));
            this.prmtNumber.setEntityViewInfo(view);
        }
        this.lblCostItem.setVisible(false);
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewAUXOverheadByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("viewAUXOverheadByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        BDCMClientUtils.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        this.prmtNumber.setDisplayFormat("$number$");
        this.prmtNumber.setEditFormat("$number$");
        this.prmtNumber.setCommitFormat("$number$");
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("AUXOverheadNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("AUXOverheadName"));
        this.kDTable1.getColumn("number").setWidth(130);
        this.kDTable1.getColumn("name").setWidth(250);
        this.kDTable1.getColumn("simpleName").getStyleAttributes().setHided(true);
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Description"));
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("adminCU.*"));
        return sic;
    }

    private void fillTable(DataBaseDCollection entrys, boolean isD) {
        Object dInfo = null;
        IRow row = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            dInfo = isD ? entrys.get(i) : entrys.get(i).getAdminCU();
            row = this.kDTable1.addRow();
            row.getCell("number").setValue((Object)dInfo.getNumber());
            row.getCell("name").setValue((Object)dInfo.getName());
            row.getCell("simpleName").setValue((Object)dInfo.getSimpleName());
            row.getCell("description").setValue((Object)dInfo.getDescription());
        }
    }

    private void doViewAUXOverheadByOrg(String currentCUID) throws BOSException, EASBizException {
        IBOSObject ibo = BOSObjectFactory.createRemoteBOSObject((BOSObjectType)BOSObjectType.create((String)AUXOverheaBosType), IDataBaseD.class);
        IDataBaseD idbd = (IDataBaseD)ibo;
        FilterInfo dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentCUID), "id", "adminCU.id");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        IAUXOverhead idbdx = AUXOverheadFactory.getRemoteInstance();
        DataBaseDCollection dbd = idbdx.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, true);
        }
    }
}

