/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.ncm.CostCenterGroupEntryInfo;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractCostCenterOrgUnitGroupEditUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CostCenterOrgUnitGroupEditUI
extends AbstractCostCenterOrgUnitGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCenterOrgUnitGroupEditUI.class);
    private static final String TB_CostCenter = "number";
    private static final String TB_CostCenterName = "name";
    private static final String TB_CostCenterType = "type";

    public CostCenterOrgUnitGroupEditUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.prmtCompanyOrgUnit.setEnabled(false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kDTable1, (boolean)true, null);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.formatEntryTable();
    }

    private void formatEntryTable() {
        KDBizPromptBox prmtCostCenter = new KDBizPromptBox();
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEditable(false);
        prmtCostCenter.setDisplayFormat("$name$");
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$");
        prmtCostCenter.setRequired(true);
        if (this.prmtCompanyOrgUnit.getData() != null) {
            String companyOrgID = ((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData()).getId().toString();
            try {
                BDCMClientUtils.filterCostCenterF7(prmtCostCenter, companyOrgID);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtCostCenter);
        this.kDTable1.getColumn(TB_CostCenter).setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable1.getColumn(TB_CostCenter).setRenderer((IBasicRender)avr);
        this.kDTable1.getColumn(TB_CostCenter).setRequired(true);
        this.kDTable1.getColumn(TB_CostCenterName).getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn(TB_CostCenterType).getStyleAttributes().setLocked(true);
        if ("ADDNEW".equals(this.getOprtState()) && this.kDTable1.getRowCount() < 1) {
            this.addLine(this.kDTable1);
            this.addLine(this.kDTable1);
        }
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        this.txtNumber.requestFocus();
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() instanceof CostCenterOrgUnitInfo) {
            CostCenterOrgUnitInfo cc = (CostCenterOrgUnitInfo)e.getValue();
            this.kDTable1.getCell(e.getRowIndex(), TB_CostCenterName).setValue((Object)cc.getName());
            this.kDTable1.getCell(e.getRowIndex(), TB_CostCenterType).setValue((Object)cc.getCostCenterType());
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        super.beforeStoreFields(arg0);
        if (UIRuleUtil.isNull((Object)((MultiLangItem)this.txtName.getDefaultLangItemData()).getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.kDLabelContainer2.getBoundLabelText()});
        }
        HashMap<String, CostCenterOrgUnitInfo> map = new HashMap<String, CostCenterOrgUnitInfo>();
        CostCenterOrgUnitInfo costCenterOrg = null;
        int count = this.kDTable1.getRowCount();
        HashSet<Object> ccs = new HashSet<Object>();
        for (int i = 0; i < count; ++i) {
            Object value = this.kDTable1.getCell(i, TB_CostCenter).getValue();
            if (value instanceof CostCenterOrgUnitInfo) {
                ccs.add(value);
                costCenterOrg = (CostCenterOrgUnitInfo)value;
                if (map.containsKey(costCenterOrg.getId().toString())) {
                    MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("CostCenterCannotBeDup"));
                    SysUtil.abort();
                    continue;
                }
                map.put(costCenterOrg.getId().toString(), costCenterOrg);
                continue;
            }
            MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("CostCenterCannotBeNull"));
            SysUtil.abort();
        }
        if (ccs.size() < 2) {
            MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("AtleastHaveTwoEntries"));
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        CostCenterOrgUnitGroupInfo objectValue = new CostCenterOrgUnitGroupInfo();
        objectValue.setCompanyOrgUnit(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
        super.actionAddLine_actionPerformed(e);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.insertLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
        super.actionInsertLine_actionPerformed(e);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kDTable1;
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.dataBinder.loadLineFields(table, row, detailData);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.dataBinder.loadLineFields(table, row, detailData);
    }

    private IObjectValue createNewDetailData(KDTable table) {
        CostCenterGroupEntryInfo entry = new CostCenterGroupEntryInfo();
        return entry;
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr.length == 0) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }
}

