/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDMultiLangArea;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.ncm.AllocStdException;
import com.kingdee.eas.basedata.ncm.CostDriverCellCollection;
import com.kingdee.eas.basedata.ncm.CostDriverCellException;
import com.kingdee.eas.basedata.ncm.CostDriverCellFactory;
import com.kingdee.eas.basedata.ncm.CostDriverException;
import com.kingdee.eas.basedata.ncm.CostDriverFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.basedata.ncm.CostDriverTreeInfo;
import com.kingdee.eas.basedata.ncm.CostDriverTypeEnum;
import com.kingdee.eas.basedata.ncm.client.AbstractCostDriverEditUI;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class CostDriverEditUI
extends AbstractCostDriverEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CostDriverEditUI.class);
    private CostDriverCellCollection CostDriverCellList;

    public CostDriverEditUI() throws Exception {
        this.lstCostDriverCell.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    CostDriverEditUI.this.lstCostDriverCell_mouseClicked(e);
                }
                catch (Exception exc) {
                    CostDriverEditUI.this.handUIException(exc);
                }
            }
        });
        this.txtName.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    CostDriverEditUI.this.txtName_focusLost(e);
                }
                catch (Exception exc) {
                    CostDriverEditUI.this.handUIException(exc);
                }
            }
        });
        this.txtName.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                try {
                    CostDriverEditUI.this.txtName_keyTyped(e);
                }
                catch (Exception exc) {
                    CostDriverEditUI.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllocStdUnitList();
        if ("VIEW".equals(this.getOprtState())) {
            this.actionRemove.setVisible(false);
            this.actionSubmit.setEnabled(false);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.updateFormulaLeftPart();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.updateFormulaForParse();
    }

    protected IObjectValue createNewData() {
        CostDriverInfo Info = new CostDriverInfo();
        Info.setTreeid(this.getCostDriverParent());
        Info.setCostDriverType(this.getCostDriverParent().getCostDriverType());
        return Info;
    }

    public CostDriverTreeInfo getCostDriverParent() {
        CostDriverTreeInfo group = (CostDriverTreeInfo)this.getUIContext().get("ParentNode");
        return group;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostDriverFactory.getRemoteInstance();
    }

    private void initAllocStdUnitList() throws BOSException {
        StringBuffer sb;
        CostDriverTypeEnum costDriverType = this.editData.getCostDriverType();
        StringBuffer sbMain = new StringBuffer();
        sbMain.append("SELECT name WHERE ( costDriverType = ").append(costDriverType.getValue()).append("  AND adminCU.id = '").append(this.getBizCUPK()).append("') ");
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT dataBaseDID WHERE status = '0' AND bosObjectType = 'E32D0AA8' AND assignCU.id = ").append("'").append(this.getBizCUPK().toString()).append("'");
        IDataBaseDAssign idbda = DataBaseDAssignFactory.getRemoteInstance();
        CoreBaseCollection entrys = idbda.getCollection(oql.toString());
        if (entrys.size() > 0 && (sb = BDCMUtils.splitPK((IObjectCollection)entrys, "databasedid")).toString().length() > 0) {
            sbMain.append(" OR (id in (").append(sb.toString()).append(") AND costDriverType = ").append(costDriverType.getValue()).append(") ");
        }
        sbMain.append(" order by name ");
        this.CostDriverCellList = CostDriverCellFactory.getRemoteInstance().getCostDriverCellCollection(sbMain.toString());
        int size = this.CostDriverCellList.size();
        for (int i = 0; i < size; ++i) {
            this.lstCostDriverCell.addElement((Object)"[".concat(this.CostDriverCellList.get(i).getName().toString()).concat("]"));
        }
        this.lstCostDriverCell.setAutoscrolls(true);
        this.lstCostDriverCell.setVisibleRowCount(10);
        this.formula.setSelectAllOnFocus(false);
        this.formula.setAutoAdjustCaret(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.formula.setText("[]=");
        }
    }

    protected void lstCostDriverCell_mouseClicked(MouseEvent e) throws Exception {
        if (this.lstCostDriverCell.getSelectedIndex() != -1 && e.getClickCount() == 2) {
            String value = this.formula.getText(0, this.formula.getSelectionStart());
            value = value.concat(this.lstCostDriverCell.getElement(this.lstCostDriverCell.getSelectedIndex()).toString());
            value = value.concat(this.formula.getText(this.formula.getSelectionEnd(), this.formula.getText().length() - this.formula.getSelectionEnd()));
            this.formula.setText(value);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("treeid.*"));
        sic.add(new SelectorItemInfo("costDriverType"));
        sic.add(new SelectorItemInfo("formulaForParse"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setAdminCU(this.curCtrlUnitInfo);
        this.editData.setIsSys(false);
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void actionOperator_actionPerformed(ActionEvent e) throws Exception {
        String value = this.formula.getText(0, this.formula.getSelectionStart());
        value = value.concat(((KDButton)e.getSource()).getText());
        value = value.concat(this.formula.getText(this.formula.getSelectionEnd(), this.formula.getText().length() - this.formula.getSelectionEnd()));
        this.formula.setText(value);
    }

    protected void txtName_focusLost(FocusEvent e) throws Exception {
        this.checkCostDriverCellName();
        this.updateFormulaLeftPart();
    }

    protected void txtName_keyTyped(KeyEvent e) {
        if ("[~@#[]+-*/><=()'|]".indexOf(String.valueOf(e.getKeyChar())) != -1) {
            e.setKeyChar('\uffff');
            e.setKeyCode(0);
        }
    }

    private void updateFormulaLeftPart() throws BadLocationException {
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        String leftPart = "[".concat(this.txtName.getText()).concat("]=");
        int idx = this.formula.getText().indexOf("=");
        if (idx != -1) {
            this.formula.setText(leftPart.concat(this.formula.getText(idx + 1, this.formula.getText().length() - idx - 1)));
        } else {
            this.formula.setText(leftPart.concat(this.formula.getText()));
        }
        this.formula.setSelectionStart(this.formula.getText().length());
    }

    private void checkCostDriverCellName() throws AllocStdException {
        String name = this.txtName.getText();
        String reg = "[~@#\\[\\]+-/*//><=()'|]";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(name);
        if (m.find()) {
            this.txtName.requestFocus();
            throw new AllocStdException(AllocStdException.EXC_ITEM_INVALID_CHAR);
        }
    }

    private void updateFormulaForParse() {
        String parse = this.ParseFormulaRightPart(false);
        if (!parse.equals(this.editData.getFormulaForParse())) {
            this.editData.setFormulaForParse(parse);
        }
    }

    private String ParseFormulaRightPart(boolean forTest) {
        String formulaForParse = this.formula.getText();
        int pos = formulaForParse.indexOf("=");
        if (pos != -1) {
            formulaForParse = formulaForParse.substring(pos + 1, formulaForParse.length());
        }
        if (formulaForParse.equals("")) {
            return "";
        }
        int size = this.CostDriverCellList.size();
        for (int i = 0; i < size; ++i) {
            String oldPart = "[".concat(this.CostDriverCellList.get(i).getName().toString()).concat("]");
            String oldPartRegex = "\\[".concat(this.CostDriverCellList.get(i).getName().toString()).concat("\\]");
            String newPart = forTest ? " 1 " : " [".concat(this.CostDriverCellList.get(i).getId().toString()).concat("] ");
            if (formulaForParse.indexOf(oldPart) == -1) continue;
            formulaForParse = formulaForParse.replaceAll(oldPartRegex, newPart);
        }
        if (!forTest) {
            formulaForParse = formulaForParse.replaceAll("\\[", "~#");
            formulaForParse = formulaForParse.replaceAll("\\]", "~@");
        }
        return formulaForParse;
    }

    public void actionCheckFormula_actionPerformed(ActionEvent e) throws Exception {
        this.checkFormula();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"formulaCheckSuccess"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsSys()) {
            throw new CostDriverCellException(CostDriverCellException.EXCEPTION2);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setSaveDeleteBtn();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setSaveDeleteBtn();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setSaveDeleteBtn();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setSaveDeleteBtn();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BDCMClientUtils.verifyTextFieldInput(this.txtNumber, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"number"));
        BDCMClientUtils.verifyTextFieldInput(this.txtName, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"name"));
        this.checkCostDriverCellName();
        this.checkFormula();
        BDCMClientUtils.verifyKDMultiLangAreaFieldInput((KDMultiLangArea)this.description, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"Remark"));
        super.verifyInput(e);
    }

    private void checkFormula() throws CostDriverException {
        if (this.formula.getText().length() > 255) {
            throw new CostDriverException(CostDriverException.EXCEPTION4);
        }
        BDCMClientUtils.verifyTextAreaInput(this.formula, EASResource.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)"formula"));
        String checkFormula = this.ParseFormulaRightPart(true);
        this.testFormula(checkFormula);
    }

    private void testFormula(String formula) throws CostDriverException {
        try {
            CostDriverFactory.getRemoteInstance().testFormula(formula);
        }
        catch (Exception e) {
            throw new CostDriverException(CostDriverException.EXCEPTION3);
        }
    }

    private void setSaveDeleteBtn() {
        if ("VIEW".equals(this.getOprtState())) {
            this.actionRemove.setVisible(false);
            this.actionSubmit.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionCopy.setEnabled(false);
        }
    }
}

