/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.ncm.IExpenseCompanyInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractExpenseCompanyInfoEditUI;
import com.kingdee.eas.basedata.ncm.client.ExpenseEditUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.UuidException;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ExpenseCompanyInfoEditUI
extends AbstractExpenseCompanyInfoEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseCompanyInfoEditUI.class);
    private static final String objectTypeID = "9UMPQgEcEADgAAkZwKgSKbmZyjk=";

    public ExpenseCompanyInfoEditUI() throws Exception {
        this.prmtcompanyOrgUnit.setEnabled(false);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (dataObject instanceof ExpenseInfo) {
            super.setDataObject((IObjectValue)this.editData);
        } else {
            super.setDataObject(dataObject);
        }
        if (this.editData.getExpense() != null && this.editData.getExpense().getId() == null) {
            String expenseID = this.getUIContext().get("pk").toString();
            this.editData.getExpense().setId(BOSUuid.read((String)expenseID));
        }
    }

    private void initF7Control() {
        CompanyF7 f7CompanyOrg = new CompanyF7((IUIObject)this);
        f7CompanyOrg.setMultiSelect(false);
        f7CompanyOrg.setIsCUFilter(true);
        f7CompanyOrg.disablePerm();
        f7CompanyOrg.setShowVirtual(false);
        this.prmtcompanyOrgUnit.setSelector((KDPromptSelector)f7CompanyOrg);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CostItemInfo costItemInfo = (CostItemInfo)this.getUIContext().get("_CostItem");
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("_Company");
        if (companyInfo == null) {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        KAClassficationInfo kaClassInfo = (KAClassficationInfo)this.getUIContext().get("_KAClass");
        this.prmtcompanyOrgUnit.setValue((Object)companyInfo);
        this.prmtcostItem.setValue((Object)costItemInfo);
        this.prmtKAClass.setValue((Object)kaClassInfo);
        this.filterCostItem();
    }

    private void filterCostItem() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        ExpenseInfo ex = (ExpenseInfo)this.getUIContext().get("_Expense");
        if (ex.getExpenseType().equals((Object)ExpenseTypeEnum.MATERIAL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("itemType", (Object)"1", CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtcostItem.setEntityViewInfo(viewInfo);
    }

    private void filterKAClass(String companyID) {
        if (companyID != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("objectType.id", (Object)objectTypeID, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1");
            viewInfo.setFilter(filterInfo);
            this.prmtKAClass.setEntityViewInfo(viewInfo);
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("_Company");
        if (companyInfo == null) {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        this.editData.setCompanyOrgUnit(companyInfo);
        CostItemInfo costItemInfo = (CostItemInfo)this.getUIContext().get("_CostItem");
        this.editData.setCostItem(costItemInfo);
        KAClassficationInfo kaClassInfo = (KAClassficationInfo)this.getUIContext().get("_KAClass");
        this.editData.setKAClass(kaClassInfo);
    }

    @Override
    public void loadFields() {
        CompanyOrgUnitInfo compOrg;
        EventListener[] prmtCompanyListners = this.prmtcompanyOrgUnit.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.prmtcompanyOrgUnit);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.prmtcompanyOrgUnit, prmtCompanyListners);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.prmtcompanyOrgUnit.setData((Object)SysContext.getSysContext().getCurrentFIUnit());
        }
        if ((compOrg = (CompanyOrgUnitInfo)this.prmtcompanyOrgUnit.getData()) != null) {
            this.filterKAClass(compOrg.getId().toString());
        }
        this.prmtcostItem.setValue((Object)this.editData.getCostItem());
    }

    @Override
    public void storeFields() {
        if (this.editData == null) {
            this.editData = (ExpenseCompanyInfoInfo)this.createNewData();
            this.setDataObject((IObjectValue)this.editData);
        }
        if (this.editData.getExpense() == null) {
            if (this.getUIContext().get("CURRENT.VO") instanceof ExpenseInfo) {
                this.editData.setExpense((ExpenseInfo)this.getUIContext().get("CURRENT.VO"));
            } else {
                String expenseInfoID = ((ExpenseInfo)this.getUIContext().get("_Expense")).getId().toString();
                try {
                    ExpenseInfo info = ExpenseFactory.getRemoteInstance().getExpenseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)expenseInfoID)));
                    this.editData.setExpense(info);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                catch (UuidException e) {
                    this.handUIException(e);
                }
            }
        }
        this.editData.setAdminCU(SysContext.getSysContext().getCurrentCtrlUnit());
        this.editData.setNumber(this.editData.getExpense().getNumber());
        this.editData.setName(this.editData.getExpense().getName());
        Object temp = this.prmtcostItem.getValue();
        if (temp != null && temp instanceof CostItemInfo) {
            this.editData.setCostItem((CostItemInfo)temp);
        } else {
            this.editData.setCostItem(null);
        }
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ExpenseCompanyInfoFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ExpenseCompanyInfoInfo objectValue = new ExpenseCompanyInfoInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCompanyOrgUnit(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected void prmtcompanyOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo companyOrg = null;
        if (!(this.prmtcompanyOrgUnit.getData() instanceof CompanyOrgUnitInfo)) {
            return;
        }
        companyOrg = (CompanyOrgUnitInfo)this.prmtcompanyOrgUnit.getData();
        ExpenseCompanyInfoInfo info = this.getCompanyInfoByOrg(companyOrg.getId(), null);
        if (info == null) {
            this.prmtbaseAcct.setData(null);
            this.prmtassistAcct.setData(null);
            this.prmtmakeAcct.setData(null);
            this.prmtcreditAcct.setData(null);
            this.prmtcostItem.setData(null);
            return;
        }
        info.setCompanyOrgUnit(companyOrg);
    }

    protected ExpenseCompanyInfoInfo getCompanyInfoByOrg(BOSUuid companyOrgPk, String expenseInfoID) throws Exception {
        if (expenseInfoID == null) {
            expenseInfoID = this.getUIContext().get("CURRENT.VO") instanceof ExpenseInfo ? (String)this.getUIContext().get("ID") : (this.editData.getExpense() != null ? this.editData.getExpense().getId().toString() : ((ExpenseInfo)this.getUIContext().get("_Expense")).getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)expenseInfoID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgPk.toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        IExpenseCompanyInfo iCustomer = ExpenseCompanyInfoFactory.getRemoteInstance();
        ExpenseCompanyInfoCollection vo = iCustomer.getExpenseCompanyInfoCollection(ev);
        if (vo.size() > 0) {
            return vo.get(0);
        }
        return null;
    }

    public boolean isModify() {
        if (this.editData == null) {
            return false;
        }
        KAClassficationInfo kaClassfication = (KAClassficationInfo)this.prmtKAClass.getData();
        if (this.editData.getKAClass() == null && kaClassfication != null || this.editData.getKAClass() != null && kaClassfication == null) {
            return true;
        }
        if (this.editData.getKAClass() != null && kaClassfication != null && !this.editData.getKAClass().getId().equals((Object)kaClassfication.getId())) {
            return true;
        }
        CostItemInfo costItem = (CostItemInfo)this.prmtcostItem.getData();
        if (this.editData.getCostItem() == null && costItem != null || this.editData.getCostItem() != null && costItem == null) {
            return true;
        }
        return this.editData.getCostItem() != null && costItem != null && !this.editData.getCostItem().getId().equals((Object)costItem.getId());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.prmtcompanyOrgUnit.getData() == null) {
            this.prmtcompanyOrgUnit.setData((Object)SysContext.getSysContext().getCurrentFIUnit());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.prmtcompanyOrgUnit.setData(null);
        this.prmtbaseAcct.setData(null);
        this.prmtassistAcct.setData(null);
        this.prmtmakeAcct.setData(null);
        this.prmtcreditAcct.setData(null);
        this.prmtcostItem.setData(null);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected void showSubmitSuccess() {
        this.setMainStatusBar(this.getParentUI().getMainStatusBar());
        super.showSubmitSuccess();
    }

    protected void showMessageForStatus() {
        this.setMainStatusBar(this.getParentUI().getMainStatusBar());
        super.showMessageForStatus();
    }

    private ExpenseEditUI getParentUI() {
        Object c;
        for (c = this.getParent(); c != null && !c.getClass().equals(ExpenseEditUI.class); c = c.getParent()) {
        }
        if (c == null) {
            c = (ExpenseEditUI)((Object)((NewWinMainUI)this.getUIContext().get("IMainUIObject")).getUiManager().getWinUiObjects().get(0));
        }
        return (ExpenseEditUI)((Object)c);
    }
}

