/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTreeInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.ncm.client.AbstractExpenseEditUI;
import com.kingdee.eas.basedata.ncm.client.ExpenseCompanyInfoEditUI;
import com.kingdee.eas.basedata.ncm.client.ExpenseListUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ExpenseEditUI
extends AbstractExpenseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseEditUI.class);
    private static final int BasePageIndex = 0;
    private static final int CompanyPageIndex = 1;
    private static int lastSelectedIndex = 0;
    private ExpenseCompanyInfoEditUI currentCompanyUI = null;
    private ChangeListener tabChangeListener = null;
    private ActionEvent action = null;
    private String perAction = "";
    private boolean isCopy = false;
    private boolean isMultiPageCopy = false;
    private boolean isAddnew = false;
    private Object oldType = null;

    public ExpenseEditUI() throws Exception {
        this.combExpenseType.setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionSave.setEnabled(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        BDCMClientUtils.setResizble(false, this.uiWindow);
        this.txtNumber.requestFocusInWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNumber.requestFocus();
        Boolean refIs = (Boolean)this.getUIContext().get("ref");
        if (refIs != null && refIs.booleanValue()) {
            this.setCompentsOnRef();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()) && !this.editData.isIsSys()) {
            this.combExpenseType.setEnabled(true);
            for (int i = 0; i < this.combExpenseType.getItemCount(); ++i) {
                Object type = this.combExpenseType.getItemAt(i);
                if (!(type instanceof ExpenseTypeEnum) || !ExpenseTypeEnum.MATERIAL.equals((Object)((ExpenseTypeEnum)((Object)type)))) continue;
                this.combExpenseType.removeItemAt(i);
                break;
            }
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.combExpenseType.setSelectedItem((Object)ExpenseTypeEnum.OTHER);
            this.kDSpinnerPrecision.setModel((SpinnerModel)new SpinnerNumberModel(4, 0, 12, 1));
            this.storeFields();
            super.initOldData((IObjectValue)this.editData);
        }
        if ("ADDNEW".equals(this.getOprtState()) && this.isMultiPageCopy) {
            this.combExpenseType.setSelectedItem(this.oldType);
            this.storeFields();
            super.initOldData((IObjectValue)this.editData);
        }
        if (this.txtNumber.getText().equals("5001")) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.chkQty.setEnabled(false);
            this.lbcUnit.setEnabled(false);
            this.lbcPricePrecision.setEnabled(false);
        }
        this.lbcUnit.setEnabled(this.chkQty.isSelected());
        this.lbcPricePrecision.setEnabled(this.chkQty.isSelected());
        this.btnCopy.setEnabled(true);
        if (!this.currentCompanyIsCtrlUnit()) {
            this.actionMultiPageCopy.setVisible(true);
        }
        this.btnMultiPageCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    @Override
    protected void chkQty_stateChanged(ChangeEvent e) throws Exception {
        this.lbcUnit.setEnabled(this.chkQty.isSelected());
        this.lbcPricePrecision.setEnabled(this.chkQty.isSelected());
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((Object)((MultiLangItem)this.txtName.getDefaultLangItemData()).getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.kDLabelContainer2.getBoundLabelText()});
        }
        super.beforeStoreFields(arg0);
    }

    @Override
    public void storeFields() {
        ExpenseListUI listUI = (ExpenseListUI)((Object)this.getUIContext().get("Owner"));
        Object uo = listUI.getSelectedTreeNode().getUserObject();
        if (uo instanceof ExpenseTreeInfo) {
            this.editData.setTreeid((ExpenseTreeInfo)uo);
        }
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        ExpenseInfo objectValue = new ExpenseInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setIsSys(false);
        this.isAddnew = true;
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("isSys"));
        return sic;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPane.getSelectedIndex() == 0) {
            super.actionAddNew_actionPerformed(e);
        } else {
            this.currentCompanyUI.actionAddNew_actionPerformed(e);
            this.btnSubmit.setEnabled(true);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPane.getSelectedIndex() == 0) {
            super.actionCopy_actionPerformed(e);
        } else {
            this.currentCompanyUI.actionCopy_actionPerformed(e);
            this.btnSubmit.setEnabled(true);
        }
        this.action = e;
        this.perAction = "actionCopy";
        this.setContrlUnit();
        this.txtNumber.requestFocus();
        this.isCopy = true;
        this.isMultiPageCopy = false;
        this.chkQty.setEnabled(true);
        this.prmtUnit.setEnabled(true);
        this.kDSpinnerPrecision.setEnabled(true);
    }

    @Override
    public void actionMultiPageCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isMultiPageCopy = true;
        this.oldType = this.editData.getExpenseType();
        this.editData.setIsSys(false);
        super.actionCopy_actionPerformed(e);
        this.action = e;
        this.setContrlUnit();
        this.perAction = "actionMultiPageCopy";
        this.isCopy = false;
        this.chkQty.setEnabled(true);
        this.prmtUnit.setEnabled(true);
        this.kDSpinnerPrecision.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPane.getSelectedIndex() == 0) {
            super.actionEdit_actionPerformed(e);
            if (this.txtNumber.getText().equals("5001")) {
                this.txtNumber.setEnabled(false);
                this.txtName.setEnabled(false);
            }
        } else {
            this.currentCompanyUI.actionEdit_actionPerformed(e);
            this.btnSubmit.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPane.getSelectedIndex() == 0) {
            if (this.txtNumber.getText().equals("5001")) {
                MsgBox.showInfo((String)BDCMClientUtils.getNcmResource("CannotDeleteSysExpense"));
                SysUtil.abort();
            }
            super.actionRemove_actionPerformed(e);
        } else {
            this.currentCompanyUI.actionRemove_actionPerformed(e);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Boolean refIs;
        if (this.tabPane.getSelectedIndex() == 0) {
            super.actionSave_actionPerformed(e);
            if (!this.isCopy && !this.isMultiPageCopy) {
                this.getUIContext().put("pk", this.editData.getId().toString());
            }
            if (this.isMultiPageCopy) {
                this.initCompanyUI();
                if (this.currentCompanyUI != null && this.currentCompanyUI.prmtcostItem != null && this.currentCompanyUI.prmtcostItem.getValue() != null) {
                    this.currentCompanyUI.actionSubmit_actionPerformed(e);
                }
            }
        } else {
            this.currentCompanyUI.actionSave_actionPerformed(e);
        }
        if ((refIs = (Boolean)this.getUIContext().get("ref")) != null && refIs.booleanValue()) {
            this.setCompentsOnRef();
        }
        this.perAction = "actionSubmit";
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        this.txtNumber.requestFocus();
    }

    @Override
    protected void tabPane_stateChanged(ChangeEvent e) throws Exception {
        int forwardIndex = this.tabPane.getSelectedIndex();
        if (forwardIndex == 1) {
            this.btnRemove.setVisible(true);
            this.hideSomeAction(false);
            this.checkCompanyOrgUnit();
            this.initCompanyUI();
            if ("actionMultiPageCopy".equals(this.perAction)) {
                this.actionSave.setEnabled(false);
            }
            if ("VIEW".equals(this.getOprtState())) {
                this.actionRemove.setEnabled(false);
            }
        } else {
            this.btnRemove.setVisible(false);
            this.hideSomeAction(true);
            this.actionCopy.setEnabled(true);
            this.actionAddNew.setEnabled(true);
            this.actionRemove.setEnabled(true);
            if (!this.currentCompanyIsCtrlUnit()) {
                this.actionMultiPageCopy.setEnabled(true);
            }
            if (!"VIEW".equals(this.getOprtState())) {
                this.actionSubmit.setEnabled(true);
            }
        }
        if (lastSelectedIndex == 0 && forwardIndex == 1) {
            if (this.isModify() || "ADDNEW".equals(this.getOprtState())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saveCurrentPageFirst"));
                this.tabPane.setSelectedIndex(0);
                return;
            }
        } else if (lastSelectedIndex == 1 && forwardIndex == 0 && this.currentCompanyUI != null && this.currentCompanyUI.isModify()) {
            int answer = MsgBox.showConfirm3(null, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"confirmSaveModifideData"));
            if (MsgBox.isYes((int)answer)) {
                this.currentCompanyUI.actionSave_actionPerformed(null);
                this.tabPane.removeChangeListener(this.tabChangeListener);
                this.tabPane.setSelectedIndex(1);
                this.tabPane.addChangeListener(this.tabChangeListener);
            }
            return;
        }
        lastSelectedIndex = forwardIndex;
    }

    protected void initCompanyUI() throws Exception {
        ItemAction actionName = this.getActionFromActionEvent(this.action);
        if (this.companyInfoUI.getComponentCount() == 0) {
            this.currentCompanyUI = new ExpenseCompanyInfoEditUI();
            if (this.perAction.equals("actionSubmit")) {
                this.currentCompanyUI.getUIContext().remove("pk");
                this.currentCompanyUI.getUIContext().put("pk", this.editData.getId().toString());
            }
        }
        if (this.companyInfoUI.getComponentCount() == 0 || this.perAction.equals("actionCopy") || this.perAction.equals("actionMultiPageCopy") || this.perAction.equals("actionSubmit")) {
            this.currentCompanyUI.initLayout();
            if (this.editData.getId() == null) {
                return;
            }
            ExpenseCompanyInfoInfo companyInfo = null;
            if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                companyInfo = this.currentCompanyUI.getCompanyInfoByOrg(SysContext.getSysContext().getCurrentFIUnit().getId(), this.editData.getId().toString());
            }
            if (companyInfo == null || "ADDNEW".equals(this.getOprtState()) || ((Object)((Object)this.actionMultiPageCopy)).equals(actionName)) {
                companyInfo = new ExpenseCompanyInfoInfo();
                companyInfo.setExpense(this.editData);
            }
            this.getUIContext().put("InitDataObject", companyInfo);
            if (companyInfo.getId() == null) {
                this.getUIContext().put("IDList", null);
            } else {
                RealModeIDList secondTabIDList = new RealModeIDList();
                secondTabIDList.add(companyInfo.getId().toString());
                this.getUIContext().put("IDList", secondTabIDList);
            }
            this.currentCompanyUI.getUIContext().putAll(this.getUIContext());
            this.currentCompanyUI.getUIContext().put("_Expense", this.editData);
            this.currentCompanyUI.setDataObject((IObjectValue)companyInfo);
        }
        BOSUuid id = this.editData.getId();
        String pk = "";
        pk = id == null || this.isMultiPageCopy ? this.getUIContext().get("pk").toString() : id.toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)pk));
        Object expenseInfotype = this.getUIContext().get("_InfoType");
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String selectedCompanyID = "";
        if (this.getUIContext().get("_companyID") != null) {
            selectedCompanyID = this.getUIContext().get("_companyID").toString();
        }
        if (expenseInfotype != null && "0".equals(expenseInfotype.toString())) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID));
        } else if (selectedCompanyID != null && !selectedCompanyID.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)selectedCompanyID));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("costItem.id");
        sic.add("KAClass.id");
        sic.add("companyOrgUnit.id");
        view.setFilter(filter);
        ExpenseCompanyInfoCollection ecColl = ExpenseCompanyInfoFactory.getRemoteInstance().getExpenseCompanyInfoCollection(view);
        if (ecColl != null && ecColl.size() > 0 && !"actionCopy".equals(this.perAction)) {
            KAClassficationInfo kaClass;
            CostItemInfo costItem;
            CompanyOrgUnitInfo company = ecColl.get(0).getCompanyOrgUnit();
            if (company != null) {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
                this.currentCompanyUI.getUIContext().put("_Company", companyInfo);
            }
            if ((costItem = ecColl.get(0).getCostItem()) != null && !this.isCopy) {
                CostItemInfo costItemInfo = CostItemFactory.getRemoteInstance().getCostItemInfo((IObjectPK)new ObjectUuidPK(costItem.getId().toString()));
                this.currentCompanyUI.getUIContext().put("_CostItem", costItemInfo);
            }
            if ((kaClass = ecColl.get(0).getKAClass()) != null && !this.isCopy) {
                KAClassficationInfo kaClassInfo = KAClassficationFactory.getRemoteInstance().getKAClassficationInfo((IObjectPK)new ObjectUuidPK(kaClass.getId().toString()));
                this.currentCompanyUI.getUIContext().put("_KAClass", kaClassInfo);
            }
        } else if (ecColl == null || ecColl.size() == 0) {
            this.currentCompanyUI.getUIContext().put("_CostItem", null);
            this.currentCompanyUI.getUIContext().put("_KAClass", null);
        }
        this.companyInfoUI.add((Component)((Object)this.currentCompanyUI));
        this.currentCompanyUI.setOprtState(this.getOprtState());
        if (this.isMultiPageCopy || this.isCopy) {
            this.currentCompanyUI.prmtcostItem.setRequired(true);
            this.currentCompanyUI.prmtcostItem.setReadOnly(false);
            this.currentCompanyUI.prmtKAClass.setReadOnly(false);
        }
        this.currentCompanyUI.onLoad();
    }

    private void setCompentsOnRef() {
        this.txtNumber.setEnabled(false);
        this.txtName.setEnabled(false);
        this.combExpenseType.setEnabled(false);
        this.chkQty.setEnabled(false);
        this.prmtUnit.setEnabled(false);
        this.kDSpinnerPrecision.setEnabled(false);
        this.kDBizMultiLangArea1.setEnabled(false);
        this.actionRemove.setEnabled(false);
    }

    private void setContrlUnit() {
        this.editData.setAdminCU(null);
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    private boolean checkCompanyOrgUnit() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        String companyID = "";
        if (this.getUIContext().get("_companyID") != null) {
            companyID = this.getUIContext().get("_companyID").toString();
        }
        if (this.currentCompanyIsCtrlUnit()) {
            this.hideSomeAction(false);
            this.actionCopy.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionMultiPageCopy.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            MsgBox.showError((String)ExpenseEditUI.getNcmResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
            return false;
        }
        return companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit() || "".equals(companyID);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void hideSomeAction(boolean isDisPlay) {
        this.actionCopy.setVisible(isDisPlay);
        this.actionFirst.setVisible(isDisPlay);
        this.actionPre.setVisible(isDisPlay);
        this.actionNext.setVisible(isDisPlay);
        this.actionLast.setVisible(isDisPlay);
        this.actionMultiPageCopy.setVisible(isDisPlay);
    }

    public static String getNcmResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NcmResource", (String)key);
    }

    private boolean currentCompanyIsCtrlUnit() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        return companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit();
    }

    public boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }
}

