/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDAssignInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfoTypeEnum;
import com.kingdee.eas.basedata.ncm.ExpenseTreeFactory;
import com.kingdee.eas.basedata.ncm.client.AbstractExpenseListUI;
import com.kingdee.eas.basedata.ncm.client.BDCMMultiViewUI;
import com.kingdee.eas.basedata.ncm.client.ExpenseTreeEditUI;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ExpenseListUI
extends AbstractExpenseListUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseListUI.class);
    public static final String SysExpense = "ml7t5QEaEADgAAwawKgRe0olWCc=";
    private KDMenuItem menuOrgByCustomer = null;
    private KDMenuItem menuCustomerByOrg = null;
    private int importInfoIndex = 0;

    public ExpenseListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.ncm.app", "ExpenseQuery");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.selectNode();
        this.initCompents();
        NCMClientUtils.addNCMDataToolUI((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.getMainOrgContext().put((Object)"CompanyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit());
    }

    protected void initTableParams() {
        super.initTableParams();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAssignDataBaseD.setVisible(true);
        this.btnAssignDataBaseD.setEnabled(true);
        this.btnViewAssigned.setVisible(true);
        this.btnViewAssigned.setEnabled(true);
    }

    private void initCompents() {
        this.setDisplayColumnn(ExpenseInfoTypeEnum.baseInfo);
        this.setDefaultCtrlUnit();
        this.expenseInfoType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ExpenseListUI.this.expenseInfoType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    ExpenseListUI.this.handUIException(exc);
                }
            }
        });
        this.expenseCtrlUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    TreePath oldPath = ExpenseListUI.this.treeMain.getSelectionPath();
                    ExpenseListUI.this.initTree();
                    ExpenseListUI.this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)ExpenseListUI.this.treeMain, (TreeModel)ExpenseListUI.this.treeMain.getModel(), (TreePath)oldPath));
                }
                catch (Exception e) {
                    ExpenseListUI.this.handUIException(e);
                }
            }
        });
        this.expenseInfoCope.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    TreePath oldPath = ExpenseListUI.this.treeMain.getSelectionPath();
                    ExpenseListUI.this.initTree();
                    ExpenseListUI.this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)ExpenseListUI.this.treeMain, (TreeModel)ExpenseListUI.this.treeMain.getModel(), (TreePath)oldPath));
                }
                catch (Exception exc) {
                    ExpenseListUI.this.handUIException(exc);
                }
            }
        });
    }

    private void checkSysExpense() {
        if (SysExpense.equalsIgnoreCase(this.getSelectedKeyValue())) {
            MsgBox.showInfo((String)BDCMClientUtils.getNcmResource("CannotDeleteSysExpense"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
            this.getBizInterface().isReferenced((IObjectPK)pk);
        }
        catch (DataBaseDException ex) {
            if (!DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED.getCode().equals(ex.getSubCode())) {
                throw ex;
            }
        }
        catch (ObjectReferedException ex) {
            BizReference ref = (BizReference)ex.getReferingObject();
            if (ref != null) {
                super.actionEdit_actionPerformed(e);
            }
            throw ex;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        this.setHasQyeryPK(false);
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionEdit) || action.equals(this.actionView)) {
            try {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
                boolean result = ExpenseFactory.getRemoteInstance().isUsed((IObjectPK)pk);
                if (result) {
                    uiContext.put((Object)"ref", (Object)Boolean.TRUE);
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        if (this.getSelectedKeyValue() != null) {
            uiContext.put((Object)"pk", (Object)BOSUuid.read((String)this.getSelectedKeyValue()));
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (selectRows.length > 0) {
                Object company = this.tblMain.getRow(selectRows[0]).getCell("companyID").getValue();
                if (company != null) {
                    String companyOrgID = this.tblMain.getRow(selectRows[0]).getCell("companyID").getValue().toString();
                    uiContext.put((Object)"_companyID", (Object)companyOrgID);
                } else {
                    uiContext.put((Object)"_companyID", (Object)"");
                }
            }
        } else {
            uiContext.put((Object)"pk", (Object)"");
        }
        uiContext.put((Object)"_ListUI", (Object)this);
        uiContext.put((Object)"_InfoType", (Object)this.expenseInfoType.getSelectedIndex());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSysExpense();
        super.actionRemove_actionPerformed(e);
        TreePath oldPath = this.treeMain.getSelectionPath();
        super.initTree();
        this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!this.isSelectDefaultTreeNode() && node.isLeaf() && this.tblMain.getRowCount() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"3_AUXOverheadListUI"));
            SysUtil.abort();
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupMoveTree_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    public void actionAssignDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssignDataBaseD_actionPerformed(e);
    }

    public void actionReferDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        super.actionReferDataBaseD_actionPerformed(e);
    }

    public void actionBathAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionBathAssign_actionPerformed(e);
    }

    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpgrade_actionPerformed(e);
    }

    public void actionViewAssigned_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAssigned_actionPerformed(e);
    }

    @Override
    public void actionViewExpenseByOrg_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = null;
        Map map = this.getUIContext();
        map.put("Owner", this);
        map.put("0", "2");
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow groupDialog = uiFactory.create(BDCMMultiViewUI.class.getName(), map);
            groupDialog.show();
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionViewOrgByExpense_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = null;
        Map map = this.getUIContext();
        map.put("Owner", this);
        map.put("0", "1");
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow groupDialog = uiFactory.create(BDCMMultiViewUI.class.getName(), map);
            groupDialog.show();
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ExpenseFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return ExpenseTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return ExpenseTreeEditUI.class.getName();
    }

    @Override
    protected IObjectPK getSelectedTreeKeyValue() {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            ObjectUuidPK detail = new ObjectUuidPK(id);
            try {
                ExpenseInfo treeInfo = (ExpenseInfo)this.getBizInterface().getValue((IObjectPK)detail);
                if (treeInfo.getTreeid() != null) {
                    ObjectUuidPK tree = new ObjectUuidPK(treeInfo.getTreeid().getId());
                    return tree;
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.treeMain.setSelectionRow(0);
        return null;
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"9_ExpenseListUI");
    }

    protected FilterItemInfo getSingleNodeFilter(TreeBaseInfo treeNode) {
        if (treeNode == null) {
            return new FilterItemInfo(this.getQueryFieldName(), null, CompareType.IS);
        }
        return new FilterItemInfo(this.getQueryFieldName(), (Object)treeNode.getId().toString());
    }

    @Override
    protected IObjectValue createNewData() {
        ExpenseInfo objectValue = new ExpenseInfo();
        return objectValue;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.menuOrgByCustomer = new KDMenuItem();
        this.menuOrgByCustomer.setAction((Action)((Object)this.actionViewOrgByExpense));
        this.menuOrgByCustomer.setText(this.menuViewOrgByExpense.getText());
        this.menuOrgByCustomer.setIcon(EASResource.getIcon((String)"imgTbtn_seeorganize"));
        this.menuCustomerByOrg = new KDMenuItem();
        this.menuCustomerByOrg.setAction((Action)((Object)this.actionViewExpenseByOrg));
        this.menuCustomerByOrg.setText(this.menuViewExpenseByOrg.getText());
        this.menuCustomerByOrg.setIcon(EASResource.getIcon((String)"imgTbtn_fromorganize"));
        this.btnMultiView.addAssistMenuItem((JMenuItem)this.menuOrgByCustomer);
        this.btnMultiView.addAssistMenuItem((JMenuItem)this.menuCustomerByOrg);
        this.btnMultiView.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuMultiView.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.menuViewOrgByExpense.setIcon(EASResource.getIcon((String)"imgTbtn_seeorganize"));
        this.menuViewExpenseByOrg.setIcon(EASResource.getIcon((String)"imgTbtn_fromorganize"));
        this.menuImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImportStandard.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemImportCompanyInfo.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        cmcq.set("query", (Object)"ExpenseCompanyQuery");
        dialog.setProcessor((IProcessor)cmcq);
        return dialog;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        this.importData();
        this.refresh(e);
    }

    private void importData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0);
        }
    }

    @Override
    public void actionImportStandard_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 0;
        this.actionImportData_actionPerformed(e);
    }

    @Override
    public void actionImportCompanyInfo_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 1;
        this.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = this.initParamForImport();
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        super.actionRefresh_actionPerformed(e);
    }

    private DatataskParameter initParamForImport() {
        String alias;
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        switch (this.importInfoIndex) {
            case 0: {
                solutionName = "expense";
                alias = EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"9_ExpenseListUI");
                break;
            }
            default: {
                solutionName = "expenseCompanyInfo";
                alias = EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"10_ExpenseListUI");
            }
        }
        param.solutionName = solutionName;
        param.alias = alias;
        param.putContextParam((Object)"cuId", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        param.putContextParam((Object)"companyId", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        return param;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor test = super.getQueryExecutor(this.mainQueryPK, viewInfo);
        return test;
    }

    @Override
    protected void expenseInfoType_itemStateChanged(ItemEvent e) throws Exception {
        this.clearCommonQueryDialog();
        Locale locale = SysContext.getSysContext().getLocale();
        String selectedValue = e.getItemSelectable().getSelectedObjects()[0].toString();
        this.setDefaultEntityViewInfo(null);
        if (ExpenseInfoTypeEnum.baseInfo.getAlias(locale).equals(selectedValue)) {
            this.expenseInfoCope.setSelectedIndex(0);
            this.setMainQueryPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.ncm.app", "ExpenseQuery"));
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
            this.setDisplayColumnn(ExpenseInfoTypeEnum.baseInfo);
        } else if (ExpenseInfoTypeEnum.companyInfo.getAlias(locale).equals(selectedValue)) {
            this.setMainQueryPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.ncm.app", "ExpenseCompanyQuery"));
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
            this.setDisplayColumnn(ExpenseInfoTypeEnum.companyInfo);
        }
    }

    private void setDisplayColumnn(ExpenseInfoTypeEnum typeEnum) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (typeEnum.getAlias(locale).equals(ExpenseInfoTypeEnum.baseInfo.getAlias(locale))) {
            this.tblMain.getColumn("companyOrg").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("costItem").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("kAClass").getStyleAttributes().setHided(true);
            this.expenseInfoCopeLabel.setVisible(false);
            this.tblMain.getColumn("isAllocateQty").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("unit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("pricePrecision").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("description").getStyleAttributes().setHided(false);
        } else if (typeEnum.getAlias(locale).equals(ExpenseInfoTypeEnum.companyInfo.getAlias(locale))) {
            this.tblMain.getColumn("isAllocateQty").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("unit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("pricePrecision").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("description").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("companyOrg").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("costItem").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("kAClass").getStyleAttributes().setHided(false);
            this.expenseInfoCopeLabel.setVisible(true);
        }
    }

    private void setDefaultCtrlUnit() {
        CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        this.expenseCtrlUnit.setValue((Object)ctrlUnit);
        BDCMClientUtils.setBizOrgF7ByType(this.expenseCtrlUnit, OrgType.ControlUnit, false);
    }

    @Override
    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            int expenseInfoCope = this.expenseInfoCope.getSelectedIndex();
            int expenseInfoType = this.expenseInfoType.getSelectedIndex();
            if (expenseInfoCope == 1) {
                FilterInfo filter = this.setCompanyFilter();
                if (filter != null) {
                    FilterItemInfo filterItem = null;
                    for (int i = 0; i < ev.getFilter().getFilterItems().size(); ++i) {
                        filterItem = ev.getFilter().getFilterItems().get(i);
                        ev.getFilter().getFilterItems().remove(filterItem);
                    }
                    ev.setFilter(filter);
                }
            } else if (expenseInfoCope == 0 && expenseInfoType == 1) {
                String ctrlUnitID = "";
                ctrlUnitID = this.expenseCtrlUnit.getValue() == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : ((CtrlUnitInfo)this.expenseCtrlUnit.getValue()).getId().toString();
                String sql = "select id where cu.id = '" + ctrlUnitID + "' and isBizUnit = 1";
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(sql);
                Iterator iter = companyColl.iterator();
                HashSet<String> companyIDSet = new HashSet<String>();
                while (iter.hasNext()) {
                    String companyID = ((CompanyOrgUnitInfo)iter.next()).getId().toString();
                    companyIDSet.add(companyID);
                }
                if (companyIDSet.size() > 0) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("expenseComapnyInfo.companyOrgUnit.id", companyIDSet, CompareType.INCLUDE));
                    FilterInfo filterDefualtCompany = new FilterInfo();
                    filterDefualtCompany.getFilterItems().add(new FilterItemInfo("expenseComapnyInfo.companyOrgUnit.id", null, CompareType.EQUALS));
                    if (filter != null) {
                        filterDefualtCompany.mergeFilter(filter, "or");
                    }
                    ev.getFilter().mergeFilter(filterDefualtCompany, "and");
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.beforeExcutQuery(ev);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.isIgnoreCUFilter()) {
            return filter;
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        String ctrlUnitID = "";
        ctrlUnitID = this.expenseCtrlUnit.getValue() == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : ((CtrlUnitInfo)this.expenseCtrlUnit.getValue()).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ctrlUnitID, CompareType.EQUALS));
        String sql = "select id, dataBaseDID WHERE BOSObjectType = '4A255827' AND AssignCU.id = '" + ctrlUnitID + "'";
        try {
            DataBaseDAssignCollection coll = DataBaseDAssignFactory.getRemoteInstance().getDataBaseDAssignCollection(sql);
            HashSet<String> expenseIDSet = new HashSet<String>();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                String id = ((DataBaseDAssignInfo)iter.next()).getDataBaseDID().toString();
                expenseIDSet.add(id);
            }
            if (expenseIDSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", expenseIDSet, CompareType.INCLUDE));
                filter.setMaskString("#0 or #1");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filter;
    }

    private FilterInfo setCompanyFilter() {
        FilterInfo filter = new FilterInfo();
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        HashSet<String> expenseIDSet = new HashSet<String>();
        String getExpenseID = "select id where companyOrgUnit.id = '" + companyID + "'";
        try {
            ExpenseCompanyInfoCollection coll = ExpenseCompanyInfoFactory.getRemoteInstance().getExpenseCompanyInfoCollection(getExpenseID);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                String expenseID = ((ExpenseCompanyInfoInfo)iter.next()).getId().toString();
                expenseIDSet.add(expenseID);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (expenseIDSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("EXPENSECOMAPNYINFO.ID", expenseIDSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("EXPENSECOMAPNYINFO.ID", (Object)"", CompareType.EQUALS));
        }
        return filter;
    }

    public boolean isSelectDefaultTreeNode() throws Exception {
        String treePK = this.getSelectedTreeNodeObjectID();
        return treePK == null || treePK.toString().length() == 0;
    }

    protected QueryInfo getQueryInfoFromQueryPK() throws Exception {
        Object qiQuery = null;
        if (qiQuery == null) {
            MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.ncm.app", "ExpenseQuery"));
        }
        return super.getQueryInfoFromQueryPK();
    }

    protected String getQuerySqlFromQueryPK() throws Exception {
        String sqlQuery = null;
        if (sqlQuery == null) {
            IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.ncm.app", "ExpenseQuery"));
            sqlQuery = qe.getSQL();
        }
        return sqlQuery;
    }
}

