/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.ncm.IPeriod;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodSpanEnum;
import com.kingdee.eas.basedata.ncm.PeriodTypeInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractPeriodEditUI;
import com.kingdee.eas.basedata.ncm.client.PeriodListUI;
import com.kingdee.eas.basedata.ncm.utils.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.client.DateHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class PeriodEditUI
extends AbstractPeriodEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PeriodEditUI.class);
    private PeriodListUI ui = null;
    private PeriodRender render = null;
    private IPeriod iPeriod = null;
    private boolean isClose = true;
    private Map map = new HashMap(500);
    private DecimalFormat df = null;
    private Locale locale = null;
    private Locale sLocale = new Locale("l2");
    private Locale tLocale = new Locale("l3");
    private int bYear;
    private int bMonth;
    private int eYear;
    private int eMonth;
    private int bDay;
    private int eDay;
    private PeriodTypeInfo periodType;
    private Calendar calendar;
    private Date defaultBeginDate;
    private Date defaultEndDate;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"11_PeriodEditUI"));
        this.locale = this.getCurrentLocale();
        this.calendar = Calendar.getInstance();
        this.kDButStartupHelp.setVisible(false);
        this.kDButEndHelp.setVisible(false);
        this.kDPanelPersonalEnd.setVisible(false);
        this.kDPanelEnd.setVisible(false);
        this.df = new DecimalFormat("00");
        this.ui = (PeriodListUI)((Object)this.getUIContext().get("ISCANCEL"));
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.kDStartupImage.setIcon(bg);
        this.kDEndImage.setIcon(bg);
        this.KDPersonalImage.setIcon(bg);
        this.periodType = (PeriodTypeInfo)this.getUIContext().get("periodType");
        this.prmtPeriodType.setValue((Object)this.periodType);
        this.rdoPersonal.setEnabled(false);
        this.rdoTenDay.setEnabled(false);
        this.rdoWeek.setEnabled(false);
        this.rdoDay.setSelected(true);
        this.prmtPeriodType.setEditable(false);
        this.setPeriodDate();
        this.InitTable();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            try {
                this.dpBeginDate.setValue(null);
                this.dpEndDate.setValue(null);
                Date endDate = PeriodFactory.getRemoteInstance().getEndDataInPeriod((IObjectPK)new ObjectUuidPK(this.periodType.getId()));
                if (endDate == null) {
                    this.calendar.setTime(PeriodUtils.getFirstDayOfYear(PeriodUtils.getCurrentlyYear()));
                } else {
                    this.calendar.setTime(PeriodUtils.getDayBegin(endDate));
                    this.calendar.add(5, 1);
                }
                this.defaultBeginDate = this.calendar.getTime();
                this.dpBeginDate.setValue((Object)this.calendar.getTime());
                this.calendar.add(1, 2);
                this.calendar.set(2, 11);
                this.calendar.set(5, 31);
                this.defaultEndDate = this.calendar.getTime();
                this.dpEndDate.setValue((Object)this.calendar.getTime());
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.toolBar.setVisible(false);
        this.menuBar.setVisible(false);
        this.prmtPeriodType.setEnabled(false);
    }

    private void setPeriodDate() {
        Date beginDate = (Date)this.dpBeginDate.getValue();
        Date endDate = (Date)this.dpEndDate.getValue();
        if (beginDate == null || endDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"12_PeriodEditUI"));
            SysUtil.abort();
        }
        this.bYear = PeriodUtils.getCurrentlyYear(beginDate);
        this.bMonth = PeriodUtils.getCurrentlyMonth(beginDate);
        this.eYear = PeriodUtils.getCurrentlyYear(endDate);
        this.eMonth = PeriodUtils.getCurrentlyMonth(endDate);
        this.calendar.setTime(beginDate);
        this.bDay = this.calendar.get(5);
        this.calendar.setTime(endDate);
        this.eDay = this.calendar.get(5);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kDButEndHelp_actionPerformed(ActionEvent e) throws Exception {
        super.kDButEndHelp_actionPerformed(e);
    }

    @Override
    protected void kDButStartupCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void kDButEndCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void kDButEndPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"11_PeriodEditUI"));
        this.kDTable.setVisible(false);
        this.kDPanelStartup.setVisible(true);
        this.kDPanelEnd.setVisible(false);
        this.kDTable.removeRows();
    }

    @Override
    protected void kDButEndFinish_actionPerformed(ActionEvent e) throws Exception {
        this.kDButEndHelp.setEnabled(false);
        this.kDButEndCancel.setEnabled(false);
        this.kDButEndPrevious.setEnabled(false);
        this.kDButEndFinish.setEnabled(false);
        this.isClose = false;
        this.endProcess();
    }

    private void endProcess() {
        try {
            if (this.iPeriod == null) {
                this.iPeriod = PeriodFactory.getRemoteInstance();
            }
            BarThread process = new BarThread(this.iPeriod, this.kDProgressBar, this.ui);
            process.start();
        }
        catch (BOSException ex) {
            this.isClose = true;
            this.kDButEndHelp.setEnabled(true);
            this.kDButEndCancel.setEnabled(true);
            this.kDButEndPrevious.setEnabled(true);
            this.kDButEndFinish.setEnabled(true);
            MsgBox.showError((Component)((Object)this), (String)ex.toString());
            SysUtil.abort();
        }
    }

    @Override
    protected void kDButStartupHelp_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void kDButStartupNext_actionPerformed(ActionEvent e) throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"13_PeriodEditUI"));
        if (this.rdoPersonal.isSelected()) {
            this.kDPanelStartup.setVisible(false);
            this.kDPanelEnd.setVisible(false);
            this.kDPanelPersonalEnd.setVisible(true);
        } else {
            this.setPeriodDate();
            this.startupProcess();
            this.kDPanelStartup.setVisible(false);
            this.kDPanelEnd.setVisible(true);
            this.kDTable.setVisible(true);
            this.kDProgressBar.setValue(0);
            this.kDProgressBar.setMinimum(0);
        }
    }

    private void startupProcess() {
        this.periodProcess();
    }

    private void periodProcess() {
        this.kDTable.setRefresh(false);
        for (int i = this.bYear; i <= this.eYear; ++i) {
            this.processYear(i);
        }
        this.kDTable.setRefresh(true);
    }

    @Override
    protected void btnPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.kDPanelPersonalEnd.setVisible(false);
        this.kDPanelStartup.setVisible(true);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnFinish_actionPerformed(ActionEvent e) throws Exception {
    }

    private void InitTable() {
        this.kDTable.getSelectManager().setSelectMode(2);
        int colCount = 5;
        for (int i = 0; i < colCount; ++i) {
            this.kDTable.addColumn(i);
        }
        IRow row = this.kDTable.addHeadRow();
        if (row != null) {
            row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"rowLongNumber"));
            row.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"rowName"));
            row.getCell(2).setValue((Object)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"14_PeriodEditUI"));
            row.getCell(3).setValue((Object)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"15_PeriodEditUI"));
            row.getCell(4).setValue((Object)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"16_PeriodEditUI"));
        }
        IColumn col = null;
        String formatString = "%{yyyy-MM-dd HH:mm:ss}t";
        col = this.kDTable.getColumn(0);
        if (col != null) {
            this.render = new PeriodRender();
            col.setRenderer((IBasicRender)this.render);
            col.setWidth(100);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(1)) != null) {
            col.setWidth(100);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(2)) != null) {
            col.getStyleAttributes().setNumberFormat(formatString);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(3)) != null) {
            col.getStyleAttributes().setNumberFormat(formatString);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(4)) != null) {
            col.setWidth(50);
            col.getStyleAttributes().setLocked(true);
        }
    }

    private void processYear(int sYear) {
        String YearNumber = null;
        boolean isLeaf = true;
        PeriodInfo periodYear = null;
        YearNumber = sYear + "Y";
        periodYear = (PeriodInfo)this.map.get(YearNumber);
        if (periodYear == null) {
            periodYear = new PeriodInfo();
            periodYear.setId(BOSUuid.create((BOSObjectType)periodYear.getBOSType()));
            periodYear.setNumber(YearNumber);
            periodYear.setLongNumber(YearNumber);
            if (this.locale.equals(this.sLocale)) {
                periodYear.setName(sYear + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Year"), this.sLocale);
                periodYear.setName(STConverter.sc2tc((String)periodYear.getName(this.sLocale)), this.tLocale);
            } else if (this.locale.equals(this.tLocale)) {
                periodYear.setName(sYear + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Year"), this.tLocale);
                periodYear.setName(STConverter.tc2sc((String)periodYear.getName(this.tLocale)), this.sLocale);
            } else {
                periodYear.setName(sYear + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Year"));
            }
            periodYear.setBeginDate(PeriodUtils.getFirstDayOfMonth(this.bYear, this.bMonth));
            periodYear.setEndDate(PeriodUtils.getLastDayOfMonth(this.eYear, this.eMonth));
            periodYear.setPeriodType(this.periodType);
            periodYear.setLevel(1);
        }
        periodYear.setIsLeaf(isLeaf);
        if (this.bYear == this.eYear) {
            this.processMonth(sYear, this.bMonth, this.eMonth, periodYear);
        } else if (sYear == this.eYear) {
            this.processMonth(sYear, 1, this.eMonth, periodYear);
        } else if (sYear == this.bYear) {
            this.processMonth(sYear, this.bMonth, 12, periodYear);
        } else {
            this.processMonth(sYear, 1, 12, periodYear);
        }
    }

    private void processMonth(int Year, int bMonth, int eMonth, PeriodInfo periodYear) {
        boolean isLeaf = true;
        String sMonth = null;
        String MonthNumber = null;
        PeriodInfo periodMonth = null;
        for (int month = bMonth; month <= eMonth; ++month) {
            sMonth = this.df.format(month);
            MonthNumber = new StringBuffer(periodYear.getNumber() + "." + sMonth + "M").toString();
            periodMonth = (PeriodInfo)this.map.get(MonthNumber);
            if (periodMonth == null) {
                periodMonth = new PeriodInfo();
                periodMonth.setId(BOSUuid.create((BOSObjectType)periodMonth.getBOSType()));
                periodMonth.setNumber(MonthNumber);
                periodMonth.setLongNumber(periodYear.getLongNumber() + "!" + MonthNumber);
                if (this.locale.equals(this.sLocale)) {
                    periodMonth.setName(periodYear.getName(this.sLocale) + sMonth + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Month"), this.sLocale);
                    periodMonth.setName(STConverter.sc2tc((String)periodMonth.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    periodMonth.setName(periodYear.getName(this.tLocale) + sMonth + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Month"), this.tLocale);
                    periodMonth.setName(STConverter.tc2sc((String)periodMonth.getName(this.tLocale)), this.sLocale);
                } else {
                    periodMonth.setName(periodYear.getName() + sMonth + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Month"));
                }
                periodMonth.setBeginDate(PeriodUtils.getStartDate(PeriodUtils.getFirstDayOfMonth(Year, month)));
                periodMonth.setEndDate(PeriodUtils.getBeoverDate(PeriodUtils.getLastDayOfMonth(Year, month)));
                periodMonth.setPeriodType(this.periodType);
                periodMonth.setLevel(4);
            }
            if (bMonth == eMonth) {
                this.processDay(Year, month, this.bDay, this.eDay, periodMonth);
                continue;
            }
            if (month == bMonth) {
                this.processDay(Year, month, this.bDay, PeriodUtils.getDaysOfMonth(Year, month), periodMonth);
                continue;
            }
            if (month == eMonth) {
                this.processDay(Year, month, 1, this.eDay, periodMonth);
                continue;
            }
            this.processDay(Year, month, 1, PeriodUtils.getDaysOfMonth(Year, month), periodMonth);
        }
    }

    private void processDay(int Year, int Month, int beginDay, int endDay, PeriodInfo periodMonth) {
        String day = null;
        String dayNumber = null;
        PeriodInfo periodDay = null;
        int d = endDay;
        for (int i = beginDay; i <= d; ++i) {
            day = this.df.format(i);
            dayNumber = new StringBuffer(periodMonth.getNumber() + "." + day + "D").toString();
            periodDay = (PeriodInfo)this.map.get(dayNumber);
            if (periodDay == null) {
                periodDay = new PeriodInfo();
                periodDay.setId(BOSUuid.create((BOSObjectType)periodDay.getBOSType()));
                periodDay.setNumber(dayNumber);
                periodDay.setLongNumber(periodMonth.getLongNumber() + "!" + dayNumber);
                if (this.locale.equals(this.sLocale)) {
                    periodDay.setName(periodMonth.getName(this.sLocale) + day + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Day"), this.sLocale);
                    periodDay.setName(STConverter.sc2tc((String)periodDay.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    periodDay.setName(periodMonth.getName(this.tLocale) + day + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Day"), this.tLocale);
                    periodDay.setName(STConverter.tc2sc((String)periodDay.getName(this.tLocale)), this.sLocale);
                } else {
                    periodDay.setName(periodMonth.getName() + day + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodResource", (String)"Day"));
                }
                Date beginDate = DateHelper.getDayBegin((Date)PeriodUtils.getStartDate(PeriodUtils.getDay(Year, Month, i)));
                Date endDate = PeriodUtils.getDayEnd(PeriodUtils.getDay(Year, Month, i));
                periodDay.setBeginDate(beginDate);
                periodDay.setEndDate(endDate);
                periodDay.setPeriodType(this.periodType);
                periodDay.setLevel(-2);
                periodDay.setIsLeaf(true);
                periodDay.setSpan(PeriodSpanEnum.DAY);
            }
            this.processTable(periodDay);
        }
    }

    private void processTable(PeriodInfo periodInfo) {
        IRow row = null;
        NumberExpandInfo numberExpandInfo = null;
        row = this.kDTable.addRow();
        if (row != null) {
            row.setUserObject((Object)periodInfo);
            row.getCell(0).setValue((Object)periodInfo.getNumber());
            row.getCell(1).setValue((Object)periodInfo.getName());
            row.getCell(2).setValue((Object)periodInfo.getBeginDate());
            row.getCell(3).setValue((Object)periodInfo.getEndDate());
            row.getCell(4).setValue((Object)periodInfo.getSpan());
            numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setLevel(periodInfo.getLevel());
            numberExpandInfo.setLeaf(periodInfo.isIsLeaf());
            numberExpandInfo.setLongNumber(periodInfo.getLongNumber());
            numberExpandInfo.setNumber(periodInfo.getNumber());
            numberExpandInfo.setExpandStatus(true);
            row.getCell(0).setValue((Object)numberExpandInfo);
        }
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        NumberExpandInfo numberExpandInfo;
        int rowIndex;
        IRow row;
        int colIndex;
        if (e.getClickCount() == 1 && (colIndex = e.getColIndex()) == 0 && (row = this.kDTable.getRow(rowIndex = e.getRowIndex())) != null && (numberExpandInfo = (NumberExpandInfo)row.getCell(0).getValue()) != null && this.render.inRect(numberExpandInfo, e.getX(), e.getY())) {
            this.setTreeDisplayStyle(row, numberExpandInfo);
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo numberExpandInfo) {
        if (!numberExpandInfo.isLeaf) {
            this.kDTable.setRefresh(false);
            this.expandTable(row, numberExpandInfo);
            this.kDTable.setRefresh(true);
            this.kDTable.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo numberExpandInfo) {
        if (row == null || numberExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = numberExpandInfo.getLongNumber();
        boolean isExpandStatus = numberExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            numberExpandInfo.setExpandStatus(false);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            numberExpandInfo.setExpandStatus(true);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                this.expandChild(child, expandInfo);
            }
        }
    }

    private int expandChild(IRow row, NumberExpandInfo parentExpandInfo) {
        int rowIndex;
        IRow child = null;
        int endIndex = rowIndex = row.getRowIndex() + 1;
        int rowCount = this.kDTable.getRowCount();
        String number = null;
        NumberExpandInfo childExpandInfo = null;
        String parentNumber = parentExpandInfo.getLongNumber();
        parentExpandInfo.setExpandStatus(true);
        for (int i = rowIndex; i < rowCount; ++i) {
            child = this.kDTable.getRow(i);
            if (child != null) {
                childExpandInfo = (NumberExpandInfo)child.getCell(0).getValue();
                number = childExpandInfo.getLongNumber();
                if (!number.startsWith(parentNumber)) break;
                if (!childExpandInfo.isLeaf()) {
                    i = this.expandChild(child, childExpandInfo);
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    @Override
    protected void dpBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkDate();
    }

    @Override
    protected void dpEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkDate();
    }

    private void checkDate() {
        Date begin = (Date)this.dpBeginDate.getValue();
        Date end = (Date)this.dpEndDate.getValue();
        if (begin != null && end != null && begin.after(end)) {
            this.dpEndDate.setValue((Object)this.defaultEndDate);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"17_PeriodEditUI"));
            return;
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PeriodFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PeriodInfo objectValue = new PeriodInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    class NumberExpandInfo {
        private String number;
        private String longNumber;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }
    }

    private class PeriodRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        private PeriodRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class BarThread
    extends Thread {
        private int DELAY = 10;
        private KDProgressBar progressBar = null;
        private IPeriod iPeriod = null;
        private PeriodListUI ui = null;

        public BarThread(IPeriod iPeriod, KDProgressBar bar, PeriodListUI ui) {
            this.iPeriod = iPeriod;
            this.progressBar = bar;
            this.ui = ui;
        }

        @Override
        public void run() {
            if (this.iPeriod == null) {
                return;
            }
            int rowCount = PeriodEditUI.this.kDTable.getRowCount();
            this.progressBar.setMaximum(rowCount);
            PeriodInfo periodInfo = null;
            try {
                for (int i = 0; i < rowCount; ++i) {
                    periodInfo = (PeriodInfo)PeriodEditUI.this.kDTable.getRow(i).getUserObject();
                    if (periodInfo != null && this.checkPeriodInfo(periodInfo)) {
                        this.iPeriod.addnew((CoreBaseInfo)periodInfo);
                    }
                    this.progressBar.setValue(i);
                    try {
                        Thread.sleep(this.DELAY);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
                PeriodEditUI.this.handUIException(ex);
                PeriodEditUI.this.kDButEndCancel.setEnabled(true);
                PeriodEditUI.this.kDButEndPrevious.setEnabled(true);
                PeriodEditUI.this.kDButEndFinish.setEnabled(true);
                return;
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                PeriodEditUI.this.handUIException(ex);
                PeriodEditUI.this.kDButEndCancel.setEnabled(true);
                PeriodEditUI.this.kDButEndPrevious.setEnabled(true);
                PeriodEditUI.this.kDButEndFinish.setEnabled(true);
                return;
            }
            PeriodEditUI.this.map.clear();
            PeriodEditUI.this.isClose = true;
            try {
                this.ui.refreshList();
            }
            catch (Exception e) {
                PeriodEditUI.this.handleException(e);
            }
            PeriodEditUI.this.getUIWindow().close();
        }

        private boolean checkPeriodInfo(PeriodInfo periodInfo) {
            if (periodInfo == null) {
                return false;
            }
            return PeriodEditUI.this.map.get(periodInfo.getNumber()) == null;
        }
    }
}

