/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.ncm.PeriodCollection;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodTypeCollection;
import com.kingdee.eas.basedata.ncm.PeriodTypeFactory;
import com.kingdee.eas.basedata.ncm.PeriodTypeInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractPeriodListUI;
import com.kingdee.eas.basedata.ncm.utils.PeriodUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

public class PeriodListUI
extends AbstractPeriodListUI {
    private boolean isModifyBothDate = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPeriodType();
        this.setSelectForTable(true);
        this.actionAddNew.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionRemoveAll.setEnabled(true);
        this.actionRemove.setVisible(true);
        this.actionPeriodType.setVisible(true);
        this.actionSearch.setVisible(false);
        this.actionSynchronization.setEnabled(true);
        this.initHeader();
        this.fireQuery();
    }

    private void initHeader() {
        try {
            PeriodTypeInfo info = (PeriodTypeInfo)this.cboPeriodType.getSelectedItem();
            if (info != null) {
                Date[] date = this.getMinDateInPeriodType(info);
                this.isModifyBothDate = true;
                this.dpBeginDate.setValue((Object)date[0]);
                this.dpEndDate.setValue((Object)date[1]);
                this.isModifyBothDate = false;
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    public Date[] getMinDateInPeriodType(PeriodTypeInfo info) throws BOSException {
        Date[] date = new Date[2];
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)info.getId()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("beginDate"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSorter(sorter);
        PeriodCollection col = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
        if (col != null && col.size() > 0) {
            PeriodInfo period = col.get(0);
            date[0] = period.getBeginDate();
            period = col.get(col.size() - 1);
            date[1] = period.getBeginDate();
            return date;
        }
        Date first = PeriodUtils.getFirstDayOfYear(PeriodUtils.getCurrentlyYear());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(first);
        calendar.add(1, 2);
        calendar.set(2, 11);
        calendar.set(5, 31);
        date[0] = first;
        date[1] = calendar.getTime();
        return date;
    }

    private void setPeriodType() throws BOSException {
        this.cboPeriodType.removeAllItems();
        DefaultComboBoxModel<PeriodTypeInfo> ntdmode = new DefaultComboBoxModel<PeriodTypeInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        PeriodTypeCollection types = PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection(view);
        Iterator Ntit = null;
        if (types != null) {
            Ntit = types.iterator();
        }
        if (Ntit != null) {
            while (Ntit.hasNext()) {
                PeriodTypeInfo type = (PeriodTypeInfo)Ntit.next();
                ntdmode.addElement(type);
            }
        }
        this.cboPeriodType.setModel(ntdmode);
        if (types != null && types.size() > 0) {
            this.cboPeriodType.setSelectedIndex(0);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRemoveAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_clear"));
        this.actionPeriodType.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.actionSynchronization.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PeriodFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PeriodInfo objectValue = new PeriodInfo();
        return objectValue;
    }

    @Override
    public void actionPeriodType_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext();
        this.getUIContext().putAll(ctx);
        IUIFactory f = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow w = f.create("com.kingdee.eas.basedata.ncm.client.PeriodTypeListUI", (Map)ctx);
        w.show();
        this.setPeriodType();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.cboPeriodType.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"18_PeriodListUI"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ISCANCEL", (Object)this);
        uiContext.put((Object)"periodType", this.cboPeriodType.getSelectedItem());
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"19_PeriodListUI"));
        if (re == 1 || re == 2) {
            return;
        }
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.cboPeriodType.getSelectedItem();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodType.getId()));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpBeginDate.getValue())), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)PeriodUtils.getDayEnd((Date)this.dpEndDate.getValue()), CompareType.LESS_EQUALS));
        PeriodFactory.getRemoteInstance().delete(filter);
        this.tblMain.refresh();
    }

    @Override
    public void actionSynchronization_actionPerformed(ActionEvent e) throws Exception {
        if (this.cboPeriodType.getSelectedItem() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NcmResource", (String)"PeriodTypeNotNull"));
            this.cboPeriodType.requestFocus();
            SysUtil.abort();
        }
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.cboPeriodType.getSelectedItem();
        int count = PeriodFactory.getRemoteInstance().synchronization(periodType);
        if (count == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"20_PeriodListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"21_PeriodListUI"));
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (this.isFirstOnload()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"1"));
            ev.setFilter(filter);
        }
        super.beforeExcutQuery(ev);
    }

    @Override
    protected void cboPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (1 == e.getStateChange()) {
            this.initHeader();
            this.fireQuery();
        }
    }

    @Override
    protected void dpBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isModifyBothDate) {
            return;
        }
        this.checkDate();
        this.fireQuery();
    }

    @Override
    protected void dpEndDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isModifyBothDate) {
            return;
        }
        this.checkDate();
        this.fireQuery();
    }

    private void checkDate() {
        Date begin = (Date)this.dpBeginDate.getValue();
        Date end = (Date)this.dpEndDate.getValue();
        if (begin != null && end != null && begin.after(end)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"17_PeriodEditUI"));
            return;
        }
    }

    private void fireQuery() {
        if (this.cboPeriodType.getSelectedItem() != null && this.dpBeginDate.getValue() != null && this.dpEndDate.getValue() != null) {
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.cboPeriodType.getSelectedItem();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodType.getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpBeginDate.getValue())), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)PeriodUtils.getDayEnd((Date)this.dpEndDate.getValue()), CompareType.LESS_EQUALS));
            this.mainQuery.setFilter(filter);
            this.tblMain.removeRows();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

