/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.IPeriodStatus;
import com.kingdee.eas.basedata.ncm.PeriodCollection;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodStatuEnum;
import com.kingdee.eas.basedata.ncm.PeriodStatusCollection;
import com.kingdee.eas.basedata.ncm.PeriodStatusFactory;
import com.kingdee.eas.basedata.ncm.PeriodStatusInfo;
import com.kingdee.eas.basedata.ncm.PeriodTypeCollection;
import com.kingdee.eas.basedata.ncm.PeriodTypeFactory;
import com.kingdee.eas.basedata.ncm.PeriodTypeInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractPeriodStatusEditUI;
import com.kingdee.eas.basedata.ncm.client.PeriodStatusQueryUI;
import com.kingdee.eas.basedata.ncm.utils.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class PeriodStatusEditUI
extends AbstractPeriodStatusEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PeriodStatusEditUI.class);
    private FilterInfo filter = null;
    CompanyOrgUnitInfo company = null;
    PeriodTypeInfo periodType = null;
    private boolean isAddFilter = true;

    public PeriodStatusEditUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.initButtonEnable();
        this.initPrmtCompany();
        this.setPeriodType();
        this.initLoadTable();
        this.menuBar.setVisible(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initButtonEnable() {
        this.actionAddNew.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionSynchronization.setVisible(false);
        this.menuBar.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionSubmit.setEnabled(false);
        this.actionRefresh.setEnabled(true);
        this.actionOpen.setEnabled(true);
        this.actionClose.setEnabled(true);
        this.actionRemoveAll.setEnabled(true);
        this.actionSynchronization.setEnabled(false);
        this.actionQuery.setEnabled(true);
        this.actionRemove.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionOpen.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_freeze"));
        this.actionClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.actionSynchronization.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.actionRemoveAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_clear"));
        this.actionQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_filter"));
    }

    protected void initTable() {
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("period.beginDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm");
        this.tblMain.getColumn("period.endDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm");
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    public void initPrmtCompany() throws EASBizException, BOSException {
        CompanyF7 companyF7 = new CompanyF7((IUIObject)this);
        companyF7.setPermissionItem("bd_systemstatusectrol_view");
        this.prmtcompany.setDisplayFormat("$name$");
        this.prmtcompany.setEditFormat("$name$");
        if (!BooksUtil.isMasterBook(null)) {
            companyF7.setShowAssistantOrg(true);
        }
        this.prmtcompany.setSelector((KDPromptSelector)companyF7);
        this.getCurrentCompany();
    }

    private void getCurrentCompany() throws EASBizException, BOSException {
        String companyid;
        if (SysContext.getSysContext().getCurrentFIUnit() == null) {
            String resFullName = "com.kingdee.eas.basedata.assistant.client.PeriodResource.SysCuNotSysStaCtrEdit";
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resFullName));
            SysUtil.abort();
        }
        if ((companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString()) != null && !companyid.equals("")) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            this.company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            if (this.company.isIsBizUnit()) {
                this.prmtcompany.setData((Object)this.company);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"22_PeriodStatusEditUI"));
                SysUtil.abort();
            }
        } else {
            String resClassName = "com.kingdee.eas.basedata.assistant.client.PeriodResource";
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PeriodOperatorFail"));
            SysUtil.abort();
        }
    }

    private void setPeriodType() throws BOSException, EASBizException {
        PeriodTypeInfo type;
        DefaultComboBoxModel<PeriodTypeInfo> ntdmode = new DefaultComboBoxModel<PeriodTypeInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        PeriodTypeCollection types = PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection(view);
        Iterator Ntit = null;
        if (types != null) {
            Ntit = types.iterator();
        }
        if (Ntit != null) {
            while (Ntit.hasNext()) {
                type = (PeriodTypeInfo)Ntit.next();
                ntdmode.addElement(type);
            }
        }
        this.cboPeriodType.setModel(ntdmode);
        type = this.getPeriodTypeByCompany();
        if (type != null) {
            this.cboPeriodType.setSelectedItem((Object)type);
            this.periodType = types.get(0);
        } else if (types != null && types.size() > 0) {
            this.cboPeriodType.setSelectedIndex(0);
            this.periodType = types.get(0);
        }
        this.checkIsSetPeriod();
    }

    public PeriodTypeInfo getPeriodTypeByCompany() throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("periodType.*");
        selector.add("periodType.name");
        selector.add("periodType.number");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        view.setTopCount(1);
        view.setSelector(selector);
        view.setFilter(filter);
        PeriodStatusCollection info = PeriodStatusFactory.getRemoteInstance().getPeriodStatusCollection(view);
        if (info.size() > 0) {
            PeriodTypeInfo type = info.get(0).getPeriodType();
            return type;
        }
        return null;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.updateStatu(PeriodStatuEnum.CLOSE);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"23_PeriodStatusEditUI"));
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.updateStatu(PeriodStatuEnum.OPEN);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"24_PeriodStatusEditUI"));
    }

    public void updateStatu(PeriodStatuEnum statu) throws EASBizException, BOSException, Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            Object obj = this.getSelectedKeyValue(selectRows[i], this.tblMain, "id");
            if (obj instanceof PeriodStatusInfo) {
                PeriodStatusInfo info = (PeriodStatusInfo)obj;
                if (statu.equals((Object)info.getStatu())) {
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"25_PeriodStatusEditUI") + (Object)((Object)statu)));
                    SysUtil.abort();
                }
                info.setStatu(statu);
                this.getBizInterface().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
            IRow row = this.tblMain.getRow(selectRows[i]);
            row.getCell("statu").setValue((Object)statu);
            if (PeriodStatuEnum.CLOSE.equals((Object)statu)) {
                row.getStyleAttributes().setBackground(new Color(255, 255, 164));
                continue;
            }
            row.getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    public Object getSelectedKeyValue(int selectRows, KDTable table, String columnName) {
        Object keyValue;
        IRow row = table.getRow(selectRows);
        if (row == null) {
            return null;
        }
        ICell cell = row.getCell(columnName);
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            return keyValue;
        }
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.company == null || this.periodType == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"26_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        if (this.isExistsPeriodStatus()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"27_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        if (!this.isExistsPeriod()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"28_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        if (this.isExistsOtherPeriod()) {
            int rlt = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"29_PeriodStatusEditUI"));
            if (0 == rlt) {
                if (this.isExistsClosePeriodStatu()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"30_PeriodStatusEditUI"));
                    SysUtil.abort();
                }
                FilterInfo filter = new FilterInfo();
                FilterItemCollection items = filter.getFilterItems();
                items.add(new FilterItemInfo("company.id", (Object)this.company.getId()));
                this.getInstance().delete(filter);
            } else {
                SysUtil.abort();
            }
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("periods", (Object)this.getPeriodsByType());
        param.put("company", this.company);
        param.put("periodType", this.periodType);
        submitProgressHintListener listener = new submitProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, param);
        this.refresh();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Object period;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        ICell cell = row.getCell("id");
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((period = cell.getValue()) instanceof PeriodStatusInfo) {
            PeriodStatusInfo info = this.getInstance().getPeriodStatusInfo((IObjectPK)new ObjectUuidPK(((PeriodStatusInfo)period).getId()));
            if (info != null && PeriodStatuEnum.CLOSE.equals((Object)info.getStatu())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"31_PeriodStatusEditUI"));
                SysUtil.abort();
            }
            if (info != null) {
                this.getInstance().delete((IObjectPK)new ObjectUuidPK(info.getId()));
            }
        }
        this.isAddFilter = false;
        this.initLoadTable();
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        int rlt;
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"32_PeriodStatusEditUI"));
        if (re == 1 || re == 2) {
            return;
        }
        FilterItemCollection items = this.filter.getFilterItems();
        items.add(new FilterItemInfo("statu", (Object)PeriodStatuEnum.CLOSE));
        boolean exists = this.getInstance().exists(this.filter);
        if (exists && ((rlt = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"33_PeriodStatusEditUI"))) == 1 || rlt == 2)) {
            items.remove(new FilterItemInfo("statu", (Object)PeriodStatuEnum.CLOSE));
            return;
        }
        items.remove(new FilterItemInfo("statu", (Object)PeriodStatuEnum.CLOSE));
        items.add(new FilterItemInfo("statu", (Object)PeriodStatuEnum.OPEN));
        this.getInstance().delete(this.filter);
        items.remove(new FilterItemInfo("statu", (Object)PeriodStatuEnum.OPEN));
        this.isAddFilter = false;
        this.initLoadTable();
    }

    private IPeriodStatus getInstance() throws BOSException {
        return PeriodStatusFactory.getRemoteInstance();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.periodType == null || this.company == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"26_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        this.isAddFilter = false;
        this.filter = new FilterInfo();
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"filter", (Object)this.filter);
        uiContext.put((Object)"editui", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PeriodStatusQueryUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionSynchronization_actionPerformed(ActionEvent e) throws Exception {
        int re;
        if (!this.isExistsPeriodStatus()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"34_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"35_PeriodStatusEditUI"))) == 1 || re == 2) {
            SysUtil.abort();
        }
        if (this.periodType == null || this.company == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"26_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("company", this.company);
        param.put("periodType", this.periodType);
        synProgressHintListener listener = new synProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, param);
    }

    public void refresh() throws Exception {
        this.isAddFilter = true;
        if (this.periodType != null && this.company != null) {
            this.isNewFilterBeforeLoad();
        }
    }

    @Override
    protected void prmtcompany_dataChanged(DataChangeEvent e) throws Exception {
        this.company = (CompanyOrgUnitInfo)this.prmtcompany.getValue();
        this.isNewFilterBeforeLoad();
    }

    @Override
    protected void cboPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.periodType = (PeriodTypeInfo)this.cboPeriodType.getSelectedItem();
            this.isNewFilterBeforeLoad();
        }
    }

    public void isNewFilterBeforeLoad() throws Exception {
        this.filter = new FilterInfo();
        this.initLoadTable();
    }

    public void initLoadTable() throws Exception {
        if (this.company != null && this.periodType != null) {
            loadProgressHintListener listener = new loadProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, null);
        }
    }

    public void loadDataInTable() throws BOSException, EASBizException {
        this.tblMain.removeRows();
        this.checkIsSetPeriod();
        if (!this.isExistsPeriodStatus()) {
            this.actionSubmit.setEnabled(true);
            this.actionSynchronization.setEnabled(false);
            return;
        }
        this.actionSubmit.setEnabled(false);
        this.actionSynchronization.setEnabled(true);
        PeriodStatusCollection col = this.getCollection();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IRow row = this.tblMain.addRow();
            PeriodStatusInfo info = (PeriodStatusInfo)it.next();
            PeriodInfo period = info.getPeriod();
            row.getCell("id").setValue((Object)info);
            row.getCell("period.id").setValue((Object)period);
            row.getCell("period.number").setValue((Object)period.getNumber());
            row.getCell("period.name").setValue((Object)period.getName());
            row.getCell("period.span").setValue((Object)period.getSpan());
            row.getCell("period.beginDate").setValue((Object)period.getBeginDate());
            row.getCell("period.endDate").setValue((Object)period.getEndDate());
            row.getCell("statu").setValue((Object)info.getStatu());
            if (!PeriodStatuEnum.CLOSE.equals((Object)info.getStatu())) continue;
            row.getStyleAttributes().setBackground(new Color(255, 255, 164));
        }
    }

    public PeriodCollection getPeriodsByType() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.periodType.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        PeriodCollection col = PeriodFactory.getRemoteInstance().getPeriodCollection(evi);
        return col;
    }

    public boolean isExistsPeriod() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("periodType.id", (Object)this.periodType.getId()));
        boolean exists = PeriodFactory.getRemoteInstance().exists(filter);
        return exists;
    }

    public boolean isExistsOtherPeriod() throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelectors();
        sic.add("company.id");
        sic.add("period.*");
        sic.add("period.id");
        sic.add("periodType.id");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        items.add(new FilterItemInfo("periodType.id", (Object)this.periodType.getId(), CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        boolean exists = this.getInstance().exists(filter);
        return exists;
    }

    public boolean isExistsClosePeriodStatu() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        items.add(new FilterItemInfo("statu", (Object)PeriodStatuEnum.CLOSE));
        boolean exists = this.getInstance().exists(filter);
        return exists;
    }

    public PeriodStatusCollection getCollection() throws BOSException, EASBizException {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        com.kingdee.eas.basedata.assistant.PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.company.getId().toString());
        if (currentPeriod == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NCMCLIENTAutoGenerateResource", (String)"36_PeriodStatusEditUI"));
            SysUtil.abort();
        }
        SelectorItemCollection sic = this.getSelectors();
        sic.add("company.id");
        sic.add("period.*");
        sic.add("period.id");
        sic.add("period.number");
        sic.add("periodType.id");
        sic.add("*");
        FilterItemCollection items = this.filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        items.add(new FilterItemInfo("periodType.id", (Object)this.periodType.getId()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("period.number"));
        if (this.isAddFilter) {
            this.filter.getFilterItems().add(new FilterItemInfo("period.beginDate", (Object)currentPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            this.filter.getFilterItems().add(new FilterItemInfo("period.endDate", (Object)PeriodUtils.getDayEnd(currentPeriod.getEndDate()), CompareType.LESS_EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(this.filter);
        evi.setSorter(sorter);
        PeriodStatusCollection col = this.getInstance().getPeriodStatusCollection(evi);
        return col;
    }

    public void checkIsSetPeriod() throws EASBizException, BOSException {
        PeriodTypeInfo type = this.getPeriodTypeByCompany();
        this.prmtcompany.setEnabled(false);
        if (type != null) {
            this.cboPeriodType.setEnabled(false);
            this.actionSave.setEnabled(false);
        } else {
            this.cboPeriodType.setEnabled(true);
            this.actionSave.setEnabled(true);
        }
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public boolean isExistsPeriodStatus() throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        items.add(new FilterItemInfo("periodType.id", (Object)this.periodType.getId()));
        boolean exists = this.getInstance().exists(filter);
        return exists;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return this.getInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PeriodStatusInfo objectValue = new PeriodStatusInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public final class synProgressHintListener
    implements ProgressHintListener {
        public void doFunction(Map param) throws Exception {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            PeriodTypeInfo periodType = (PeriodTypeInfo)param.get("periodType");
            PeriodStatusFactory.getRemoteInstance().synchronization(company, periodType);
            PeriodStatusEditUI.this.loadDataInTable();
        }
    }

    public final class submitProgressHintListener
    implements ProgressHintListener {
        public void doFunction(Map param) throws Exception {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            PeriodTypeInfo periodType = (PeriodTypeInfo)param.get("periodType");
            PeriodCollection periods = (PeriodCollection)((Object)param.get("periods"));
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = periods.iterator();
            while (it.hasNext()) {
                PeriodInfo period = (PeriodInfo)it.next();
                PeriodStatusInfo info = new PeriodStatusInfo();
                info.setCompany(company);
                info.setPeriod(period);
                info.setStatu(PeriodStatuEnum.OPEN);
                info.setPeriodType(periodType);
                colls.add((CoreBaseInfo)info);
            }
            PeriodStatusEditUI.this.getBizInterface().addnew(colls);
        }
    }

    public final class loadProgressHintListener
    implements ProgressHintListener {
        public void doFunction(Map param) throws Exception {
            PeriodStatusEditUI.this.loadDataInTable();
        }
    }
}

