/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.ncm.RecoveryCoefficientEntryInfo;
import com.kingdee.eas.basedata.ncm.RecoveryCoefficientFactory;
import com.kingdee.eas.basedata.ncm.RecoveryCoefficientInfo;
import com.kingdee.eas.basedata.ncm.client.AbstractRecoveryCoefficientEditUI;
import com.kingdee.eas.basedata.ncm.utils.BDCMConst;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RecoveryCoefficientEditUI
extends AbstractRecoveryCoefficientEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryCoefficientEditUI.class);
    private static final String TB_CostItem = "costItem.number";
    private static final String TB_CostItemName = "costItem.name";
    private static final String TB_COEFFICIENT = "coefficient";
    private String companyID;

    public RecoveryCoefficientEditUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.prmtFICompany.getData() instanceof CompanyOrgUnitInfo) {
            String comID = ((CompanyOrgUnitInfo)this.prmtFICompany.getData()).getId().toString();
            BDCMClientUtils.filterF7(this.prmtcostObject, "company.id", comID);
        }
        this.formatEntryTable();
    }

    public void onShow() throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + this.companyID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
        super.onShow();
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kDTable1, (boolean)true, null);
        this.kDTable1.getSelectManager().setSelectMode(15);
    }

    public boolean destroyWindow() {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + this.companyID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        return super.destroyWindow();
    }

    private void formatEntryTable() {
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(false);
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kDTable1.getColumn(TB_CostItem).setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable1.getColumn(TB_CostItem).setRenderer((IBasicRender)avr);
        this.kDTable1.getColumn(TB_CostItem).setRequired(true);
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(10);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)SysConstant.BIGZERO);
        colTxtField.setMaximumValue((Comparable)BDCMConst.ONE);
        colTxtField.setSupportedEmpty(false);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        this.kDTable1.getColumn(TB_COEFFICIENT).setEditor((ICellEditor)col_CellEditor);
        String precision = BDCMUtils.getFormatString(10);
        this.kDTable1.getColumn(TB_COEFFICIENT).getStyleAttributes().setNumberFormat(precision);
        this.kDTable1.getColumn(TB_CostItemName).getStyleAttributes().setLocked(true);
        if ("ADDNEW".equals(this.getOprtState()) && this.kDTable1.getRowCount() < 1) {
            this.addLine(this.kDTable1);
        }
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kDTable1.getCell(e.getRowIndex(), TB_CostItemName).setValue((Object)ci.getName());
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        int count = this.kDTable1.getRowCount();
        if (count <= 0) {
            MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("EntryCannotIsNull"));
            SysUtil.abort();
        }
        for (int i = 0; i < count; ++i) {
            Object value = this.kDTable1.getCell(i, TB_CostItem).getValue();
            if (!UIRuleUtil.isNull((Object)value)) continue;
            MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("CostItemCannotBeNull"));
            SysUtil.abort();
        }
        KDTFootManager footRowManager = this.kDTable1.getFootManager();
        IRow footRow = footRowManager.getFootRow(0);
        String sumCoefficient = (String)footRow.getCell(TB_COEFFICIENT).getValue();
        if (BDCMConst.ONE.compareTo(new BigDecimal(sumCoefficient)) != 0) {
            MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("CoefficientSumMustEquelsOne"));
            SysUtil.abort();
        }
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kDTable1, new String[]{TB_COEFFICIENT});
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
        super.actionAddLine_actionPerformed(e);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.insertLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
        super.actionInsertLine_actionPerformed(e);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kDTable1;
    }

    private IObjectValue createNewDetailData(KDTable table) {
        RecoveryCoefficientEntryInfo entry = new RecoveryCoefficientEntryInfo();
        entry.setCoefficient(SysConstant.BIGZERO);
        return entry;
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.dataBinder.loadLineFields(table, row, detailData);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.dataBinder.loadLineFields(table, row, detailData);
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr.length == 0) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RecoveryCoefficientFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        RecoveryCoefficientInfo objectValue = new RecoveryCoefficientInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getBoolean("isBizUnit")) {
            objectValue.setFICompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

