/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.ncm.client.AbstractRecoveryCoefficientListUI;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.ncm.utils.client.CMCommonQueryProcessor;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RecoveryCoefficientListUI
extends AbstractRecoveryCoefficientListUI {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryCoefficientListUI.class);

    public RecoveryCoefficientListUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = RecoveryCoefficientListUI.this.tblMain.getRow(i);
                    if (row.getCell("entries.coefficient") == null || row.getCell("entries.coefficient").getValue() == null) continue;
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.coefficient"), (int)10);
                }
            }
        });
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("FICompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS));
        try {
            if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                filter.mergeFilter(filter2, "AND");
            } else {
                filter = filter2;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filter;
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        String precision = BDCMUtils.getFormatString(10);
        this.tblMain.getColumn("coefficient").getStyleAttributes().setNumberFormat(precision);
        SorterItemInfo costObjectSort = new SorterItemInfo("costObject.number");
        costObjectSort.setSortType(SortType.ASCEND);
        SorterItemInfo costItemSort = new SorterItemInfo("costItem.number");
        costItemSort.setSortType(SortType.ASCEND);
        this.mainQuery.getSorter().add(costObjectSort);
        this.mainQuery.getSorter().add(costItemSort);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"FICompany", "costObject.number", "costObject.name"};
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        CMCommonQueryProcessor cmcq = new CMCommonQueryProcessor();
        cmcq.set("companyOrg", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        dialog.setProcessor((IProcessor)cmcq);
        return dialog;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        qe.option().isIgnoreOrder = false;
        qe.option().isAutoIgnoreZero = false;
        return qe;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String comID;
        try {
            this.setOprtState("CLOSING");
            comID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.setOprtState("RELEASEALL");
        try {
            comID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"costObject.number", "costObject.name", "costItem.number", "costItem.name", "coefficient"};
        return locateNames;
    }
}

