/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BDCMUtils {
    public static IObjectValue getObjectValue(Context ctx, BOSObjectType bosType, String id) {
        IDynamicObject ibiz = null;
        try {
            ibiz = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            return ibiz.getValue(bosType, "where id = '" + id + "'");
        }
        catch (BOSException e) {
            return null;
        }
    }

    public static IObjectValue getObjectValue(Context ctx, String id) {
        if (StringUtil.isEmpty((String)id)) {
            throw new IllegalArgumentException("id is null");
        }
        BOSObjectType bosType = BOSUuid.read((String)id).getType();
        return BDCMUtils.getObjectValue(ctx, bosType, id);
    }

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static void iniColumnsPrecision(int precision, String[] fields, IRowSet rowSet) throws SQLException {
        for (int i = 0; i < fields.length; ++i) {
            BDCMUtils.iniColumnsPrecision(precision, fields[i], rowSet);
        }
    }

    public static void iniColumnsPrecision(int precision, String field, IRowSet rowSet) throws SQLException {
        BigDecimal temp = rowSet.getBigDecimal(field);
        if (temp != null) {
            temp = temp.setScale(precision, 4);
            rowSet.updateObject(field, (Object)temp);
        }
    }

    public static StringBuffer splitPK(IObjectPK[] pks) {
        return BDCMUtils.splitPK((Object[])pks);
    }

    public static StringBuffer splitPK(Object[] pks) {
        if (pks == null || pks.length == 0) {
            throw new IllegalArgumentException("ID is null");
        }
        StringBuffer params = new StringBuffer(44);
        Object id = null;
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            id = pks[i];
            if (!UIRuleUtil.isNotNull((Object)id)) continue;
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        return params;
    }

    public static StringBuffer splitPK(Collection ids) {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ID is null");
        }
        return BDCMUtils.splitPK(ids.toArray(new Object[ids.size()]));
    }

    public static StringBuffer splitPK(IObjectCollection ids, String fldName) {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ID is null");
        }
        StringBuffer params = new StringBuffer(44);
        int c = ids.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(ids.getObject(i).getString(fldName).toString());
            params.append("'");
        }
        return params;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return BDCMUtils.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static Timestamp DateToTime(Date date) {
        return date != null ? new Timestamp(date.getTime()) : new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public static Date now() {
        return Calendar.getInstance().getTime();
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static void checkClose(PeriodInfo periodinfo, CompanyOrgUnitInfo companyinfo) {
        if (companyinfo != null && periodinfo != null) {
            try {
                ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
                PeriodInfo currenctPeriod = ctrol.getCacheCurrentPeriod(1001, companyinfo.getId().toString());
                if (ctrol.isClose(1001, companyinfo.getId().toString()) && currenctPeriod != null && currenctPeriod.getId().toString().equals(periodinfo.getId().toString())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.NCMAutoGenerateResource", (String)"0_BDCMUtils"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public static void checkPeriod(PeriodInfo periodinfo, CompanyOrgUnitInfo companyinfo) {
        if (companyinfo != null && periodinfo != null) {
            try {
                ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
                PeriodInfo currenctPeriod = ctrol.getCacheCurrentPeriod(1001, companyinfo.getId().toString());
                int year = periodinfo.getPeriodYear();
                int number = periodinfo.getPeriodNumber();
                int currentyear = currenctPeriod.getPeriodYear();
                int currentnumber = currenctPeriod.getPeriodNumber();
                if (year == 0) {
                    String periodid = periodinfo.getId().toString();
                    periodinfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectStringPK(periodid));
                    year = periodinfo.getPeriodYear();
                    number = periodinfo.getPeriodNumber();
                }
                if (!BDCMUtils.isBig(currentyear, currentnumber, year, number)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.ncm.NCMAutoGenerateResource", (String)"1_BDCMUtils"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public static boolean isBig(int currenctyear, int currenctnumber, int selectyear, int selectnumber) {
        boolean falg = false;
        if (selectyear > currenctyear) {
            falg = true;
        } else if (selectyear == currenctyear && selectnumber >= currenctnumber) {
            falg = true;
        }
        return falg;
    }

    public static Set getAdminAndCostCenterSet(Context ctx, String companyOrgID) throws BOSException, EASBizException {
        HashSet<String> IDSet = new HashSet<String>();
        IOrgUnitRelation iOUR = null;
        try {
            iOUR = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgColl = iOUR.getFromUnit(companyOrgID, 1, 0);
            int orgSize = orgColl.size();
            if (orgSize > 0) {
                for (int i = 0; i < orgSize; ++i) {
                    IDSet.add(orgColl.get(i).getId().toString());
                }
            }
            return IDSet.size() > 0 ? IDSet : null;
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String buildSqlFromIds(Set ids) {
        StringBuffer idsSql = new StringBuffer();
        if (ids != null && ids.size() > 0) {
            idsSql.append("(");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                idsSql.append("'" + it.next() + "',");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            idsSql.append(")");
        }
        return idsSql.toString();
    }

    public static String buildSqlFromInts(Set ids) {
        StringBuffer idsSql = new StringBuffer();
        if (ids != null && ids.size() > 0) {
            idsSql.append("(");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                idsSql.append(it.next() + ",");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            idsSql.append(")");
        }
        return idsSql.toString();
    }

    public static Set getStorageOrgUnitIdsOfCompany(String companyId) throws BOSException, EASBizException {
        return BDCMUtils.getStorageOrgUnitIdsOfCompany(null, companyId);
    }

    public static Set getStorageOrgUnitIdsOfCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        HashSet<String> storageOrgUnitIds = new HashSet<String>();
        IOrgUnitRelation iOUR = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOUR.getFromUnit(companyId, 1, 4);
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                storageOrgUnitIds.add(coll.get(i).getId().toString());
            }
        }
        return storageOrgUnitIds;
    }

    public static Set getCostCenterIdsOfCompany(String companyId) throws BOSException, EASBizException {
        return BDCMUtils.getCostCenterIdsOfCompany(null, companyId);
    }

    public static Set getCostCenterIdsOfCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        HashSet<String> costCenterIds = new HashSet<String>();
        IOrgUnitRelation iOUR = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOUR.getFromUnit(companyId, 1, 5);
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                costCenterIds.add(coll.get(i).getId().toString());
            }
        }
        return costCenterIds;
    }

    public static Set getSaleOrgUnitIdsOfCompany(String companyId) throws BOSException, EASBizException {
        return BDCMUtils.getSaleOrgUnitIdsOfCompany(null, companyId);
    }

    public static Set getSaleOrgUnitIdsOfCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        HashSet<String> saleOrgUnitIds = new HashSet<String>();
        IOrgUnitRelation iOUR = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOUR.getFromUnit(companyId, 1, 2);
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                saleOrgUnitIds.add(coll.get(i).getId().toString());
            }
        }
        return saleOrgUnitIds;
    }
}

