/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.utils.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangArea;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangAreaEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public abstract class BDCMClientUtils {
    private static Logger logger = Logger.getLogger((String)BDCMClientUtils.class.getName());

    public static String getNcmResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.ncm.client.NcmResource", (String)key);
    }

    public static String getSaleResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.SaleResource", (String)key);
    }

    public static void checkIsNull(JComponent comp, String tips) throws EASBizException {
        Object value = null;
        if (comp instanceof KDPromptBox) {
            value = ((KDPromptBox)comp).getData();
        } else if (comp instanceof JTextComponent) {
            value = ((JTextComponent)comp).getText();
        }
        if (UIRuleUtil.isNull((Object)value)) {
            comp.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{tips});
        }
    }

    public static void checkValue(JComponent comp, String tips, BigDecimal compareV, CompareType ct) throws EASBizException {
        if (compareV == null) {
            return;
        }
        BigDecimal value = SysConstant.BIGZERO;
        if (comp instanceof KDFormattedTextField) {
            value = ((KDFormattedTextField)comp).getBigDecimalValue();
        } else if (comp instanceof JTextComponent) {
            try {
                value = new BigDecimal(((JTextComponent)comp).getText());
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException(ignored);
            }
        }
        if (CompareType.GREATER_EQUALS.equals((Object)ct)) {
            if (compareV.compareTo(value) >= 0) {
                comp.requestFocus();
                MsgBox.showError((String)tips);
                SysUtil.abort();
            }
        } else if (CompareType.LESS_EQUALS.equals((Object)ct) && compareV.compareTo(value) <= 0) {
            comp.requestFocus();
            MsgBox.showError((String)tips);
            SysUtil.abort();
        }
    }

    public static void setResizble(boolean b, IUIWindow uiWindow) {
        if (uiWindow == null) {
            return;
        }
        Window win = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (win instanceof UINewFrame) {
            ((UINewFrame)win).setResizable(b);
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setResizable(b);
        }
    }

    public static void filterPeriod(EntityViewInfo ev) {
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            FilterItemInfo filterItem = filters.get(i);
            if (!"calculatePeriod".equals(filterItem.getPropertyName())) continue;
            String oldArg = String.valueOf(filterItem.getCompareValue());
            filters.remove(filterItem);
            FilterItemInfo item = new FilterItemInfo();
            item.setPropertyName("number");
            item.setCompareType(CompareType.EQUALS);
            item.setCompareValue((Object)oldArg);
            filters.add(item);
            break;
        }
    }

    public static void setNumberEnabledByCodeRule(IObjectValue caller, DataBinder dataBinder) {
        boolean isModifiable = false;
        boolean isExist = false;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            isExist = iCodingRuleManager.isExist(caller, orgID);
            if (isExist) {
                isModifiable = iCodingRuleManager.isModifiable(caller, orgID);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Component txtNumber = dataBinder.getComponetByField("number");
        if (txtNumber != null) {
            boolean isEnabled = !isExist || isModifiable;
            txtNumber.setEnabled(isEnabled);
        }
        if (txtNumber != null && txtNumber.isEnabled()) {
            txtNumber.requestFocus();
        }
    }

    public static void showCannotBeEmptyMsg(String fieldName) {
        String msg = BDCMClientUtils.getSaleResource("FieldCannotEmpty");
        MsgBox.showInfo((String)MessageFormat.format(msg, fieldName));
        SysUtil.abort();
    }

    public static void verifyTextFieldInput(KDTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            txt.requestFocusInWindow();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyTextAreaInput(KDTextArea txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            txt.requestFocusInWindow();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilTextFieldInput(KDBizMultiLangBox txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            txt.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilAreaFieldInput(KDBizMultiLangArea txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            txt.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyNumFieldInput(KDFormattedTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyF7Input(KDPromptBox box, String fieldName) {
        if (box.getText().trim().length() == 0 || box.getText() == null) {
            box.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyComboInput(KDComboBox box, String fieldName) {
        if (box.getSelectedIndex() < 0) {
            box.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void setVisible(boolean b, Component[] comps) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setVisible(b);
        }
    }

    public static void setEnable(boolean b, Component[] comps) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(b);
        }
    }

    public static void removeDataChangeListeners(JComponent owner) {
        EventListener[] listeners;
        if (owner != null && (listeners = owner.getListeners(DataChangeListener.class)) != null && listeners.length > 0) {
            EventListener event2 = null;
            for (EventListener event2 : listeners) {
                if (event2 == null || !(event2 instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
                ((IKDEditor)owner).removeDataChangeListener((DataChangeListener)event2);
            }
        }
    }

    public static void removeKDTEditListeners(KDTable owner) {
        EventListener[] listeners;
        if (owner != null && (listeners = owner.getListeners(KDTEditListener.class)) != null && listeners.length > 0) {
            EventListener event2 = null;
            for (EventListener event2 : listeners) {
                if (event2 == null || !(event2 instanceof KDTEditListener)) continue;
                owner.removeKDTEditListener((KDTEditListener)event2);
            }
        }
    }

    public static void addDataChangeListeners(JComponent owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event2 = null;
        for (EventListener event2 : listeners) {
            if (event2 == null || !(event2 instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
            ((IKDEditor)owner).addDataChangeListener((DataChangeListener)event2);
        }
    }

    public static void addKDTEditListeners(KDTable owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event2 = null;
        for (EventListener event2 : listeners) {
            if (event2 == null || !(event2 instanceof KDTEditListener)) continue;
            owner.addKDTEditListener((KDTEditListener)event2);
        }
    }

    public static void removeMouseListeners(KDTable owner) {
        EventListener[] listeners;
        if (owner != null && (listeners = owner.getListeners(MouseListener.class)) != null && listeners.length > 0) {
            EventListener event2 = null;
            for (EventListener event2 : listeners) {
                if (event2 == null || !(event2 instanceof MouseListener)) continue;
                owner.removeMouseListener((MouseListener)event2);
            }
        }
    }

    public static void addMouseListeners(JComponent owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event2 = null;
        for (EventListener event2 : listeners) {
            if (event2 == null || !(event2 instanceof MouseListener) || !(owner instanceof IKDEditor)) continue;
            owner.addMouseListener((MouseListener)event2);
        }
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, IntEnum compareValue) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)compareValue.getValue(), CompareType.EQUALS));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, Object compareValue, CompareType ct) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, ct));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, Object compareValue) {
        BDCMClientUtils.filterF7(f7, fieldName, compareValue, CompareType.EQUALS);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getCostCenterSet(companyOrgID);
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String fieldName, Object compareValue) throws BOSException, EASBizException {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2)");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static Set getCostCenterSet(String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 5);
        int ccSize = ccColl.size();
        if (ccSize != 0) {
            HashSet<String> ccIDSet = new HashSet<String>(ccSize);
            for (int i = 0; i < ccSize; ++i) {
                ccIDSet.add(ccColl.get(i).getId().toString());
            }
            return ccIDSet;
        }
        MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("NoCostCenterDelegateThisCompanyOrg"));
        SysUtil.abort();
        return null;
    }

    public static Set getCostCenterSet1(String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 5);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            return null;
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        return ccIDSet;
    }

    public static void filterDirectCostCenterF7(KDBizPromptBox f7, String companyOrgId) throws BOSException, EASBizException {
        BDCMClientUtils.filterCostCenterF7(f7, companyOrgId, true, false);
    }

    public static void filterAssistantCostCenterF7(KDBizPromptBox f7, String companyOrgId) throws BOSException, EASBizException {
        BDCMClientUtils.filterCostCenterF7(f7, companyOrgId, false, false);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String companyOrgId, boolean isDirect, boolean needFilterSealUp) throws BOSException, EASBizException {
        Set costCenterSet = BDCMClientUtils.getCostCenterSet(companyOrgId);
        EntityViewInfo view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)costCenterSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)(isDirect ? 0 : 1), CompareType.EQUALS));
        if (needFilterSealUp) {
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterDirectCostCenterF7(KDBizPromptBox f7) throws BOSException, EASBizException {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostCenterGroupF7(KDBizPromptBox f7, String companyOrgID) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgID, CompareType.EQUALS));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterBaseCostCenterF7(KDBizPromptBox f7, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getCostCenterSet(companyOrgID);
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 ");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        BDCMClientUtils.filterCostCenterF7(f7, "isBizUnit", (Object)Boolean.TRUE, companyOrgID);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7) throws BOSException, EASBizException {
        BDCMClientUtils.filterCostCenterF7(f7, "isBizUnit", Boolean.TRUE);
    }

    public static void filterCostCenterByCompanyOrgF7(KDBizPromptBox f7, String companyOrgId) throws BOSException, EASBizException {
        BDCMClientUtils.filterCostCenterByCompanyOrgF7(f7, companyOrgId, false);
    }

    public static void filterCostCenterByCompanyOrgF7(KDBizPromptBox f7, String companyOrgId, boolean needFilterSealUp) throws BOSException, EASBizException {
        Set costCenterIdSet = BDCMClientUtils.getCostCenterSet(companyOrgId);
        EntityViewInfo view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)costCenterIdSet, CompareType.INCLUDE));
        if (needFilterSealUp) {
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        if (needFilterSealUp) {
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1 ");
        }
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterStorageFromCompanyF7(KDBizPromptBox f7, String fieldName, Object compareValue, String companyOrgID, String storageOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(storageOrgID, ccIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterStorageFromCompany(EntityViewInfo view, String fieldName, Object compareValue, String companyOrgID, String storageOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(storageOrgID, ccIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
    }

    public static void filterSuperior(KDBizPromptBox f7, CostCenterOrgUnitInfo node) {
        BDCMClientUtils.filterF7(f7, "parent", node.getId().toString());
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, String periodTypeID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeID, CompareType.EQUALS));
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, CompanyOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        if (orgInfo == null) {
            throw new IllegalArgumentException("CompanyOrgUnit is NULL !");
        }
        PeriodInfo currPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, orgInfo.getId().toString());
        EntityViewInfo evi = null;
        evi = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)orgInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)currPeriod.getBeginDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        try {
            filter.mergeFilter(evi.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        evi.setFilter(filter);
        prmt.setEntityViewInfo(evi);
    }

    public static void filterAccountVIewF7(KDBizPromptBox f7, String cuID, CompanyOrgUnitInfo companyOrg) {
        if (UIRuleUtil.isNull((String)cuID) || UIRuleUtil.isNull((Object)companyOrg)) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (companyOrg.getAccountTable() == null) {
            MsgBox.showError((String)"\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u79d1\u76ee\u8868\uff01");
            SysUtil.abort();
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)companyOrg.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)companyOrg.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("control", (Object)0));
        fic.add(new FilterItemInfo("isGFreeze", (Object)0));
        fic.add(new FilterItemInfo("isCFreeze", (Object)0));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterAccountVIewF7(KDBizPromptBox f7, CompanyOrgUnitInfo companyOrg) {
        if (UIRuleUtil.isNull((Object)companyOrg)) {
            throw new IllegalArgumentException("Argument is null");
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("accountTableID.id", (Object)companyOrg.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("control", (Object)0));
        fic.add(new FilterItemInfo("isGFreeze", (Object)0));
        fic.add(new FilterItemInfo("isCFreeze", (Object)0));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static OrgUnitInfo getBizOrgUnitInfo(String addNewPermItemName, OrgType orgType, Context mainOrgContext) {
        if (addNewPermItemName == null || mainOrgContext == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mainOrgContext.get((Object)orgType);
        OrgUnitInfo retOrgUnitInfo = null;
        retOrgUnitInfo = BDCMClientUtils.getBizOrgUnit(SysContext.getSysContext().getCurrentUserInfo(), orgType, addNewPermItemName, orgUnitInfo);
        return retOrgUnitInfo;
    }

    public static OrgUnitInfo getBizOrgUnit(UserInfo userInfo, OrgType orgType, String permissionItem, OrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo bizSaleOrgUnitInfo = null;
        if (orgUnitInfo.getBoolean("isBizUnit")) {
            bizSaleOrgUnitInfo = orgUnitInfo;
        } else {
            try {
                OrgUnitInfo[] mainOrgs = null;
                FullOrgUnitCollection collection = BDCMClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), orgType, permissionItem);
                mainOrgs = SCMGroupClientUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)orgType);
                if (mainOrgs == null) {
                    return null;
                }
                if (mainOrgs.length > 0) {
                    mainOrgs = (OrgUnitInfo[])BDCMClientUtils.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
                }
                bizSaleOrgUnitInfo = mainOrgs[0];
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return bizSaleOrgUnitInfo;
    }

    public static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Comparator {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int compare(Object arg0, Object arg1) {
                return this.isAsc ? ((DataBaseInfo)arg0).getNumber().compareTo(((DataBaseInfo)arg1).getNumber()) : ((DataBaseInfo)arg1).getNumber().compareTo(((DataBaseInfo)arg0).getNumber());
            }
        }
        Arrays.sort(datas, new DataCompare(isAsc));
        return datas;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPk = null;
        if (cu != null) {
            cuPk = new ObjectUuidPK(cu.getId());
        }
        result = permission.getAuthorizedOrgOfIncludeSubCU((IObjectPK)cuPk, user, orgType, null, permItem);
        return result;
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)BDCMClientUtils.getNcmResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static boolean hasTableDuplication(KDTable table, String colName) {
        if (table == null || UIRuleUtil.isNull((String)colName)) {
            throw new IllegalArgumentException("argument is null !");
        }
        int rowCount = table.getRowCount();
        HashSet<Object> values = new HashSet<Object>();
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            value = table.getCell(i, colName).getValue();
            if (!UIRuleUtil.isNotNull((Object)value) || values.add(value)) continue;
            String title = (String)table.getHeadRow(0).getCell(colName).getValue();
            MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.basedata.ncm.NCMAutoGenerateResource", (String)"2_BDCMClientUtils") + title + EASResource.getString((String)"com.kingdee.eas.basedata.ncm.NCMAutoGenerateResource", (String)"3_BDCMClientUtils")));
            return true;
        }
        return false;
    }

    public static void setBizOrgF7ByType(KDBizPromptBox f7, OrgType orgType, boolean hasCU) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        iProducer.getModel().setIsCUFilter(hasCU);
        f7.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public static void filterCostObjectF7(KDBizPromptBox f7, String companyOrgID) {
        HashSet<String> cuIDs = new HashSet<String>();
        CtrlUnitInfo currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        cuIDs.add("00000000-0000-0000-0000-000000000000CCE7AED4");
        do {
            cuIDs.add(currentCU.getId().toString());
        } while ((currentCU = currentCU.getParent()) != null);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID));
        EntityViewInfo eviCostObject = new EntityViewInfo();
        eviCostObject.setFilter(filter);
        f7.setEntityViewInfo(eviCostObject);
    }

    public static void filterCostObjectF7(KDBizPromptBox f7, String companyOrgID, CORelatedType[] types) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID));
        if (types != null && types.length > 0) {
            HashSet<Integer> typeSet = new HashSet<Integer>();
            int length = types.length;
            for (int i = 0; i < length; ++i) {
                typeSet.add(types[i].getValue());
            }
            filter.getFilterItems().add(new FilterItemInfo("relatedType", typeSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void setBizOrgF7ByType(KDBizPromptBox prmtCompany, OrgType company) {
        BDCMClientUtils.setBizOrgF7ByType(prmtCompany, company, true);
    }

    public static void filterDataBaseDF7(String bosType, KDBizPromptBox f7, String fieldName, Object compareValue, CompareType compareType) throws BOSException, EASBizException {
        FilterInfo dbdFilter = BDCMClientUtils.getDataBaseDF7Filter(bosType);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, compareType));
        dbdFilter.mergeFilter(filter, "and");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        f7.setEntityViewInfo(evi);
    }

    public static void filterDataBaseDF7(String bosType, KDBizPromptBox f7) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(BDCMClientUtils.getDataBaseDF7Filter(bosType));
        f7.setEntityViewInfo(evi);
    }

    private static FilterInfo getDataBaseDF7Filter(String bosType) throws BOSException, EASBizException {
        FilterInfo dbdFilter = new FilterInfo();
        try {
            BOSObjectType bosObjectType = new BOSObjectType(bosType);
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosObjectType);
            String businessInterface = entityObjectInfo.getBusinessInterface();
            Class<?> model = null;
            model = Class.forName(businessInterface);
            IDataBaseD idbd = (IDataBaseD)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, model);
            dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId()), "id", "CU.id");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return dbdFilter;
    }

    public static boolean isNumber(String numStr) {
        if (numStr == null) {
            return false;
        }
        try {
            Double.parseDouble(numStr);
        }
        catch (NumberFormatException nex) {
            return false;
        }
        return true;
    }

    public static BigDecimal castToBigDecimal(KDTable table, int rowIndex, String fieldName) {
        Object value = table.getRow(rowIndex).getCell(fieldName).getValue();
        BigDecimal numeric = SysConstant.BIGZERO;
        if (value instanceof BigDecimal) {
            numeric = (BigDecimal)value;
        } else if (BDCMClientUtils.isNumber((String)value)) {
            numeric = new BigDecimal((String)value);
        }
        return numeric;
    }

    public static void filterAdminAndCostCenterF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getAdminAndCostCenterSet(companyOrgID);
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ccIDSet != null && ccIDSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"#999#"));
        }
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static Set getAdminAndCostCenterSet(String companyOrgID) throws BOSException, EASBizException {
        HashSet<String> IDSet = new HashSet<String>();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgColl = iOUR.getFromUnit(companyOrgID, 1, 0);
        int orgSize = orgColl.size();
        if (orgSize > 0) {
            for (int i = 0; i < orgSize; ++i) {
                IDSet.add(orgColl.get(i).getId().toString());
            }
        }
        return IDSet.size() > 0 ? IDSet : null;
    }

    public static void verifyKDMultiLangAreaFieldInput(KDMultiLangArea field, String fieldName) {
        KDTextAreaCtrl tf;
        ComboBoxEditor edt = field.getEditor();
        if (edt instanceof MultiLangAreaEditor && (tf = (KDTextAreaCtrl)edt.getEditorComponent()) != null && tf.getText().length() > 255) {
            MsgBox.showInfo((String)("[" + fieldName + "]\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7255\u5b57\u7b26\u3002"));
            SysUtil.abort();
        }
    }

    public static void filterActivityF7(KDBizPromptBox f7, String companyOrgID) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterOrderF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ccIDSet, CompareType.INCLUDE));
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(4);
        status.add(8);
        status.add(7);
        status.add(5);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterOrderF7(KDBizPromptBox f7, String companyOrgID, BillBaseStatusEnum[] status) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ccIDSet, CompareType.INCLUDE));
        HashSet<Integer> _status = new HashSet<Integer>();
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                _status.add(status[i].getValue());
            }
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", _status, CompareType.INCLUDE));
        }
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterStorageF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostCenterF7(EntityViewInfo view, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getCostCenterSet(companyOrgID);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
    }

    public static void filterCostCenterF7forUI(EntityViewInfo view, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getCostCenterSet1(companyOrgID);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        if (ccIDSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"0", CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
    }

    public static void filterDirectCostCenterF7(EntityViewInfo view, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getCostCenterSet(companyOrgID);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
    }

    public static void filterCostCenterF7(EntityViewInfo view, String fieldName, Object compareValue, String companyOrgID, CostCenterType[] costCenterTypes) throws BOSException, EASBizException {
        Set ccIDSet = BDCMClientUtils.getCostCenterSet(companyOrgID);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        if (costCenterTypes != null) {
            HashSet<Integer> types = new HashSet<Integer>();
            for (int i = 0; i < costCenterTypes.length; ++i) {
                types.add(costCenterTypes[i].getValue());
            }
            filter.getFilterItems().add(new FilterItemInfo("costCenterType", types, CompareType.INCLUDE));
        }
        filter.setMaskString("#0 and #1 and #2");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
    }

    public static void filterExpenseF7(EntityViewInfo view, String companyOrgID, Set ExpenseTypes) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CompanyInfo.id", (Object)companyOrgID, CompareType.EQUALS));
        if (ExpenseTypes != null) {
            filter.getFilterItems().add(new FilterItemInfo("expenseType", (Object)ExpenseTypes, CompareType.INCLUDE));
        }
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        view.setFilter(filter);
    }

    public static void filterMaterialF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterMaterialF7(EntityViewInfo view, String companyOrgID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        try {
            filter.mergeFilter(view.getFilter(), "AND");
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        view.setFilter(filter);
    }
}

