/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.EconomicTypeEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartFI;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartFICollection;
import com.kingdee.eas.basedata.org.OUPartFIFactory;
import com.kingdee.eas.basedata.org.OUPartFIInfo;
import com.kingdee.eas.basedata.org.OUTaxType;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.basedata.org.client.OUEditUI;
import com.kingdee.eas.basedata.org.client.OUEdit_AdminUI;
import com.kingdee.eas.basedata.org.client.OUEdit_FIUI;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.uihelper.IOUEditHelper;
import com.kingdee.eas.basedata.org.client.uihelper.OUEditDefault;
import com.kingdee.eas.basedata.org.client.uihelper.OUEditUICenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgEditPanelInfo;
import com.kingdee.eas.basedata.org.client.uihelper.UIHelper;
import com.kingdee.eas.basedata.org.client.uihelper.imp.OrgTypeFIHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.orgext.OUExtException;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class OUEdit4FIHelper
extends OUEditDefault
implements IOUEditHelper {
    private static Logger logger = Logger.getLogger((String)OUEdit4FIHelper.class.getName());
    private AcountSchemeInfo curSchemeInfo = null;
    private FullOrgUnitInfo editData;
    private OUEditUI ouEditui = null;
    private boolean initialized = false;
    private boolean is_Report_Currency = false;
    private OUEdit_FIUI fiUI = new OUEdit_FIUI();
    private KDCheckBox chkIsCompanyOrgUnit = new KDCheckBox();
    private boolean is_Enable_Assistant_Org;

    public boolean isIs_Enable_Assistant_Org() {
        return this.is_Enable_Assistant_Org;
    }

    public void setIs_Enable_Assistant_Org(boolean is_Enable_Assistant_Org) {
        this.is_Enable_Assistant_Org = is_Enable_Assistant_Org;
    }

    private void checkHasDupTaxCode(FullOrgUnitInfo fullOrg, OUPartFIInfo fiInfo) throws EASBizException, BOSException {
        Object[] message;
        String msg;
        int result;
        String fid;
        if (!fullOrg.isIsCompanyOrgUnit()) {
            return;
        }
        OUPartFIInfo partFI = fullOrg.getPartFI();
        if (partFI == null || !partFI.isIsBizUnit()) {
            return;
        }
        if (StringUtils.isEmpty((String)fiInfo.getTaxNumber())) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection coll = filter.getFilterItems();
        BOSUuid id = this.ouEditui.editData.getPartFI().getId();
        String string = fid = id == null ? "" : id.toString();
        if (!StringUtils.isEmpty((String)fid)) {
            coll.add(new FilterItemInfo("partFI.id", (Object)fid, CompareType.NOTEQUALS));
        }
        coll.add(new FilterItemInfo("partFI.isSealUp", (Object)false, CompareType.EQUALS));
        coll.add(new FilterItemInfo("isCompanyOrgUnit", (Object)true, CompareType.EQUALS));
        coll.add(new FilterItemInfo("partFI.isBizUnit", (Object)true, CompareType.EQUALS));
        coll.add(new FilterItemInfo("partFI.taxNumber", (Object)fiInfo.getTaxNumber(), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.setSelector(selector);
        FullOrgUnitCollection orgColl = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        Iterator it = orgColl.iterator();
        StringBuffer message0 = new StringBuffer();
        boolean isFirst = true;
        while (it.hasNext()) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                message0.append(",");
            }
            message0.append(orgUnit.getNumber() + "(" + orgUnit.getName() + ")");
        }
        if (message0.length() > 0 && (result = MsgBox.showConfirm2New(null, (String)(msg = new OUExtException(OUExtException.TAX_NUMBER_DUPLICATE_CONFIRM, message = new String[]{message0.toString(), fiInfo.getTaxNumber()}).getMessage()))) == 1) {
            SysUtil.abort();
        }
    }

    public void unSealUp(OUEditUI ouEditui) throws Exception {
        if (ouEditui.editData.getPartFI() == null || !ouEditui.editData.getPartFI().isIsSealUp()) {
            return;
        }
        ouEditui.editData.getPartFI().setIsSealUp(false);
        this.chkIsCompanyOrgUnit.setEnabled(true);
        this.setSubComponentsEnable((Component)((Object)this.fiUI), true);
        this.chkIsCompanyOrgUnit.setSelected(false);
        this.setSealDate(this.fiUI.fiSealUpDate, false);
        if (!this.editData.isIsCU() && !this.editData.isIsAssistantOrg()) {
            this.fiUI.bizPromptAccountTable.setEnabled(false);
        }
        ouEditui.btnSealUp.setEnabled(true);
        ouEditui.btnUnSealUp.setEnabled(false);
    }

    public void sealUp(OUEditUI ouEditui) throws Exception {
        ouEditui.editData.getPartFI().setIsSealUp(true);
        this.setSealDate(this.fiUI.fiSealUpDate, true);
        ouEditui.btnSealUp.setEnabled(false);
        ouEditui.btnUnSealUp.setEnabled(true);
    }

    public OrgEditPanelInfo getPanelInfo() {
        return new OrgEditPanelInfo(OrgType.Company, this.fiUI.getToolTipText(), 2, "OU_Com_Update", (CoreUI)this.fiUI, this.chkIsCompanyOrgUnit);
    }

    public void removePanel(OUEditUI ouEditui, KDTabbedPane tabbedPane1) throws Exception {
        tabbedPane1.remove((Component)((Object)this.fiUI));
    }

    public void setChkEnableAllComp(OUEditUI ouEditui, boolean enable) throws Exception {
        this.chkIsCompanyOrgUnit.setEnabled(enable);
        UIHelper.setAComponentEnabled((Component)this.chkIsCompanyOrgUnit, (boolean)enable);
        if (this.chkIsCompanyOrgUnit.isSelected()) {
            UIHelper.setAllComponentsEnabled((Component)((Object)this.fiUI), (boolean)enable);
        }
    }

    public void disableSealUp(OUEditUI ouEditui) throws Exception {
        this.editData = ouEditui.editData;
        this.ouEditui = ouEditui;
        if (this.editData.isIsCompanyOrgUnit() && this.editData.getPartFI().isIsSealUp()) {
            this.chkIsCompanyOrgUnit.setEnabled(false);
            this.setSubComponentsEnable((Component)((Object)this.fiUI), false);
        }
    }

    public boolean selectedByChk(OUEditUI ouEditui) throws Exception {
        return this.chkIsCompanyOrgUnit.isSelected();
    }

    public boolean hasNewAdd(FullOrgUnitInfo oldData, OUEditUI ouEditui) throws Exception {
        return !oldData.isIsCompanyOrgUnit() && this.chkIsCompanyOrgUnit.isSelected();
    }

    public void verifyInput(OUEditUI ouEditui) throws Exception {
        String invoiceCount;
        String contact;
        String registeredCode;
        this.editData = ouEditui.editData;
        this.ouEditui = ouEditui;
        if (this.getUserSelectKDCheckBox().isSelected()) {
            long capitalValue;
            OUPartFIInfo parFiInfo = this.editData.getPartFI();
            if (parFiInfo.getBaseCurrency() == null) {
                throw new OrgBlankException(OrgBlankException.BASE_CURRENCY_CAN_NOT_BLANK);
            }
            if (parFiInfo.getAccountPeriodType() == null) {
                throw new OrgBlankException(OrgBlankException.PERIOD_TYPE_CAN_NOT_BLANK);
            }
            if (parFiInfo.getBaseExchangeTable() == null) {
                throw new OrgBlankException(OrgBlankException.BASE_EXCHANGE_TABLE_CAN_NOT_BLANK);
            }
            if (this.is_Report_Currency) {
                if (parFiInfo.getReportCurrency() == null) {
                    throw new OrgException(OrgException.DEPTCH_REPORT_CURRENCY);
                }
                if (parFiInfo.getReportExchangeTable() == null) {
                    throw new OrgException(OrgException.DEPTCH_REPORT_EXCHANGE_TABLE);
                }
                if (parFiInfo.getReportConvertMode() == null) {
                    throw new OrgException(OrgException.DEPTCH_REPORT_CONVERTMODE_TABLE);
                }
            }
            if (this.fiUI.cbConvertMode.isEnabled() && (this.fiUI.cbConvertMode.getSelectedItem() == null || ReportCurrencyConvertMode.Zero.equals(this.fiUI.cbConvertMode.getSelectedItem()))) {
                throw new OrgException(OrgException.CONVERTMODE_NOTNULL);
            }
            BigDecimal capital = parFiInfo.getRegisteredCapital();
            if (capital != null && (capitalValue = capital.longValue()) > 999999999999L) {
                throw new OrgException(OrgException.REGISTEREDCAPITAL_TOO_LARGE);
            }
        }
        if (!StringUtils.isEmpty((String)(registeredCode = this.fiUI.txtRegisteredCode.getText())) && registeredCode.length() > 100) {
            throw new OUExtException(OUExtException.REGISTERED_CODE_TOO_LONG);
        }
        String taxCode = this.fiUI.txtTaxCode.getText();
        if (!StringUtils.isEmpty((String)taxCode)) {
            if (taxCode.length() > 20) {
                throw new OUExtException(OUExtException.TAX_CODE_TOO_LONG);
            }
            if (!taxCode.matches("[a-z0-9A-Z]{0,20}")) {
                throw new OUExtException(OUExtException.TAX_CODE_LIMIT);
            }
        }
        if (!StringUtils.isEmpty((String)(contact = this.fiUI.txtContact.getText())) && contact.length() > 20) {
            throw new OUExtException(OUExtException.CONTACT_NAME_TOO_LONG);
        }
        String taxAddress = this.fiUI.txtAddress.getText();
        if (!StringUtils.isEmpty((String)taxAddress) && taxAddress.length() > 200) {
            throw new OUExtException(OUExtException.TAX_ADDRESS_TOO_LONG);
        }
        String contactPhone = this.fiUI.txtContactPhone.getText();
        if (!StringUtils.isEmpty((String)contactPhone) && contactPhone.length() > 50) {
            throw new OUExtException(OUExtException.CONTACT_PHONE_TOO_LONG);
        }
        String bankAccount = this.fiUI.txtBankAccount.getText();
        if (!StringUtils.isEmpty((String)bankAccount) && bankAccount.length() > 100) {
            throw new OUExtException(OUExtException.BANK_ACCOUNT_TOO_LONG);
        }
        String invoiceNumber = this.fiUI.txtInvoiceNumber.getText();
        if (!StringUtils.isEmpty((String)invoiceNumber)) {
            if (invoiceNumber.length() > 200) {
                throw new OUExtException(OUExtException.INVOICE_NUMBER_TOO_LONG);
            }
            if (!invoiceNumber.matches("[a-z0-9A-Z]{0,200}")) {
                throw new OUExtException(OUExtException.INVOUCE_NUMBER_LIMIT);
            }
        }
        if (!StringUtils.isEmpty((String)(invoiceCount = this.fiUI.txtInvoiceCount.getText()))) {
            if (invoiceCount.length() > 200) {
                throw new OUExtException(OUExtException.INVOICE_COUNT_TOO_LONG);
            }
            if (!invoiceCount.matches("[a-z0-9A-Z]{0,200}")) {
                throw new OUExtException(OUExtException.INVOICE_COUNT_LIMIT);
            }
        }
        OUEdit_AdminUI adinUI = (OUEdit_AdminUI)OUEditUICenter.getInstance((OrgType)OrgType.Admin).getPanelInfo().getMyUI();
        if (this.editData.isIsCompanyOrgUnit() && this.editData.isIsAdminOrgUnit() && !adinUI.chkIsIndependence.isSelected()) {
            adinUI.chkIsIndependence.setSelected(true);
            throw new OUException(OUException.CHKISINDEPENDENCEMUSTCHECK);
        }
    }

    public void orgUnit_actionPerformed(OUEditUI ouEditui) throws Exception {
    }

    public void setTabPanelSelect() {
        if (this.editData == null || this.editData.getId() == null || !this.editData.isIsCompanyOrgUnit()) {
            this.ouEditui.btnMaintainAssistantOrg.setVisible(false);
            this.ouEditui.btnAccountingRange.setVisible(false);
        } else if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.editData.getId().toString())) {
            this.ouEditui.btnMaintainAssistantOrg.setVisible(false);
            this.ouEditui.btnAccountingRange.setEnabled(true);
            this.ouEditui.btnAccountingRange.setVisible(true);
            this.ouEditui.btnAccountingRange.setVisible(!OprtState.VIEW.equals(this.ouEditui.getOprtState()));
        } else {
            this.ouEditui.btnMaintainAssistantOrg.setVisible(this.is_Enable_Assistant_Org);
            this.ouEditui.btnMaintainAssistantOrg.setEnabled(this.is_Enable_Assistant_Org);
            this.ouEditui.btnAccountingRange.setEnabled(true);
            this.ouEditui.btnAccountingRange.setVisible(true);
            this.ouEditui.btnMaintainAssistantOrg.setVisible(!OprtState.VIEW.equals(this.ouEditui.getOprtState()));
            this.ouEditui.btnAccountingRange.setVisible(!OprtState.VIEW.equals(this.ouEditui.getOprtState()));
        }
        if (!this.fiUI.chkIsComBizUnit.isSelected()) {
            this.ouEditui.btnMaintainAssistantOrg.setVisible(false);
            this.ouEditui.btnMaintainAssistantOrg.setEnabled(false);
        }
        this.fiUI.lblcAccountScheme.setVisible(this.is_Enable_Assistant_Org);
        this.fiUI.bizPromptAccountScheme.setVisible(this.is_Enable_Assistant_Org);
        if (this.editData.getPartFI() != null) {
            this.ouEditui.btnSealUp.setEnabled(!this.editData.getPartFI().isIsSealUp());
            this.ouEditui.btnUnSealUp.setEnabled(this.editData.getPartFI().isIsSealUp());
        } else {
            this.ouEditui.btnSealUp.setEnabled(false);
            this.ouEditui.btnUnSealUp.setEnabled(false);
        }
    }

    public void orgUnit_itemStateChanged() throws Exception {
        this.editData = this.ouEditui.editData;
        this.ouEditui = this.ouEditui;
        UIHelper.orgUnitItemStateChangedExt((KDCheckBox)this.getUserSelectKDCheckBox(), (OrgTypeHelper)this.ouEditui.getOrgTypeHelper(), (OrgEditPanelInfo)this.getPanelInfo());
        if (this.chkIsCompanyOrgUnit.isSelected()) {
            this.setCtrlParams();
            if (this.isIs_Enable_Assistant_Org()) {
                if (this.fiUI.bizPromptAccountScheme.getData() == null) {
                    this.fiUI.bizPromptAccountScheme.setData((Object)this.curSchemeInfo);
                }
            } else {
                this.fiUI.bizPromptAccountScheme.setData(null);
            }
            UIHelper.insertTabeIntoPanel((KDTabbedPane)this.ouEditui.kDTabbedPane1, (CoreUI)this.fiUI, (OrgType)OrgType.Company);
            this.ouEditui.kDTabbedPane1.setSelectedComponent((Component)((Object)this.fiUI));
            if (this.ouEditui.getOprtState() != OprtState.VIEW && this.fiUI.bizPromptSuperiorCom.getData() == null) {
                if (!this.isBizPropertyExistInCU(this.editData, 1)) {
                    Object[] param = new Object[]{OrgType.Company.getAlias(), OrgType.Company.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getRemoteInstance();
                CompanyOrgUnitInfo bizParent = (CompanyOrgUnitInfo)iNOV.findBizSuperiorInCU(this.editData, 1);
                this.fiUI.bizPromptSuperiorCom.setData((Object)bizParent);
            }
            if (!this.ouEditui.isCurVersion()) {
                this.setFIProperties();
            }
            if (this.fiUI.chkIsComBizUnit.isSelected()) {
                this.fiUI.handleSelfAdminToFIDelegate();
                this.fiUI.handleSelfPurchaseToFIDelegate();
                this.fiUI.handleSelfSaleToFIDelegate();
                this.fiUI.handleSelfStorageToFIDelegate();
                this.fiUI.handleSelfCostToFIDelegate();
                this.fiUI.handleSelfTransportToFIDelegate();
                this.fiUI.handleSelfProfitToFIDelegate();
                this.fiUI.handleSelfHRToFIDelegate();
                this.fiUI.handleSelfQualityToFIDelegate();
                this.fiUI.handleSelfServiceToFIDelegate();
            }
        } else {
            this.ouEditui.kDTabbedPane1.remove((Component)((Object)this.fiUI));
            this.fiUI.chkIsComBizUnit.setSelected(false);
            this.fiUI.handleSelfAdminToFIDelegate();
            this.fiUI.handleSelfPurchaseToFIDelegate();
            this.fiUI.handleSelfSaleToFIDelegate();
            this.fiUI.handleSelfStorageToFIDelegate();
            this.fiUI.handleSelfCostToFIDelegate();
            this.fiUI.handleSelfTransportToFIDelegate();
            this.fiUI.handleSelfProfitToFIDelegate();
            this.fiUI.handleSelfHRToFIDelegate();
            this.fiUI.handleSelfQualityToFIDelegate();
            this.fiUI.handleSelfServiceToFIDelegate();
        }
        this.ouEditui.resetUISize();
    }

    private void setCtrlParams() throws EASBizException, BOSException {
        if (!this.initialized) {
            String value;
            String startReportCry = ParamManager.getParamValue(null, (String)"G001");
            if ("true".equalsIgnoreCase(startReportCry)) {
                this.is_Report_Currency = true;
            }
            if ("true".equalsIgnoreCase(value = ParamManager.getParamValue(null, null, (String)"G012"))) {
                this.setIs_Enable_Assistant_Org(true);
                this.curSchemeInfo = (AcountSchemeInfo)AcountSchemeFactory.getRemoteInstance().getValue("where id = '00000000-0000-0000-0000-000000000000DDF8E923'");
            } else {
                this.setIs_Enable_Assistant_Org(false);
            }
            this.initialized = true;
            this.setFIProperties();
        }
    }

    private void setFIProperties() throws BOSException, EASBizException {
        boolean isGroup = this.setIsGroup();
        INewOUInnerFacade iNOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        CtrlUnitInfo ctrlInfo = this.editData != null && this.editData.getCU() != null ? this.editData.getCU() : SysContext.getSysContext().getCurrentCtrlUnit();
        HashMap fiProperty = iNOUI.getFIPropertiesOfCU((IObjectPK)new ObjectUuidPK(ctrlInfo.getId()));
        if (this.is_Report_Currency) {
            boolean isCanModifyReportCurrency = this.isCanModifyReportCurrency();
            if (isCanModifyReportCurrency) {
                this.fiUI.bizPromptReportCurrency.setEnabled(true);
            } else {
                this.fiUI.bizPromptReportCurrency.setEnabled(false);
                this.fiUI.bizPromptReportCurrency.setData(fiProperty.get("reportCurrency"));
            }
            this.fiUI.bizPromptCurrencyAux.setEnabled(true);
            this.fiUI.cbConvertMode.setEnabled(true);
        } else {
            this.fiUI.bizPromptReportCurrency.setEnabled(false);
            this.fiUI.bizPromptReportCurrency.setData(null);
            this.fiUI.bizPromptCurrencyAux.setEnabled(false);
            this.fiUI.bizPromptCurrencyAux.setData(null);
            this.fiUI.cbConvertMode.setEnabled(false);
            this.fiUI.cbConvertMode.setSelectedItem(null);
        }
        if (OprtState.EDIT.equals(this.ouEditui.getOprtState()) && this.editData.isIsCompanyOrgUnit()) {
            boolean hasSetStartPeriod = this.checkStartPeriod();
            this.fiUI.bizPromptSelfCurrency.setEnabled(!hasSetStartPeriod);
            this.fiUI.bizPromptAccountPeriodType.setEnabled(!hasSetStartPeriod);
        }
        if (!this.editData.isIsCU() && this.fiUI.bizPromptAccountPeriodType.getData() == null) {
            this.fiUI.bizPromptAccountPeriodType.setData(fiProperty.get("periodType"));
        }
        this.fiUI.bizPromptAccountTable.setEnabled(false);
    }

    private boolean checkStartPeriod() throws BOSException, EASBizException {
        String oql = " where company.id='" + this.editData.getId() + "' and startperiod.id!=null";
        ISystemStatusCtrol iSysStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        return iSysStatusCtrol.exists(oql);
    }

    private boolean setIsGroup() throws BOSException, EASBizException {
        String oql;
        IOUPartFI iCom = OUPartFIFactory.getRemoteInstance();
        if (iCom.exists(oql = "Select * Where isGroup = 1")) {
            this.fiUI.chkIsGroup.setEnabled(false);
            this.fiUI.chkIsGroup.setSelected(false);
            return false;
        }
        this.fiUI.chkIsGroup.setSelected(true);
        this.fiUI.chkIsGroup.setEnabled(false);
        return true;
    }

    public void loadDelegate(OUEditUI ouEditui) {
    }

    public void loadBizSuperior(OUEditUI ouEditui) {
        this.editData = ouEditui.editData;
        this.ouEditui = ouEditui;
        if (this.editData == null || this.editData.getPartFI() == null || !this.editData.isIsCompanyOrgUnit()) {
            this.fiUI.bizPromptSuperiorCom.setData(null);
        } else {
            this.fiUI.bizPromptSuperiorCom.setData((Object)((CompanyOrgUnitInfo)ouEditui.getPDValueInfo().getParentOrg(OrgType.Company)));
        }
    }

    public void storeOrgFields() throws Exception {
        this.editData = this.ouEditui.editData;
        this.ouEditui = this.ouEditui;
        if (this.getUserSelectKDCheckBox().isSelected()) {
            this.storeCompanyFields();
            this.editData.setIsCompanyOrgUnit(true);
        } else {
            this.editData.setPartFI(null);
            this.editData.setIsCompanyOrgUnit(false);
            this.ouEditui.getPDValueInfo().setParentOrg(OrgType.Company, null);
            this.editData.setIsCompanyOrgUnit(false);
        }
    }

    void storeCompanyFields() {
        Locale locale;
        MultiLangItem mli;
        int i;
        int n;
        if (this.editData == null) {
            return;
        }
        this.editData.setIsCompanyOrgUnit(true);
        OUPartFIInfo ouPartFI = this.editData.getPartFI();
        if (ouPartFI == null) {
            ouPartFI = new OUPartFIInfo();
        }
        ouPartFI.setIsGroup(this.fiUI.chkIsGroup.isSelected());
        ouPartFI.setIsBizUnit(this.fiUI.chkIsComBizUnit.isSelected());
        ouPartFI.setAuthorizationCode(this.fiUI.authorizationCode.getText());
        ouPartFI.setAuthorizationKey(this.fiUI.authorizationKey.getText());
        ouPartFI.setEncryptionKey(this.fiUI.encryptionKey.getText());
        ouPartFI.setIsOnlyUnion(!this.fiUI.chkIsComBizUnit.isSelected());
        ouPartFI.setReportExchangeTable((ExchangeTableInfo)this.fiUI.bizPromptCurrencyAux.getData());
        ouPartFI.setBaseCurrency((CurrencyInfo)this.fiUI.bizPromptSelfCurrency.getData());
        ouPartFI.setReportCurrency((CurrencyInfo)this.fiUI.bizPromptReportCurrency.getData());
        ouPartFI.setAccountPeriodType((PeriodTypeInfo)this.fiUI.bizPromptAccountPeriodType.getData());
        ouPartFI.setAccountTable((AccountTableInfo)this.fiUI.bizPromptAccountTable.getData());
        ouPartFI.setBaseExchangeTable((ExchangeTableInfo)this.fiUI.bizPromptAux.getData());
        ouPartFI.setAdjustExchangeTable((ExchangeTableInfo)this.fiUI.bizPromptAuxLast.getData());
        if (this.fiUI.cbConvertMode.getSelectedItem() == null) {
            ouPartFI.setReportConvertMode(ReportCurrencyConvertMode.Zero);
        } else {
            ouPartFI.setReportConvertMode((ReportCurrencyConvertMode)((Object)this.fiUI.cbConvertMode.getSelectedItem()));
        }
        IOUEditHelper ouEditHelper = OUEditUICenter.getInstance((OrgType)OrgType.Admin);
        OUEdit_AdminUI adminUI = (OUEdit_AdminUI)ouEditHelper.getPanelInfo().getMyUI();
        if (this.chkIsCompanyOrgUnit.isSelected() && ouEditHelper.getUserSelectKDCheckBox().isSelected()) {
            if (adminUI.adminEconomicType.getSelectedItem() == null) {
                ouPartFI.setEconomicType(EconomicTypeEnum.ET0);
            } else {
                ouPartFI.setEconomicType((EconomicTypeEnum)((Object)adminUI.adminEconomicType.getSelectedItem()));
            }
            ouPartFI.setIndustry((IndustryInfo)adminUI.bizPromptIndustry.getData());
            n = adminUI.mlbAdminTerritory.getItemCount();
            for (i = 0; i < n; ++i) {
                mli = (MultiLangItem)adminUI.mlbAdminTerritory.getItemAt(i);
                locale = mli.getLang().getLocale();
                String territory = mli.getData().toString();
                ouPartFI.setTerritory(territory, locale);
            }
            if (adminUI.radioAdminCountry.isSelected()) {
                ouPartFI.setIsChurchyard(true);
            } else {
                ouPartFI.setIsChurchyard(false);
            }
            ouPartFI.setJuridicalPerson((PersonInfo)adminUI.adminJuridicalPerson.getData());
            ouPartFI.setRegisteredCapital(adminUI.adminRegisteredCapital.getBigDecimalValue());
            ouPartFI.setSetupDate(adminUI.adminSetupDate.getTimestamp());
            ouPartFI.setEndupDate(adminUI.adminEndupDate.getTimestamp());
        }
        n = this.fiUI.mlaComDesc.getItemCount();
        for (i = 0; i < n; ++i) {
            mli = (MultiLangItem)this.fiUI.mlaComDesc.getItemAt(i);
            locale = mli.getLang().getLocale();
            String desc = mli.getData().toString();
            ouPartFI.setCompanyDescription(desc, locale);
        }
        this.curSchemeInfo = (AcountSchemeInfo)this.fiUI.bizPromptAccountScheme.getData();
        if (this.curSchemeInfo != null) {
            ouPartFI.setAccountScheme(this.curSchemeInfo);
        }
        ouPartFI.setRegisteredCode(this.fiUI.txtRegisteredCode.getText());
        ouPartFI.setTaxNumber(this.fiUI.taxNumber.getText());
        Object bankInfo = this.fiUI.taxBank.getData();
        ouPartFI.setBank(bankInfo == null ? null : (BankInfo)bankInfo);
        ouPartFI.setBankAccount(this.fiUI.txtBankAccount.getText());
        ouPartFI.setTaxType((OUTaxType)((Object)this.fiUI.comboTaxType.getSelectedItem()));
        ouPartFI.setActivityDate(this.fiUI.activityDate.getTimestamp());
        ouPartFI.setTaxCode(this.fiUI.txtTaxCode.getText());
        ouPartFI.setContact(this.fiUI.txtContact.getText());
        ouPartFI.setContactPhone(this.fiUI.txtContactPhone.getText());
        ouPartFI.setTaxAddress(this.fiUI.txtAddress.getText());
        ouPartFI.setInvoiceNumber(this.fiUI.txtInvoiceNumber.getText());
        ouPartFI.setInvoiceCount(this.fiUI.txtInvoiceCount.getText());
        this.editData.setPartFI(ouPartFI);
        try {
            this.checkHasDupTaxCode(this.editData, ouPartFI);
        }
        catch (Exception e) {
            SysUtil.abort();
            return;
        }
        this.editData.setPartFI(ouPartFI);
        if (this.fiUI.bizPromptSuperiorCom.getData() != null) {
            this.ouEditui.getPDValueInfo().setParentOrg(OrgType.Company, (OrgUnitInfo)((CompanyOrgUnitInfo)this.fiUI.bizPromptSuperiorCom.getData()));
        }
    }

    public void loadOrgFields(OUEditUI ouEditui) throws Exception {
        this.editData = ouEditui.editData;
        this.ouEditui = ouEditui;
        this.loadCompanyFields();
        this.loadDelegate(ouEditui);
        this.fiUI.setOuEditui(ouEditui);
        if (ouEditui.editData == null || !ouEditui.editData.isIsCompanyOrgUnit()) {
            this.getUserSelectKDCheckBox().setSelected(false);
        } else {
            this.getUserSelectKDCheckBox().setSelected(true);
        }
        if (this.editData.getId() != null && "00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.editData.getId().toString())) {
            this.fiUI.bizPromptSuperiorCom.setEnabled(false);
        }
    }

    public void init(OUEditUI ouEditui) {
        this.ouEditui = ouEditui;
        this.editData = ouEditui.editData;
        this.fiUI.setOuEditui(ouEditui);
        this.initChkPnl("chkIsCompanyOrgUnit", this.ouEditui, this);
        this.fiUI.setOuEditui(ouEditui);
        UIHelper.initComboBoxModel((KDComboBox)this.fiUI.cbConvertMode, (Iterator)ReportCurrencyConvertMode.iterator());
        this.fiUI.bizPromptSuperiorCom.setEditable(false);
        NewCompanyF7 comF7 = (NewCompanyF7)new OrgTypeFIHelper().createNewF7ByCondition("TREETYPE_VIRTUALUNIT");
        comF7.setNeedAddOrgRange(false);
        comF7.setUiOwner((IUIObject)ouEditui);
        this.fiUI.bizPromptSuperiorCom.setSelector((KDPromptSelector)comF7);
        this.fiUI.cbConvertMode.setEditable(false);
        this.fiUI.bizPromptSuperiorCom.setData(null);
        if (this.editData != null && this.editData.getId() != null && this.editData.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            this.fiUI.bizPromptSuperiorCom.setEnabled(false);
        }
    }

    public SelectorItemCollection getSelection4RPC() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.number"));
        sic.add(new SelectorItemInfo("reportExchangeTable.name"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.number"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("address.id"));
        sic.add(new SelectorItemInfo("address.number"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("area.id"));
        sic.add(new SelectorItemInfo("area.number"));
        sic.add(new SelectorItemInfo("area.name"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    void loadCompanyFields() throws EASBizException, Exception {
        if (this.ouEditui.editData == null || !this.editData.isIsCompanyOrgUnit()) {
            this.fiUI.chkIsGroup.setSelected(false);
            this.fiUI.chkIsComBizUnit.setSelected(false);
            this.fiUI.bizPromptCurrencyAux.setData(null);
            this.fiUI.bizPromptSelfCurrency.setData(null);
            this.fiUI.bizPromptReportCurrency.setData(null);
            this.fiUI.bizPromptAccountPeriodType.setData(null);
            this.fiUI.bizPromptAccountTable.setData(null);
            this.fiUI.bizPromptAux.setData(null);
            this.fiUI.bizPromptAuxLast.setData(null);
            this.fiUI.cbConvertMode.setSelectedItem(null);
            int n = this.fiUI.mlaComDesc.getItemCount();
            for (int i = 0; i < n; ++i) {
                ((MultiLangItem)this.fiUI.mlaComDesc.getItemAt(i)).setData(null);
            }
            this.fiUI.mlaComDesc.setSelectedItemData(null);
            this.fiUI.fiSealUpDate.setValue(null);
            this.fiUI.bizPromptAccountScheme.setData(null);
        } else {
            this.ouEditui.editData.setPartFI((OUPartFIInfo)OUEditUICenter.getOUpartInfo((IOUEditHelper)this, (boolean)this.ouEditui.isCurVersion(), (FullOrgUnitInfo)this.ouEditui.editData, (SelectorItemCollection)this.getSelection4RPC()));
            OUPartFIInfo fiExtInfo = this.ouEditui.editData.getPartFI();
            if (!fiExtInfo.isIsGroup()) {
                this.fiUI.chkIsGroup.setEnabled(false);
            } else {
                this.fiUI.chkIsGroup.setEnabled(true);
            }
            this.fiUI.chkIsGroup.setSelected(fiExtInfo.isIsGroup());
            this.fiUI.chkIsComBizUnit.setSelected(fiExtInfo.isIsBizUnit());
            this.fiUI.bizPromptCurrencyAux.setData((Object)fiExtInfo.getReportExchangeTable());
            this.fiUI.bizPromptSelfCurrency.setData((Object)fiExtInfo.getBaseCurrency());
            this.fiUI.bizPromptReportCurrency.setData((Object)fiExtInfo.getReportCurrency());
            this.fiUI.bizPromptAccountPeriodType.setData((Object)fiExtInfo.getAccountPeriodType());
            this.fiUI.bizPromptAccountTable.setData((Object)fiExtInfo.getAccountTable());
            this.fiUI.bizPromptAux.setData((Object)fiExtInfo.getBaseExchangeTable());
            this.fiUI.bizPromptAuxLast.setData((Object)fiExtInfo.getAdjustExchangeTable());
            this.fiUI.cbConvertMode.setSelectedItem((Object)fiExtInfo.getReportConvertMode());
            this.fiUI.authorizationCode.setText(fiExtInfo.getAuthorizationCode());
            this.fiUI.authorizationKey.setText(fiExtInfo.getAuthorizationKey());
            this.fiUI.encryptionKey.setText(fiExtInfo.getEncryptionKey());
            int n = this.fiUI.mlaComDesc.getItemCount();
            for (int i = 0; i < n; ++i) {
                MultiLangItem mli = (MultiLangItem)this.fiUI.mlaComDesc.getItemAt(i);
                mli.setData((Object)fiExtInfo.getCompanyDescription(mli.getLang().getLocale()));
            }
            this.fiUI.mlaComDesc.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
            this.fiUI.mlaComDesc.setSelectedItemData((Object)fiExtInfo.getCompanyDescription());
            this.fiUI.fiSealUpDate.setValue((Object)this.ouEditui.editData.getPartFI().getPropertySealUpDate());
            if (this.ouEditui.editData.getPartFI().getAccountScheme() == null && this.isIs_Enable_Assistant_Org()) {
                this.fiUI.bizPromptAccountScheme.setData((Object)this.curSchemeInfo);
            } else if (this.ouEditui.editData.getPartFI().getAccountScheme() != null) {
                AcountSchemeInfo newSchemInfo = AcountSchemeFactory.getRemoteInstance().getAcountSchemeInfo((IObjectPK)new ObjectStringPK(this.ouEditui.editData.getPartFI().getAccountScheme().getId().toString()));
                this.fiUI.bizPromptAccountScheme.setData((Object)newSchemInfo);
            }
            this.loadBizSuperior(this.ouEditui);
            this.chkIsCompanyOrgUnit.setSelected(true);
            OUPartFIInfo ouFI = this.ouEditui.editData.getPartFI();
            if (ouFI.getBank() != null) {
                this.fiUI.taxBank.setData((Object)BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectStringPK(ouFI.getBank().getId().toString())));
            }
            this.fiUI.txtRegisteredCode.setText(ouFI.getRegisteredCode());
            this.fiUI.taxNumber.setText(ouFI.getTaxNumber());
            this.fiUI.txtBankAccount.setText(ouFI.getBankAccount());
            this.fiUI.comboTaxType.setSelectedItem((Object)ouFI.getTaxType());
            this.fiUI.activityDate.setValue((Object)ouFI.getActivityDate());
            this.fiUI.txtTaxCode.setText(ouFI.getTaxCode());
            this.fiUI.txtContact.setText(ouFI.getContact());
            this.fiUI.txtContactPhone.setText(ouFI.getContactPhone());
            this.fiUI.txtAddress.setText(ouFI.getTaxAddress());
            this.fiUI.txtInvoiceNumber.setText(ouFI.getInvoiceNumber());
            this.fiUI.txtInvoiceCount.setText(ouFI.getInvoiceCount());
        }
        this.fiUI.showTaxField(this.fiUI.chkIsComBizUnit.isSelected());
        this.setFIComponentsEnabled(true);
    }

    private boolean isCanModifyReportCurrency() throws EASBizException, BOSException {
        boolean isCanModifyReportCurrency = false;
        if (this.editData.getId() == null) {
            return isCanModifyReportCurrency;
        }
        if (this.editData.getId() != null && "00000000-0000-0000-0000-000000000000CCE7AED4".equalsIgnoreCase(this.editData.getId().toString())) {
            isCanModifyReportCurrency = CompanyOrgUnitFactory.getRemoteInstance().isCanModifyReportCurrency();
        }
        return isCanModifyReportCurrency;
    }

    public KDPanel getPanel() {
        return this.fiUI;
    }

    public KDCheckBox getUserSelectKDCheckBox() {
        return this.chkIsCompanyOrgUnit;
    }

    public void submit_afterDeal(OUEditUI editUI, FullOrgUnitInfo oldData, String number, String state, boolean isAddedNewOrgType, String name, List orgTypeList, String uiContextID, KDTree treeMain) throws Exception {
    }

    public boolean mayOperatreAssistantOrg() {
        return this.editData != null && this.editData.isIsCompanyOrgUnit() && this.editData.getPartFI().isIsBizUnit() || !this.fiUI.chkIsComBizUnit.isSelected();
    }

    private void loadPartData(FullOrgUnitInfo editOrgData) throws BOSException, EASBizException {
        if (editOrgData.getPartFI() == null && editOrgData.getPartFI() != null) {
            IOUPartFI iOUpart = OUPartFIFactory.getRemoteInstance();
            OUPartFICollection ouPartExtCol = iOUpart.getOUPartFICollection(" select * where unit = '" + editOrgData.getId() + "'");
            editOrgData.setPartFI(ouPartExtCol.get(0));
        }
    }

    public void setComponentsEnabled(boolean enable) {
        this.setFIComponentsEnabled(enable);
        if (this.editData.getPartFI() != null) {
            this.ouEditui.btnSealUp.setEnabled(!this.editData.getPartFI().isIsSealUp());
            this.ouEditui.btnUnSealUp.setEnabled(this.editData.getPartFI().isIsSealUp());
        }
    }

    private void setFIComponentsEnabled(boolean enable) {
        try {
            if (!OprtState.VIEW.equals(this.ouEditui.getOprtState())) {
                this.setFIProperties();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.fiUI.fiSealUpDate.setEnabled(false);
        this.fiUI.bizPromptAccountScheme.setEnabled(false);
        this.fiUI.bizPromptAccountTable.setEnabled(false);
    }

    private void handleControlState(JComponent component, boolean isEnable) {
        component.setEnabled(isEnable);
    }

    public void checkBeforeBizUnSealUp(OUEditUI ouEditui) throws BOSException, EASBizException {
        this.checkHasDupTaxCode(ouEditui.editData, ouEditui.editData.getPartFI());
    }
}

