/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IBudgetCheckAction;
import com.kingdee.eas.basedata.org.ICslRptCheckAction;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IUnionVersionControllerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionGroupOrgUnitFactory;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.basedata.org.client.AbstractOUUnionListUI;
import com.kingdee.eas.basedata.org.client.DateChooser;
import com.kingdee.eas.basedata.org.client.IUnionVersionClient;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OUUnionGroupEditUI;
import com.kingdee.eas.basedata.org.client.OrgManagerLayerListUI;
import com.kingdee.eas.basedata.org.client.OrgSpecialTablesClientUtil;
import com.kingdee.eas.basedata.org.client.di.OrgDIUtil;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7ForImportingCompanyInUnionGroup;
import com.kingdee.eas.basedata.org.client.f7.NewCompany4ImportCompanyInUnionGroup;
import com.kingdee.eas.basedata.org.client.f7.NewProfitCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewUnionF7;
import com.kingdee.eas.basedata.org.client.tree.CUTreeBuilder;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.IOrgMsgManager;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OUUnionListUI
extends AbstractOUUnionListUI {
    private static Logger logger = Logger.getLogger((String)OUUnionListUI.class.getName());
    boolean isDoStart = false;
    private static volatile boolean isHasMethod = false;
    CUTreeBuilder builder = null;
    boolean isMaintainCU = false;
    private String selectedRecordQuerySQL = null;
    private EntityViewInfo mainQueryForExportUnionCompany = null;
    private boolean versioned = false;

    public OUUnionListUI() throws Exception {
        this.getUIMenuBar().setVisible(false);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.basedata.org.app.OUUnionListUIHandler");
            OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
            request.put("currentCU", (Object)SysContext.getSysContext().getCurrentCtrlUnit());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initInOnLoad();
        this.getOldF7();
    }

    protected void initInOnLoad() throws Exception {
        this.initGroupButton();
        this.initWorkButton();
        this.initCBXMain();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnQuery.setVisible(false);
        this.isExistMethod();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInput.setIcon(EASResource.getIcon((String)"imgTbtn_CiteJobSystem"));
        this.btnInput.setEnabled(true);
        this.btnExportUnionGroup.setIcon(EASResource.getIcon((String)"imgTbtn_citeunitecell"));
        this.btnExportUnionCompany.setIcon(EASResource.getIcon((String)"imgTbtn_educecompany"));
    }

    void initCBXMain() throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer("Select * Where type = ").append(8);
        String[] ids = this.getCtrlUnitIds();
        for (int i = 0; i < ids.length; ++i) {
            if (i == 0) {
                oql.append(" and cu.id in ('").append(ids[i]).append("'");
            } else {
                oql.append("'").append(ids[i]).append("'");
            }
            if (i != ids.length - 1) {
                oql.append(", ");
                continue;
            }
            oql.append(")");
        }
        oql.append(" order by number");
        OrgTreeCollection treeCol = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(oql.toString());
        DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
        int index = 0;
        String selectedID = (String)this.getUIContext().get("UnionTree");
        for (int i = 0; i < treeCol.size(); ++i) {
            OrgTreeInfo treeInfo = treeCol.get(i);
            model.addElement(treeInfo);
            if (!treeInfo.getId().toString().equals(selectedID)) continue;
            index = i;
        }
        this.cbxMain.setModel(model);
        this.cbxMain.setSelectedIndex(-1);
        this.cbxMain.setSelectedIndex(index);
        this.cbxMain.setEditable(false);
    }

    private String[] getCtrlUnitIds() throws BOSException, EASBizException {
        ArrayList<String> ctrlUnitIdList = new ArrayList<String>();
        CtrlUnitInfo currentCUInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        ctrlUnitIdList.add(currentCUInfo.getId().toString());
        String longNumber = currentCUInfo.getLongNumber();
        int lastIndex = longNumber.lastIndexOf(33);
        if (lastIndex > 0) {
            longNumber = longNumber.substring(0, lastIndex);
            String[] numbers = longNumber.split("!");
            StringBuffer oql = new StringBuffer("select id where number in (");
            for (int i = 0; i < numbers.length; ++i) {
                if (i != 0) {
                    oql.append(", ");
                }
                oql.append("'").append(numbers[i]).append("'");
            }
            oql.append(") order by longNumber");
            CtrlUnitCollection ctrlCol = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(oql.toString());
            for (int i = ctrlCol.size() - 1; i >= 0; --i) {
                ctrlUnitIdList.add(ctrlCol.get(i).getId().toString());
            }
        }
        String[] ids = new String[ctrlUnitIdList.size()];
        for (int i = 0; i < ctrlUnitIdList.size(); ++i) {
            ids[i] = (String)ctrlUnitIdList.get(i);
        }
        return ids;
    }

    protected void initTree() throws Exception {
        this.buildTree();
    }

    private void buildTree() throws Exception {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null) {
            IOrgStructure iStruct = OrgStructureFactory.getRemoteInstance();
            OrgStructureCollection col = iStruct.getOrgStructureCollection("Select *, unit.* Where parent = null and tree.id = '" + selectInfo.getId().toString() + "' order by longnumber");
            if (col.size() > 0) {
                this.builder = new CUTreeBuilder((Object)col.get(0), false, true, selectInfo, false);
                StepAddParamInfo rootStep = StepAddParamInfo.rootAllInstance;
                rootStep.setTreeType("TREE_TYPE_KDNODE");
                this.builder.buildTree((JTree)this.treeMain, rootStep);
                int selectPath = 0;
                if (this.getUIContext().get("selectPath") != null) {
                    selectPath = (Integer)this.getUIContext().get("selectPath");
                }
                this.treeMain.setSelectionRow(selectPath);
            } else {
                this.treeMain.setModel(null);
            }
        } else {
            this.treeMain.setModel(null);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        Object comp = this.treeMain.getLastSelectedPathComponent();
        if (comp instanceof KDTreeNode) {
            return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        }
        return null;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initInOnShow();
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OUUnionListUI.this.doStarting();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    private void initInOnShow() throws Exception {
        if (((Boolean)this.getUIContext().get("NewVersion")).booleanValue()) {
            this.cbxMain.setVisible(false);
        }
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.btnStart.setVisible(((Boolean)this.getUIContext().get("NewVersion")).booleanValue());
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OUUnionListUI.this.doStarting();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        this.hideSomeBtnsWhenReadOnly();
    }

    protected void cbxMain_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.cbxMain.getSelectedItem();
            this.buildTree();
            if (!((Boolean)this.getUIContext().get("NewVersion")).booleanValue()) {
                this.resetReadOnlyValue();
                this.hideSomeBtnsWhenReadOnly();
            }
        }
    }

    private void resetReadOnlyValue() throws Exception {
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        String currentCUId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        boolean isSameCU = currentCUId.equals(selectInfo.getCU().getId().toString());
        this.getUIContext().put("TreeStatus", selectInfo.getStatus().getValue());
    }

    private void hideSomeBtnsWhenReadOnly() {
        int treeStatus = (Integer)this.getUIContext().get("TreeStatus");
        boolean readOnly = (Boolean)this.getUIContext().get("ReadOnly");
        if (!readOnly) {
            if (treeStatus == 0) {
                this.btnRemove.setVisible(true);
                this.btnRefresh.setVisible(true);
                this.btnInput.setVisible(true);
                this.btnGroupAddNew.setVisible(true);
                this.btnGroupRemove.setVisible(true);
                this.btnGroupEdit.setVisible(true);
                this.btnGroupMoveTree.setVisible(true);
            } else if (treeStatus == 1) {
                if (((Boolean)this.getUIContext().get("NewVersion")).booleanValue()) {
                    this.btnRefresh.setVisible(true);
                    this.btnInput.setVisible(true);
                    this.btnGroupAddNew.setVisible(true);
                    this.btnGroupEdit.setVisible(true);
                    this.btnGroupMoveTree.setVisible(true);
                    this.btnRemove.setVisible(true);
                    this.btnGroupRemove.setVisible(true);
                } else {
                    this.btnRefresh.setVisible(true);
                    this.btnInput.setVisible(true);
                    this.btnGroupAddNew.setVisible(true);
                    this.btnGroupEdit.setVisible(true);
                    this.btnGroupMoveTree.setVisible(false);
                    if (isHasMethod) {
                        this.btnRemove.setVisible(true);
                        this.btnGroupRemove.setVisible(true);
                    } else {
                        this.btnRemove.setVisible(false);
                        this.btnGroupRemove.setVisible(false);
                    }
                }
            } else if (treeStatus == 2) {
                this.btnRefresh.setVisible(true);
                this.btnInput.setVisible(true);
                this.btnGroupAddNew.setVisible(false);
                this.btnGroupEdit.setVisible(true);
                this.btnGroupMoveTree.setVisible(false);
                this.btnGroupRemove.setVisible(false);
                if (isHasMethod) {
                    this.btnRemove.setVisible(true);
                } else {
                    this.btnRemove.setVisible(false);
                }
            }
        } else {
            this.btnRemove.setVisible(false);
            this.btnRefresh.setVisible(false);
            this.btnInput.setVisible(false);
            this.btnGroupAddNew.setVisible(false);
            this.btnGroupRemove.setVisible(false);
            this.btnGroupEdit.setVisible(false);
            this.btnGroupMoveTree.setVisible(false);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.refreshTableData();
        this.hideSomeBtnsWhenReadOnly();
    }

    private void refreshTableData() {
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            String treeID = ((OrgTreeInfo)this.cbxMain.getSelectedItem()).getId().toString();
            StringBuffer querySQL = new StringBuffer();
            querySQL.append("select unit.fid from t_org_baseunit unit inner join t_org_structure struct on unit.fid = struct.funitid ").append(" where struct.ftreeid = '").append(treeID).append("' and unit.fisunion = 0 ");
            OrgStructureInfo selectInfo = (OrgStructureInfo)this.getSelectedTreeNode().getUserObject();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeID));
            filter.getFilterItems().add(new FilterItemInfo("unit.isUnion", (Object)new Integer(0), CompareType.EQUALS));
            if (this.chkIncludeChild.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
                querySQL.append(" and struct.flongnumber like '").append(selectInfo.getLongNumber()).append("!%'");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)selectInfo.getId().toString(), CompareType.EQUALS));
                querySQL.append(" and struct.fparentid = '").append(selectInfo.getId()).append("'");
            }
            filter.setMaskString("#0 and #1 and #2");
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("fullUnit.number"));
            this.selectedRecordQuerySQL = querySQL.toString();
            this.mainQuery = view;
        } else {
            this.mainQuery = null;
        }
        this.tblMain.removeRows();
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        this.syncExportQueryForUnionCompany();
    }

    private void syncExportQueryForUnionCompany() {
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            OrgStructureInfo selectInfo = (OrgStructureInfo)this.getSelectedTreeNode().getUserObject();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)((OrgTreeInfo)this.cbxMain.getSelectedItem()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("unit.isUnion", (Object)new Integer(0), CompareType.EQUALS));
            if (this.chkIncludeChild.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(selectInfo.getLongNumber() + "!%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)selectInfo.getId().toString(), CompareType.EQUALS));
            }
            filter.setMaskString("#0 and #1 and #2");
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("unit.number"));
            this.mainQueryForExportUnionCompany = view;
        } else {
            this.mainQueryForExportUnionCompany = null;
        }
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            boolean bl;
            ICslRptCheckAction ia;
            ArrayList<Object> selectIds = this.getSelectedIdValues();
            ArrayList<String> numberList = new ArrayList<String>();
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = row.getCell("id").getValue().toString();
                if (!selectIds.contains(id)) continue;
                String number = row.getCell("number").getValue().toString();
                numberList.add(number);
            }
            int result = this.doVersioningBeforeModification();
            if (result == 2) {
                return;
            }
            selectIds = new ArrayList<Object>();
            ArrayList<String> unitids = new ArrayList<String>();
            rowCount = this.tblMain.getRowCount();
            IOrgStructure iOrgStructure = OrgStructureFactory.getRemoteInstance();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblMain.getRow(i);
                String number = row.getCell("number").getValue().toString();
                if (!numberList.contains(number)) continue;
                Object id = row.getCell("id").getValue();
                selectIds.add(id);
                OrgStructureInfo orgStructureInfo = iOrgStructure.getOrgStructureInfo("select unit.id  where id = '" + id + "'");
                unitids.add(orgStructureInfo.getUnit().getId().toString());
            }
            int treeStatus = (Integer)this.getUIContext().get("TreeStatus");
            String orgTreeId = (String)this.getUIContext().get("UnionTree");
            if ((treeStatus == 1 && !((Boolean)this.getUIContext().get("NewVersion")).booleanValue() || treeStatus == 2) && (ia = this.getCslRptCheckActionBizHandler()) != null && !(bl = ia.isCheckDelOrg(orgTreeId, unitids))) {
                return;
            }
            ObjectUuidPK[] arrayPK = new ObjectUuidPK[selectIds.size()];
            for (int i = 0; i < selectIds.size(); ++i) {
                arrayPK[i] = new ObjectUuidPK(BOSUuid.read((String)((String)selectIds.get(i))));
            }
            NewOUInnerFacadeFactory.getRemoteInstance().deleteUnionImport((IObjectPK[])arrayPK);
            this.refresh(e);
        }
    }

    public String[] getInputCompanyNumber() {
        int rowCount = this.tblMain.getRowCount();
        String[] companyNumber = new String[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            companyNumber[i] = new String(row.getCell("number").getValue().toString());
        }
        return companyNumber;
    }

    @Override
    public void actionInputOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionInputOrg_actionPerformed(e);
        OrgTreeInfo orginfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        OrgStructureInfo parentInfo = this.getSelectedNodeUserObject();
        if (parentInfo != null) {
            NewOrgViewF7PromptDialog f7 = null;
            if (orginfo.getLayerType().equals((Object)OrgViewType.COMPANY)) {
                f7 = new NewCompany4ImportCompanyInUnionGroup();
                f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                f7.setShowAssistantOrg(true);
                f7.setMultiSelect(true);
                f7.setNeedAddOrgRange(false);
                ((NewCompany4ImportCompanyInUnionGroup)f7).setImportedCompanyQuerySQL(this.selectedRecordQuerySQL);
                f7.show();
            }
            if (orginfo.getLayerType().equals((Object)OrgViewType.PROFITCENTER)) {
                f7 = new NewProfitCenterF7();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)"select FID from T_ORG_ProfitCenter where FIsBizUnit = 1", CompareType.INNER));
                f7.setOuterFilterInfo(filter);
                f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                f7.setMultiSelect(true);
                f7.setNeedAddOrgRange(false);
                f7.show();
            }
            if (f7 != null && f7.getData() != null) {
                OrgUnitInfo[] orgInfos = (OrgUnitInfo[])f7.getData();
                OrgStructureCollection strucInfos = new OrgStructureCollection();
                OrgStructureInfo sInfo = null;
                for (int i = 0; i < orgInfos.length; ++i) {
                    sInfo = new OrgStructureInfo();
                    sInfo.setTree((OrgTreeInfo)this.cbxMain.getSelectedItem());
                    FullOrgUnitInfo fInfo = new FullOrgUnitInfo();
                    fInfo.setId(orgInfos[i].getId());
                    fInfo.setName(orgInfos[i].getName());
                    fInfo.setNumber(orgInfos[i].getNumber());
                    sInfo.setUnit(fInfo);
                    sInfo.setParent(parentInfo);
                    strucInfos.add(sInfo);
                }
                NewOUInnerFacadeFactory.getRemoteInstance().addNewUnionInput(strucInfos);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
        this.treeMain_valueChanged(null);
    }

    private void getOldF7() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(79, 3), "biz");
        this.getActionMap().put("biz", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CompanyF7ForImportingCompanyInUnionGroup f7 = (CompanyF7ForImportingCompanyInUnionGroup)OrgTypeClientCenter.getInstance().getClientImp(OrgType.Company).createF7ByCondition("ImprtOrg");
                    f7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                    f7.setShowAssistantOrg(true);
                    f7.setIsShowSub(true);
                    f7.setMultiSelect(true);
                    f7.disablePerm(null, false);
                    String[] companyNumber = OUUnionListUI.this.getInputCompanyNumber();
                    f7.setFilterCompany(companyNumber);
                    f7.show();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareGroupUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.getGroupEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            this.buildTree();
        }
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedNodeKeyValue());
        int treeStatusValue = (Integer)this.getUIContext().get("TreeStatus");
        if (((Boolean)this.getUIContext().get("NewVersion")).booleanValue()) {
            uiContext.put((Object)"ISNEWBERSION", (Object)new Boolean(true));
        } else if (treeStatusValue == 0) {
            boolean isNewVersion = this.getUnionVersionInterface().isNewVersion((String)this.getUIContext().get("UnionTree"));
            uiContext.put((Object)"ISNEWBERSION", (Object)new Boolean(isNewVersion));
        }
        uiContext.put((Object)"NewVersion", this.getUIContext().get("NewVersion"));
        uiContext.put((Object)"TreeStatus", (Object)((Integer)this.getUIContext().get("TreeStatus")));
        this.prepareGroupUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (this.getGroupEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            this.buildTree();
        }
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        int result = this.doVersioningBeforeModification();
        if (result == 2) {
            return;
        }
        OrgStructureInfo structInfo = this.getSelectedNodeUserObject();
        if (structInfo != null) {
            int choise = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete"));
            if (MsgBox.isCancel((int)choise)) {
                return;
            }
            int treeStatus = (Integer)this.getUIContext().get("TreeStatus");
            if (treeStatus == 1 && !((Boolean)this.getUIContext().get("NewVersion")).booleanValue()) {
                boolean bl;
                ICslRptCheckAction ia = this.getCslRptCheckActionBizHandler();
                IBudgetCheckAction ib = this.getBudgetCheckActionBizHandler();
                String orgTreeId = (String)this.getUIContext().get("UnionTree");
                ArrayList<String> list = new ArrayList<String>();
                list.add(structInfo.getUnit().getId().toString());
                if (ia != null && !(bl = ia.isCheckDelOrg(orgTreeId, list))) {
                    return;
                }
                if (ib != null && !(bl = ib.isCheckDelOrg(orgTreeId, list))) {
                    return;
                }
            }
            IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
            iFull.delete((IObjectPK)new ObjectUuidPK(structInfo.getUnit().getId()));
        }
        if (this.getGroupEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            this.buildTree();
        }
    }

    OrgStructureInfo getSelectedNodeUserObject() {
        KDTreeNode selectedNode;
        TreePath path = this.treeMain.getSelectionPath();
        OrgStructureInfo info = null;
        if (path != null && (selectedNode = (KDTreeNode)path.getLastPathComponent()) != null) {
            info = (OrgStructureInfo)selectedNode.getUserObject();
            return info;
        }
        return null;
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        OrgStructureInfo structureInfo = null;
        if (this.getSelectedTreeNode() == null) {
            return;
        }
        structureInfo = (OrgStructureInfo)this.getSelectedTreeNode().getUserObject();
        if (structureInfo.getParent() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.orgext.OUExtResource", (String)"ROOT_CANNOT_MOVE"));
            SysUtil.abort();
        }
        OrgTreeInfo selectedInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        boolean newVersion = (Boolean)this.getUIContext().get("NewVersion");
        int result = this.doVersioningBeforeModification();
        if (!newVersion && selectedInfo != null && selectedInfo.getStatus().getValue() == 1 && result != 0) {
            return;
        }
        String treeId = ((OrgTreeInfo)this.cbxMain.getSelectedItem()).getId().toString();
        NewUnionF7 unionF7 = null;
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        unionF7 = window instanceof Dialog ? new NewUnionF7((Dialog)window, 2, structureInfo.getLongNumber()) : new NewUnionF7((Frame)window, 2, structureInfo.getLongNumber());
        unionF7.setTitle(EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"CHOOSE_PARENT"));
        unionF7.setTreeID(treeId);
        unionF7.setIsVersion(false);
        unionF7.setCurrentCUID("00000000-0000-0000-0000-000000000000CCE7AED4");
        unionF7.setNeedAddOrgRange(false);
        unionF7.setUserPK((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        unionF7.show();
        if (!unionF7.isCanceled()) {
            if (structureInfo == null) {
                return;
            }
            FullOrgUnitInfo orgUnitInfo = structureInfo.getUnit();
            if (orgUnitInfo == null) {
                return;
            }
            String id = StringUtils.cnulls((Object)orgUnitInfo.getId());
            if (id == null) {
                return;
            }
            String newParentID = ((FullOrgUnitInfo)unionF7.getData()).getId().toString();
            UnionGroupOrgUnitFactory.getRemoteInstance().moveTree(id, newParentID, treeId);
            this.buildTree();
        }
    }

    private int doVersioningBeforeModification() throws Exception {
        OrgTreeInfo selectedInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        int result = 3;
        if (selectedInfo == null) {
            return result;
        }
        boolean newVersion = (Boolean)this.getUIContext().get("NewVersion");
        if (!newVersion && selectedInfo.getStatus().getValue() == 1 && (result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"CREATE_NEW_VERSION"))) == 0) {
            String oldTreeID = (String)this.getUIContext().get("UnionTree");
            String newTreeID = this.getTreeID(oldTreeID);
            Map context = this.getUIContext();
            context.put("UnionTree", newTreeID);
            context.put("OldTree", oldTreeID);
            context.put("TreeStatus", new Integer(1));
            context.put("ReadOnly", new Boolean(false));
            context.put("NewVersion", new Boolean(true));
            int[] selectRow = this.treeMain.getSelectionRows();
            if (selectRow != null && selectRow.length > 0) {
                context.put("selectPath", new Integer(selectRow[0]));
            }
            this.initInOnLoad();
            this.initInOnShow();
        }
        if (selectedInfo.getStatus().getValue() == 0) {
            result = 0;
        }
        return result;
    }

    private String getTreeID(String oldTreeID) throws Exception {
        IUnionVersionControllerFacade iuvcf = this.getUnionVersionInterface();
        int treeStatus = iuvcf.getStatus(oldTreeID);
        String newTreeID = "";
        if (treeStatus == 1) {
            newTreeID = iuvcf.clone(oldTreeID);
        }
        return newTreeID;
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof OrgStructureInfo) {
            return ((OrgStructureInfo)treeNode.getUserObject()).getUnit().getId().toString();
        }
        SysUtil.abort();
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        Action action = null;
        if (e != null) {
            action = ((AbstractButton)e.getSource()).getAction();
        }
        if (action == this.actionGroupRemove) {
            this.buildTree();
        } else if (action == this.actionRefresh) {
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.buildTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
        } else if (action == this.actionGroupAddNew) {
            this.buildTree();
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (treeNode != null) {
                TreePath oldPath = this.treeMain.getSelectionPath();
                this.treeMain.setSelectionPath(oldPath);
            }
        } else if (action == this.actionGroupEdit) {
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (treeNode != null && treeNode.getParent() != null) {
                TreePath oldPath = this.treeMain.getSelectionPath();
                this.buildTree();
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
            }
        } else {
            this.treeMain_valueChanged(null);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isValid", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isValid", (Object)new Integer(0), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    public boolean destroyWindow() {
        try {
            this.doAsking();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        OrgSpecialTablesClientUtil.rebuildASpecialTableWhenAutoAudit((int)8);
        if (CacheConfigManager.getConfig() != null) {
            CacheServiceFactory.getInstance().discardAll();
        }
        return super.destroyWindow();
    }

    private void doAsking() throws Exception {
        if (((Boolean)this.getUIContext().get("NewVersion")).booleanValue() && this.btnStart.isVisible() && !this.versioned) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"ASK_START_UNION")) == 0) {
                this.doStarting();
            } else {
                ((OrgManagerLayerListUI)((Object)this.getUIContext().get("Owner"))).refreshList();
            }
        }
    }

    private void doStarting() throws Exception {
        IOrgMsgManager iOrgMsgManager = this.getBizHandler();
        boolean getMsg = false;
        if (iOrgMsgManager != null) {
            try {
                getMsg = iOrgMsgManager.doStartMsg();
            }
            catch (Exception ex) {
                logger.info((Object)"OrgMsgManagerImpl running errer!");
            }
        } else {
            logger.info((Object)"Can not find class OrgMsgManagerImpl");
        }
        if ((iOrgMsgManager == null || getMsg) && !this.isDoStart) {
            final DateChooser dc = new DateChooser((Component)((Object)this));
            dc.show();
            if (dc.isOK()) {
                LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
                dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        OUUnionListUI.this.doStarted(dc);
                        return null;
                    }

                    public void afterExec(Object result) throws Exception {
                    }
                });
                dialog.show();
            }
        } else {
            this.isDoStart = false;
        }
    }

    private void doStarted(DateChooser dc) throws Exception {
        ICslRptCheckAction ia;
        Map result = this.getUnionVersionInterface().commit(this.getUIContext().get("OldTree").toString(), this.getUIContext().get("UnionTree").toString(), dc.getDate());
        if (result != null && (ia = this.getCslRptCheckActionBizHandler()) != null) {
            try {
                ia.init(result, (Object)this, true);
                ia.show();
                if (ia.isCancel()) {
                    return;
                }
                this.getUnionVersionInterface().commit(this.getUIContext().get("OldTree").toString(), this.getUIContext().get("UnionTree").toString(), dc.getDate());
            }
            catch (EASBizException easexc) {
                throw easexc;
            }
            catch (BOSException bosexc) {
                throw bosexc;
            }
            catch (Exception exc) {
                throw new BOSException((Throwable)exc);
            }
        }
        this.versioned = true;
        ((OrgManagerLayerListUI)((Object)this.getUIContext().get("Owner"))).refreshList();
        IUnionVersionClient uv = this.getUnionVersionClientHandler();
        uv.afterStart();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"VERSIONING_FINISH"));
        this.btnStart.setEnabled(false);
        this.btnStart.setVisible(false);
        this.isDoStart = !this.isDoStart;
    }

    private ICslRptCheckAction getCslRptCheckActionBizHandler() throws BOSException {
        ICslRptCheckAction ia = null;
        try {
            ia = (ICslRptCheckAction)Class.forName("com.kingdee.eas.fi.gr.cslrpt.client.CslRptCheckActionImpl").newInstance();
        }
        catch (Exception e) {
            throw new BOSException("Can not find class for ICslRptCheckAction:");
        }
        return ia;
    }

    private IBudgetCheckAction getBudgetCheckActionBizHandler() throws BOSException {
        IBudgetCheckAction ib = null;
        try {
            ib = (IBudgetCheckAction)Class.forName("com.kingdee.eas.ma.bgcsl.client.cslRptCheckAction.BgCslRptCheckActionImpl").newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"Can not find class for IBudgetCheckAction:");
        }
        return ib;
    }

    private IUnionVersionClient getUnionVersionClientHandler() throws BOSException {
        IUnionVersionClient uv = null;
        try {
            uv = (IUnionVersionClient)Class.forName("com.kingdee.eas.fi.gr.cslrpt.client.UnionVersionClient").newInstance();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return uv;
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        this.refreshTableData();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        KDTreeNode selectNode = this.getSelectedTreeNode();
        return new ObjectUuidPK(((OrgStructureInfo)selectNode.getUserObject()).getUnit().getId());
    }

    protected String getGroupEditUIName() {
        return OUUnionGroupEditUI.class.getName();
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"OrgTreeInfo", (Object)((OrgTreeInfo)this.cbxMain.getSelectedItem()));
        uiContext.put((Object)"ParentNode", (Object)this.getSelectedNodeUserObject());
        uiContext.put((Object)"isMaintainCU", (Object)new Boolean(this.isMaintainCU));
    }

    protected String getQueryFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgStructureFactory.getRemoteInstance();
    }

    private IUnionVersionControllerFacade getUnionVersionInterface() throws Exception {
        return UnionVersionControllerFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionExportUnionGroup_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportUnionGroup_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)OrgToolUtils.getExtResource((String)"res_13"), (BOSObjectType)new FullOrgUnitInfo().getBOSType(), null, (String)OrgToolUtils.getExtResource((String)"res_13"));
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null) {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "UnionGroupExportQuery");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)selectInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("unit.isUnion", (Object)new Integer(1), CompareType.EQUALS));
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("longNumber"));
            OrgDIUtil.performExportForKey((Component)((Object)this), (String)"UnionGroup", (IMetaDataPK)mainQueryPK, (EntityViewInfo)view);
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void actionExportUnionCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportUnionCompany_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)OrgToolUtils.getExtResource((String)"res_14"), (BOSObjectType)OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(OrgType.Company).getBosType(), null, (String)OrgToolUtils.getExtResource((String)"res_14"));
        OrgTreeInfo selectInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (selectInfo != null) {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "UnionCompanyExportQuery");
            OrgDIUtil.performExportForKey((Component)((Object)this), (String)"UnionCompany", (IMetaDataPK)mainQueryPK, (EntityViewInfo)this.mainQueryForExportUnionCompany);
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private IOrgMsgManager getBizHandler() throws BOSException {
        IOrgMsgManager iOrgMsgManager = null;
        try {
            iOrgMsgManager = (IOrgMsgManager)Class.forName("com.kingdee.eas.fi.gr.cslrpt.OrgMsgManagerImpl").newInstance();
        }
        catch (Exception e) {
            logger.info((Object)"Can not find class OrgMsgManagerImpl: ", (Throwable)e);
        }
        return iOrgMsgManager;
    }

    private boolean isExistMethod() {
        try {
            Method[] methods;
            Class<?> cl = Class.forName("com.kingdee.eas.fi.gr.cslrpt.client.CslRptCheckActionImpl");
            for (Method me : methods = cl.getDeclaredMethods()) {
                if (!me.getName().contains("isCheckDelOrg")) continue;
                isHasMethod = true;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return isHasMethod;
    }
}

