/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.AbstractOrgManagerLayerEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OrgManagerLayerEditUI
extends AbstractOrgManagerLayerEditUI {
    private static String strResource = "com.kingdee.eas.basedata.org.client.OrgResource";

    public OrgManagerLayerEditUI() throws Exception {
        this.init();
        this.txtNumber.setMaxLength(79);
        this.txtName.setMaxLength(79);
        this.txtDescription.setMaxLength(254);
    }

    private void init() {
        this.initKDBox_LayerType();
        this.chkBasic.addChangeListener((ChangeListener)new CheckBoxListener());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.hideBtnEditWhenReadOnly();
        this.menuSubmitOption.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.menuView.setVisible(false);
    }

    private void initKDBox_LayerType() {
        DefaultComboBoxModel<OrgViewType> model = new DefaultComboBoxModel<OrgViewType>();
        model.addElement(OrgViewType.COMPANY);
        model.addElement(OrgViewType.PROFITCENTER);
        this.layerType.setModel(model);
    }

    private void hideBtnEditWhenReadOnly() {
        if (((Boolean)this.getUIContext().get("ReadOnly")).booleanValue()) {
            this.btnEdit.setVisible(false);
            this.btnSubmit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.menuItemCopy.setVisible(false);
            Object obj = this.getUIContext().get("ReadOnly_del");
            if (obj != null && obj instanceof Boolean) {
                boolean isDel = (Boolean)this.getUIContext().get("ReadOnly_del");
                this.menuItemRemove.setVisible(isDel);
                this.menuEdit.setVisible(isDel);
            }
        }
        if (((Boolean)this.getUIContext().get("editStart")).booleanValue()) {
            this.txtNumber.setEnabled(false);
            this.chkBasic.setEnabled(false);
            this.chkForBudget.setEnabled(false);
            this.btnSubmit.setVisible(true);
            this.menuItemRemove.setVisible(false);
        }
        if (((Boolean)this.getUIContext().get("isVersioned")).booleanValue()) {
            this.txtNumber.setEnabled(false);
            this.chkBasic.setEnabled(false);
            this.chkForBudget.setEnabled(false);
            this.btnSubmit.setVisible(true);
            this.menuItemRemove.setVisible(false);
        }
        if (((Boolean)this.getUIContext().get("ReadOnly")).booleanValue() || this.editData != null && 1 == this.editData.getStatus().getValue() || this.editData != null && this.isSetting()) {
            this.layerType.setEnabled(false);
        }
    }

    private boolean isSetting() {
        boolean flag = false;
        try {
            IOrgStructure iStruct = OrgStructureFactory.getRemoteInstance();
            OrgStructureCollection col = iStruct.getOrgStructureCollection("Select tree.id Where parent = null and tree.id = '" + this.editData.getId().toString() + "'");
            if (col != null && col.size() > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.layerType.setSelectedItem((Object)this.editData.getLayerType());
            if (this.editData.getLayerType() == OrgViewType.PROFITCENTER) {
                this.chkBasic.setEnabled(false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData != null) {
            this.editData.setType(OrgViewType.UNIONDEBT);
        }
    }

    protected IObjectValue createNewData() {
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setType(OrgViewType.UNIONDEBT);
        return treeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgTreeFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    private class CheckBoxListener
    implements ChangeListener {
        private CheckBoxListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDCheckBox checkBox = (KDCheckBox)e.getSource();
            if (checkBox.getSelected() == 32) {
                OrgManagerLayerEditUI.this.layerType.setSelectedIndex(0);
                OrgManagerLayerEditUI.this.layerType.setEnabled(false);
            } else {
                OrgManagerLayerEditUI.this.layerType.setEnabled(true);
            }
        }
    }
}

