/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class AdminByHROF7
extends AdminF7 {
    private String hrOrgUnitID = "";
    private boolean useGrayNodeStyle = false;
    private boolean useOrgRangeFilter = true;

    public AdminByHROF7(String hrOrgUnitID) {
        this.hrOrgUnitID = hrOrgUnitID;
    }

    public AdminByHROF7(IUIObject iuio, String hrOrgUnitID) {
        super(iuio);
        this.hrOrgUnitID = hrOrgUnitID;
    }

    public AdminByHROF7(Frame frm, String hrOrgUnitID) {
        super(frm);
        this.hrOrgUnitID = hrOrgUnitID;
    }

    public AdminByHROF7(Dialog dlg, String hrOrgUnitID) {
        super(dlg);
        this.hrOrgUnitID = hrOrgUnitID;
    }

    public void setUseGrayNodeStyle() {
        this.useGrayNodeStyle = true;
    }

    public void setDoNotUseOrgRangeFilter() {
        this.useOrgRangeFilter = false;
    }

    public DefaultKingdeeTreeNode getRoot() throws Exception {
        OrgViewType orgViewType = OrgViewType.ADMIN;
        OrgTreeInfo treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType)));
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel(orgViewType, treeInfo).getRoot();
        this.convertNodeUserObjectToAdminOrgUnitInfo(root);
        return root;
    }

    private void convertNodeUserObjectToAdminOrgUnitInfo(DefaultKingdeeTreeNode root) throws Exception {
        if (root.getUserObject() == null) {
            return;
        }
        Enumeration enu = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (enu.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enu.nextElement();
            node.setUserObject((Object)this.makeAdminOrgUnitInfo((OrgStructureInfo)node.getUserObject()));
        }
    }

    private AdminOrgUnitInfo makeAdminOrgUnitInfo(OrgStructureInfo structInfo) {
        FullOrgUnitInfo unitInfo = structInfo.getUnit();
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(unitInfo.getId());
        adminInfo.setName(unitInfo.getName());
        adminInfo.setLongNumber(structInfo.getLongNumber());
        adminInfo.setLevel(structInfo.getLevel());
        adminInfo.setIndex(unitInfo.getPartAdmin().getIndex());
        return adminInfo;
    }

    public static DefaultKingdeeTreeNode getRootNew(String hrOrgUnitID, boolean useOrgRangeFilter) throws Exception {
        String firstLongNumber;
        IHROrgUnit iHR = HROrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection adminCol = iHR.getAdminOrgUnitCollectionWithOrgRangeFilter(hrOrgUnitID);
        if (!useOrgRangeFilter) {
            adminCol = iHR.getAdminOrgUnitCollection(hrOrgUnitID);
        }
        if (adminCol.size() == 0) {
            return null;
        }
        HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
        AdminOrgUnitInfo adminInfo = null;
        if (AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"))) {
            adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(adminInfo);
        OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)root);
        String rootLongNumber = firstLongNumber = adminCol.get(0).getLongNumber();
        if (firstLongNumber.indexOf("!") != -1) {
            rootLongNumber = firstLongNumber.substring(0, firstLongNumber.indexOf("!"));
        }
        map.put(rootLongNumber, root);
        String longNumber = "";
        String parLongNumber = "";
        DefaultKingdeeTreeNode node = null;
        int n = adminCol.size();
        for (int i = 0; i < n; ++i) {
            parLongNumber = longNumber = adminCol.get(i).getLongNumber();
            while (!map.containsKey(parLongNumber) && parLongNumber.lastIndexOf("!") != -1) {
                parLongNumber = parLongNumber.substring(0, parLongNumber.lastIndexOf("!"));
            }
            node = new DefaultKingdeeTreeNode((Object)adminCol.get(i));
            map.put(longNumber, node);
            if (parLongNumber.equals(longNumber)) {
                root = node;
                continue;
            }
            ((DefaultKingdeeTreeNode)map.get(parLongNumber)).add((MutableTreeNode)node);
        }
        NewOrgViewHelper.reBuildAdminTreeBySortCode((DefaultKingdeeTreeNode)root);
        return root;
    }

    protected void prepareDisplayOrgIDs(OrgViewType orgViewType, OrgTreeInfo orgTree) throws Exception {
        this.innerPrepareDisplayOrgIDs();
    }

    protected void prepareDisplayOrgIDs() throws Exception {
        this.innerPrepareDisplayOrgIDs();
    }

    private void innerPrepareDisplayOrgIDs() throws Exception {
        IHROrgUnit iHR = HROrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection unitCol = iHR.getAdminOrgUnitCollectionWithOrgRangeFilter(this.hrOrgUnitID);
        if (!this.useOrgRangeFilter) {
            unitCol = iHR.getAdminOrgUnitCollection(this.hrOrgUnitID);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        int n = unitCol.size();
        for (int i = 0; i < n; ++i) {
            map.put(unitCol.get(i).getId().toString(), Boolean.FALSE);
        }
        this.displayOrgIds = map;
        if (this.rootUnitID == null || this.rootUnitID.equals("11111111-1111-1111-1111-111111111111CCE7AED4")) {
            this.rootUnitID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
    }

    protected void clipTreeModel(TreeModel model) {
        if (this.useGrayNodeStyle) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)model;
        this.moveTheWantedTreeNodesTogether(treeModel);
        this.removeAllTheUnwantedTreeNodes(treeModel);
    }

    private void moveTheWantedTreeNodesTogether(DefaultTreeModel treeModel) {
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode parnode = null;
        ArrayList nodes = this.getAListOfAllTreeNodes(treeModel);
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            node = (DefaultKingdeeTreeNode)nodes.get(i);
            if (node.isRoot() || !this.isTheWantedTreeNode(node)) continue;
            parnode = (DefaultKingdeeTreeNode)node.getParent();
            while (!parnode.isRoot() && !this.isTheWantedTreeNode(parnode)) {
                parnode = (DefaultKingdeeTreeNode)parnode.getParent();
                treeModel.removeNodeFromParent((MutableTreeNode)node);
                parnode.add((MutableTreeNode)node);
            }
        }
    }

    private void removeAllTheUnwantedTreeNodes(DefaultTreeModel treeModel) {
        ArrayList nodes = this.getAListOfAllTreeNodes(treeModel);
        DefaultKingdeeTreeNode node = null;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            node = (DefaultKingdeeTreeNode)nodes.get(i);
            if (node.isRoot() || node.getParent() == null || this.isTheWantedTreeNode(node)) continue;
            treeModel.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    private boolean isTheWantedTreeNode(DefaultKingdeeTreeNode node) {
        return !OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node);
    }

    private ArrayList getAListOfAllTreeNodes(DefaultTreeModel treeModel) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        Enumeration nodes = root.breadthFirstEnumeration();
        ArrayList list = new ArrayList();
        while (nodes.hasMoreElements()) {
            list.add(nodes.nextElement());
        }
        return list;
    }
}

