/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForF7;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OrgF7Helper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class OUUnionF7
extends OuF7PromptDialog {
    private boolean isDisplayMaintain = false;
    private boolean isShowNameandNumber = false;
    private boolean disableTheOUWhichIsOnlyAdmin = false;

    public OUUnionF7() {
    }

    public OUUnionF7(IUIObject _uiObject) {
        super(_uiObject);
    }

    public OUUnionF7(Frame _owner) {
        super(_owner);
    }

    public OUUnionF7(Dialog _owner) {
        super(_owner);
    }

    protected void processTree(DefaultTreeModel treeModel) throws Exception {
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (this.disableTheOUWhichIsOnlyAdmin) {
            this.disableTheOUWhichIsOnlyAdmin(rootNode);
        }
        List cuNodeList = this.getAllCUNodesUnderRootNode(rootNode);
        this.buildUnionGroupTreeInCU(cuNodeList);
        this.appendMaintainUnion(rootNode);
        if (this.isShowNameandNumber) {
            OrgF7Helper.displayNumberinTreeNode((DefaultKingdeeTreeNode)rootNode);
        }
        treeModel.setRoot((TreeNode)rootNode);
    }

    public boolean isShowNameandNumber() {
        return this.isShowNameandNumber;
    }

    public void setShowNameandNumber(boolean isShowNameandNumber) {
        this.isShowNameandNumber = isShowNameandNumber;
    }

    private List getAllCUNodesUnderRootNode(DefaultKingdeeTreeNode rootNode) {
        ArrayList<DefaultKingdeeTreeNode> cuNodeList = new ArrayList<DefaultKingdeeTreeNode>();
        DefaultKingdeeTreeNode node = null;
        FullOrgUnitInfo fullInfo = null;
        Enumeration enu = rootNode.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enu.nextElement();
            fullInfo = (FullOrgUnitInfo)node.getUserObject();
            if (fullInfo == null || !fullInfo.isIsCU()) continue;
            cuNodeList.add(node);
        }
        return cuNodeList;
    }

    private void buildUnionGroupTreeInCU(List cuNodeList) throws Exception {
        int i;
        if (cuNodeList == null || cuNodeList.size() == 0) {
            return;
        }
        HashSet<String> cuIdSet = new HashSet<String>();
        HashMap<String, DefaultKingdeeTreeNode> cuNodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i2 = 0; i2 < cuNodeList.size(); ++i2) {
            DefaultKingdeeTreeNode cuTreeNode = (DefaultKingdeeTreeNode)cuNodeList.get(i2);
            FullOrgUnitInfo cuInfo = (FullOrgUnitInfo)cuTreeNode.getUserObject();
            String cuId = cuInfo.getId().toString();
            cuIdSet.add(cuId);
            cuNodeMap.put(cuId, cuTreeNode);
        }
        IOrgStructure iStruct = OrgStructureFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("tree.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.*"));
        viewInfo.getSorter().add(new SorterItemInfo("tree.CU.id"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(8), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.CU.id", cuIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)UnionVersionStatusEnum.START, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)UnionVersionStatusEnum.ARCHIVE, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        viewInfo.setFilter(filter);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(viewInfo);
        ArrayList<OrgTreeInfo> unionRange = new ArrayList<OrgTreeInfo>();
        int n = structCol.size();
        for (int i3 = 0; i3 < n; ++i3) {
            OrgTreeInfo treeInfo = structCol.get(i3).getTree();
            if (unionRange.contains(treeInfo)) continue;
            unionRange.add(treeInfo);
        }
        OrgTreeInfo[] treeInfos = unionRange.toArray(new OrgTreeInfo[0]);
        this.sortTreeArray(treeInfos);
        unionRange.clear();
        for (i = 0; i < treeInfos.length; ++i) {
            unionRange.add(treeInfos[i]);
        }
        int n2 = unionRange.size();
        for (i = 0; i < n2; ++i) {
            OrgTreeInfo treeInfo = (OrgTreeInfo)unionRange.get(i);
            DefaultKingdeeTreeNode rangeNode = new DefaultKingdeeTreeNode();
            rangeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            rangeNode.setText(treeInfo.toString());
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)rangeNode);
            FullOrgUnitCollection unitCol = new FullOrgUnitCollection();
            int m = structCol.size();
            for (int j = 0; j < m; ++j) {
                OrgStructureInfo structInfo = structCol.get(j);
                if (!structInfo.getTree().equals((Object)treeInfo)) continue;
                FullOrgUnitInfo unitInfo = structInfo.getUnit();
                unitCol.add(unitInfo);
            }
            DefaultKingdeeTreeNode groupRoot = NewOrgViewHelper.buildTreeByOrgUnitCollection((AbstractObjectCollection)unitCol);
            this.setCustomImage(groupRoot);
            rangeNode.add((MutableTreeNode)groupRoot);
            DefaultKingdeeTreeNode cuTreeNode = (DefaultKingdeeTreeNode)cuNodeMap.get(treeInfo.getCU().getId().toString());
            cuTreeNode.add((MutableTreeNode)rangeNode);
        }
    }

    private Set getCuIdSet(DefaultKingdeeTreeNode rootNode) {
        List cuNodeList = this.getAllCUNodesUnderRootNode(rootNode);
        HashSet<String> cuIdSet = new HashSet<String>();
        for (int i = 0; i < cuNodeList.size(); ++i) {
            DefaultKingdeeTreeNode cuTreeNode = (DefaultKingdeeTreeNode)cuNodeList.get(i);
            FullOrgUnitInfo cuInfo = (FullOrgUnitInfo)cuTreeNode.getUserObject();
            String cuId = cuInfo.getId().toString();
            cuIdSet.add(cuId);
        }
        return cuIdSet;
    }

    private void appendMaintainUnion(DefaultKingdeeTreeNode rootNode) throws Exception {
        int i;
        if (!this.isDisplayMaintain()) {
            return;
        }
        IOrgStructure iStruct = OrgStructureFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("tree.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.*"));
        viewInfo.getSorter().add(new SorterItemInfo("tree.CU.id"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        Set cuIdSet = this.getCuIdSet(rootNode);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(8), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.maintainCU.id", (Object)cuIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("tree.CU.id", (Object)cuIdSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)UnionVersionStatusEnum.START, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)UnionVersionStatusEnum.ARCHIVE, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5)");
        viewInfo.setFilter(filter);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(viewInfo);
        ArrayList<OrgTreeInfo> unionRange = new ArrayList<OrgTreeInfo>();
        int n = structCol.size();
        for (int i2 = 0; i2 < n; ++i2) {
            OrgTreeInfo treeInfo = structCol.get(i2).getTree();
            if (unionRange.contains(treeInfo)) continue;
            unionRange.add(treeInfo);
        }
        OrgTreeInfo[] treeInfos = unionRange.toArray(new OrgTreeInfo[0]);
        this.sortTreeArray(treeInfos);
        unionRange.clear();
        for (i = 0; i < treeInfos.length; ++i) {
            unionRange.add(treeInfos[i]);
        }
        int n2 = unionRange.size();
        for (i = 0; i < n2; ++i) {
            OrgTreeInfo treeInfo = (OrgTreeInfo)unionRange.get(i);
            DefaultKingdeeTreeNode rangeNode = new DefaultKingdeeTreeNode();
            rangeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            rangeNode.setText(treeInfo.toString());
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)rangeNode);
            FullOrgUnitCollection unitCol = new FullOrgUnitCollection();
            int m = structCol.size();
            for (int j = 0; j < m; ++j) {
                OrgStructureInfo structInfo = structCol.get(j);
                if (!structInfo.getTree().equals((Object)treeInfo)) continue;
                FullOrgUnitInfo unitInfo = structInfo.getUnit();
                unitCol.add(unitInfo);
            }
            DefaultKingdeeTreeNode[] groupRoots = OUUnionF7.buildTreeByOrgUnitCollection((AbstractObjectCollection)unitCol);
            for (int j = 0; j < groupRoots.length; ++j) {
                this.setCustomImage(groupRoots[j]);
                rangeNode.add((MutableTreeNode)groupRoots[j]);
            }
            rootNode.add((MutableTreeNode)rangeNode);
        }
    }

    public static DefaultKingdeeTreeNode[] buildTreeByOrgUnitCollection(AbstractObjectCollection col) throws BOSException {
        if (col == null || col.size() == 0) {
            return new DefaultKingdeeTreeNode[0];
        }
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < col.size(); ++i) {
            OrgUnitInfo unitInfo = (OrgUnitInfo)col.getObject(i);
            OrgUnitInfo parentInfo = (OrgUnitInfo)unitInfo.get("parent");
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)unitInfo);
            if (parentInfo != null && nodeMap.containsKey(parentInfo.getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentInfo.getId().toString())).add((MutableTreeNode)node);
                continue;
            }
            nodeMap.put(unitInfo.getId().toString(), node);
        }
        Collection rootNodes = nodeMap.values();
        DefaultKingdeeTreeNode[] ret = new DefaultKingdeeTreeNode[rootNodes.size()];
        Iterator itr = rootNodes.iterator();
        int i = 0;
        while (itr.hasNext()) {
            ret[i] = (DefaultKingdeeTreeNode)itr.next();
            ++i;
        }
        return ret;
    }

    private void sortTreeArray(OrgTreeInfo[] treeInfos) {
        for (int i = 0; i < treeInfos.length - 1; ++i) {
            for (int j = i + 1; j < treeInfos.length; ++j) {
                OrgTreeInfo temp;
                if (treeInfos[i].getNumber() != null && treeInfos[i].getNumber().compareTo(treeInfos[j].getNumber()) > 0) {
                    temp = treeInfos[i];
                    treeInfos[i] = treeInfos[j];
                    treeInfos[j] = temp;
                    continue;
                }
                if (treeInfos[i].getNumber() == null || treeInfos[i].getStartDate() == null || treeInfos[i].getNumber().compareTo(treeInfos[j].getNumber()) != 0 || treeInfos[i].getStartDate().compareTo(treeInfos[j].getStartDate()) <= 0) continue;
                temp = treeInfos[i];
                treeInfos[i] = treeInfos[j];
                treeInfos[j] = temp;
            }
        }
    }

    public void setIsDisplayMaintain(boolean isDisplayMaintain) {
        this.isDisplayMaintain = isDisplayMaintain;
    }

    public boolean isDisplayMaintain() {
        return this.isDisplayMaintain;
    }

    private void disableTheOUWhichIsOnlyAdmin(DefaultKingdeeTreeNode root) {
        Enumeration enu = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        FullOrgUnitInfo fullInfo = null;
        boolean isOnlyAdmin = false;
        while (enu.hasMoreElements()) {
            OrgTypeHelper orgHelper;
            node = (DefaultKingdeeTreeNode)enu.nextElement();
            fullInfo = (FullOrgUnitInfo)node.getUserObject();
            if (fullInfo == null || !(isOnlyAdmin = (orgHelper = new OrgTypeHelper((OrgUnitInfo)fullInfo)).isOnlyThisOrgType(OrgType.Admin))) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    private void setCustomImage(DefaultKingdeeTreeNode root) {
        root.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.setCustomImage((DefaultKingdeeTreeNode)root.getChildAt(i));
        }
    }

    public void disableTheOUWhichIsOnlyAdmin() {
        this.disableTheOUWhichIsOnlyAdmin = true;
    }

    public OrgTypeForF7 getOrgTypeForF7() {
        return this.f7ui.getOrgTypeForF7();
    }
}

