/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.client.f7.F7AdaptorBuilderParam;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.IOUPartAdmin;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.AbstractPositionEditUI;
import com.kingdee.eas.basedata.org.client.JobPromptBox;
import com.kingdee.eas.basedata.org.client.PositionAdminOrgF7;
import com.kingdee.eas.basedata.org.client.PositionMainListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.context.f7.RegisterF7Param;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PositionEditUI
extends AbstractPositionEditUI {
    private static final Logger logger = Logger.getLogger(PositionEditUI.class);
    String resClass = "com.kingdee.eas.basedata.org.client.PositionResource.";
    protected MetaDataPK mainQueryPK;
    private PositionMainListUI listUI = null;

    @Override
    public void loadFields() {
        try {
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                PositionInfo pInfo = new PositionInfo();
                pInfo.setCU(this.getCurrentCU());
                pInfo.setAdminOrgUnit(this.editData.getAdminOrgUnit());
                String num = this.addCodingRule(this.txtNumber, (ObjectBaseInfo)pInfo, false);
                this.editData.setNumber(num);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.txtNumber.setText(this.editData.getNumber());
        super.loadFields();
        this.bizPromptJob.setValue((Object)this.editData.getJob());
        try {
            if (!OprtState.ADDNEW.equals(this.getOprtState())) {
                String rangeValue;
                IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                ObjectUuidPK pk = new ObjectUuidPK(this.editData.getAdminOrgUnit().getId());
                AdminOrgUnitInfo info = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)pk);
                this.bizPromptAdminOrgUnit.setValue((Object)info);
                PositionInfo respInfo = info.getResponPosition();
                if (respInfo != null && respInfo.getId().toString().equals(this.editData.getId().toString())) {
                    this.btnDefaultPosition.setSelected(true);
                } else {
                    this.btnDefaultPosition.setSelected(false);
                }
                this.bizPromptSuperPosition.setValue((Object)this.getParentPosition(this.editData));
                this.reloadPersonTable();
                if (this.btnDefaultPosition.isSelected() && "false".equalsIgnoreCase(rangeValue = ParamManager.getParamValue(null, (String)"isAllowNoPositionInDepartment"))) {
                    this.bizPromptAdminOrgUnit.setEnabled(false);
                    this.btnDefaultPosition.setEnabled(false);
                }
                if (this.bizPromptAdminOrgUnit.getData() != null) {
                    this.editData.setAdminOrgUnit((AdminOrgUnitInfo)this.bizPromptAdminOrgUnit.getData());
                }
                this.editData.setJob((JobInfo)this.bizPromptJob.getData());
                if (this.bizPromptSuperPosition.isEnabled()) {
                    this.editData.put("SuperPosition", (PositionInfo)this.bizPromptSuperPosition.getData());
                } else {
                    this.editData.put("SuperPosition", "Me");
                }
                this.editData.put("PrimaryPosition", this.btnDefaultPosition.isSelected());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    protected void btnDefaultPosition_actionPerformed(ActionEvent e) throws Exception {
        super.btnDefaultPosition_actionPerformed(e);
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "NOTICE_UPDATE_POSITION_HIERARCHY")));
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.bizPromptAdminOrgUnit.getData() != null) {
            this.editData.setAdminOrgUnit((AdminOrgUnitInfo)this.bizPromptAdminOrgUnit.getData());
        }
        this.editData.setJob((JobInfo)this.bizPromptJob.getData());
        if (this.bizPromptSuperPosition.isEnabled()) {
            this.editData.put("SuperPosition", (PositionInfo)this.bizPromptSuperPosition.getData());
        } else {
            this.editData.put("SuperPosition", "Me");
        }
        if (this.txtNumber.getText() != null) {
            this.editData.setNumber(this.txtNumber.getText().trim());
        }
        this.editData.put("PrimaryPosition", this.btnDefaultPosition.isSelected());
    }

    protected IObjectValue createNewData() {
        PositionInfo info = new PositionInfo();
        try {
            if (this.getUIContext().get("AdminOrgUnitInfo") != null) {
                AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.getUIContext().get("AdminOrgUnitInfo");
                if (this.bizPromptAdminOrgUnit.getData() == null) {
                    this.bizPromptAdminOrgUnit.setData((Object)adminInfo);
                    info.setAdminOrgUnit(adminInfo);
                } else {
                    info.setAdminOrgUnit((AdminOrgUnitInfo)this.bizPromptAdminOrgUnit.getData());
                }
                PositionInfo parentPositionInfo = this.getDefaultParentPosition(adminInfo);
                if (parentPositionInfo != null) {
                    this.bizPromptSuperPosition.setData((Object)parentPositionInfo);
                    info.put("SuperPosition", parentPositionInfo);
                    this.bizPromptSuperPosition.setEnabled(true);
                } else if (adminInfo.getParent() == null) {
                    this.bizPromptSuperPosition.setEnabled(false);
                    info.put("SuperPosition", "Me");
                }
            }
            this.bizPromptJob.setData(null);
            this.bizPromptAdminOrgUnit.setEnabled(true);
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();
            this.dateEffectDate.setValue((Object)date);
            info.setEffectDate(DateTimeUtils.truncateDate((Date)((Date)this.dateEffectDate.getValue(Date.class))));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return PositionFactory.getRemoteInstance();
    }

    private void initF7() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId()));
        evi.setFilter(filter);
        this.bizPromptJob.setSelector((KDPromptSelector)new JobPromptBox((IUIObject)this));
        this.bizPromptJob.setQueryInfo("com.kingdee.eas.basedata.org.app.JobQuery");
        this.bizPromptJob.setEditFormat("$number$");
        this.bizPromptJob.setCommitFormat("$number$");
        this.bizPromptJob.setDisplayFormat("$name$");
        this.bizPromptJob.setEntityViewInfo(evi);
        this.bizPromptJob.setHasCUDefaultFilter(false);
        RegisterF7Param f7Param = new RegisterF7Param(this.bizPromptSuperPosition, "com.kingdee.eas.basedata.org.app.PositionQuery4Fuzzy", OrgType.Admin);
        F7AdaptorBuilderParam f7AdaptorBuilderParam = new F7AdaptorBuilderParam("com.kingdee.eas.hr.base.client.f7.CustomizePositionF7AdaptorBuilder", new Class[]{IUIObject.class}, new Object[]{this});
        F7ContextInitializationHelper.initF7Context((RegisterF7Param)f7Param, (F7AdaptorBuilderParam)f7AdaptorBuilderParam);
        this.bizPromptSuperPosition.setHasCUDefaultFilter(false);
        this.bizPromptSuperPosition.setEditable(true);
        this.bizPromptAdminOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.bizPromptAdminOrgUnit.setCommitFormat("$number$");
        this.bizPromptAdminOrgUnit.setEditFormat("$number$");
        this.bizPromptAdminOrgUnit.setDisplayFormat("$name$");
        this.bizPromptAdminOrgUnit.setEntityViewInfo(evi);
        this.bizPromptAdminOrgUnit.setHasCUDefaultFilter(false);
        this.bizPromptAdminOrgUnit.setEditable(true);
        PositionAdminOrgF7 adminF7 = new PositionAdminOrgF7();
        adminF7.setNeedAddOrgRange(true);
        this.bizPromptAdminOrgUnit.setSelector((KDPromptSelector)adminF7);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
        this.tblPersonList.checkParsed();
        this.tblPersonList.getSelectManager().setSelectMode(2);
        this.tblPersonList.getStyleAttributes().setLocked(true);
        Calendar cal = Calendar.getInstance();
        cal.set(1900, 1, 1);
        this.dateEffectDate.setMinimumDate(cal.getTime());
        this.dateValiDate.setMinimumDate(cal.getTime());
        this.bizPromptSuperPosition.setEditable(true);
        if (this.editData.getJob() != null) {
            IJob iJob = JobFactory.getRemoteInstance();
            this.bizPromptJob.setValue((Object)iJob.getJobInfo((IObjectPK)new ObjectUuidPK(this.editData.getJob().getId())));
        }
        this.tblPersonList.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (PositionEditUI.this.tblPersonList.getRowCount() != 0) {
                    PositionEditUI.this.tblPersonList.getSelectManager().select(0, 0);
                }
            }
        });
        if (this.getUIContext().get("HierarchyID") != null) {
            this.btnEdit.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.btnCopy.setVisible(false);
            this.btnSubmit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.menuItemCopy.setVisible(false);
            this.menuItemSave.setVisible(false);
            this.menuItemSubmit.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
        this.isStartSHR();
        this.setNumberEditalbe();
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            PositionCollection collection = PositionFactory.getRemoteInstance().getPositionCollection();
            System.out.println(collection.size());
            if (collection == null || collection.size() <= 0) {
                this.bizPromptSuperPosition.setEnabled(false);
                System.out.println("bizPromptSuperPosition");
            }
            this.btnEdit.setEnabled(false);
        }
        if (this.oprtState.equals(OprtState.EDIT)) {
            this.setDeletedStatus();
            this.btnEdit.setEnabled(false);
        }
        if (this.oprtState.equals(OprtState.VIEW)) {
            this.setDeletedStatus();
        }
        if (this.getUIContext().get("listUI") != null) {
            this.listUI = (PositionMainListUI)((Object)this.getUIContext().get("listUI"));
        }
    }

    private void isStartSHR() {
        String fid = this.getRecentEditObjId();
        this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app.PositionQuery");
        EntityViewInfo result = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("POSITION.id", (Object)fid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.ISSTARTSHR", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        result.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(result);
        try {
            IRowSet rowSet = exec.executeQuery();
            if (rowSet.size() != 0) {
                this.menuItemAddNew.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.btnAddNew.setEnabled(false);
                this.btnEdit.setEnabled(false);
            } else {
                this.menuItemAddNew.setEnabled(true);
                this.menuItemEdit.setEnabled(true);
                this.btnAddNew.setEnabled(true);
                this.btnEdit.setEnabled(true);
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.getBizInterface().cancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.innerLoadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
        this.setDeletedStatus();
    }

    private void innerLoadFields() {
        this.setInnerLoadFields(true);
        this.loadFields();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.getBizInterface().cancelCancel((IObjectPK)pk, (CoreBaseInfo)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.innerLoadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
        this.setDeletedStatus();
    }

    private void reloadPersonTable() throws BOSException, EASBizException {
        this.positionOfPerson = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)this.editData.getId().toString()));
        this.positionOfPerson.setFilter(filter);
        this.tblPersonList.removeRows();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String orgId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        CodingRuleInfo codingRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, orgId);
        if (StringUtils.isEmpty((String)this.txtNumber.getText()) && (codingRuleInfo != null && codingRuleInfo.isIsAddView() || codingRuleInfo == null)) {
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (this.txtNumber.isEnabled() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (this.bizPromptAdminOrgUnit.getData() == null) {
            this.bizPromptAdminOrgUnit.requestFocusInWindow();
            throw new PositionException(PositionException.NOT_ADMINORGUNIT);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(2199, 11, 31);
        Date date = cal.getTime();
        if (this.dateEffectDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.dateEffectDate.getValue()), (Date)date) || this.dateValiDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.dateValiDate.getValue()), (Date)date)) {
            throw new OrgException(OrgException.DATE_ERROR_2199);
        }
        if (this.dateValiDate.getValue() != null && this.dateEffectDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.dateEffectDate.getValue()), (Date)((Date)this.dateValiDate.getValue()))) {
            this.dateEffectDate.requestFocusInWindow();
            throw new OrgException(OrgException.EFFECTDATE_NOT_INVALIDDATE);
        }
        if (this.bizPromptSuperPosition.isEnabled() && this.bizPromptSuperPosition.getValue() == null) {
            this.bizPromptSuperPosition.requestFocusInWindow();
            throw new PositionException(PositionException.NO_PARENT_POSITION);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("effectDate"));
        sic.add(new SelectorItemInfo("adminOrgUnit"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("job"));
        sic.add(new SelectorItemInfo("job.number"));
        sic.add(new SelectorItemInfo("job.name"));
        sic.add(new SelectorItemInfo("valiDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        return sic;
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.reloadPersonTable();
        this.setDeletedStatus();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.reloadPersonTable();
        this.setDeletedStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.reloadPersonTable();
        this.setDeletedStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.reloadPersonTable();
        this.setDeletedStatus();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.positionOfPerson = null;
        this.tblPersonList.removeRows();
    }

    protected void unLockUI() {
        super.unLockUI();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (this.btnDefaultPosition.isSelected()) {
                this.btnDefaultPosition.setEnabled(false);
                this.bizPromptAdminOrgUnit.setEnabled(false);
            } else {
                this.btnDefaultPosition.setEnabled(true);
                this.bizPromptAdminOrgUnit.setEnabled(true);
            }
        }
        this.setNumberEditalbe();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private OUPartAdminInfo getOUPartAdmin(AdminOrgUnitInfo info) throws Exception {
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("id"));
        selColl.add(new SelectorItemInfo("number"));
        selColl.add(new SelectorItemInfo("name"));
        selColl.add(new SelectorItemInfo("responPosition.id"));
        selColl.add(new SelectorItemInfo("responPosition.number"));
        selColl.add(new SelectorItemInfo("responPosition.name"));
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        IFullOrgUnit iFullUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo fullUnitInfo = iFullUnit.getFullOrgUnitInfo((IObjectPK)pk);
        IOUPartAdmin iOUPartAdmin = OUPartAdminFactory.getRemoteInstance();
        OUPartAdminInfo ouPartAdminInfo = fullUnitInfo.getPartAdmin();
        ouPartAdminInfo = iOUPartAdmin.getOUPartAdminInfo((IObjectPK)new ObjectUuidPK(ouPartAdminInfo.getId()), selColl);
        return ouPartAdminInfo;
    }

    private PositionInfo getDefaultParentPosition(AdminOrgUnitInfo adminInfo) throws Exception {
        OUPartAdminInfo parentAdminInfo = null;
        OUPartAdminInfo ouPartAdminInfo = this.getOUPartAdmin(adminInfo);
        if (adminInfo.getParent() != null) {
            parentAdminInfo = this.getOUPartAdmin(adminInfo.getParent());
        }
        PositionInfo positionInfo = null;
        if (ouPartAdminInfo.getResponPosition() == null) {
            String rangeValue;
            if (this.getOprtState().equals(OprtState.ADDNEW) && "false".equalsIgnoreCase(rangeValue = ParamManager.getParamValue(null, (String)"isAllowNoPositionInDepartment"))) {
                this.btnDefaultPosition.setSelected(true);
            }
            if (parentAdminInfo == null) {
                return null;
            }
            if (parentAdminInfo.getResponPosition() == null) {
                return null;
            }
            positionInfo = new PositionInfo();
            positionInfo.setId(parentAdminInfo.getResponPosition().getId());
            positionInfo.setName(parentAdminInfo.getResponPosition().getName());
            positionInfo.setNumber(parentAdminInfo.getResponPosition().getNumber());
            return positionInfo;
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnDefaultPosition.setSelected(false);
        }
        positionInfo = new PositionInfo();
        positionInfo.setId(ouPartAdminInfo.getResponPosition().getId());
        positionInfo.setName(ouPartAdminInfo.getResponPosition().getName());
        positionInfo.setNumber(ouPartAdminInfo.getResponPosition().getNumber());
        return positionInfo;
    }

    private PositionInfo getParentPosition(PositionInfo info) throws Exception {
        IPositionHierarchy iPH = PositionHierarchyFactory.getRemoteInstance();
        IHierarchy iHierarchy = HierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        FilterItemInfo filterItem2 = null;
        filterItem = new FilterItemInfo("child.id", (Object)info.getId().toString());
        filter.getFilterItems().add(filterItem);
        filterItem2 = this.getUIContext().get("HierarchyID") != null ? new FilterItemInfo("hierarchy.id", (Object)this.getUIContext().get("HierarchyID").toString()) : new FilterItemInfo("hierarchy.id", (Object)iHierarchy.getDefaultHierarchy().getId().toString());
        filter.getFilterItems().add(filterItem2);
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("parent.id"));
        evi.getSelector().add(new SelectorItemInfo("parent.number"));
        evi.getSelector().add(new SelectorItemInfo("parent.name"));
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(evi);
        PositionInfo pInfo = new PositionInfo();
        if (phColl.size() > 0) {
            pInfo = phColl.get(0).getParent();
        }
        return pInfo;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.bizPromptSuperPosition.setEnabled(true);
        this.bizPromptAdminOrgUnit.setEnabled(true);
        this.btnDefaultPosition.setSelected(false);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.getUIContext().get("AdminOrgUnitInfo");
        request.put("adminInfo", (Object)adminInfo);
        request.put("HierarchyID", this.getUIContext().get("HierarchyID"));
        return handler;
    }

    private void setNumberEditalbe() {
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            try {
                this.txtNumber.setEnabled(this.isModifiable((IObjectValue)this.editData, null));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected boolean isModifiable(IObjectValue bizObject, String orgID) throws BOSException, EASBizException {
        boolean isExistRule;
        if (bizObject == null) {
            return true;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (StringUtils.isEmpty((String)orgID)) {
            orgID = iCodingRuleManager.getCurrentAppOUID(bizObject);
        }
        if (orgID != null && (isExistRule = iCodingRuleManager.isExist(bizObject, orgID))) {
            return iCodingRuleManager.isModifiable(bizObject, orgID);
        }
        return true;
    }

    private String addCodingRule(Object txtNumber, ObjectBaseInfo bgTpInfo, boolean isModify) throws EASBizException, BOSException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String cu = this.getCurrentCU().getId().toString();
        if (this.editData.getAdminOrgUnit() != null) {
            ObjectUuidPK pk2 = new ObjectUuidPK(this.editData.getAdminOrgUnit().getId());
            IFullOrgUnit iFullUnit = FullOrgUnitFactory.getRemoteInstance();
            FullOrgUnitInfo fullUnitInfo = iFullUnit.getFullOrgUnitInfo((IObjectPK)pk2);
            cu = fullUnitInfo.getCU().getId().toString();
        }
        try {
            if (iCodingRuleManager.isExist((IObjectValue)bgTpInfo, cu)) {
                if (isModify) {
                    return null;
                }
                if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)bgTpInfo, cu)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)bgTpInfo, cu)) {
                        number = iCodingRuleManager.readNumber((IObjectValue)bgTpInfo, cu);
                    }
                } else if (iCodingRuleManager.isAddView((IObjectValue)bgTpInfo, cu)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)bgTpInfo, cu);
                }
                if (iCodingRuleManager.isModifiable((IObjectValue)bgTpInfo, cu)) {
                    if (txtNumber instanceof KDTextField) {
                        ((KDTextField)txtNumber).setEnabled(true);
                    } else {
                        ((KDFilterTextField)txtNumber).setEnabled(true);
                    }
                } else if (txtNumber instanceof KDTextField) {
                    ((KDTextField)txtNumber).setEnabled(false);
                } else {
                    ((KDFilterTextField)txtNumber).setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit) != null) {
            return (CtrlUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit);
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String tempOprState = this.getOprtState();
        this.setSave(false);
        this.setOprtState("EDIT");
        this.unLockUI();
        IObjectValue val = (IObjectValue)this.getUIContext().get("CURRENT.VO");
        this.getUIContext().put("CURRENT.VO", null);
        try {
            this.setDataObject(val);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            this.getUIContext().put("CURRENT.VO", val);
            throw ex;
        }
        this.showMessageForStatus();
        this.initDataStatus();
        this.setDefaultFocused();
        this.setDeletedStatus();
        this.bizPromptSuperPosition.setEditable(true);
    }

    public void setDeletedStatus() throws Exception {
        if (!DeletedStatusEnum.NORMAL.equals((Object)this.editData.getDeletedStatus())) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        } else {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        }
    }
}

