/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.TreePath;

public class HRBaseCommonUtil {
    public static String EARLIEST_EFFDT = "1900-01-01";
    public static final String CHANGEENDDATE = "2199-12-31";
    public static final String IS_FROM_SHR_OPTAction = "IS_FROM_SHR_OPTAction";
    public static final String IS_FROM_SHR_OPT_CURD = "IS_FROM_SHR_OPT_CURD";
    private static Boolean IS_SHRSYSTEM_UPDATE = null;
    public static final String CUSET = "cuset";
    private static Color disableColor = Color.GRAY;

    public static void trimNameAndNumberSpaceOfObjectInfo(DataBaseInfo info) {
        if (!StringUtils.isEmpty((String)info.getName())) {
            info.setName(info.getName().trim());
        }
        if (!StringUtils.isEmpty((String)info.getNumber())) {
            info.setNumber(info.getNumber().trim());
        }
    }

    public static boolean isNotFromSHROperation(CoreBaseInfo info) {
        return info.get(IS_FROM_SHR_OPTAction) == null;
    }

    public static java.util.Date getMaxEndDate() {
        try {
            return DateTimeUtils.parseDate((String)CHANGEENDDATE);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date getMinEffdtDate() {
        try {
            return DateTimeUtils.parseDate((String)EARLIEST_EFFDT);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date getEarliestAdminOrgEFFDT(Context ctx, String objId) throws BOSException {
        return HRBaseCommonUtil.getEarliestEFFDT(ctx, "t_org_adminHis", objId);
    }

    public static java.util.Date getEarliestPositionEFFDT(Context ctx, String objId) throws BOSException {
        return HRBaseCommonUtil.getEarliestEFFDT(ctx, "t_org_PositionHis", objId);
    }

    public static java.util.Date getEarliestEFFDT(Context ctx, String table, String objId) throws BOSException {
        Date effdt = null;
        String sql = "select top 1 FEFFDT from " + table + " where FHistoryRelateID='" + objId + "' order by FEFFDT ASC";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                effdt = rs.getDate("FEFFDT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return effdt;
    }

    public static boolean isBeginToUseSHR(Context ctx) throws BOSException {
        boolean isStartSHR = false;
        if (IS_SHRSYSTEM_UPDATE == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from t_hr_hrinit where FKEY = 'IS_SHRSYSTEM_UPDATE'");
            try {
                if (rs.next()) {
                    isStartSHR = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isStartSHR;
    }

    public static boolean isTreeNodeDisable(DefaultKingdeeTreeNode treeNode) {
        if (treeNode.getTextColor() == null) {
            return true;
        }
        return disableColor.equals(treeNode.getTextColor());
    }

    public static TreePath[] getSelectTreePaths(KDTree tree) {
        int i;
        TreePath[] paths = tree.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        boolean flag = true;
        int size = paths.length;
        for (i = 0; i < size; ++i) {
            flag = true;
            for (int t = 0; t < paths.length; ++t) {
                if (paths[i] == paths[t] || !paths[t].isDescendant(paths[i])) continue;
                flag = false;
            }
            if (!flag) continue;
            list.add(paths[i]);
        }
        paths = new TreePath[list.size()];
        size = list.size();
        for (i = 0; i < size; ++i) {
            paths[i] = (TreePath)list.get(i);
        }
        return paths;
    }

    public static FilterInfo getS4FilterByMulCu(String cuNumber, Set cuSet) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (cuSet == null || cuSet.size() == 0) {
            CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
            filter.getFilterItems().add(new FilterItemInfo(cuNumber, (Object)HRBaseCommonUtil.getParentOneCU(cu, new HashSet()), CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(cuNumber, (Object)HRBaseCommonUtil.getParentCU(cuSet), CompareType.INCLUDE));
        }
        return filter;
    }

    public static Set getParentCU(Set cuSet) throws EASBizException, BOSException {
        HashSet set = new HashSet();
        if (cuSet == null || cuSet.size() == 0) {
            HRBaseCommonUtil.getParentOneCU(SysContext.getSysContext().getCurrentCtrlUnit(), set);
            return set;
        }
        Iterator it = cuSet.iterator();
        CtrlUnitInfo ctrlUnitInfo = null;
        Object ob = null;
        while (it.hasNext()) {
            ob = it.next();
            ctrlUnitInfo = ob instanceof CtrlUnitInfo ? (CtrlUnitInfo)ob : CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK((String)ob));
            HRBaseCommonUtil.getParentOneCU(ctrlUnitInfo, set);
        }
        return set;
    }

    public static Set getParentOneCU(CtrlUnitInfo ctrlUnitInfo, Set set) {
        if (ctrlUnitInfo.getLongNumber() != null) {
            if (ctrlUnitInfo.getLongNumber().indexOf("!") == -1) {
                set.add(ctrlUnitInfo.getLongNumber());
            } else {
                String[] longNumberArgus = ctrlUnitInfo.getLongNumber().split("!");
                for (int i = 0; i < longNumberArgus.length; ++i) {
                    if (longNumberArgus[i] == null || longNumberArgus[i].length() <= 0) continue;
                    set.add(longNumberArgus[i]);
                }
            }
        }
        return set;
    }

    public static void updateInfoState(Context ctx, String id, String StateField, int state) throws BOSException {
        IMetaDataLoader metaData = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String tableName = metaData.getEntity(BOSUuid.read((String)id).getType()).getTable().getName();
        String sql = "UPDATE " + tableName + " SET " + StateField + "=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            pstmt = con.prepareStatement(sql);
            pstmt.setInt(1, state);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }
}

