/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;

public class PersonClientUtils {
    public static void setPersonNumbers(PersonInfo info, KDFilterTextField txtNumber) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCurCompany = iCodingRuleManager.getCurrentAppOUID((IObjectValue)info);
        String number = null;
        if (strCurCompany == null || strCurCompany.equals("")) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)info, strCurCompany)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, strCurCompany)) {
                if (iCodingRuleManager.isAddView((IObjectValue)info, strCurCompany)) {
                    number = iCodingRuleManager.readNumber((IObjectValue)info, strCurCompany);
                }
            } else if (iCodingRuleManager.isAddView((IObjectValue)info, strCurCompany)) {
                number = PersonFacadeFactory.getRemoteInstance().getNewNumber(strCurCompany);
            }
            if (iCodingRuleManager.isModifiable((IObjectValue)info, strCurCompany)) {
                txtNumber.setEnabled(true);
            } else {
                txtNumber.setEnabled(false);
            }
        } else {
            txtNumber.setEnabled(true);
        }
        info.setNumber(number);
    }

    public static boolean isStartSHR() throws EASBizException, BOSException {
        boolean isStartSHR = false;
        OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (unitInfo != null && unitInfo.isIsAdminOrgUnit()) {
            isStartSHR = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId())).isIsStartSHR();
        }
        return isStartSHR;
    }

    public static boolean isStartSHR(PositionInfo positionInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        PositionInfo info = new PositionInfo();
        info = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(positionInfo.getId()), sic);
        AdminOrgUnitInfo positionAdmin = info.getAdminOrgUnit();
        return positionAdmin.isIsStartSHR();
    }

    public static boolean isStartSHRByPositionId(String positionId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)positionId)) {
            return false;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        PositionInfo info = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(positionId), sic);
        AdminOrgUnitInfo positionAdmin = info.getAdminOrgUnit();
        return positionAdmin.isIsStartSHR();
    }

    public static boolean isStartSHRByAdminorgUnitId(String adminId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)adminId)) {
            return false;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        AdminOrgUnitInfo info = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId), sic);
        return info.isIsStartSHR();
    }
}

