/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class PersonF7UIHelper {
    private static String oldDSessionId = null;
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon positionIcon = EASResource.getIcon((String)"imgTree_position");

    public static DefaultKingdeeTreeNode createBizOrgRangeAdminTreeNode(boolean showHidden, boolean reBuild, boolean isAllOrg, int fromType, int toType, Set bizOrgIds) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" INNER JOIN T_ORG_UnitRelation unitRelation ON unitRelation.FFromUnitID = org.FID ");
        sql.append(" INNER JOIN T_ORG_TypeRelation relationType on unitRelation.FTypeRelationID = relationType.FID ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        sql.append(" and relationType.FFromType = ").append(fromType);
        sql.append(" and relationType.FToType = ").append(toType);
        sql.append(" and unitRelation.FToUnitID IN");
        sql.append("(");
        if (isAllOrg) {
            sql.append(PersonF7UIHelper.getAllRangeBizOrgSql(toType));
        } else {
            Iterator iter = bizOrgIds.iterator();
            while (iter.hasNext()) {
                sql.append("'").append(iter.next()).append("'");
                if (!iter.hasNext()) continue;
                sql.append(",");
            }
        }
        sql.append(")");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        if (!showHidden) {
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        rootNode = PersonF7UIHelper.buildTreeNodeByRowSet(rows, false);
        return rootNode;
    }

    public static DefaultKingdeeTreeNode createUserRangeAdminTreeNode(boolean showHidden, boolean reBuild) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        if (!showHidden) {
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        rootNode = PersonF7UIHelper.buildTreeNodeByRowSet(rows, false);
        return rootNode;
    }

    public static DefaultKingdeeTreeNode createUserPermissionRangeAdminTreeNode(boolean showHidden, boolean reBuild) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ADMINORG.FID FROM T_PM_User AS PMUSER ");
        sql.append(" INNER JOIN t_pm_orgrangeIncludeSuborg AS ORGRANGE ON PMUSER.FID=ORGRANGE.FUSERID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS ADMINORG ON ORGRANGE.FORGID = ADMINORG.FCONTROLUNITID ");
        sql.append(" WHERE ( ORGRANGE.FTYPE = 10 OR ORGRANGE.FTYPE = 30 AND PMUSER.FTYPE <> 10 ) ");
        sql.append(" AND  PMUSER.FID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        if (!showHidden) {
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        rootNode = PersonF7UIHelper.buildTreeNodeByRowSetWithoutCreateDefaultNode(rows, true);
        return rootNode;
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSetWithoutCreateDefaultNode(IRowSet rows, boolean includeChildCU) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        KDTreeNode subTreeNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        AdminOrgUnitInfo adminInfo = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet rows1 = queryExcu.executeQuery();
        rows1.next();
        adminInfo = PersonF7UIHelper.createAdminUnitInfo(rows1);
        rootTreeNode = new KDTreeNode((Object)adminInfo);
        rootTreeNode.setCustomIcon(groupIcon);
        nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
        if (includeChildCU) {
            // empty if block
        }
        while (rows.next()) {
            adminInfo = PersonF7UIHelper.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            if (adminInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) continue;
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                if (nodeMap.containsKey(adminInfo.getId().toString())) {
                    subTreeNode = (DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getId().toString());
                    subTreeNode.setCustomIcon(companyIcon);
                    continue;
                }
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                nodeMap.put(adminInfo.getId().toString(), subTreeNode);
                continue;
            }
            ISQLExecutor sqlExcu = SQLExecutorFactory.getRemoteInstance((String)PersonF7UIHelper.getLongnumberSplitStringSQL(adminInfo.getLongNumber()));
            IRowSet rows2 = sqlExcu.executeSQL();
            while (rows2.next()) {
                AdminOrgUnitInfo adminInfo1 = PersonF7UIHelper.createAdminUnitInfo(rows2);
                subTreeNode = new KDTreeNode((Object)adminInfo1);
                if (adminInfo1.getId().toString().equals(adminInfo.getId().toString())) {
                    subTreeNode.setCustomIcon(companyIcon);
                }
                if (nodeMap.containsKey(adminInfo1.getId().toString())) continue;
                if (nodeMap.get(adminInfo1.getParent().getId().toString()) == null) {
                    throw new Exception("buildTreeError:" + adminInfo.getLongNumber() + " isError!");
                }
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo1.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                nodeMap.put(adminInfo1.getId().toString(), subTreeNode);
            }
        }
        return rootTreeNode;
    }

    private static String getLongnumberSplitStringSQL(String longnumberStr) {
        String[] longnumber = longnumberStr.split("!");
        StringBuilder sqlLongnumber = new StringBuilder();
        sqlLongnumber.append("select fid \"id\",fname_l2 \"name\",fnumber \"number\",flongnumber \"longnumber\",flevel \"level\",findex \"index\",fisleaf \"isleaf\",fparentID \"parent.id\" from t_org_admin ");
        sqlLongnumber.append(" where flongnumber in ( '");
        int nums = longnumber.length - 1;
        for (int i = 0; i < nums; ++i) {
            sqlLongnumber.append(longnumber[i]).append("','");
            longnumber[i + 1] = longnumber[i] + "!" + longnumber[i + 1];
        }
        sqlLongnumber.append(longnumber[longnumber.length - 1]).append("') order by flongnumber asc ");
        return sqlLongnumber.toString();
    }

    public static DefaultKingdeeTreeNode createUserAndCuRangeAdminTreeNode(boolean showHidden, boolean reBuild, String cuId) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        if (cuId == null || cuId.trim().length() < 1) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" INNER JOIN T_ORG_CtrlUnit cu on org.FControlUnitId = cu.FId ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and cu.Fid = '").append(cuId).append("'");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        if (!showHidden) {
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        rootNode = PersonF7UIHelper.buildTreeNodeByRowSet(rows, false);
        return rootNode;
    }

    public static DefaultKingdeeTreeNode createUserAndCuRangeAdminTreeNode(boolean showHidden, boolean reBuild, CtrlUnitInfo[] cus) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        if (cus == null || cus.length < 1) {
            return PersonF7UIHelper.createUserAndCuRangeAdminTreeNode(showHidden, reBuild, "");
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer cuIdSet = new StringBuffer();
        cuIdSet.append("''");
        for (int i = 0; i < cus.length; ++i) {
            CtrlUnitInfo cuInfo = cus[i];
            cuIdSet.append(",'").append(cuInfo.getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" INNER JOIN T_ORG_CtrlUnit cu on org.FControlUnitId = cu.FId ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and cu.Fid in(").append(cuIdSet).append(")");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        if (!showHidden) {
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet rows = queryExcu.executeQuery();
        rootNode = PersonF7UIHelper.buildTreeNodeByRowSet(rows, false);
        return rootNode;
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSet(IRowSet rows, boolean includeChildCU) throws Exception {
        if (rows == null) {
            return null;
        }
        ArrayList<String> adminList = new ArrayList<String>();
        while (rows.next()) {
            adminList.add(rows.getString("LongNumber"));
        }
        String rootLongNumber = PersonF7UIHelper.getRootAdminLongNumber(adminList);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("LongNumber", (Object)rootLongNumber, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("LongNumber", (Object)(rootLongNumber + "!%"), CompareType.LIKE));
        fi.setMaskString("#0 or #1");
        evi.setFilter(fi);
        queryExcu.setObjectView(evi);
        IRowSet allAdminIRowSet = queryExcu.executeQuery();
        AdminOrgUnitInfo adminInfo = null;
        KDTreeNode rootTreeNode = null;
        KDTreeNode subTreeNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        block1: while (allAdminIRowSet.next()) {
            adminInfo = PersonF7UIHelper.createAdminUnitInfo(allAdminIRowSet);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                if (!adminList.contains(adminInfo.getLongNumber())) {
                    HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)rootTreeNode);
                }
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminList.contains(adminInfo.getLongNumber())) {
                if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                } else {
                    rootTreeNode.add((MutableTreeNode)subTreeNode);
                }
                nodeMap.put(adminInfo.getId().toString(), subTreeNode);
                continue;
            }
            for (int t = 0; t < adminList.size(); ++t) {
                if (adminList.get(t).toString().indexOf(adminInfo.getLongNumber() + "!") <= -1) continue;
                HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)subTreeNode);
                if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                } else {
                    rootTreeNode.add((MutableTreeNode)subTreeNode);
                }
                nodeMap.put(adminInfo.getId().toString(), subTreeNode);
                continue block1;
            }
        }
        return rootTreeNode;
    }

    private static String getRootAdminLongNumber(ArrayList adminList) {
        if (adminList == null || adminList.size() == 0) {
            return null;
        }
        String longNumber = adminList.get(0).toString();
        for (int i = 1; i < adminList.size(); ++i) {
            for (int count = 0; adminList.get(i).toString().indexOf(longNumber) == -1 && count < 20; ++count) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
        }
        return longNumber;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    public static String getBizOrgAndAdminOrgRangeSql(boolean isAllOrg, int fromType, int toType, Set bizOrgIds) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" INNER JOIN T_ORG_UnitRelation unitRelation ON unitRelation.FFromUnitID = org.FID ");
        sql.append(" INNER JOIN T_ORG_TypeRelation relationType on unitRelation.FTypeRelationID = relationType.FID ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        sql.append(" and relationType.FFromType = ").append(fromType);
        sql.append(" and relationType.FToType = ").append(toType);
        sql.append(" and unitRelation.FToUnitID IN");
        sql.append("(");
        if (isAllOrg) {
            sql.append(PersonF7UIHelper.getAllRangeBizOrgSql(toType));
        } else {
            Iterator iter = bizOrgIds.iterator();
            while (iter.hasNext()) {
                sql.append("'").append(iter.next()).append("'");
                if (!iter.hasNext()) continue;
                sql.append(",");
            }
        }
        sql.append(")");
        sql.append(" ");
        return sql.toString();
    }

    public static String getUserRangeAdminOrgSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        sql.append(" ");
        return sql.toString();
    }

    public static String getUserAndCuRangeAdminOrgSql(String cuId) {
        if (cuId == null || cuId.trim().length() < 1) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" INNER JOIN T_ORG_CtrlUnit cu on org.FControlUnitId = cu.FId ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and cu.FId = '").append(cuId).append("'");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        sql.append(" ");
        return sql.toString();
    }

    public static String getUserAndCuRangeAdminOrgSql(CtrlUnitInfo[] cus) {
        if (cus == null || cus.length == 0) {
            return PersonF7UIHelper.getUserAndCuRangeAdminOrgSql("");
        }
        StringBuffer cuIdSet = new StringBuffer();
        cuIdSet.append("''");
        for (int i = 0; i < cus.length; ++i) {
            CtrlUnitInfo cuInfo = cus[i];
            cuIdSet.append(",'").append(cuInfo.getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.FId from T_ORG_Admin org ");
        sql.append(" INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID ");
        sql.append(" INNER JOIN T_ORG_CtrlUnit cu on org.FControlUnitId = cu.FId ");
        sql.append(" WHERE orgRange.FType = 20 ");
        sql.append(" and cu.FId in( ").append(cuIdSet).append(")");
        sql.append(" and orgRange.FUserID= '").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        sql.append(" ");
        return sql.toString();
    }

    private static String getAllRangeBizOrgSql(int orgType) {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select unit.FId from T_ORG_BaseUnit unit ");
        sql.append(" inner join T_PM_OrgRange orgRange on orgRange.FOrgID = unit.FId ");
        sql.append(" where orgRange.FUserID = '").append(userId).append("'");
        sql.append(" and orgRange.FType = ").append(10);
        String colName = null;
        switch (orgType) {
            case 1: {
                colName = "FIsCompanyOrgUnit";
                break;
            }
            case 16: {
                colName = "FIsHROrgUnit";
                break;
            }
            case 3: {
                colName = "FIsPurchaseOrgUnit";
                break;
            }
            case 4: {
                colName = "FIsStorageOrgUnit";
                break;
            }
            case 2: {
                colName = "FIsSaleOrgUnit";
                break;
            }
            case 6: {
                colName = "FIsProfitOrgUnit";
                break;
            }
            case 5: {
                colName = "FIsCostOrgUnit";
                break;
            }
            case 24: {
                colName = "FIsTransportOrgUnit";
                break;
            }
            case 32: {
                colName = "FIsQualityOrgUnit";
                break;
            }
            case 8: {
                colName = "FIsUnion";
                break;
            }
            case 0: {
                colName = "FIsAdminOrgUnit";
                break;
            }
            default: {
                colName = null;
            }
        }
        if (colName != null) {
            sql.append(" and unit.").append(colName).append("=1 ");
        }
        sql.append(" ");
        return sql.toString();
    }
}

