/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.client.tree;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.OrgTreeBuilder;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class NewOrgTreeHelper {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    private static HashMap nodeCache = new HashMap();
    private static HashMap nodeCache2 = null;
    private static HashMap nodeCache3 = null;
    private static boolean rebuildTree = false;
    private static String oldDSessionId = null;

    public static boolean isRebuildTree() {
        return rebuildTree;
    }

    public static void setRebuildTree(boolean rebuildTree) {
        NewOrgTreeHelper.rebuildTree = rebuildTree;
    }

    public static DefaultKingdeeTreeNode createAllAdminTreeNode() throws Exception {
        return NewOrgTreeHelper.createAllAdminTreeNode(false);
    }

    public static DefaultKingdeeTreeNode createAllAdminTreeNode(boolean includeSealUp) throws Exception {
        return NewOrgTreeHelper.createAllAdminTreeNode(true, false, includeSealUp);
    }

    public static DefaultKingdeeTreeNode createAllAdminTreeNodeRefresh(boolean reBuild, boolean includeSealUp) throws Exception {
        return NewOrgTreeHelper.createAllAdminTreeNode(true, reBuild, includeSealUp);
    }

    public static DefaultKingdeeTreeNode createAllAdminTreeNode(boolean showHidden, boolean reBuild) throws Exception {
        return NewOrgTreeHelper.createAllAdminTreeNode(showHidden, reBuild, true);
    }

    public static DefaultKingdeeTreeNode createAllAdminTreeNode(boolean showHidden, boolean reBuild, boolean includeSealUp) throws Exception {
        return NewOrgTreeHelper.createAllAdminTreeNode(showHidden, reBuild, includeSealUp, true);
    }

    public static DefaultKingdeeTreeNode createAllAdminTreeNode(boolean showHidden, boolean reBuild, boolean includeSealUp, boolean showVirtualOrg) throws Exception {
        if (nodeCache2 == null) {
            nodeCache2 = new HashMap();
        }
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache2.clear();
        }
        String key = oldDSessionId + includeSealUp + showVirtualOrg;
        DefaultKingdeeTreeNode rootNode = null;
        if (nodeCache2.get(key) != null && !reBuild) {
            rootNode = (DefaultKingdeeTreeNode)nodeCache2.get(key);
        } else {
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.NewAdminTreeQuery");
            IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            FilterInfo fi = null;
            if (!showHidden) {
                boolean isNew = false;
                if (fi == null) {
                    fi = new FilterInfo();
                    isNew = true;
                }
                fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
                fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
                if (isNew) {
                    fi.setMaskString("#0 or #1");
                } else {
                    fi.setMaskString("#0 and (#1 or #2)");
                }
            }
            if (!showVirtualOrg) {
                fi = new FilterInfo();
                FilterInfo isVirtualFilter = new FilterInfo("isVirtual = 0");
                fi.mergeFilter(isVirtualFilter, "and");
            }
            if (fi != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(fi);
                queryExcu.setObjectView(viewInfo);
            }
            IRowSet rows = null;
            if (includeSealUp) {
                String sql = queryExcu.getSQL();
                sql = sql.replaceAll("\"ADMINORGUNIT\".FIsSealUp", "0");
                ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
                rows = iSql.executeSQL();
            } else {
                rows = queryExcu.executeQuery();
            }
            rootNode = NewOrgTreeHelper.buildTreeNodeByRowSet(rows, false);
            nodeCache2.put(key, rootNode);
        }
        return rootNode;
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNode(cuID, null);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID, boolean includeSealUp) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNode(cuID, null, false, false, includeSealUp);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID, AdminOrgUnitInfo rootInfo) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNode(cuID, rootInfo, false);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID, AdminOrgUnitInfo rootInfo, boolean includeChildCU) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNode(cuID, rootInfo, includeChildCU, false);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID, AdminOrgUnitInfo rootInfo, boolean includeChildCU, boolean reBuild) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNode(cuID, rootInfo, includeChildCU, reBuild, false);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID, AdminOrgUnitInfo rootInfo, boolean includeChildCU, boolean reBuild, boolean includeSealUp) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNode(cuID, rootInfo, includeChildCU, reBuild, includeSealUp, true);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNode(String cuID, AdminOrgUnitInfo rootInfo, boolean includeChildCU, boolean reBuild, boolean includeSealUp, boolean showVirtualOrg) throws Exception {
        if (cuID == null) {
            CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            cuID = cuInfo.getId().toString();
        }
        String adminId = null;
        adminId = rootInfo == null ? "null" : rootInfo.getId().toString();
        if (nodeCache3 == null) {
            nodeCache3 = new HashMap();
        }
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache3.clear();
        }
        DefaultKingdeeTreeNode rootNode = null;
        if (nodeCache3.get(oldDSessionId + cuID + adminId + includeChildCU) != null && !reBuild) {
            rootNode = (DefaultKingdeeTreeNode)nodeCache3.get(oldDSessionId + cuID + adminId + includeChildCU);
        } else {
            IRowSet rows = NewOrgTreeHelper.getAdminRowSet(cuID, rootInfo, includeChildCU, includeSealUp, showVirtualOrg);
            rootNode = NewOrgTreeHelper.buildTreeNodeByRowSet(rows, includeChildCU);
            nodeCache3.put(oldDSessionId + cuID + adminId + includeChildCU, rootNode);
        }
        return rootNode;
    }

    private static IRowSet getAdminRowSet(String cuID, AdminOrgUnitInfo rootInfo, boolean includeChildCU, boolean includeSealUp, boolean showVirtualOrg) throws Exception {
        boolean reValue = HRParamUtil.getParamOfHR(null, (String)"TASKARRANGE_001", null);
        int userType = SysContext.getSysContext().getCurrentUserInfo().getType().getValue();
        if (userType == 10) {
            reValue = true;
        }
        if (!reValue) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            if (rootInfo != null) {
                fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
                fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
                if (includeChildCU) {
                    fi.setMaskString("#0 or #1");
                } else if (cuID != null) {
                    fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
                    fi.setMaskString("(#0 or #1) and #2");
                }
            } else if (includeChildCU) {
                CtrlUnitInfo cuInfo = null;
                cuInfo = cuID == null ? SysContext.getSysContext().getCurrentCtrlUnit() : CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuID)));
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)cuInfo.getLongNumber()));
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)(cuInfo.getLongNumber() + "!%"), CompareType.LIKE));
                fi.setMaskString("#0 or #1 ");
            }
            if (!showVirtualOrg) {
                FilterInfo isVirtualFilter = new FilterInfo("isVirtual = 0");
                fi.mergeFilter(isVirtualFilter, "and");
            }
            String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            FilterInfo isCuFilter = new FilterInfo();
            isCuFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userid));
            fi.mergeFilter(isCuFilter, "and");
            FilterInfo isOrgType = new FilterInfo();
            isOrgType.getFilterItems().add(new FilterItemInfo("orgRange.type", (Object)20));
            fi.mergeFilter(isOrgType, "and");
            viewInfo.setFilter(fi);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewOrgTreeQuery");
            IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            queryExcu.setObjectView(viewInfo);
            return queryExcu.executeQuery();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            if (includeChildCU) {
                fi.setMaskString("#0 or #1");
            } else if (cuID != null) {
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
                fi.setMaskString("(#0 or #1) and #2");
            }
        } else if (includeChildCU) {
            CtrlUnitInfo cuInfo = null;
            cuInfo = cuID == null ? SysContext.getSysContext().getCurrentCtrlUnit() : CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuID)));
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)cuInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.longNumber", (Object)(cuInfo.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 or #1 ");
        } else {
            fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
        }
        if (!includeSealUp) {
            FilterInfo sealUpFi = new FilterInfo();
            sealUpFi.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE));
            fi.mergeFilter(sealUpFi, "and");
        }
        if (!showVirtualOrg) {
            FilterInfo isVirtualFilter = new FilterInfo("isVirtual = 0");
            fi.mergeFilter(isVirtualFilter, "and");
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSet(IRowSet rows, boolean includeChildCU) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        KDTreeNode subTreeNode = null;
        HashMap nodeMap = new HashMap();
        AdminOrgUnitInfo rowsAdminInfo = null;
        if (includeChildCU) {
            // empty if block
        }
        ArrayList<AdminOrgUnitInfo> allAdminInfo = new ArrayList<AdminOrgUnitInfo>();
        while (rows.next()) {
            rowsAdminInfo = NewOrgTreeHelper.createAdminUnitInfo(rows);
            allAdminInfo.add(rowsAdminInfo);
        }
        for (int i = 0; i < allAdminInfo.size(); ++i) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)allAdminInfo.get(i);
            if (rootTreeNode == null) {
                AdminOrgUnitInfo adminInfoRoot = NewOrgTreeHelper.getRootAdmin(allAdminInfo);
                if (adminInfoRoot.getId().equals((Object)adminInfo.getId())) {
                    rootTreeNode = new KDTreeNode((Object)adminInfo);
                    rootTreeNode.setCustomIcon(groupIcon);
                    nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                    continue;
                }
                rootTreeNode = new KDTreeNode((Object)adminInfoRoot);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminInfoRoot.getId().toString(), rootTreeNode);
                HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)rootTreeNode);
                subTreeNode = new KDTreeNode((Object)adminInfo);
                subTreeNode.setCustomIcon(companyIcon);
                if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                    nodeMap.put(adminInfo.getId().toString(), subTreeNode);
                    continue;
                }
                if (nodeMap.containsKey(adminInfo.getParent().getId().toString())) continue;
                nodeMap = NewOrgTreeHelper.addTreeNode(nodeMap, adminInfo, false);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                nodeMap.put(adminInfo.getId().toString(), subTreeNode);
                continue;
            }
            if (adminInfo.getParent() == null || nodeMap.containsKey(adminInfo.getParent().getId().toString())) continue;
            nodeMap = NewOrgTreeHelper.addTreeNode(nodeMap, adminInfo, false);
        }
        return rootTreeNode;
    }

    private static HashMap addTreeNode(HashMap nodeMap, AdminOrgUnitInfo adminInfo, boolean flag) throws Exception {
        AdminOrgUnitInfo newAdminInfo;
        if (adminInfo.getParent() != null && !nodeMap.containsKey(adminInfo.getParent().getId().toString()) && (newAdminInfo = NewOrgTreeHelper.getAdminInfoByParentId(adminInfo.getParent().getId().toString())).getParent() != null) {
            if (!nodeMap.containsKey(newAdminInfo.getParent().getId().toString())) {
                nodeMap = NewOrgTreeHelper.addTreeNode(nodeMap, newAdminInfo, true);
            } else {
                KDTreeNode newSubTreeNode = new KDTreeNode((Object)newAdminInfo);
                newSubTreeNode.setCustomIcon(companyIcon);
                if (newAdminInfo.getParent() != null && nodeMap.containsKey(newAdminInfo.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(newAdminInfo.getParent().getId().toString())).add((MutableTreeNode)newSubTreeNode);
                    nodeMap.put(newAdminInfo.getId().toString(), newSubTreeNode);
                    HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)newSubTreeNode);
                }
            }
            KDTreeNode subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                nodeMap.put(adminInfo.getId().toString(), subTreeNode);
                if (flag) {
                    HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)subTreeNode);
                }
            }
        }
        return nodeMap;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || "".equals(row.getString("parent.id"))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static AdminOrgUnitInfo getRootAdmin(ArrayList list) throws Exception {
        ArrayList adminList = new ArrayList();
        String longNumber = ((AdminOrgUnitInfo)list.get(0)).getLongNumber();
        if (longNumber.indexOf("!") > 0) {
            return NewOrgTreeHelper.getAdminInfoByLongNumber(longNumber.substring(0, longNumber.indexOf("!")));
        }
        return NewOrgTreeHelper.getAdminInfoByLongNumber(longNumber);
    }

    private static Boolean getNextFlag(String LongNumber, String newLongNumber) {
        Boolean flag = false;
        Character c = null;
        if (LongNumber.length() < newLongNumber.length()) {
            c = Character.valueOf(newLongNumber.charAt(LongNumber.length()));
            if ("!".equals(c.toString())) {
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    private static AdminOrgUnitInfo getAdminInfoByLongNumber(String longNumber) throws Exception {
        StringBuffer sql = new StringBuffer("SELECT FID,FNAME_L2,FNUMBER,FLONGNUMBER,FLEVEL,FINDEX,FISLEAF,FPARENTID FROM T_ORG_Admin WHERE FLongNumber = '");
        sql.append(longNumber);
        sql.append("'");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        if (rows.first()) {
            adminInfo.setId(BOSUuid.read((String)rows.getString("FID")));
            adminInfo.setName(rows.getString("FNAME_L2"));
            adminInfo.setNumber(rows.getString("FNUMBER"));
            adminInfo.setLongNumber(rows.getString("FLONGNUMBER"));
            adminInfo.setLevel(rows.getInt("FLEVEL"));
            adminInfo.setIndex(rows.getInt("FINDEX"));
            adminInfo.setIsLeaf(rows.getBoolean("FISLEAF"));
            AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
            if (rows.getString("FPARENTID") == null || "".equals(rows.getString("FPARENTID"))) {
                parentInfo = null;
            } else {
                parentInfo.setId(BOSUuid.read((String)rows.getString("FPARENTID")));
            }
            adminInfo.setParent(parentInfo);
        }
        return adminInfo;
    }

    private static AdminOrgUnitInfo getAdminInfoByParentId(String FID) throws Exception {
        StringBuffer sql = new StringBuffer("SELECT FID,FNAME_L2,FNUMBER,FLONGNUMBER,FLEVEL,FINDEX,FISLEAF,FPARENTID FROM T_ORG_Admin WHERE FID = '");
        sql.append(FID);
        sql.append("'");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        if (rows.first()) {
            adminInfo.setId(BOSUuid.read((String)rows.getString("FID")));
            adminInfo.setName(rows.getString("FNAME_L2"));
            adminInfo.setNumber(rows.getString("FNUMBER"));
            adminInfo.setLongNumber(rows.getString("FLONGNUMBER"));
            adminInfo.setLevel(rows.getInt("FLEVEL"));
            adminInfo.setIndex(rows.getInt("FINDEX"));
            adminInfo.setIsLeaf(rows.getBoolean("FISLEAF"));
            AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
            if (rows.getString("FPARENTID") == null || "".equals(rows.getString("FPARENTID"))) {
                parentInfo = null;
            } else {
                parentInfo.setId(BOSUuid.read((String)rows.getString("FPARENTID")));
            }
            adminInfo.setParent(parentInfo);
        }
        return adminInfo;
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByHRO() throws Exception {
        return NewOrgTreeHelper.createAdminTreeNodeByHRO(null);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByHRO(String hroId) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNodeByHRO(null, true);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByHRO(String hroId, boolean isHroFilter) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNodeByHRO(hroId, isHroFilter, false, false);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByHRO(String hroId, boolean isHroFilter, boolean includePosition) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNodeByHRO(hroId, isHroFilter, includePosition, false);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByHRO(String hroId, boolean isHroFilter, boolean includePosition, boolean includeSealUp) throws Exception {
        return NewOrgTreeHelper.createAdminTreeNodeByHRO(hroId, isHroFilter, includePosition, includeSealUp, true);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByHRO(String hroId, boolean isHroFilter, boolean includePosition, boolean includeSealUp, boolean showVirtualOrg) throws Exception {
        if (hroId == null) {
            HROrgUnitInfo hroInfo = SysContext.getSysContext().getCurrentHRUnit();
            if (hroInfo == null) {
                return null;
            }
            hroId = hroInfo.getId().toString();
        }
        DefaultKingdeeTreeNode root = null;
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache.clear();
        }
        String key = sessionId + hroId + isHroFilter + includePosition + includeSealUp + showVirtualOrg;
        if (nodeCache.get(key) == null || rebuildTree) {
            root = OrgTreeBuilder.getRoot((String)hroId, (boolean)isHroFilter, (boolean)includeSealUp, (boolean)showVirtualOrg);
            if (root != null && includePosition) {
                NewOrgTreeHelper.addPositionNode(root);
            }
            nodeCache.put(key, root);
            rebuildTree = false;
        } else {
            root = (DefaultKingdeeTreeNode)nodeCache.get(key);
        }
        return root;
    }

    private static PositionInfo createPositionInfo(IRowSet row) throws Exception {
        PositionInfo info = new PositionInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        info.setName(row.getString("name"));
        return info;
    }

    private static void getAdminNodeHashMap(DefaultKingdeeTreeNode root, Map nodeMap) {
        if (!OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            nodeMap.put(((AdminOrgUnitInfo)root.getUserObject()).getId().toString(), root);
        }
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)child) || !(child.getUserObject() instanceof AdminOrgUnitInfo)) continue;
            nodeMap.put(((AdminOrgUnitInfo)child.getUserObject()).getId().toString(), child);
        }
    }

    public static void addPositionNode(DefaultKingdeeTreeNode root) throws Exception {
        if (!(root.getUserObject() instanceof AdminOrgUnitInfo)) {
            return;
        }
        HashMap nodeMap = new HashMap();
        NewOrgTreeHelper.getAdminNodeHashMap(root, nodeMap);
        AdminOrgUnitInfo admin = (AdminOrgUnitInfo)root.getUserObject();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT P.FID id ,P.FName_").append(SysContext.getSysContext().getLocale()).append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ").append(" ,FAdminOrgUnitID,P.FIndex PFIndex  FROM T_ORG_Position P, T_ORG_Admin A ").append(" WHERE P.FAdminOrgUnitID=A.FID AND (A.FID = '").append(admin.getId().toString()).append("' or A.FParentID = '").append(admin.getId().toString()).append("')");
        if (!HRParamUtil.getParamOfHR(null, (String)"IS_AFFAIR", null)) {
            sql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
        }
        sql.append(" ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        String adminID = null;
        PositionInfo positionInfo = null;
        DefaultKingdeeTreeNode positionTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        DefaultKingdeeTreeNode childNode = null;
        int index = 0;
        block0: while (rows.next()) {
            adminID = rows.getString("FAdminOrgUnitID");
            if (!nodeMap.containsKey(adminID)) continue;
            parentNode = (DefaultKingdeeTreeNode)nodeMap.get(adminID);
            int size = parentNode.getChildCount();
            for (int i = 0; i < size; ++i) {
                Object child = ((DefaultKingdeeTreeNode)parentNode.getChildAt(i)).getUserObject();
                if (child instanceof PositionInfo && rows.getString("id").equals(((PositionInfo)child).getId().toString())) continue block0;
            }
            positionInfo = NewOrgTreeHelper.createPositionInfo(rows);
            positionTreeNode = new DefaultKingdeeTreeNode((Object)positionInfo);
            positionTreeNode.setCustomIcon(positionIcon);
            if (rows.getBoolean("DefaultPosition")) {
                parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                continue;
            }
            if (parentNode.getChildCount() > 0) {
                childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(0);
                index = rows.getInt("PFIndex") + 1;
                if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() > index && rows.getString("PFIndex") != null && rows.getInt("PFIndex") >= 0) {
                    NewOrgTreeHelper.insertPositionNode(parentNode, positionTreeNode, index);
                    continue;
                }
                if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() <= index) {
                    NewOrgTreeHelper.insertPositionNode(parentNode, positionTreeNode, parentNode.getChildCount());
                    continue;
                }
                if (childNode.getUserObject() instanceof PositionInfo) {
                    parentNode.insert((MutableTreeNode)positionTreeNode, 1);
                    continue;
                }
                parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                continue;
            }
            parentNode.add((MutableTreeNode)positionTreeNode);
        }
        nodeMap = null;
    }

    private static void insertPositionNode(DefaultKingdeeTreeNode parent, DefaultKingdeeTreeNode child, int index) {
        for (int i = index; i > 0; --i) {
            if (!(((DefaultKingdeeTreeNode)parent.getChildAt(i - 1)).getUserObject() instanceof PositionInfo)) continue;
            parent.insert((MutableTreeNode)child, i);
            return;
        }
        parent.insert((MutableTreeNode)child, 0);
    }

    public static DefaultTreeModel getCompany() {
        return null;
    }

    public static KDTreeNode searchTreeNodeById(KDTreeNode root, String id) {
        if (root == null) {
            return null;
        }
        String rootId = ((FullOrgUnitInfo)root.getUserObject()).getId().toString();
        if (id.equals(rootId)) {
            return root;
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            KDTreeNode node = NewOrgTreeHelper.searchTreeNodeById((KDTreeNode)root.getChildAt(i), id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static DefaultKingdeeTreeNode searchTreeNodeById(DefaultKingdeeTreeNode root, String id) {
        if (root == null) {
            return null;
        }
        String rootId = ((FullOrgUnitInfo)root.getUserObject()).getId().toString();
        if (id.equals(rootId)) {
            return root;
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode node = NewOrgTreeHelper.searchTreeNodeById((DefaultKingdeeTreeNode)root.getChildAt(i), id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static DefaultKingdeeTreeNode createAdminHierarchyTreeNode(String hierarchyId, boolean showHidden) throws Exception {
        Set adminIds = NewOrgTreeHelper.getUserRangeAdmins();
        IRowSet rows = NewOrgTreeHelper.getAdminHierarchyRowSet(hierarchyId, showHidden);
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        KDTreeNode subTreeNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        AdminOrgUnitInfo adminInfo = null;
        while (rows.next()) {
            adminInfo = NewOrgTreeHelper.createAdminUnitInfo2(rows);
            if (adminIds.contains(adminInfo.getId().toString())) {
                adminInfo.put("CAN_VIEW", (Object)"1");
            }
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    private static Set getUserRangeAdmins() throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer("SELECT DISTINCT FFromUnitID, FToUnitID ");
        sql.append(" FROM T_ORG_UnitRelation ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_UnitRelation.FFromUnitID = T_PM_OrgRange.FOrgID ");
        sql.append(" WHERE T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID='");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        FullOrgUnitCollection orgCollection = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.HRO, null, null);
        HashSet<String> hrOrgSet = new HashSet<String>();
        if (orgCollection != null) {
            int n = orgCollection.size();
            for (int i = 0; i < n; ++i) {
                hrOrgSet.add(orgCollection.get(i).getId().toString());
            }
        }
        String hrOrgId = null;
        String fromUnitId = null;
        HashSet<String> hasPermissionOrgSet = new HashSet<String>();
        while (rowSet.next()) {
            fromUnitId = rowSet.getString("FFromUnitID");
            hrOrgId = rowSet.getString("FToUnitID");
            if (!hrOrgSet.contains(hrOrgId)) continue;
            hasPermissionOrgSet.add(fromUnitId);
        }
        return hasPermissionOrgSet;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo2(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("child.id")));
        adminInfo.setName(row.getString("child.name"));
        adminInfo.setNumber(row.getString("child.number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static IRowSet getAdminHierarchyRowSet(String hierarchyId, boolean showHidden) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId, CompareType.EQUALS));
        if (!showHidden) {
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("adminOther.visibleInOrgChart", null));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.AdminOrgUnitHierarchyTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }
}

