/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.BizTypeException;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.common.client.AbstractBizTypeListUI;
import com.kingdee.eas.basedata.scm.common.client.BizTypeEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BizTypeListUI
extends AbstractBizTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BizTypeListUI.class);
    private final String resource = "com.kingdee.eas.basedata.scm.im.inv.InvAddResource";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
        this.menuBiz.setVisible(true);
        this.menuBiz.setEnabled(true);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("bizcategory.number"));
        sorterColl.add(new SorterItemInfo("number"));
        viewInfo.setSorter(sorterColl);
        return exec;
    }

    private void initTable() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("bizCategory.system").setGroup(true);
        this.tblMain.getColumn("bizCategory.name").setGroup(true);
        this.tblMain.getColumn("bizCategory.system").setMergeable(true);
        this.tblMain.getColumn("bizCategory.name").setMergeable(true);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
    }

    @Override
    protected String getEditUIName() {
        return BizTypeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BizTypeFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        BizTypeInfo info = (BizTypeInfo)((IBizType)this.getBizInterface()).getValue((IObjectPK)pk);
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList sids = this.getSelectedIdValues();
        if (sids != null) {
            ObjectUuidPK pk;
            String idtmp;
            int i;
            int size = sids.size();
            boolean flag = false;
            for (i = 0; i < size; ++i) {
                idtmp = (String)sids.get(i);
                pk = new ObjectUuidPK(BOSUuid.read((String)idtmp));
                BizTypeInfo info = (BizTypeInfo)((IBizType)this.getBizInterface()).getValue((IObjectPK)pk);
                if (!info.isIsDefault()) continue;
                throw new BizTypeException(BizTypeException.DEFAULTCANNOTDELETE);
            }
            if (this.confirmRemove()) {
                for (i = 0; i < size; ++i) {
                    idtmp = (String)sids.get(i);
                    pk = new ObjectUuidPK(BOSUuid.read((String)idtmp));
                    ((IBizType)this.getBizInterface()).delete((IObjectPK)pk);
                }
                this.refresh(e);
            }
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.INACTIVE, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.ACTIVE, e);
    }

    private void setStatus(UseStatusEnum status, ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        StringBuffer errMsg = new StringBuffer();
        ArrayList errors = BizTypeFactory.getRemoteInstance().cancelCancelOrCancel(pks, status);
        String msg = null;
        boolean isSuccess = true;
        if (errors != null && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            msg = isSuccess ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"EnableSuccess") : EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_EnableError");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"DisableSuccess") : EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_DisableError");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)8188);
        }
        this.refresh(e);
        this.setMessageText(msg);
        this.showMessage();
    }
}

