/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.scm.common.ExpenseItemFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseItemInfo;
import com.kingdee.eas.basedata.scm.common.client.AbstractExpenseItemListUI;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.common.client.ExpenseItemEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExpenseItemListUI
extends AbstractExpenseItemListUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseItemListUI.class);
    private static final String resClassName = "com.kingdee.eas.basedata.scm.common.SCMResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("createTime"));
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setVisible(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedIdValues().size() == 1) {
            super.actionRemove_actionPerformed(e);
        } else if (this.confirmRemove()) {
            ArrayList list = this.getSelectedIdValues();
            IObjectPK[] pks = new IObjectPK[list.size()];
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                pks[i] = new ObjectUuidPK((String)list.get(i));
            }
            this.getBizInterface().delete(pks);
            this.refreshList();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return ExpenseItemEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ExpenseItemFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ExpenseItemInfo objectValue = new ExpenseItemInfo();
        return objectValue;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    private void print(boolean isPreview) {
        this.preparePrintPage(this.tblMain);
        KDPrinter printer = this.tblMain.getPrintManager().getNewPrintManager().getPrinter();
        PrintListener printListener = new PrintListener();
        printer.addPrintActionListener((IPrintActionListener)printListener);
        if (isPreview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
        printer.removePrintActionListener((IPrintActionListener)printListener);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            pks[i] = new ObjectUuidPK((String)list.get(i));
        }
        ExpenseItemFactory.getRemoteInstance().cancel(pks);
        MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"DisableSuccess"));
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            pks[i] = new ObjectUuidPK((String)list.get(i));
        }
        ExpenseItemFactory.getRemoteInstance().cancelCancel(pks);
        MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"EnableSuccess"));
        this.refreshList();
    }

    class PrintListener
    implements IPrintActionListener {
        PrintListener() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            BDInvClientUtils.logUIOperation("LOG_PRINT", new ExpenseItemInfo().getBOSType());
        }

        public void closePreview() {
        }
    }
}

