/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.scm.common.ExpenseTypeFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseTypeInfo;
import com.kingdee.eas.basedata.scm.common.client.AbstractExpenseTypeListUI;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.common.client.ExpenseTypeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExpenseTypeListUI
extends AbstractExpenseTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(ExpenseTypeListUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedIdValues().size() == 1) {
            super.actionRemove_actionPerformed(e);
        } else if (this.confirmRemove()) {
            ArrayList list = this.getSelectedIdValues();
            IObjectPK[] pks = new IObjectPK[list.size()];
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                pks[i] = new ObjectUuidPK((String)list.get(i));
            }
            this.getBizInterface().delete(pks);
            this.refreshList();
        }
    }

    @Override
    protected String getEditUIName() {
        return ExpenseTypeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ExpenseTypeFactory.getRemoteInstance();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    private void print(boolean isPreview) {
        this.preparePrintPage(this.tblMain);
        KDPrinter printer = this.tblMain.getPrintManager().getNewPrintManager().getPrinter();
        PrintListener printListener = new PrintListener();
        printer.addPrintActionListener((IPrintActionListener)printListener);
        if (isPreview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
        printer.removePrintActionListener((IPrintActionListener)printListener);
    }

    class PrintListener
    implements IPrintActionListener {
        PrintListener() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            BDInvClientUtils.logUIOperation("LOG_PRINT", new ExpenseTypeInfo().getBOSType());
        }

        public void closePreview() {
        }
    }
}

