/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.common.SetMTBizRelationTypeEnum;
import com.kingdee.eas.basedata.scm.common.SettlementRelationEntryInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRelationFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRelationInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRuleEntryCollection;
import com.kingdee.eas.basedata.scm.common.SettlementRuleEntryInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRuleInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRulePriceRuleEnum;
import com.kingdee.eas.basedata.scm.common.SettlementStatusEnum;
import com.kingdee.eas.basedata.scm.common.client.AbstractSettlementRelationEditUI;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettlementRelationEditUI
extends AbstractSettlementRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementRelationEditUI.class);
    private DataChangeListener prmtSupCompanyChangeListener;
    private DataChangeListener prmtReqCompanyChangeListener;
    private DataChangeListener prmtRowTypeChangeListener;
    private DataChangeListener prmtMaterialGroupStandardChangeListener;
    private DataChangeListener prmtMaterialGroupChangeListener;
    private SelectorListener prmtMaterialGroupStandardSelectorListener;
    private SelectorListener prmtMaterialGroupSelectorListener;
    private KDTEditListener kdtEditListener;

    public SettlementRelationEditUI() throws Exception {
        this.detailTable.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setSyncOldValue(true);
        this.editData.setBizRelationType(SetMTBizRelationTypeEnum.company);
        this.editData.setSyncOldValue(false);
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.addListeners();
    }

    protected IObjectValue createNewData() {
        SettlementRelationInfo info = new SettlementRelationInfo();
        info.setBizRelationType(SetMTBizRelationTypeEnum.company);
        info.getEntries().add((SettlementRelationEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementRelationFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        String permissionItem = "settlementRelation_addnew";
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType, permissionItem);
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setCommitFormat("$number$");
    }

    public void onLoad() throws Exception {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAudit.setEnabled(false);
        super.onLoad();
        this.setMainBizOrgF7(this.prmtSupCompanyOrg, OrgType.Company);
        this.initEntryEditor();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        this.editData = (SettlementRelationInfo)ov;
        super.setDataObject(ov);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
        } else if (this.editData.getBaseStatus().equals((Object)SettlementStatusEnum.SAVED)) {
            this.btnAudit.setEnabled(true);
            this.btnUnAudit.setEnabled(false);
            this.btnRemove.setEnabled(true);
            if ("VIEW".equals(this.getOprtState())) {
                this.btnRemoveLine.setEnabled(false);
                this.btnAddLine.setEnabled(false);
            } else {
                this.btnRemoveLine.setEnabled(true);
                this.btnAddLine.setEnabled(true);
            }
        } else if (this.editData.getBaseStatus().equals((Object)SettlementStatusEnum.AUDITED)) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(true);
            this.btnRemove.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnAddLine.setEnabled(false);
        }
    }

    private void initEntryEditor() {
        KDBizPromptBox prmtProCompanyOrg = new KDBizPromptBox();
        prmtProCompanyOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        prmtProCompanyOrg.setEditFormat("$number$");
        prmtProCompanyOrg.setDisplayFormat("$name$");
        prmtProCompanyOrg.setCommitFormat("$number$");
        KDBizPromptBox prmtAccCompanyOrg = new KDBizPromptBox();
        prmtAccCompanyOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        prmtAccCompanyOrg.setEditFormat("$number$");
        prmtAccCompanyOrg.setDisplayFormat("$name$");
        prmtAccCompanyOrg.setCommitFormat("$number$");
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        prmtAccCompanyOrg.setEntityViewInfo(view);
        KDBizPromptBox prmtProStorageOrg = new KDBizPromptBox();
        prmtProStorageOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageItemQuery");
        prmtProStorageOrg.setEditFormat("$number$");
        prmtProStorageOrg.setDisplayFormat("$name$");
        prmtProStorageOrg.setCommitFormat("$number$");
        KDBizPromptBox prmtAccStorageOrg = new KDBizPromptBox();
        prmtAccStorageOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageItemQuery");
        prmtAccStorageOrg.setEditFormat("$number$");
        prmtAccStorageOrg.setDisplayFormat("$name$");
        prmtAccStorageOrg.setCommitFormat("$number$");
        KDBizPromptBox prmtProWarehouse = new KDBizPromptBox();
        prmtProWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        prmtProWarehouse.setEditFormat("$number$");
        prmtProWarehouse.setDisplayFormat("$name$");
        prmtProWarehouse.setCommitFormat("$number$");
        KDBizPromptBox prmtAccWarehouse = new KDBizPromptBox();
        prmtAccWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        prmtAccWarehouse.setEditFormat("$number$");
        prmtAccWarehouse.setDisplayFormat("$name$");
        prmtAccWarehouse.setCommitFormat("$number$");
        KDBizPromptBox prmtProLocation = new KDBizPromptBox();
        prmtProLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
        prmtProLocation.setEditFormat("$number$");
        prmtProLocation.setDisplayFormat("$name$");
        prmtProLocation.setCommitFormat("$number$");
        KDBizPromptBox prmtAccLocation = new KDBizPromptBox();
        prmtAccLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
        prmtAccLocation.setEditFormat("$number$");
        prmtAccLocation.setDisplayFormat("$name$");
        prmtAccLocation.setCommitFormat("$number$");
        KDBizPromptBox prmtSettlementRule = new KDBizPromptBox();
        prmtSettlementRule.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7SettlementRuleQuery");
        prmtSettlementRule.setEditFormat("$number$");
        prmtSettlementRule.setDisplayFormat("$name$");
        prmtSettlementRule.setCommitFormat("$number$");
        KDBizPromptBox prmtSaleOrg = new KDBizPromptBox();
        prmtSaleOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleItemQuery");
        prmtSaleOrg.setEditFormat("$number$");
        prmtSaleOrg.setDisplayFormat("$name$");
        prmtSaleOrg.setCommitFormat("$number$");
        this.detailTable.getColumn("proCompanyOrg").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProCompanyOrg));
        this.detailTable.getColumn("accCompanyOrg").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccCompanyOrg));
        this.detailTable.getColumn("proStorageOrg").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProStorageOrg));
        this.detailTable.getColumn("accStorageOrg").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccStorageOrg));
        this.detailTable.getColumn("proWareHouse").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProWarehouse));
        this.detailTable.getColumn("accWareHouse").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccWarehouse));
        this.detailTable.getColumn("proLocation").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProLocation));
        this.detailTable.getColumn("accLocation").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccLocation));
        this.detailTable.getColumn("settlementRule").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSettlementRule));
        this.detailTable.getColumn("saleOrgUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSaleOrg));
    }

    private void addListeners() {
        if (this.prmtSupCompanyChangeListener == null) {
            this.prmtSupCompanyChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SettlementRelationEditUI.this.supCompanyChanged(eventObj);
                }
            };
        }
        this.prmtSupCompanyOrg.addDataChangeListener(this.prmtSupCompanyChangeListener);
        if (this.prmtReqCompanyChangeListener == null) {
            this.prmtReqCompanyChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SettlementRelationEditUI.this.reqCompanyChanged(eventObj);
                }
            };
        }
        this.prmtReqCompanyOrg.addDataChangeListener(this.prmtReqCompanyChangeListener);
        if (this.prmtRowTypeChangeListener == null) {
            this.prmtRowTypeChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SettlementRelationEditUI.this.rowTypeChanged(eventObj);
                }
            };
        }
        this.prmtRowType.addDataChangeListener(this.prmtRowTypeChangeListener);
        if (this.prmtMaterialGroupStandardChangeListener == null) {
            this.prmtMaterialGroupStandardChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SettlementRelationEditUI.this.materialGroupStandardChanged(eventObj);
                }
            };
        }
        this.prmtMaterialGroupStandard.addDataChangeListener(this.prmtMaterialGroupStandardChangeListener);
        if (this.prmtMaterialGroupChangeListener == null) {
            this.prmtMaterialGroupChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SettlementRelationEditUI.this.materialGroupChanged(eventObj);
                }
            };
        }
        this.prmtMaterialGroup.addDataChangeListener(this.prmtMaterialGroupChangeListener);
        if (this.prmtMaterialGroupStandardSelectorListener == null) {
            this.prmtMaterialGroupStandardSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    SettlementRelationEditUI.this.materialGroupStandardSelect(e);
                }
            };
        }
        this.prmtMaterialGroupStandard.addSelectorListener(this.prmtMaterialGroupStandardSelectorListener);
        if (this.prmtMaterialGroupSelectorListener == null) {
            this.prmtMaterialGroupSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    SettlementRelationEditUI.this.materialGroupSelect(e);
                }
            };
        }
        this.prmtMaterialGroup.addSelectorListener(this.prmtMaterialGroupSelectorListener);
        if (this.kdtEditListener == null) {
            this.kdtEditListener = new KDTEditListener(){

                public void editValueChanged(KDTEditEvent e) {
                }

                public void editStopping(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    SettlementRelationEditUI.this.table_editStoped(e);
                }

                public void editStarting(KDTEditEvent e) {
                    SettlementRelationEditUI.this.table_editStarting(e);
                }

                public void editStarted(KDTEditEvent e) {
                }

                public void editCanceled(KDTEditEvent e) {
                }
            };
        }
        this.detailTable.addKDTEditListener(this.kdtEditListener);
    }

    protected void table_editStoped(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.detailTable.getRow(rowIndex);
        IRow nextRow = this.detailTable.getRow(rowIndex + 1);
        int proCompanyOrgIndex = this.detailTable.getColumnIndex("proCompanyOrg");
        int proStorageOrgIndex = this.detailTable.getColumnIndex("proStorageOrg");
        int proWareHouseIndex = this.detailTable.getColumnIndex("proWareHouse");
        int proLocationIndex = this.detailTable.getColumnIndex("proLocation");
        int accCompanyOrgIndex = this.detailTable.getColumnIndex("accCompanyOrg");
        int accStorageOrgIndex = this.detailTable.getColumnIndex("accStorageOrg");
        int accWareHouseIndex = this.detailTable.getColumnIndex("accWareHouse");
        int accLocationIndex = this.detailTable.getColumnIndex("accLocation");
        int settlementRuleIndex = this.detailTable.getColumnIndex("settlementRule");
        int saleOrgUnitIndex = this.detailTable.getColumnIndex("saleOrgUnit");
        if (colIndex == accCompanyOrgIndex) {
            row.getCell(accStorageOrgIndex).setValue(null);
            row.getCell(accWareHouseIndex).setValue(null);
            row.getCell(accLocationIndex).setValue(null);
            row.getCell(settlementRuleIndex).setValue(null);
            row.getCell(saleOrgUnitIndex).setValue(null);
            if (nextRow != null) {
                nextRow.getCell(proCompanyOrgIndex).setValue(e.getValue());
                nextRow.getCell(proStorageOrgIndex).setValue(null);
                nextRow.getCell(proWareHouseIndex).setValue(null);
                nextRow.getCell(proLocationIndex).setValue(null);
            }
        }
        if (colIndex == accStorageOrgIndex) {
            row.getCell(accWareHouseIndex).setValue(null);
            row.getCell(accLocationIndex).setValue(null);
            if (nextRow != null) {
                nextRow.getCell(proStorageOrgIndex).setValue(e.getValue());
                nextRow.getCell(proWareHouseIndex).setValue(null);
                nextRow.getCell(proLocationIndex).setValue(null);
            }
        }
        if (colIndex == accWareHouseIndex) {
            row.getCell(accLocationIndex).setValue(null);
            if (nextRow != null) {
                nextRow.getCell(proWareHouseIndex).setValue(e.getValue());
                nextRow.getCell(proLocationIndex).setValue(null);
            }
        }
        if (colIndex == accLocationIndex && nextRow != null) {
            nextRow.getCell(proLocationIndex).setValue(e.getValue());
        }
    }

    protected void table_editStarting(KDTEditEvent e) {
        String filterSql;
        String sql;
        EntityViewInfo view;
        FilterInfo filter;
        CompanyOrgUnitInfo accCompanyOrgInfo;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.detailTable.getRow(rowIndex);
        int proCompanyOrgIndex = this.detailTable.getColumnIndex("proCompanyOrg");
        int proStorageOrgIndex = this.detailTable.getColumnIndex("proStorageOrg");
        int proWareHouseIndex = this.detailTable.getColumnIndex("proWareHouse");
        int proLocationIndex = this.detailTable.getColumnIndex("proLocation");
        int accCompanyOrgIndex = this.detailTable.getColumnIndex("accCompanyOrg");
        int accStorageOrgIndex = this.detailTable.getColumnIndex("accStorageOrg");
        int accWareHouseIndex = this.detailTable.getColumnIndex("accWareHouse");
        int accLocationIndex = this.detailTable.getColumnIndex("accLocation");
        int settlementRuleIndex = this.detailTable.getColumnIndex("settlementRule");
        int saleOrgUnitIndex = this.detailTable.getColumnIndex("saleOrgUnit");
        if (rowIndex == 0) {
            if (this.prmtSupCompanyOrg.getValue() == null) {
                MsgBox.showWarning((String)this.getResource("PLS_Fill_SupCompany", null));
                e.setCancel(true);
                return;
            }
            row.getCell(proCompanyOrgIndex).setValue((Object)((CompanyOrgUnitInfo)this.prmtSupCompanyOrg.getValue()));
        } else {
            accCompanyOrgInfo = (CompanyOrgUnitInfo)this.detailTable.getCell(rowIndex - 1, accCompanyOrgIndex).getValue();
            if (accCompanyOrgInfo == null) {
                MsgBox.showWarning((String)this.getResource("AccCompany_Not_Null", new Object[]{rowIndex}));
                e.setCancel(true);
                return;
            }
            StorageOrgUnitInfo accStorageOrgInfo = (StorageOrgUnitInfo)this.detailTable.getCell(rowIndex - 1, accStorageOrgIndex).getValue();
            WarehouseInfo accWareHouse = (WarehouseInfo)this.detailTable.getCell(rowIndex - 1, accWareHouseIndex).getValue();
            LocationInfo accLocation = (LocationInfo)this.detailTable.getCell(rowIndex - 1, accLocationIndex).getValue();
            row.getCell(proCompanyOrgIndex).setValue((Object)accCompanyOrgInfo);
            row.getCell(proStorageOrgIndex).setValue((Object)accStorageOrgInfo);
            row.getCell(proWareHouseIndex).setValue((Object)accWareHouse);
            row.getCell(proLocationIndex).setValue((Object)accLocation);
        }
        if (colIndex == proCompanyOrgIndex || colIndex == proStorageOrgIndex || colIndex == proWareHouseIndex || colIndex == proLocationIndex) {
            e.setCancel(true);
            return;
        }
        if (colIndex == accStorageOrgIndex) {
            accCompanyOrgInfo = (CompanyOrgUnitInfo)this.detailTable.getCell(rowIndex, accCompanyOrgIndex).getValue();
            filter = new FilterInfo();
            view = new EntityViewInfo();
            view.setFilter(filter);
            if (accCompanyOrgInfo == null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"888888"));
            } else {
                sql = "id in (SELECT a.FFromUnitID FROM T_ORG_UnitRelation AS A INNER JOIN T_ORG_TypeRelation AS B ON a.FTypeRelationID = b.FID WHERE a.FToUnitID = '" + accCompanyOrgInfo.getId().toString() + "' AND b.FFromType = 4 AND b.FToType = 1)";
                filter.getFilterItems().add(new FilterItemInfo(sql));
            }
            ((KDBizPromptBox)this.detailTable.getColumn(accStorageOrgIndex).getEditor().getComponent()).setEntityViewInfo(view);
        }
        if (colIndex == accWareHouseIndex) {
            StorageOrgUnitInfo accStorageOrgInfo = (StorageOrgUnitInfo)this.detailTable.getCell(rowIndex, accStorageOrgIndex).getValue();
            filter = new FilterInfo();
            view = new EntityViewInfo();
            view.setFilter(filter);
            if (accStorageOrgInfo == null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"888888"));
            } else {
                sql = "id in (select FWarehouseID from T_DB_SOAccreditWH where FStorageOrgID ='" + accStorageOrgInfo.getId().toString() + "' and FStatus=1)";
                filter.getFilterItems().add(new FilterItemInfo(sql));
            }
            ((KDBizPromptBox)this.detailTable.getColumn(accWareHouseIndex).getEditor().getComponent()).setEntityViewInfo(view);
        }
        if (colIndex == accLocationIndex) {
            WarehouseInfo accWarehouseInfo = (WarehouseInfo)this.detailTable.getCell(rowIndex, accWareHouseIndex).getValue();
            filter = new FilterInfo();
            view = new EntityViewInfo();
            view.setFilter(filter);
            if (accWarehouseInfo == null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"888888"));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("WAREHOUSE.ID", (Object)accWarehouseInfo.getId().toString()));
            }
            ((KDBizPromptBox)this.detailTable.getColumn(accLocationIndex).getEditor().getComponent()).setEntityViewInfo(view);
        }
        if (colIndex == settlementRuleIndex) {
            RowTypeInfo rowType = (RowTypeInfo)this.prmtRowType.getValue();
            MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)this.prmtMaterialGroup.getValue();
            MaterialGroupStandardInfo MSGInfo = (MaterialGroupStandardInfo)this.prmtMaterialGroupStandard.getValue();
            filterSql = "";
            if (rowType != null) {
                filterSql = filterSql + "id in (select t1.fparentid from T_SCM_SettlementRuleEntry t1 where t1.fparentid in (select t.fparentid from (select fparentid,frowTypeid from T_SCM_SettlementRuleentry group by fparentid,frowTypeid)t group by t.fparentid having count(*)=1) and (t1.frowTypeid is null or t1.frowTypeid='" + rowType.getId().toString() + "'))";
            }
            if (materialGroupInfo != null) {
                if (!StringUtils.isEmpty((String)filterSql)) {
                    filterSql = filterSql + " and ";
                }
                filterSql = filterSql + "id in (select FID from T_SCM_SettlementRule where FMaterialGroupStandardID is null or FMaterialGroupStandardID='" + MSGInfo.getId().toString() + "')";
            }
            if (!StringUtils.isEmpty((String)filterSql)) {
                FilterInfo filter2 = new FilterInfo();
                EntityViewInfo view2 = new EntityViewInfo();
                view2.setFilter(filter2);
                filter2.getFilterItems().add(new FilterItemInfo(filterSql));
                ((KDBizPromptBox)this.detailTable.getColumn(settlementRuleIndex).getEditor().getComponent()).setEntityViewInfo(view2);
            }
        }
        if (colIndex == saleOrgUnitIndex) {
            if (!this.checkSettlementRule(rowIndex)) {
                e.setCancel(true);
                return;
            }
            FilterInfo filter3 = new FilterInfo();
            EntityViewInfo view3 = new EntityViewInfo();
            view3.setFilter(filter3);
            CompanyOrgUnitInfo proCompanyOrg = (CompanyOrgUnitInfo)this.detailTable.getCell(rowIndex, proCompanyOrgIndex).getValue();
            if (proCompanyOrg == null) {
                filter3.getFilterItems().add(new FilterItemInfo("id", (Object)"888888"));
            } else {
                filterSql = "id in (SELECT a.FFromUnitID FROM T_ORG_UnitRelation AS A INNER JOIN T_ORG_TypeRelation AS B ON a.FTypeRelationID = b.FID WHERE a.FToUnitID = '" + proCompanyOrg.getId().toString() + "' AND b.FFromType = 2 AND b.FToType = 1)";
                filter3.getFilterItems().add(new FilterItemInfo(filterSql));
            }
            ((KDBizPromptBox)this.detailTable.getColumn(saleOrgUnitIndex).getEditor().getComponent()).setEntityViewInfo(view3);
        }
    }

    private boolean checkSettlementRule(int rowIndex) {
        SettlementRuleInfo ruleInfo = (SettlementRuleInfo)this.detailTable.getCell(rowIndex, "settlementRule").getValue();
        if (ruleInfo != null) {
            SettlementRuleEntryCollection ruleEntryColl = ruleInfo.getEntries();
            SettlementRuleEntryInfo ruleEntryInfo = null;
            for (int i = 0; i < ruleEntryColl.size(); ++i) {
                ruleEntryInfo = ruleEntryColl.get(i);
                if (!ruleEntryInfo.getPriceRule().equals((Object)SettlementRulePriceRuleEnum.ProOrgSalesPricePolicy)) continue;
                return true;
            }
        }
        return false;
    }

    protected void materialGroupSelect(SelectorEvent e) {
        MaterialGroupStandardInfo MGSInfo = (MaterialGroupStandardInfo)this.prmtMaterialGroupStandard.getValue();
        if (MGSInfo == null) {
            MsgBox.showWarning((String)this.getResource("PLS_Fill_MSG", null));
            e.setCanceled(true);
            return;
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)MGSInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtMaterialGroup.setEntityViewInfo(view);
    }

    protected void materialGroupStandardSelect(SelectorEvent e) {
        CompanyOrgUnitInfo orgInfo = (CompanyOrgUnitInfo)this.prmtSupCompanyOrg.getValue();
        if (orgInfo == null) {
            MsgBox.showWarning((String)this.getResource("SupCompany_Not_Null", null));
            e.setCanceled(true);
            return;
        }
        try {
            this.setMaterialGroupStandardFilter(orgInfo.getId().toString());
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void materialGroupChanged(DataChangeEvent eventObj) {
        this.clearEntrySettlementRule();
    }

    protected void materialGroupStandardChanged(DataChangeEvent eventObj) {
        this.prmtMaterialGroup.setValue(null);
    }

    protected void rowTypeChanged(DataChangeEvent eventObj) {
        this.clearEntrySettlementRule();
    }

    private void clearEntrySettlementRule() {
        for (int i = this.getDetailTable().getRowCount() - 1; i >= 0; --i) {
            this.getDetailTable().getCell(i, "settlementRule").setValue(null);
            this.getDetailTable().getCell(i, "saleOrgUnit").setValue(null);
        }
    }

    protected void reqCompanyChanged(DataChangeEvent eventObj) {
    }

    private void supCompanyChanged(DataChangeEvent eventObj) {
        CompanyOrgUnitInfo oldOrg = (CompanyOrgUnitInfo)eventObj.getOldValue();
        CompanyOrgUnitInfo newOrg = (CompanyOrgUnitInfo)eventObj.getNewValue();
        if (oldOrg == null) {
            this.doSupCompanyOrgUnitChanged(newOrg);
            return;
        }
        this.removeListeners();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.ChangeSupCompay_Will_ClearData")))) {
            this.clearData();
            this.doSupCompanyOrgUnitChanged(newOrg);
        } else {
            this.prmtSupCompanyOrg.setValue((Object)oldOrg);
        }
        this.addListeners();
    }

    private void clearData() {
        this.prmtReqCompanyOrg.setValue(null);
        this.prmtRowType.setValue(null);
        this.prmtMaterialGroup.setValue(null);
        this.prmtMaterialGroupStandard.setValue(null);
        this.clearEntry();
    }

    private void clearEntry() {
        for (int i = this.getDetailTable().getRowCount() - 1; i >= 0; --i) {
            this.removeLine(this.getDetailTable(), i);
        }
        this.addLine(this.getDetailTable());
    }

    protected void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
            } else if (detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    private void doSupCompanyOrgUnitChanged(CompanyOrgUnitInfo orgInfo) {
    }

    public void setMaterialGroupStandardFilter(String orgId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), sic);
        if (orgInfo != null) {
            CtrlUnitInfo cu = orgInfo.getCU();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            this.prmtMaterialGroupStandard.setEntityViewInfo(viewInfo);
        }
    }

    private void removeListeners() {
        if (this.prmtSupCompanyChangeListener != null) {
            this.prmtSupCompanyOrg.removeDataChangeListener(this.prmtSupCompanyChangeListener);
        }
        if (this.prmtReqCompanyChangeListener != null) {
            this.prmtReqCompanyOrg.removeDataChangeListener(this.prmtReqCompanyChangeListener);
        }
        if (this.prmtRowTypeChangeListener != null) {
            this.prmtRowType.removeDataChangeListener(this.prmtRowTypeChangeListener);
        }
        if (this.prmtMaterialGroupStandardChangeListener != null) {
            this.prmtMaterialGroupStandard.removeDataChangeListener(this.prmtMaterialGroupStandardChangeListener);
        }
        if (this.prmtMaterialGroupChangeListener != null) {
            this.prmtMaterialGroup.removeDataChangeListener(this.prmtMaterialGroupChangeListener);
        }
        if (this.prmtMaterialGroupStandardSelectorListener != null) {
            this.prmtMaterialGroupStandard.removeSelectorListener(this.prmtMaterialGroupStandardSelectorListener);
        }
        if (this.prmtMaterialGroupSelectorListener != null) {
            this.prmtMaterialGroup.removeSelectorListener(this.prmtMaterialGroupSelectorListener);
        }
        if (this.kdtEditListener != null) {
            this.detailTable.removeKDTEditListener(this.kdtEditListener);
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        if (detailData != null) {
            IRow row = table.addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
        }
    }

    private IObjectValue createNewDetailData(KDTable table) {
        return new SettlementRelationEntryInfo();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getEditManager().stopEditing();
        String id = null;
        super.actionAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.BillCantAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        id = this.editData.getId().toString();
        Map map = SettlementRelationFactory.getRemoteInstance().batchAudit(new String[]{id});
        if (map != null) {
            StringBuffer msg = new StringBuffer();
            if (map.get("errNumber") != null || map.get("errNumberAndSeq") != null) {
                List list = (List)map.get("errNumber");
                for (int i = 0; i < list.size(); ++i) {
                    String number = list.get(i).toString();
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.NoSave_Cant_Audit", (Object[])new Object[]{number})).append("\n");
                }
                List errEntryList = (List)map.get("errNumberAndSeq");
                for (int i = 0; i < errEntryList.size(); ++i) {
                    String[] numberAndSeq = errEntryList.get(i).toString().split("\\|");
                    String number = numberAndSeq[0];
                    String seq = numberAndSeq[1];
                    if (list.contains(number)) continue;
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.SETTLEMENTRELATION_AUDIT_ERR_ENTRY", (Object[])new Object[]{number, seq})).append("\n");
                }
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                MsgBox.showWarning((String)msg.toString());
                this.setOprtState(OprtState.EDIT);
            } else {
                this.setOprtState(OprtState.VIEW);
            }
        }
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        if (this.editData.getBaseStatus() != SettlementStatusEnum.AUDITED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.NotUnAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        Map map = SettlementRelationFactory.getRemoteInstance().batchUnAudit(new String[]{pk.toString()});
        if (map != null) {
            StringBuffer msg = new StringBuffer();
            if (map.get("errNumber") != null) {
                List list = (List)map.get("errNumber");
                for (int i = 0; i < list.size(); ++i) {
                    String number = list.get(i).toString();
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.NoAudit_Cant_unAudit", (Object[])new Object[]{number})).append("\n");
                }
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                MsgBox.showWarning((String)msg.toString());
            } else {
                this.btnEdit.setEnabled(true);
            }
        }
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkDataBeforeSave();
        this.storeFields();
        IObjectPK pk = SettlementRelationFactory.getRemoteInstance().save((CoreBaseInfo)this.editData);
        this.setSaved(true);
        this.showSaveSuccess();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            int size = this.idList.size();
            this.idList.add(size, pk.toString());
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject(this.getValue(pk));
        this.loadFields();
    }

    private void checkDataBeforeSave() {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((String)this.getResource("Number_Not_Null", null));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((String)this.getResource("Name_Not_Null", null));
            SysUtil.abort();
        }
        if (this.prmtBizType.getValue() == null) {
            MsgBox.showWarning((String)this.getResource("BizType_Not_Null", null));
            SysUtil.abort();
        }
        if (this.prmtSupCompanyOrg.getValue() == null) {
            MsgBox.showWarning((String)this.getResource("SupCompany_Not_Null", null));
            SysUtil.abort();
        }
        if (this.prmtReqCompanyOrg.getValue() == null) {
            MsgBox.showWarning((String)this.getResource("ReqCompany_Not_Null", null));
            SysUtil.abort();
        }
        if (((CompanyOrgUnitInfo)this.prmtSupCompanyOrg.getValue()).getId().toString().equals(((CompanyOrgUnitInfo)this.prmtReqCompanyOrg.getValue()).getId().toString())) {
            MsgBox.showWarning((String)this.getResource("SupCompany_NoEquals_ReqCompany", null));
            SysUtil.abort();
        }
        this.checkEntryData();
    }

    private void checkEntryData() {
        int i;
        int rowCount = this.getDetailTable().getRowCount();
        for (i = rowCount - 1; i >= 0; --i) {
            if (this.getDetailTable().getCell(i, "proCompanyOrg").getValue() != null) continue;
            this.removeLine(this.getDetailTable(), i);
        }
        rowCount = this.getDetailTable().getRowCount();
        if (rowCount == 0) {
            this.addLine(this.getDetailTable());
            rowCount = 1;
        }
        for (i = 0; i < rowCount; ++i) {
            if (this.getDetailTable().getCell(i, "accCompanyOrg").getValue() == null) {
                MsgBox.showWarning((String)this.getResource("AccCompany_Not_Null", new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (this.getDetailTable().getCell(i, "settlementRule").getValue() == null) {
                MsgBox.showWarning((String)this.getResource("SettlementRule_Not_Null", new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (i != rowCount - 1) continue;
            CompanyOrgUnitInfo accCompanyOrg = (CompanyOrgUnitInfo)this.getDetailTable().getCell(i, "accCompanyOrg").getValue();
            CompanyOrgUnitInfo reqCompanyOrg = (CompanyOrgUnitInfo)this.prmtReqCompanyOrg.getValue();
            if (accCompanyOrg.getId().toString().equals(reqCompanyOrg.getId().toString())) continue;
            MsgBox.showWarning((String)this.getResource("EntryAppAndAcc_MustEquals_BillSupAndReq", null));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            if (this.getDetailTable().getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.getDetailTable()) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.getDetailTable());
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private String getResource(String key, Object[] o) {
        if (o == null) {
            return EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource", (String)key);
        }
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource", (String)key, (Object[])o);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        SettlementRelationInfo info = (SettlementRelationInfo)newData;
        info.setBaseStatus(SettlementStatusEnum.NEW);
        info.setName(null);
        info.setNumber(null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals("VIEW")) {
            this.checkCanEdit();
        }
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanEdit() {
        if (this.editData == null || this.editData.getId() == null) {
            SysUtil.abort();
        } else {
            int baseStatusValue;
            SettlementStatusEnum baseStatus = this.editData.getBaseStatus();
            if (baseStatus != null && (baseStatusValue = baseStatus.getValue()) == 2) {
                MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BillStatusCantBeEdited", (String[])new String[]{baseStatus.getAlias()}));
                SysUtil.abort();
            }
        }
    }
}

