/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.scm.common.ISettlementRelation;
import com.kingdee.eas.basedata.scm.common.SettlementRelationFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRelationInfo;
import com.kingdee.eas.basedata.scm.common.SettlementStatusEnum;
import com.kingdee.eas.basedata.scm.common.client.AbstractSettlementRelationListUI;
import com.kingdee.eas.basedata.scm.common.client.SettlementRelationEditUI;
import com.kingdee.eas.basedata.scm.common.client.SettlementRelationFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettlementRelationListUI
extends AbstractSettlementRelationListUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementRelationListUI.class);
    public CommonQueryDialog conditionDialog = null;
    public SettlementRelationFilterUI conditionPanel = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return SettlementRelationEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementRelationFactory.getRemoteInstance();
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = new String[]{"name", "number", "description", "baseStatus", "bizType.name", "supCompanyOrg.name", "reqCompanyOrg.name", "rowType.name", "materialGroupStandard.name", "materialGroup.name"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        super.onLoad();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.conditionDialog = super.initCommonQueryDialog();
            this.conditionDialog.setWidth(650);
            this.conditionDialog.setHeight(250);
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.conditionDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.conditionDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.conditionDialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SettlementRelationFilterUI();
        }
        return this.conditionPanel;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        Map map = ((ISettlementRelation)this.getBizInterface()).batchAudit(ids);
        if (map != null) {
            StringBuffer msg = new StringBuffer();
            if (map.get("errNumber") != null || map.get("errNumberAndSeq") != null) {
                List list = (List)map.get("errNumber");
                for (int i = 0; i < list.size(); ++i) {
                    String number = list.get(i).toString();
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.NoSave_Cant_Audit", (Object[])new Object[]{number})).append("\n");
                }
                List errEntryList = (List)map.get("errNumberAndSeq");
                for (int i = 0; i < errEntryList.size(); ++i) {
                    String[] numberAndSeq = errEntryList.get(i).toString().split("\\|");
                    String number = numberAndSeq[0];
                    String seq = numberAndSeq[1];
                    if (list.contains(number)) continue;
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.SETTLEMENTRELATION_AUDIT_ERR_ENTRY", (Object[])new Object[]{number, seq})).append("\n");
                }
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Has_errMsg"), (String)msg.toString(), (int)0);
            }
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        Map map = ((ISettlementRelation)this.getBizInterface()).batchUnAudit(ids);
        if (map != null) {
            StringBuffer msg = new StringBuffer();
            if (map.get("errNumber") != null) {
                List list = (List)map.get("errNumber");
                for (int i = 0; i < list.size(); ++i) {
                    String number = list.get(i).toString();
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.NoAudit_Cant_unAudit", (Object[])new Object[]{number})).append("\n");
                }
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Has_errMsg"), (String)msg.toString(), (int)0);
            }
        }
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
            Map map = ((ISettlementRelation)this.getBizInterface()).batchDelete(ids);
            if (map != null) {
                StringBuffer msg = new StringBuffer();
                if (map.get("errNumber") != null) {
                    List list = (List)map.get("errNumber");
                    for (int i = 0; i < list.size(); ++i) {
                        String number = list.get(i).toString();
                        msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.NoSave_Cant_Delete", (Object[])new Object[]{number})).append("\n");
                    }
                }
                if (!StringUtils.isEmpty((String)msg.toString())) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Has_errMsg"), (String)msg.toString(), (int)0);
                }
            }
            this.refresh(e);
        }
    }

    protected String getEditUIModal() {
        return super.getEditUIModal();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SettlementRelationInfo info = SettlementRelationFactory.getRemoteInstance().getSettlementRelationInfo((IObjectPK)new ObjectUuidPK(id));
        this.checkCanEdit(info);
        super.actionEdit_actionPerformed(e);
    }

    protected void checkCanEdit(SettlementRelationInfo billInfo) throws Exception {
        if (billInfo.getBaseStatus().equals((Object)SettlementStatusEnum.AUDITED)) {
            MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BillStatusCantBeEdited", (String[])new String[]{billInfo.getBaseStatus().getAlias()}));
            SysUtil.abort();
        }
    }
}

