/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.ISettlementRule;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.common.SettlementBizException;
import com.kingdee.eas.basedata.scm.common.SettlementCurrencyEnum;
import com.kingdee.eas.basedata.scm.common.SettlementRelationEntryCollection;
import com.kingdee.eas.basedata.scm.common.SettlementRelationEntryFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRuleEntryInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRuleFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRuleInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRulePriceRuleEnum;
import com.kingdee.eas.basedata.scm.common.SettlementStatusEnum;
import com.kingdee.eas.basedata.scm.common.client.AbstractSettlementRuleEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SettlementRuleEditUI
extends AbstractSettlementRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementRuleEditUI.class);
    private DataChangeListener prmtMaterialGroupStandardChangeListener;
    private KDTEditListener kdtEditListener;

    public SettlementRuleEditUI() throws Exception {
        this.kdtEntries.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        SettlementRuleInfo info = new SettlementRuleInfo();
        info.setBaseStatus(SettlementStatusEnum.NEW);
        info.getEntries().add((SettlementRuleEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementRuleFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        super.onLoad();
        this.initEntryEditor();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfoCU);
        this.prmtMaterialGroupStandard.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialGroupStandardQuery");
        this.prmtMaterialGroupStandard.setEditFormat("$number$");
        this.prmtMaterialGroupStandard.setDisplayFormat("$name$");
        this.prmtMaterialGroupStandard.setCommitFormat("$number$");
        this.prmtMaterialGroupStandard.setEntityViewInfo(viewInfo);
    }

    private void initEntryEditor() {
        KDBizPromptBox prmtMaterialGroup = new KDBizPromptBox();
        prmtMaterialGroup.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialGroupQuery");
        prmtMaterialGroup.setEditFormat("$number$");
        prmtMaterialGroup.setDisplayFormat("$name$");
        prmtMaterialGroup.setCommitFormat("$number$");
        this.kdtEntries.getColumn("materialGroup").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMaterialGroup));
        KDBizPromptBox prmtRowType = new KDBizPromptBox();
        prmtRowType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.RowTypeQuery");
        prmtRowType.setEditFormat("$number$");
        prmtRowType.setDisplayFormat("$name$");
        prmtRowType.setCommitFormat("$number$");
        this.kdtEntries.getColumn("rowType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtRowType));
        KDBizPromptBox prmtMaterial = new KDBizPromptBox();
        prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        prmtMaterial.setEditFormat("$number$");
        prmtMaterial.setDisplayFormat("$name$");
        prmtMaterial.setCommitFormat("$number$");
        ObjectValueRender avrAssPro = new ObjectValueRender();
        avrAssPro.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("material").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMaterial));
        this.kdtEntries.getColumn("material").setRenderer((IBasicRender)avrAssPro);
        KDFormattedTextField additionRateTextFiled = this.getNewDecimalFormatTxtField(2, true);
        this.kdtEntries.getColumn("additionRate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)additionRateTextFiled));
        KDFormattedTextField addConstantPriceTextFiled = this.getNewDecimalFormatTxtField(6, true);
        this.kdtEntries.getColumn("addConstantPrice").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)addConstantPriceTextFiled));
        KDComboBox priceRuleComboBox = this.getComboBox("com.kingdee.eas.basedata.scm.common.SettlementRulePriceRuleEnum");
        this.kdtEntries.getColumn("priceRule").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)priceRuleComboBox));
        KDComboBox currencySourceComboBox = this.getComboBox("com.kingdee.eas.basedata.scm.common.SettlementCurrencyEnum");
        this.kdtEntries.getColumn("currencySource").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)currencySourceComboBox));
        this.kdtEntries.getColumn("isInTax").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this.getNewKDCheckBox(true)));
        this.kdtEntries.getColumn("isPresent").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this.getNewKDCheckBox(false)));
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        this.editData = (SettlementRuleInfo)ov;
        super.setDataObject(ov);
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.addListeners();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
        } else if (this.editData.getBaseStatus().equals((Object)SettlementStatusEnum.SAVED)) {
            this.btnAudit.setEnabled(true);
            this.btnUnAudit.setEnabled(false);
            this.btnRemove.setEnabled(true);
            if ("VIEW".equals(this.getOprtState())) {
                this.btnRemoveLine.setEnabled(false);
                this.btnAddLine.setEnabled(false);
                this.btnEdit.setEnabled(true);
            } else {
                this.btnRemoveLine.setEnabled(true);
                this.btnAddLine.setEnabled(true);
                this.btnEdit.setEnabled(false);
            }
        } else if (this.editData.getBaseStatus().equals((Object)SettlementStatusEnum.AUDITED)) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(true);
            this.btnRemove.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
            this.appendFootRow(this.getDetailTable());
            if (this.getDetailTable().getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != this.getDetailTable()) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)this.getDetailTable());
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        if (detailData != null) {
            IRow row = table.addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    private IObjectValue createNewDetailData(KDTable table) {
        SettlementRuleEntryInfo ruleEntryInfo = new SettlementRuleEntryInfo();
        ruleEntryInfo.setPriceRule(SettlementRulePriceRuleEnum.NULL);
        ruleEntryInfo.setCurrencySource(SettlementCurrencyEnum.NULL);
        ruleEntryInfo.setIsInTax(true);
        return ruleEntryInfo;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        SettlementRuleInfo info = (SettlementRuleInfo)newData;
        info.setBaseStatus(SettlementStatusEnum.NEW);
        info.setCU(null);
        info.setName(null);
        info.setNumber(null);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.doAction("audit", "com.kingdee.eas.basedata.scm.common.SettlementResource.NoSave_Cant_Audit");
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        this.doAction("unAudit", "com.kingdee.eas.basedata.scm.common.SettlementResource.NoAudit_Cant_unAudit");
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        SettlementRelationEntryCollection srColl = SettlementRelationEntryFactory.getRemoteInstance().getSettlementRelationEntryCollection("where settlementRule.id = '" + id + "'");
        if (srColl.size() > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Rule_UsedByRelation_Cant_Delete", (Object[])new Object[]{this.editData.getNumber()});
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkDataBeforeSave();
        this.storeFields();
        IObjectPK pk = SettlementRuleFactory.getRemoteInstance().save((CoreBaseInfo)this.editData);
        this.setSaved(true);
        this.showSaveSuccess();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            int size = this.idList.size();
            this.idList.add(size, pk.toString());
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject(this.getValue(pk));
        this.loadFields();
    }

    private void checkDataBeforeSave() {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((String)this.getResource("Number_Not_Null", null));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((String)this.getResource("Name_Not_Null", null));
            SysUtil.abort();
        }
        this.checkEntryData();
    }

    private void checkEntryData() {
        int rowCount = this.kdtEntries.getRowCount();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        boolean hasDupRow = false;
        for (int i = rowCount - 1; i >= 0; --i) {
            BigDecimal addConstantPrice;
            BigDecimal additionRate;
            SettlementCurrencyEnum currencySource;
            MaterialInfo material;
            MaterialGroupInfo materialGroup;
            boolean isNeedDelRow = true;
            String rowTypeID = "";
            String materialGroupID = "";
            String materialID = "";
            RowTypeInfo rowType = (RowTypeInfo)this.kdtEntries.getCell(i, "rowType").getValue();
            if (rowType != null) {
                rowTypeID = rowType.getId().toString();
                isNeedDelRow = false;
            }
            if ((materialGroup = (MaterialGroupInfo)this.kdtEntries.getCell(i, "materialGroup").getValue()) != null) {
                materialGroupID = materialGroup.getId().toString();
                isNeedDelRow = false;
            }
            if ((material = (MaterialInfo)this.kdtEntries.getCell(i, "material").getValue()) != null) {
                materialID = material.getId().toString();
                isNeedDelRow = false;
            }
            String idStr = rowTypeID + "|" + materialGroupID + "|" + materialID;
            SettlementRulePriceRuleEnum priceRule = (SettlementRulePriceRuleEnum)((Object)this.kdtEntries.getCell(i, "priceRule").getValue());
            if (!priceRule.equals((Object)SettlementRulePriceRuleEnum.NULL)) {
                isNeedDelRow = false;
            }
            if (!(currencySource = (SettlementCurrencyEnum)((Object)this.kdtEntries.getCell(i, "currencySource").getValue())).equals((Object)SettlementCurrencyEnum.NULL)) {
                isNeedDelRow = false;
            }
            if ((additionRate = (BigDecimal)this.kdtEntries.getCell(i, "additionRate").getValue()) != null && additionRate.compareTo(BigDecimal.ZERO) != 0) {
                isNeedDelRow = false;
            }
            if ((addConstantPrice = (BigDecimal)this.kdtEntries.getCell(i, "addConstantPrice").getValue()) != null && addConstantPrice.compareTo(BigDecimal.ZERO) != 0) {
                isNeedDelRow = false;
            }
            if (isNeedDelRow) {
                this.kdtEntries.removeRow(i);
                continue;
            }
            if (!map.containsKey(idStr)) {
                map.put(idStr, i);
                continue;
            }
            hasDupRow = true;
        }
        if (hasDupRow) {
            MsgBox.showWarning((String)this.getResource("Rule_Has_DupRow", null));
            SysUtil.abort();
        }
        MaterialGroupStandardInfo standardInfo = (MaterialGroupStandardInfo)this.prmtMaterialGroupStandard.getValue();
        rowCount = this.kdtEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            SettlementCurrencyEnum currencySource;
            SettlementRulePriceRuleEnum priceRule = (SettlementRulePriceRuleEnum)((Object)this.kdtEntries.getCell(i, "priceRule").getValue());
            if (priceRule.equals((Object)SettlementRulePriceRuleEnum.NULL)) {
                MsgBox.showWarning((String)this.getResource("Rule_PriceRule_NotNull", new Object[]{i + 1}));
                SysUtil.abort();
            }
            MaterialGroupInfo materialGroup = (MaterialGroupInfo)this.kdtEntries.getCell(i, "materialGroup").getValue();
            if (standardInfo != null && materialGroup == null) {
                MsgBox.showWarning((String)this.getResource("Rule_MaterialGroup_NotNull", new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (!(currencySource = (SettlementCurrencyEnum)((Object)this.kdtEntries.getCell(i, "currencySource").getValue())).equals((Object)SettlementCurrencyEnum.NULL)) continue;
            MsgBox.showWarning((String)this.getResource("Rule_CurrencySource_NotNull", new Object[]{i + 1}));
            SysUtil.abort();
        }
    }

    private void addListeners() {
        if (this.prmtMaterialGroupStandardChangeListener == null) {
            this.prmtMaterialGroupStandardChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SettlementRuleEditUI.this.materialGroupStandardChanged(eventObj);
                }
            };
        }
        this.prmtMaterialGroupStandard.addDataChangeListener(this.prmtMaterialGroupStandardChangeListener);
        if (this.kdtEditListener == null) {
            this.kdtEditListener = new KDTEditListener(){

                public void editValueChanged(KDTEditEvent e) {
                }

                public void editStopping(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    SettlementRuleEditUI.this.tableEditStopped(e);
                }

                public void editStarting(KDTEditEvent e) {
                    SettlementRuleEditUI.this.tableEditStarting(e);
                }

                public void editStarted(KDTEditEvent e) {
                }

                public void editCanceled(KDTEditEvent e) {
                }
            };
        }
        this.kdtEntries.addKDTEditListener(this.kdtEditListener);
    }

    protected void tableEditStopped(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int priceRuleIndex = this.kdtEntries.getColumnIndex("priceRule");
        int currencySourceIndex = this.kdtEntries.getColumnIndex("currencySource");
        if (colIndex == priceRuleIndex) {
            SettlementRulePriceRuleEnum priceRuleEnum = (SettlementRulePriceRuleEnum)((Object)this.kdtEntries.getCell(rowIndex, priceRuleIndex).getValue());
            if (priceRuleEnum.equals((Object)SettlementRulePriceRuleEnum.NULL)) {
                this.kdtEntries.getCell(rowIndex, currencySourceIndex).setValue((Object)SettlementCurrencyEnum.NULL);
            } else if (priceRuleEnum.equals((Object)SettlementRulePriceRuleEnum.ProOrgSalesPricePolicy)) {
                this.kdtEntries.getCell(rowIndex, currencySourceIndex).setValue((Object)SettlementCurrencyEnum.pricePolicyCurrency);
            } else if (priceRuleEnum.equals((Object)SettlementRulePriceRuleEnum.OrderPrice)) {
                this.kdtEntries.getCell(rowIndex, currencySourceIndex).setValue((Object)SettlementCurrencyEnum.orderCurrency);
            } else if (priceRuleEnum.equals((Object)SettlementRulePriceRuleEnum.SettlementCost)) {
                this.kdtEntries.getCell(rowIndex, currencySourceIndex).setValue((Object)SettlementCurrencyEnum.baseCurrency);
            }
        }
    }

    protected void tableEditStarting(KDTEditEvent e) {
        BigDecimal additionRate;
        BigDecimal addConstantPrice;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int materialGroupIndex = this.kdtEntries.getColumnIndex("materialGroup");
        int materialIndex = this.kdtEntries.getColumnIndex("material");
        int additionRateIndex = this.kdtEntries.getColumnIndex("additionRate");
        int addConstantPriceIndex = this.kdtEntries.getColumnIndex("addConstantPrice");
        int currencySourceIndex = this.kdtEntries.getColumnIndex("currencySource");
        MaterialGroupStandardInfo standardInfo = (MaterialGroupStandardInfo)this.prmtMaterialGroupStandard.getValue();
        if (colIndex == materialGroupIndex) {
            if (standardInfo != null) {
                FilterInfo filter = new FilterInfo();
                EntityViewInfo view = new EntityViewInfo();
                filter.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)standardInfo.getId().toString()));
                view.setFilter(filter);
                ((KDBizPromptBox)this.kdtEntries.getColumn(materialGroupIndex).getEditor().getComponent()).setEntityViewInfo(view);
            } else {
                e.setCancel(true);
                return;
            }
        }
        if (colIndex == materialIndex && standardInfo != null) {
            e.setCancel(true);
            return;
        }
        if (colIndex == additionRateIndex && (addConstantPrice = (BigDecimal)this.kdtEntries.getCell(rowIndex, addConstantPriceIndex).getValue()) != null && addConstantPrice.compareTo(BigDecimal.ZERO) != 0) {
            e.setCancel(true);
            return;
        }
        if (colIndex == addConstantPriceIndex && (additionRate = (BigDecimal)this.kdtEntries.getCell(rowIndex, additionRateIndex).getValue()) != null && additionRate.compareTo(BigDecimal.ZERO) != 0) {
            e.setCancel(true);
            return;
        }
        if (colIndex == currencySourceIndex) {
            e.setCancel(true);
            return;
        }
    }

    protected void materialGroupStandardChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                this.kdtEntries.getCell(i, "materialGroup").setValue(null);
            }
        } else {
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                this.kdtEntries.getCell(i, "material").setValue(null);
            }
        }
    }

    private void removeListeners() {
        if (this.prmtMaterialGroupStandardChangeListener != null) {
            this.prmtMaterialGroupStandard.removeDataChangeListener(this.prmtMaterialGroupStandardChangeListener);
        }
        if (this.kdtEditListener != null) {
            this.kdtEntries.removeKDTEditListener(this.kdtEditListener);
        }
    }

    protected KDFormattedTextField getNewDecimalFormatTxtField(int amtPrecision, boolean canMinus) {
        KDFormattedTextField txtField = new KDFormattedTextField(1);
        txtField.setPrecision(amtPrecision);
        txtField.setNegatived(canMinus);
        txtField.setSupportedEmpty(true);
        txtField.setHorizontalAlignment(4);
        return txtField;
    }

    protected KDComboBox getComboBox(String enumClass) {
        KDComboBox comboBox = new KDComboBox();
        comboBox.addItems(EnumUtils.getEnumList((String)enumClass).toArray());
        return comboBox;
    }

    protected KDCheckBox getNewKDCheckBox(boolean isSelected) {
        KDCheckBox checkBox = new KDCheckBox();
        checkBox.setSelected(isSelected);
        return checkBox;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals("VIEW")) {
            this.checkCanEdit();
        }
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanEdit() throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            SysUtil.abort();
        } else {
            CtrlUnitInfo cu;
            int baseStatusValue;
            SettlementStatusEnum baseStatus = this.editData.getBaseStatus();
            if (baseStatus != null && (baseStatusValue = baseStatus.getValue()) == 2) {
                MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BillStatusCantBeEdited", (String[])new String[]{baseStatus.getAlias()}));
                SysUtil.abort();
            }
            if ((cu = SysContext.getSysContext().getCurrentCtrlUnit()) != null && !this.editData.getCU().getId().toString().equals(cu.getId().toString())) {
                throw new SettlementBizException(SettlementBizException.RULE_CANT_CU);
            }
        }
    }

    private void doAction(String actionName, String errResource) throws Exception {
        String id = this.editData.getId().toString();
        Map map = null;
        if ("audit".equals(actionName)) {
            map = ((ISettlementRule)this.getBizInterface()).batchAudit(new String[]{id});
        } else if ("unAudit".equals(actionName)) {
            map = ((ISettlementRule)this.getBizInterface()).batchUnAudit(new String[]{id});
        }
        if (map != null) {
            StringBuffer msg = new StringBuffer();
            if (map.get("errNumberForCU") != null || map.get("errNumber") != null) {
                List errCUList = (List)map.get("errNumberForCU");
                for (int i = 0; i < errCUList.size(); ++i) {
                    String number = errCUList.get(i).toString();
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Rule_CU_Err", (Object[])new Object[]{number})).append("\n");
                }
                List errList = (List)map.get("errNumber");
                for (int i = 0; i < errList.size(); ++i) {
                    String number = errList.get(i).toString();
                    if (errCUList.contains(number)) continue;
                    msg.append(EASResource.getString((String)errResource, (Object[])new Object[]{number})).append("\n");
                }
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                MsgBox.showWarning((String)msg.toString());
            } else {
                this.setOprtState(OprtState.VIEW);
            }
        }
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
    }

    private String getResource(String key, Object[] o) {
        if (o == null) {
            return EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource", (String)key);
        }
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource", (String)key, (Object[])o);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.priceRule"));
        sic.add(new SelectorItemInfo("entries.currencySource"));
        sic.add(new SelectorItemInfo("entries.additionRate"));
        sic.add(new SelectorItemInfo("entries.addConstantPrice"));
        sic.add(new SelectorItemInfo("entries.isInTax"));
        sic.add(new SelectorItemInfo("entries.isPresent"));
        sic.add(new SelectorItemInfo("entries.rowType.id"));
        sic.add(new SelectorItemInfo("entries.rowType.name"));
        sic.add(new SelectorItemInfo("entries.rowType.number"));
        sic.add(new SelectorItemInfo("entries.materialGroup.id"));
        sic.add(new SelectorItemInfo("entries.materialGroup.name"));
        sic.add(new SelectorItemInfo("entries.materialGroup.number"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("materialGroupStandard.id"));
        sic.add(new SelectorItemInfo("materialGroupStandard.number"));
        sic.add(new SelectorItemInfo("materialGroupStandard.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }
}

