/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.ISettlementRule;
import com.kingdee.eas.basedata.scm.common.SettlementBizException;
import com.kingdee.eas.basedata.scm.common.SettlementRuleFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRuleInfo;
import com.kingdee.eas.basedata.scm.common.SettlementStatusEnum;
import com.kingdee.eas.basedata.scm.common.client.AbstractSettlementRuleListUI;
import com.kingdee.eas.basedata.scm.common.client.SettlementRuleEditUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettlementRuleListUI
extends AbstractSettlementRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementRuleListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected String getEditUIName() {
        return SettlementRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementRuleFactory.getRemoteInstance();
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = new String[]{"name", "number", "description", "baseStatus", "materialGroupStandard.name", "rowType.name", "CU.name"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        super.onLoad();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.doBatchAction("audit", "com.kingdee.eas.basedata.scm.common.SettlementResource.NoSave_Cant_Audit");
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        this.doBatchAction("unAudit", "com.kingdee.eas.basedata.scm.common.SettlementResource.NoAudit_Cant_unAudit");
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            this.doBatchAction("delete", "com.kingdee.eas.basedata.scm.common.SettlementResource.NoSave_Cant_Delete");
        }
    }

    private void doBatchAction(String actionName, String errResource) throws Exception {
        this.checkSelected();
        String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        Map map = null;
        if ("audit".equals(actionName)) {
            map = ((ISettlementRule)this.getBizInterface()).batchAudit(ids);
        } else if ("unAudit".equals(actionName)) {
            map = ((ISettlementRule)this.getBizInterface()).batchUnAudit(ids);
        } else if ("delete".equals(actionName)) {
            map = ((ISettlementRule)this.getBizInterface()).batchDelete(ids);
        }
        if (map != null) {
            StringBuffer msg = new StringBuffer();
            if (map.get("errNumberForCU") != null || map.get("errNumber") != null || map.get("numberForRelationUse") != null) {
                List errCUList = (List)map.get("errNumberForCU");
                for (int i = 0; i < errCUList.size(); ++i) {
                    String number = errCUList.get(i).toString();
                    msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Rule_CU_Err", (Object[])new Object[]{number})).append("\n");
                }
                List errList = (List)map.get("errNumber");
                for (int i = 0; i < errList.size(); ++i) {
                    String number = errList.get(i).toString();
                    if (errCUList.contains(number)) continue;
                    msg.append(EASResource.getString((String)errResource, (Object[])new Object[]{number})).append("\n");
                }
                if ("delete".equals(actionName)) {
                    List errRelationList = (List)map.get("numberForRelationUse");
                    for (int i = 0; i < errRelationList.size(); ++i) {
                        String number = errRelationList.get(i).toString();
                        if (errCUList.contains(number) || errList.contains(number)) continue;
                        msg.append(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Rule_UsedByRelation_Cant_Delete", (Object[])new Object[]{number})).append("\n");
                    }
                }
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SettlementResource.Has_errMsg"), (String)msg.toString(), (int)0);
            }
        }
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SettlementRuleInfo info = SettlementRuleFactory.getRemoteInstance().getSettlementRuleInfo((IObjectPK)new ObjectUuidPK(id));
        this.checkCanEdit(info);
        super.actionEdit_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void checkCanEdit(SettlementRuleInfo billInfo) throws Exception {
        CtrlUnitInfo cu;
        if (billInfo.getBaseStatus().equals((Object)SettlementStatusEnum.AUDITED)) {
            MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BillStatusCantBeEdited", (String[])new String[]{billInfo.getBaseStatus().getAlias()}));
            SysUtil.abort();
        }
        if ((cu = SysContext.getSysContext().getCurrentCtrlUnit()) != null && !billInfo.getCU().getId().toString().equals(cu.getId().toString())) {
            throw new SettlementBizException(SettlementBizException.RULE_CANT_CU);
        }
    }
}

