/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeGroupEnum;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DisplayTypeEnum;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.client.AbstractTransactionTypeListUI;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.common.client.TransactionTypeEditUI;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TransactionTypeListUI
extends AbstractTransactionTypeListUI
implements TreeSelectionListener {
    private static final long serialVersionUID = -4103809939835858018L;
    private final String RESOURCENAME = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private final String ROOTTAG = "root";
    private final String SUBTAG = "sub";
    private KDTreeNode rootTreeNode = null;
    private String currentCUID;
    public CommonQueryDialog commonQueryDialog = null;
    private static final MetaDataPK TRANSACTIONTYPE_DEFAULTQUERY = MetaDataPK.create((String)"com.kingdee.eas.basedata.scm.common.app.TransactionTypeDefaultQuery");
    private static final MetaDataPK TRANSACTIONTYPE_INVUPDATETYPEQUERY = MetaDataPK.create((String)"com.kingdee.eas.basedata.scm.common.app.TransInvUpdateTypeQuery");
    private static final MetaDataPK TRANSACTIONTYPE_BIZTYPEQUERY = MetaDataPK.create((String)"com.kingdee.eas.basedata.scm.common.app.TransBizTypeQuery");
    private boolean hasChange = false;
    private final String[] invUpdateTypeFields = new String[]{"defaults", "invUpdateType.number", "invUpdateType.name", "existingQtyPre", "StoreTypePre", "StoreStatePre", "existingQty", "StoreType", "StoreState", "isNotUpdateInv", "invUpdateType.description"};
    private final String[] bizTypeFields = new String[]{"bizType.number", "bizType.name", "bizType.description", "bizType.scheduled", "bizType.selfmade"};
    FilterInfo selectNodeFilterInfo = null;
    EntityViewInfo defaultSolution = null;

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.setControlDisable();
        this.initKDTreeMain((JTree)this.kdTreeMain);
        this.kdTreeMain.addTreeSelectionListener((TreeSelectionListener)this);
        this.kdTreeMain.setSelectionNode((DefaultKingdeeTreeNode)this.rootTreeNode);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.btnUpgrade.setIcon(EASResource.getIcon((String)"imgTbtn_checkstart"));
        this.btnOpenMapUI.setIcon(EASResource.getIcon((String)"imgTbtn_organiselist"));
        this.addListener();
        this.setDisplayColumn(DisplayTypeEnum.TransactionType);
        this.displayType.setSelectedIndex(0);
        this.commonQueryDialog = super.initCommonQueryDialog();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tHelper.setUserPreferenceData(null);
    }

    private MetaDataPK getMainQuery(DisplayTypeEnum type) {
        if (DisplayTypeEnum.TransactionType.equals(this.displayType.getSelectedItem())) {
            return TRANSACTIONTYPE_DEFAULTQUERY;
        }
        if (DisplayTypeEnum.InvUpdateType.equals(this.displayType.getSelectedItem())) {
            return TRANSACTIONTYPE_INVUPDATETYPEQUERY;
        }
        if (DisplayTypeEnum.BizType.equals(this.displayType.getSelectedItem())) {
            return TRANSACTIONTYPE_BIZTYPEQUERY;
        }
        return null;
    }

    private void addListener() {
        this.displayType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TransactionTypeListUI.this.mainQueryPK = (IMetaDataPK)TransactionTypeListUI.this.getMainQuery((DisplayTypeEnum)((Object)TransactionTypeListUI.this.displayType.getSelectedItem()));
                TransactionTypeListUI.this.mainQuery = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                TransactionTypeListUI.this.mainQuery.setFilter(filterInfo);
                TransactionTypeListUI.this.setMainQueryEntityView();
                TransactionTypeListUI.this.hasChange = true;
                TransactionTypeListUI.this.commonQueryDialog = TransactionTypeListUI.this.getDialog();
                if (TransactionTypeListUI.this.commonQueryDialog != null && TransactionTypeListUI.this.mainQueryPK != null) {
                    try {
                        TransactionTypeListUI.this.commonQueryDialog.setQueryObjectPK(TransactionTypeListUI.this.mainQueryPK);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                TransactionTypeListUI.this.setDisplayColumn((DisplayTypeEnum)((Object)TransactionTypeListUI.this.displayType.getSelectedItem()));
                TransactionTypeListUI.this.execQuery();
                new Thread(){

                    @Override
                    public void run() {
                        TransactionTypeListUI.this.tHelper.findAllTables(null);
                        TransactionTypeListUI.this.tHelper.setQuerySolutionInfo(null);
                        TransactionTypeListUI.this.tHelper.setUserPreferenceData(null);
                        TransactionTypeListUI.this.tHelper.setDefaultUserData(TransactionTypeListUI.this.tHelper.getUserDataFromUI());
                    }
                }.start();
            }
        });
    }

    private void setDisplayColumn(DisplayTypeEnum type) {
        String[] invUpdTypeFields = this.getInvUpdateTypeFields();
        String[] bizTypeFields = this.getBizTypeFields();
        if (DisplayTypeEnum.TransactionType.equals((Object)type)) {
            int i;
            int len = invUpdTypeFields.length;
            for (i = 0; i < len; ++i) {
                this.tblMain.getColumn(invUpdTypeFields[i]).getStyleAttributes().setHided(true);
            }
            len = bizTypeFields.length;
            for (i = 0; i < len; ++i) {
                this.tblMain.getColumn(bizTypeFields[i]).getStyleAttributes().setHided(true);
            }
        } else {
            int i;
            boolean isHiden = DisplayTypeEnum.InvUpdateType.equals((Object)type);
            int len = invUpdTypeFields.length;
            for (i = 0; i < len; ++i) {
                this.tblMain.getColumn(invUpdTypeFields[i]).getStyleAttributes().setHided(!isHiden);
            }
            len = bizTypeFields.length;
            for (i = 0; i < len; ++i) {
                this.tblMain.getColumn(bizTypeFields[i]).getStyleAttributes().setHided(isHiden);
            }
        }
    }

    private String[] getInvUpdateTypeFields() {
        return this.invUpdateTypeFields;
    }

    private String[] getBizTypeFields() {
        return this.bizTypeFields;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.mainQueryPK = this.getMainQuery((DisplayTypeEnum)((Object)this.displayType.getSelectedItem()));
        super.tblMain_tableClicked(e);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "name", "billType.name", "RIType", "rI", "isWriteOff", "isCalculate", "isManuCostCalculate", "Scheduled", "status", "cu", "description"};
    }

    private void setControlDisable() {
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnEdit.setEnabled(true);
        this.btnRemove.setEnabled(true);
    }

    private boolean initKDTreeMain(JTree kdTree) throws Exception {
        kdTree.setModel(new DefaultTreeModel((TreeNode)this.createRootNode()));
        kdTree.setShowsRootHandles(true);
        this.expandAll(kdTree, new TreePath(this.rootTreeNode));
        return true;
    }

    private DefaultKingdeeTreeNode createRootNode() throws Exception {
        BillTypeInfo rootBillTypeInfo = new BillTypeInfo();
        rootBillTypeInfo.setNumber(this.ROOTTAG);
        rootBillTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource", (String)"transactionTypeRoot"));
        this.rootTreeNode = new KDTreeNode((Object)rootBillTypeInfo);
        for (BillTypeGroupEnum billTypeValue : BillTypeGroupEnum.getEnumList()) {
            if (billTypeValue.getValue() != 12) continue;
            BillTypeInfo subBillTypeInfo = new BillTypeInfo();
            subBillTypeInfo.setNumber(this.SUBTAG);
            subBillTypeInfo.setName(billTypeValue.getAlias());
            subBillTypeInfo.setBillTypeGroup(billTypeValue);
            KDTreeNode subTreeNode = new KDTreeNode((Object)subBillTypeInfo);
            this.addChildrenToNode(billTypeValue, subTreeNode);
            this.rootTreeNode.add((MutableTreeNode)subTreeNode);
        }
        return this.rootTreeNode;
    }

    private void expandAll(JTree tree, TreePath parent) {
        KDTreeNode node = (KDTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                KDTreeNode n = (KDTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private void addChildrenToNode(BillTypeGroupEnum billTypeGroupEnum, KDTreeNode treeNode) throws Exception {
        IBillType iBillType = BillTypeFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billTypeGroup", (Object)new Integer(billTypeGroupEnum.getValue()), CompareType.EQUALS));
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.setFilter(filterInfo);
        BillTypeCollection collection = iBillType.getBillTypeCollection(entityView);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                BillTypeInfo aBillTypeInfo = collection.get(i);
                KDTreeNode childrenNode = new KDTreeNode((Object)aBillTypeInfo);
                treeNode.add((MutableTreeNode)childrenNode);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TransactionTypeFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return TransactionTypeEditUI.class.getName();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.transactionTypeRoot");
    }

    private void setMainQueryEntityView() {
        TreePath treePath = this.kdTreeMain.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
        BillTypeInfo billTypeInfo = (BillTypeInfo)node.getUserObject();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        this.selectNodeFilterInfo = new FilterInfo();
        entityViewInfo.setFilter(this.selectNodeFilterInfo);
        if (billTypeInfo.getNumber().equals(this.ROOTTAG)) {
            this.mainQuery = entityViewInfo;
            return;
        }
        if (billTypeInfo.getNumber().equals(this.SUBTAG)) {
            entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("billType.billTypeGroup", (Object)new Integer(billTypeInfo.getBillTypeGroup().getValue()), CompareType.EQUALS));
        } else {
            entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeInfo.getId(), CompareType.EQUALS));
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        if (this.isFirstOnload()) {
            try {
                if (viewInfo.getFilter().getFilterItems().size() == 0) {
                    QuerySolutionInfo solution = this.getCurrentSolutionInfo();
                    String viewStr = solution.getEntityViewInfo();
                    EntityViewInfo view = new EntityViewInfo();
                    if (viewStr != null && !viewStr.equals("")) {
                        this.defaultSolution = Util.getInnerFilterInfo((QuerySolutionInfo)solution);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        FilterInfo commonFilter = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(this.selectNodeFilterInfo);
        if (this.commonQueryDialog != null) {
            commonFilter = this.getDialog().getCommonFilter();
        }
        try {
            if (this.hasChange) {
                commonFilter = entityViewInfo.getFilter();
            } else if (commonFilter == null) {
                commonFilter = entityViewInfo.getFilter();
            } else {
                commonFilter.mergeFilter(entityViewInfo.getFilter(), "AND");
            }
            this.mainQuery.setFilter(commonFilter);
            if (this.defaultSolution != null) {
                this.mainQuery.getFilter().mergeFilter(this.defaultSolution.getFilter(), "and");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return exec;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kdTreeMain.getLastSelectedPathComponent();
        BillTypeInfo aBillTypeInfo = (BillTypeInfo)node.getUserObject();
        if (!aBillTypeInfo.getNumber().equals(this.ROOTTAG) && !aBillTypeInfo.getNumber().equals(this.SUBTAG)) {
            uiContext.put((Object)"BillType", (Object)aBillTypeInfo);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.defaultSolution = null;
        this.hasChange = false;
        this.setMainQueryPK(this.getMainQueryPK());
        super.actionQuery_actionPerformed(e);
    }

    public IMetaDataPK getMainQueryPK() {
        this.setDisplayColumn((DisplayTypeEnum)((Object)this.displayType.getSelectedItem()));
        this.mainQueryPK = this.getMainQuery((DisplayTypeEnum)((Object)this.displayType.getSelectedItem()));
        return this.getMainQuery((DisplayTypeEnum)((Object)this.displayType.getSelectedItem()));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        EntityControlTypeUtil.checkCanAddnew((String)"S3", (String)this.currentCUID);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kdTreeMain.getLastSelectedPathComponent();
        if (node == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCENAME, (String)"mustSelectNode"));
        } else {
            BillTypeInfo aBillTypeInfo = (BillTypeInfo)node.getUserObject();
            if (aBillTypeInfo.getNumber().equals(this.ROOTTAG) || aBillTypeInfo.getNumber().equals(this.SUBTAG)) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCENAME, (String)"canNotTransactionBill"));
            } else {
                super.actionAddNew_actionPerformed(e);
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            ITransactionType iTransactionType = TransactionTypeFactory.getRemoteInstance();
            TransactionTypeInfo aTransactionTypeInfo = iTransactionType.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(strId));
            String cuid = BDInvClientUtils.getCUID(aTransactionTypeInfo);
            if (cuid != null) {
                EntityControlTypeUtil.checkCanRemove((String)"S3", (String)this.currentCUID, (String)cuid);
            }
            if (aTransactionTypeInfo.isScheduled()) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.SystemSettingDel");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
            if (aTransactionTypeInfo.getStatus().getValue() != 0) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource", (String)"UnSaveTranType_Cannt_Remove");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            ITransactionType iTransactionType = TransactionTypeFactory.getRemoteInstance();
            TransactionTypeInfo aTransactionTypeInfo = iTransactionType.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(strId));
            String cuid = BDInvClientUtils.getCUID(aTransactionTypeInfo);
            if (cuid != null) {
                EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
            }
            if (aTransactionTypeInfo.getStatus().getValue() == 1) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource", (String)"ActiveTranType_Cannt_Modify");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        if (arg0.getNewLeadSelectionPath() != null) {
            try {
                this.setMainQueryEntityView();
                this.refresh(null);
                this.setControlDisable();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setDisplayColumn((DisplayTypeEnum)((Object)this.displayType.getSelectedItem()));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this._actionCancelOrCancelCancel(false, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this._actionCancelOrCancelCancel(true, e);
    }

    private void _actionCancelOrCancelCancel(boolean active, ActionEvent e) throws Exception {
        this.checkSelected();
        ITransactionType iTransactionType = TransactionTypeFactory.getRemoteInstance();
        ArrayList ids = this.getSelectedIdValues();
        boolean isNotCUEnable = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        TransactionTypeCollection col = iTransactionType.getTransactionTypeCollection(view);
        TransactionTypeInfo transactionType = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                transactionType = col.get(i);
                String cu = transactionType.getCU() != null ? transactionType.getCU().getId().toString() : null;
                map.put(transactionType.getNumber(), transactionType.getName());
                if (this.currentCUID.equals(cu)) continue;
                isNotCUEnable = true;
            }
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        String message = null;
        ArrayList errors = null;
        StringBuffer errMsg = new StringBuffer();
        String forbidError = null;
        String logItemName = null;
        String methodName = null;
        if (active) {
            errors = iTransactionType.setActive(ids);
            message = "TranType_Active_OK";
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Start_Error");
            methodName = ResourceUtil.getMessage(null, (String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"enable", null);
            logItemName = "im_transactionType_enable";
        } else {
            errors = iTransactionType.setInactive(ids);
            message = "TranType_Inactive_OK";
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Forbid_Error");
            methodName = ResourceUtil.getMessage(null, (String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"disable", null);
            logItemName = "im_transactionType_disable";
        }
        if (errors != null && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            message = active ? "TranType_Active_FAIL" : "TranType_Inactive_FAIL";
        }
        if (errMsg.toString().length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)forbidError, (String)errMsg.toString(), (int)8188);
        }
        this.refresh(e);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource", (String)message));
        this.showMessage();
    }

    protected boolean isMutiRemove() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionOpenMapUI_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUpgraded = TransactionTypeFactory.getRemoteInstance().isUpgraded();
        if (!isUpgraded.booleanValue()) {
            throw new InvException(InvException.TRANSACTIONTYPE_NOT_MERGE);
        }
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        String mapUI = "com.kingdee.eas.basedata.scm.common.client.TransactionTypeMapUI";
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(mapUI, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(mapUI, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        String str = null;
        str = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.client.CommonResource", (String)"Confirm_TransactionType_Upgrade");
        int ret = MsgBox.showConfirm2((String)(str = str.replace("\\n", "\n")));
        if (ret == 0) {
            TransactionTypeFactory.getRemoteInstance().upgrade();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.client.CommonResource", (String)"TransactionType_Upgrade_Success"));
            this.refresh(null);
        }
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.tblMain.getInputMap(2);
        ActionMap actionMap = this.tblMain.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(77, 3), "actionShowUpgradeBtn");
        actionMap.put("actionShowUpgradeBtn", (Action)((Object)this.actionShowUpgradeBtn));
        this.actionShowUpgradeBtn.setEnabled(true);
    }

    @Override
    public void actionShowUpgradeBtn_actionPerformed(ActionEvent e) throws Exception {
        this.btnUpgrade.setEnabled(!this.btnUpgrade.isEnabled());
        this.btnUpgrade.setVisible(!this.btnUpgrade.isVisible());
        this.btnOpenMapUI.setEnabled(!this.btnOpenMapUI.isEnabled());
        this.btnOpenMapUI.setVisible(!this.btnOpenMapUI.isVisible());
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "name", "billType.name", "RIType", "rI", "isWriteOff", "isCalculate", "isManuCostCalculate", "Scheduled", "status", "CU.name", "description"};
    }

    protected boolean isLazyMode() {
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        if (DisplayTypeEnum.TransactionType.equals(this.displayType.getSelectedItem())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billType.name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simpleName"));
            sic.add(new SelectorItemInfo("RIType"));
            sic.add(new SelectorItemInfo("Scheduled"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("status"));
            sic.add(new SelectorItemInfo("isCalculate"));
            sic.add(new SelectorItemInfo("CU.name"));
            sic.add(new SelectorItemInfo("isManuCostCalculate"));
            sic.add(new SelectorItemInfo("isWriteOff"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("rI"));
            return sic;
        }
        if (DisplayTypeEnum.BizType.equals(this.displayType.getSelectedItem())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billType.name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simpleName"));
            sic.add(new SelectorItemInfo("RIType"));
            sic.add(new SelectorItemInfo("Scheduled"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("status"));
            sic.add(new SelectorItemInfo("isCalculate"));
            sic.add(new SelectorItemInfo("CU.name"));
            sic.add(new SelectorItemInfo("isManuCostCalculate"));
            sic.add(new SelectorItemInfo("isWriteOff"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("rI"));
            sic.add(new SelectorItemInfo("biztype.number"));
            sic.add(new SelectorItemInfo("biztype.name"));
            sic.add(new SelectorItemInfo("biztype.description"));
            sic.add(new SelectorItemInfo("biztype.isDefault"));
            sic.add(new SelectorItemInfo("transBizType.selfmade"));
            return sic;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("RIType"));
        sic.add(new SelectorItemInfo("Scheduled"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isCalculate"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("isManuCostCalculate"));
        sic.add(new SelectorItemInfo("isWriteOff"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("rI"));
        sic.add(new SelectorItemInfo("transactionInvUpdateType.defaults"));
        sic.add(new SelectorItemInfo("invUpdateType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.existingQtyPre"));
        sic.add(new SelectorItemInfo("storeTypePre.name"));
        sic.add(new SelectorItemInfo("storeStatePre.name"));
        sic.add(new SelectorItemInfo("invUpdateType.existingQty"));
        sic.add(new SelectorItemInfo("storeType.name"));
        sic.add(new SelectorItemInfo("storeState.name"));
        sic.add(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
        sic.add(new SelectorItemInfo("invUpdateType.description"));
        sic.add(new SelectorItemInfo("invUpdateType.scheduled"));
        return sic;
    }

    public void mergeSelectorBeforeExcuteQuery(EntityViewInfo ev) {
        super.mergeSelectorBeforeExcuteQuery(ev);
        if (null == ev || null == ev.getSelector()) {
            return;
        }
        SelectorItemCollection sic = ev.getSelector();
        if (DisplayTypeEnum.TransactionType.equals(this.displayType.getSelectedItem())) {
            sic.remove(new SelectorItemInfo("invUpdateType.id"));
            sic.remove(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
            sic.remove(new SelectorItemInfo("invUpdateType.number"));
            sic.remove(new SelectorItemInfo("invUpdateType.name"));
            sic.remove(new SelectorItemInfo("invUpdateType.existingQtyPre"));
            sic.remove(new SelectorItemInfo("storeTypePre.name"));
            sic.remove(new SelectorItemInfo("storeStatePre.name"));
            sic.remove(new SelectorItemInfo("invUpdateType.existingQty"));
            sic.remove(new SelectorItemInfo("storeType.name"));
            sic.remove(new SelectorItemInfo("storeState.name"));
            sic.remove(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
            sic.remove(new SelectorItemInfo("invUpdateType.description"));
            sic.remove(new SelectorItemInfo("invUpdateType.scheduled"));
            sic.remove(new SelectorItemInfo("biztype.id"));
            sic.remove(new SelectorItemInfo("biztype.number"));
            sic.remove(new SelectorItemInfo("biztype.name"));
            sic.remove(new SelectorItemInfo("biztype.description"));
            sic.remove(new SelectorItemInfo("biztype.isDefault"));
            sic.remove(new SelectorItemInfo("transBizType.selfmade"));
        } else if (DisplayTypeEnum.BizType.equals(this.displayType.getSelectedItem())) {
            sic.remove(new SelectorItemInfo("invUpdateType.id"));
            sic.remove(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
            sic.remove(new SelectorItemInfo("invUpdateType.number"));
            sic.remove(new SelectorItemInfo("invUpdateType.name"));
            sic.remove(new SelectorItemInfo("invUpdateType.existingQtyPre"));
            sic.remove(new SelectorItemInfo("storeTypePre.name"));
            sic.remove(new SelectorItemInfo("storeStatePre.name"));
            sic.remove(new SelectorItemInfo("invUpdateType.existingQty"));
            sic.remove(new SelectorItemInfo("storeType.name"));
            sic.remove(new SelectorItemInfo("storeState.name"));
            sic.remove(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
            sic.remove(new SelectorItemInfo("invUpdateType.description"));
            sic.remove(new SelectorItemInfo("invUpdateType.scheduled"));
        } else {
            sic.remove(new SelectorItemInfo("biztype.id"));
            sic.remove(new SelectorItemInfo("biztype.number"));
            sic.remove(new SelectorItemInfo("biztype.name"));
            sic.remove(new SelectorItemInfo("biztype.description"));
            sic.remove(new SelectorItemInfo("biztype.isDefault"));
            sic.remove(new SelectorItemInfo("transBizType.selfmade"));
        }
        ev.setSelector(sic);
    }

    @Override
    protected List getQueryPKFields() {
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add("id");
        return pkList;
    }
}

