/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.util;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class AdminPositionTreeBuilder {
    BOSUuid adminTreeID = null;
    Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    IQueryExecutor queryExcu = null;
    IRowSet rows = null;

    public AdminPositionTreeBuilder() throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionQuery");
        this.queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
    }

    private IRowSet getPositionList(AdminOrgUnitInfo adminInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "%"), CompareType.LIKE));
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminInfo.getLongNumber(), CompareType.EQUALS));
        fi.setMaskString("#0 or #1");
        viewInfo.setFilter(fi);
        this.queryExcu.setObjectView(viewInfo);
        return this.queryExcu.executeQuery();
    }

    public JTree buildTree(JTree tree) throws Exception {
        tree.setModel(new DefaultTreeModel((TreeNode)this.createRootNode()));
        tree.setShowsRootHandles(true);
        return tree;
    }

    private DefaultKingdeeTreeNode createRootNode() throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit().getCU();
        String cuID = cuInfo.getId().toString();
        IRowSet rows = AdminPositionTreeBuilder.getAdminRowSet(cuID, null);
        return this.buildTreeByRowSet(rows);
    }

    private PositionInfo createPositionInfo(IRowSet row) throws Exception {
        PositionInfo info = new PositionInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        info.setName(row.getString("name"));
        info.setNumber(row.getString("number"));
        return info;
    }

    private DefaultKingdeeTreeNode buildTreeByRowSet(IRowSet rowset) throws Exception {
        AdminOrgUnitInfo adminInfo;
        if (rowset == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        HashMap<String, DefaultKingdeeTreeNode> nodeMap2 = new HashMap<String, DefaultKingdeeTreeNode>();
        while (rowset.next()) {
            adminInfo = AdminPositionTreeBuilder.createAdminUnitInfo(rowset);
            if (rootTreeNode == null) {
                rootTreeNode = new DefaultKingdeeTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(this.groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                nodeMap2.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(this.companyIcon);
            if (nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
            nodeMap2.put(adminInfo.getId().toString(), subTreeNode);
        }
        if (rootTreeNode != null) {
            adminInfo = (AdminOrgUnitInfo)rootTreeNode.getUserObject();
            IRowSet rows = this.getPositionList(adminInfo);
            String adminID = null;
            while (rows.next()) {
                PositionInfo positionInfo = this.createPositionInfo(rows);
                DefaultKingdeeTreeNode positionTreeNode = new DefaultKingdeeTreeNode((Object)positionInfo);
                positionTreeNode.setCustomIcon(this.positionIcon);
                adminID = rows.getString("AdminOrgUnit.id");
                if (!nodeMap2.containsKey(adminID)) continue;
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)nodeMap2.get(adminID);
                if (rows.getBoolean("DefaultPosition")) {
                    parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                    continue;
                }
                if (parentNode.getChildCount() > 0) {
                    DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(0);
                    if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() > 1) {
                        parentNode.insert((MutableTreeNode)positionTreeNode, 1);
                        continue;
                    }
                    parentNode.add((MutableTreeNode)positionTreeNode);
                    continue;
                }
                parentNode.add((MutableTreeNode)positionTreeNode);
            }
        }
        return rootTreeNode;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static IRowSet getAdminRowSet(String cuID, AdminOrgUnitInfo rootInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 and (#1 or #2)");
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }
}

