/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.util;

import com.kingdee.eas.basedata.scm.im.inv.InvException;

public class DataBaseCheckPermissionUtil {
    public static final String CONTROLTYPE_S1 = "S1";
    public static final String CONTROLTYPE_S3 = "S3";
    public static final String CONTROLTYPE_S4 = "S4";
    private static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_MODIFY = "ACTION_MODIFY";

    public static void checkCanAddnew(String controlType, String currentCUID) throws Exception {
        DataBaseCheckPermissionUtil.checkPermission(ACTION_ADDNEW, controlType, currentCUID, "");
    }

    public static void checkCanRemove(String controlType, String currentCUID, String dataCUID) throws Exception {
        DataBaseCheckPermissionUtil.checkPermission(ACTION_DELETE, controlType, currentCUID, dataCUID);
    }

    public static void checkCanEdit(String controlType, String currentCUID, String dataCUID) throws Exception {
        DataBaseCheckPermissionUtil.checkPermission(ACTION_MODIFY, controlType, currentCUID, dataCUID);
    }

    private static void checkPermission(String action, String controlType, String currentCUID, String dataCUID) throws Exception {
        if (controlType.equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!currentCUID.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                DataBaseCheckPermissionUtil.throwsExceptionForNoPermission(action);
            }
        } else if ((controlType.equalsIgnoreCase(CONTROLTYPE_S3) || controlType.equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !currentCUID.equals(dataCUID)) {
            DataBaseCheckPermissionUtil.throwsExceptionForNoPermission(action);
        }
    }

    private static void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new InvException(InvException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new InvException(InvException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new InvException(InvException.CAN_NOT_UPDATE);
        }
    }
}

