/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillBizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillBizType;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.AbstractInvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.ITransactionInvUpdateType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SCMBaseCommonUtil {
    private static Logger logger = Logger.getLogger(SCMBaseCommonUtil.class);
    private static int discountRatePrecision = 4;
    public static final HashMap transTypeMap = new HashMap();

    public static String transferToSqlParam(String[] str) {
        StringBuffer params = new StringBuffer();
        int c = str.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(str[i].toString());
            params.append("'");
        }
        return params.toString();
    }

    public static int getDiscountRatePrecision(String cuid) {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            String paramvalue = ipc.getParamValue(null, "DISCOUNTRATEPRECISION");
            discountRatePrecision = Integer.valueOf(paramvalue);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return discountRatePrecision;
    }

    public static boolean isEffectExistingQty(Context ctx, TransactionTypeInfo ttInfo) {
        if (null == ttInfo) {
            return false;
        }
        AbstractInvUpdateTypeInfo invUpdateTypeInfo = null;
        try {
            invUpdateTypeInfo = ctx == null ? TransactionTypeFactory.getRemoteInstance().getDefaultInvUpdateType(ttInfo.getId().toString()) : TransactionTypeFactory.getLocalInstance(ctx).getDefaultInvUpdateType(ttInfo.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return invUpdateTypeInfo == null ? false : invUpdateTypeInfo.isIsNotUpdateInv();
    }

    public static boolean isEffectExistingQty(TransactionTypeInfo ttInfo) {
        return SCMBaseCommonUtil.isEffectExistingQty(null, ttInfo);
    }

    public static Map<String, List<String>> getTranAllStoreTypeAndState(Context ctx, String transactionTypeID, String inORout) throws BOSException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> storeTypeList = new ArrayList<String>();
        ArrayList<String> storeStateList = new ArrayList<String>();
        try {
            InvUpdateTypeCollection col = null;
            ITransactionType iTran = null == ctx ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance(ctx);
            col = iTran.getInvUpdateType(transactionTypeID);
            StoreTypeInfo storeTypeInfo = null;
            StoreStateInfo storeStateInfo = null;
            InvUpdateTypeInfo invUpdateTypeInfo = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                invUpdateTypeInfo = col.get(i);
                if ("in".equals(inORout)) {
                    storeTypeInfo = invUpdateTypeInfo.getStoreType();
                    storeStateInfo = invUpdateTypeInfo.getStoreState();
                }
                if ("out".equals(inORout)) {
                    storeTypeInfo = invUpdateTypeInfo.getStoreTypePre();
                    storeStateInfo = invUpdateTypeInfo.getStoreStatePre();
                }
                if (storeTypeInfo != null) {
                    storeTypeList.add(storeTypeInfo.getId().toString());
                }
                if (storeStateInfo == null) continue;
                storeStateList.add(storeStateInfo.getId().toString());
            }
            map.put("STORETYPE", storeTypeList);
            map.put("STORESTATE", storeStateList);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static boolean isNormalInWarehsAddInvTransaction(TransactionTypeInfo transactionTypeInfo) {
        return SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction(transactionTypeInfo, null);
    }

    public static boolean isNormalInWarehsAddInvTransaction(TransactionTypeInfo transactionTypeInfo, Context ctx) {
        boolean isNormalInWarehsBill = false;
        if (transactionTypeInfo == null) {
            return isNormalInWarehsBill;
        }
        if (transactionTypeInfo.getRiType() == null || transactionTypeInfo.getBillType() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic = SCMSelectorFactory.getTransactionTypeSelector((boolean)false);
            try {
                transactionTypeInfo = ctx == null ? TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId()), sic) : TransactionTypeFactory.getLocalInstance(ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId()), sic);
            }
            catch (Exception e) {
                new BOSException(e.getMessage());
            }
            if (null == transactionTypeInfo.getRiType()) {
                return isNormalInWarehsBill;
            }
        }
        RecIssueTypeInfo riType = transactionTypeInfo.getRiType();
        String billTypeID = transactionTypeInfo.getBillType().getId().toString();
        return SCMBaseCommonUtil.isInWarehsBill(billTypeID) && riType.getBizDirection() == BizDirectionEnum.normal;
    }

    public static boolean isInWarehsSubInvTransaction(TransactionTypeInfo transactionTypeInfo) {
        boolean isNormalInWarehsSubInvBill = false;
        if (transactionTypeInfo == null) {
            return isNormalInWarehsSubInvBill;
        }
        if (transactionTypeInfo.getRiType() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic = SCMSelectorFactory.getTransactionTypeSelector((boolean)false);
            try {
                transactionTypeInfo = TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId()), sic);
            }
            catch (Exception e) {
                new BOSException(e.getMessage());
            }
            if (null == transactionTypeInfo.getRiType()) {
                return isNormalInWarehsSubInvBill;
            }
        }
        RecIssueTypeInfo riType = transactionTypeInfo.getRiType();
        String billTypeID = transactionTypeInfo.getBillType().getId().toString();
        return SCMBaseCommonUtil.isInWarehsBill(billTypeID) && riType.getBizDirection() == BizDirectionEnum.back;
    }

    public static boolean isNormalIssueWarehsSubInvTransaction(TransactionTypeInfo transactionTypeInfo) {
        boolean isIssueWarehsSubInvBill = false;
        if (transactionTypeInfo == null) {
            return isIssueWarehsSubInvBill;
        }
        if (transactionTypeInfo.getRiType() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic = SCMSelectorFactory.getTransactionTypeSelector((boolean)false);
            try {
                transactionTypeInfo = TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId()), sic);
            }
            catch (Exception e) {
                new BOSException(e.getMessage());
            }
            if (null == transactionTypeInfo.getRiType()) {
                return isIssueWarehsSubInvBill;
            }
        }
        RecIssueTypeInfo riType = transactionTypeInfo.getRiType();
        String billTypeID = transactionTypeInfo.getBillType().getId().toString();
        return SCMBaseCommonUtil.isOutWarehsBill(billTypeID) && riType.getBizDirection() == BizDirectionEnum.normal;
    }

    public static boolean isIssueWarehsAddInvTransaction(TransactionTypeInfo transactionTypeInfo) {
        boolean isIssueWarehsAddInvBill = false;
        if (transactionTypeInfo == null) {
            return isIssueWarehsAddInvBill;
        }
        if (transactionTypeInfo.getRiType() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic = SCMSelectorFactory.getTransactionTypeSelector((boolean)false);
            try {
                transactionTypeInfo = TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId()), sic);
            }
            catch (Exception e) {
                new BOSException(e.getMessage());
            }
            if (null == transactionTypeInfo.getRiType()) {
                return isIssueWarehsAddInvBill;
            }
        }
        RecIssueTypeInfo riType = transactionTypeInfo.getRiType();
        String billTypeID = transactionTypeInfo.getBillType().getId().toString();
        return SCMBaseCommonUtil.isOutWarehsBill(billTypeID) && riType.getBizDirection() == BizDirectionEnum.back;
    }

    public static boolean isInvBill(String billTypeID) {
        return "50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID) || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID) || "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeID) || "50957179-0105-1000-e001-1152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e004-4152c0a812fd463ED552".equals(billTypeID);
    }

    public static TransactionInvUpdateTypeCollection getTransactionInvUpdateTypeCol(Context ctx, EntityViewInfo view) throws EASBizException, BOSException {
        if (null == view) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("invUpdateType.id"));
        sic.add(new SelectorItemInfo("invUpdateType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.existingQty"));
        sic.add(new SelectorItemInfo("invUpdateType.existingQtyPre"));
        sic.add(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
        sic.add(new SelectorItemInfo("invUpdateType.scheduled"));
        sic.add(new SelectorItemInfo("invUpdateType.status"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.isForwardAmt"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.storeFlag"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.isForwardAmt"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.name"));
        sic.add(new SelectorItemInfo("defaults"));
        view.setSelector(sic);
        if (view.getSorter() != null && view.getSorter().size() == 0) {
            SorterItemInfo sortItem = new SorterItemInfo("invUpdateType.number");
            sortItem.setSortType(SortType.ASCEND);
            view.getSorter().add(sortItem);
        }
        ITransactionInvUpdateType iInv = null;
        iInv = ctx == null ? TransactionInvUpdateTypeFactory.getRemoteInstance() : TransactionInvUpdateTypeFactory.getLocalInstance(ctx);
        return iInv.getTransactionInvUpdateTypeCollection(view);
    }

    public static InvUpdateTypeInfo getInvUpdateType(Context ctx, String transactionTypeID, String aStoreTypeID, String aStoreStateID) throws EASBizException, BOSException {
        block18: {
            String storeStatePreID;
            String storeTypePreID;
            StoreStateInfo storeStatePre;
            StoreTypeInfo storeTypePre;
            String storeStateID;
            String storeTypeID;
            StoreStateInfo storeState;
            StoreTypeInfo storeType;
            TransactionInvUpdateTypeCollection col;
            block17: {
                if (StringUtil.isEmpty((String)transactionTypeID) || StringUtil.isEmpty((String)aStoreTypeID) || StringUtil.isEmpty((String)aStoreStateID)) {
                    return null;
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)transactionTypeID, CompareType.EQUALS));
                view.setFilter(filterInfo);
                col = SCMBaseCommonUtil.getTransactionInvUpdateTypeCol(ctx, view);
                ITransactionType iTran = null;
                InvUpdateTypeInfo defaultInvUpdateType = null;
                storeType = null;
                storeState = null;
                storeTypeID = null;
                storeStateID = null;
                storeTypePre = null;
                storeStatePre = null;
                storeTypePreID = null;
                storeStatePreID = null;
                iTran = ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance(ctx);
                defaultInvUpdateType = iTran.getDefaultInvUpdateType(transactionTypeID);
                if (defaultInvUpdateType == null) break block17;
                storeType = defaultInvUpdateType.getStoreType();
                storeState = defaultInvUpdateType.getStoreState();
                if (storeType != null) {
                    storeTypeID = storeType.getId().toString();
                }
                if (storeState != null) {
                    storeStateID = storeState.getId().toString();
                }
                storeTypePre = defaultInvUpdateType.getStoreTypePre();
                storeStatePre = defaultInvUpdateType.getStoreStatePre();
                if (storeTypePre != null) {
                    storeTypePreID = storeTypePre.getId().toString();
                }
                if (storeStatePre != null) {
                    storeStatePreID = storeStatePre.getId().toString();
                }
                if (aStoreTypeID.equals(storeTypeID) && aStoreStateID.equals(storeStateID) || aStoreTypeID.equals(storeTypePreID) && aStoreStateID.equals(storeStatePreID)) {
                    return defaultInvUpdateType;
                }
                if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) break block18;
                TransactionInvUpdateTypeInfo transactionInvUpdateType = null;
                InvUpdateTypeInfo invUpdateType = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    transactionInvUpdateType = col.get(i);
                    invUpdateType = transactionInvUpdateType.getInvUpdateType();
                    storeType = invUpdateType.getStoreType();
                    storeState = invUpdateType.getStoreState();
                    if (storeType != null) {
                        storeTypeID = storeType.getId().toString();
                    }
                    if (storeState != null) {
                        storeStateID = storeState.getId().toString();
                    }
                    storeTypePre = invUpdateType.getStoreTypePre();
                    storeStatePre = invUpdateType.getStoreStatePre();
                    if (storeTypePre != null) {
                        storeTypePreID = storeTypePre.getId().toString();
                    }
                    if (storeStatePre != null) {
                        storeStatePreID = storeStatePre.getId().toString();
                    }
                    if ((!aStoreTypeID.equals(storeTypeID) || !aStoreStateID.equals(storeStateID)) && (!aStoreTypeID.equals(storeTypePreID) || !aStoreStateID.equals(storeStatePreID))) continue;
                    return invUpdateType;
                }
                break block18;
            }
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                TransactionInvUpdateTypeInfo transactionInvUpdateType = null;
                InvUpdateTypeInfo invUpdateType = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    transactionInvUpdateType = col.get(i);
                    invUpdateType = transactionInvUpdateType.getInvUpdateType();
                    storeType = invUpdateType.getStoreType();
                    storeState = invUpdateType.getStoreState();
                    if (storeType != null) {
                        storeTypeID = storeType.getId().toString();
                    }
                    if (storeState != null) {
                        storeStateID = storeState.getId().toString();
                    }
                    storeTypePre = invUpdateType.getStoreTypePre();
                    storeStatePre = invUpdateType.getStoreStatePre();
                    if (storeTypePre != null) {
                        storeTypePreID = storeTypePre.getId().toString();
                    }
                    if (storeStatePre != null) {
                        storeStatePreID = storeStatePre.getId().toString();
                    }
                    if ((!aStoreTypeID.equals(storeTypeID) || !aStoreStateID.equals(storeStateID)) && (!aStoreTypeID.equals(storeTypePreID) || !aStoreStateID.equals(storeStatePreID))) continue;
                    return invUpdateType;
                }
            }
        }
        return null;
    }

    public static Map<String, List<String>> getTranAllStoreTypeAndState(String transactionTypeID, String inORout) throws BOSException {
        return SCMBaseCommonUtil.getTranAllStoreTypeAndState(null, transactionTypeID, inORout);
    }

    public static boolean isInWarehsBill(String billTypeID) {
        return "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID);
    }

    public static boolean isOutWarehsBill(String billTypeID) {
        return "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID);
    }

    public static TransactionTypeInfo getTransType(Context ctx, String id) throws BOSException, EASBizException {
        TransactionTypeInfo transType = new TransactionTypeInfo();
        transType = transTypeMap.get(id) == null ? SCMBaseCommonUtil.putTransType(ctx, id) : (TransactionTypeInfo)transTypeMap.get(id);
        return transType;
    }

    public static TransactionTypeInfo putTransType(Context ctx, String id) throws BOSException, EASBizException {
        TransactionTypeInfo transType = new TransactionTypeInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("billType.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("billType.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("billType.billTypeGroup"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("billType.Scheduled"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.storeTypePre.storeFlag"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.storeTypePre.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.storeType.storeFlag"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.storeType.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.existingQtyPre"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.existingQty"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("invUpdateType.isNotUpdateInv"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("isWriteOff"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("riType.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("riType.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("riType.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("riType.status"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("riType.bizDirection"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("riType.dataDirection"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ITransactionType iTransType = TransactionTypeFactory.getLocalInstance(ctx);
        TransactionTypeCollection transTypeCol = iTransType.getTransactionTypeCollection(entityViewInfo);
        transType = transTypeCol.get(0);
        transTypeMap.put(id, transType);
        return transType;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou) {
        EntityViewInfo viewInfo = null;
        try {
            if (sou != null) {
                viewInfo = SCMBaseCommonUtil.getWarehouseFilter(sou.getId().toString(), -1);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return viewInfo;
    }

    public static EntityViewInfo getWarehouseFilter(String souID, int isStarted) throws EASBizException, BOSException {
        if (souID != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)souID, CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)isStarted, CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou, PeriodInfo curPeriod, int isStarted) throws EASBizException, BOSException {
        if (sou != null && sou.getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            if (curPeriod != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("sowhPeriod.id", (Object)curPeriod.getId().toString(), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo souFrom, StorageOrgUnitInfo souTo, int isStarted) throws EASBizException, BOSException {
        if (souFrom == null && souTo == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (souFrom != null && souTo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souFrom.getNumber(), CompareType.GREATER_EQUALS));
        } else if (souFrom == null && souTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souTo.getNumber(), CompareType.LESS_EQUALS));
        } else if (souFrom != null && souTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souFrom.getNumber(), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souTo.getNumber(), CompareType.LESS_EQUALS));
        }
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static EntityViewInfo getWarehouseFilter(CompanyOrgUnitInfo companyInfo, int isStarted) throws EASBizException, BOSException {
        if (companyInfo == null) {
            return null;
        }
        Set storageSet = SCMUtil.getStoragesIDSet((CompanyOrgUnitInfo)companyInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)storageSet, CompareType.INCLUDE));
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static EntityViewInfo getWarehouseFilter(OrgUnitCollection orgColl, int isStarted) throws EASBizException, BOSException {
        HashSet<String> orgIdSet = new HashSet<String>();
        for (int i = 0; i < orgColl.size(); ++i) {
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)orgColl.get(i);
            orgIdSet.add(sou.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", orgIdSet, CompareType.INCLUDE));
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static BizTypeInfo getDefaultBizTypeInfo(Context ctx, String bizTypeID, String billTypeID) throws BOSException, EASBizException {
        if (bizTypeID == null || billTypeID == null) {
            return null;
        }
        IBillBizType ibb = ctx == null ? BillBizTypeFactory.getRemoteInstance() : BillBizTypeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("selfmade", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizType.status", (Object)new Integer("1"), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        view.setSelector(sic);
        BillBizTypeCollection col = ibb.getBillBizTypeCollection(view);
        if (col.size() == 0) {
            return null;
        }
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizCategory.id"));
        sic.add(new SelectorItemInfo("bizCategory.number"));
        IBizType ibt = ctx == null ? BizTypeFactory.getRemoteInstance() : BizTypeFactory.getLocalInstance(ctx);
        return ibt.getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeID), sic);
    }

    public static boolean isConsignmentBizType(BizTypeInfo bizTypeInfo) {
        boolean isConsignmentBizType = false;
        if (bizTypeInfo != null && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeInfo.getId().toString())) {
            isConsignmentBizType = true;
        }
        return isConsignmentBizType;
    }

    public static boolean isConsOutSaleIssueBill(BizTypeInfo bizTypeInfo, TransactionTypeInfo transTypeInfo) {
        boolean isConsignOut = false;
        if (SCMBaseCommonUtil.isConsignmentBizType(bizTypeInfo) && transTypeInfo != null && transTypeInfo.getRiType() != null && RecIssueTypeConstant.CONSIGNOUT_RITYPEID.equals(transTypeInfo.getRiType().getId().toString())) {
            isConsignOut = true;
        }
        return isConsignOut;
    }

    public static boolean isConsRtSaleIssueBill(BizTypeInfo bizTypeInfo, TransactionTypeInfo transTypeInfo) {
        boolean isConsignRt = false;
        if (SCMBaseCommonUtil.isConsignmentBizType(bizTypeInfo) && transTypeInfo != null && transTypeInfo.getRiType() != null) {
            String riTypeID = transTypeInfo.getRiType().getId().toString();
            return RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(riTypeID);
        }
        return isConsignRt;
    }
}

