/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.scm.im.inv.FillSignDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleEntryCollection;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleEntryInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.SectTypeEnum;
import com.kingdee.eas.basedata.scm.im.inv.TimeFormatUtil;
import com.kingdee.eas.basedata.scm.im.inv.ValueAttributeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LotFrame
implements Serializable {
    private static final long serialVersionUID = 3274967688043991391L;
    private int seq;
    private String entryID;
    private LotRuleInfo lotRule;
    private long currentSerial;
    private Date sysDate;
    private String billNumber;
    private String mainBizOrg;
    private String supplier;
    private String supplierlotno;
    private String customer;
    private String material;
    private String warehouse;
    private String department;
    private Date bizDate;
    private Date mfg;
    private Date exp;
    private String freeProp1;
    private String freeProp2;
    private String freeProp3;
    private String freeProp4;
    private String freeProp5;

    public void setSupplierlotno(String supplierlotno) {
        this.supplierlotno = supplierlotno;
    }

    public String getLotNumber() {
        if (this.lotRule == null) {
            return null;
        }
        StringBuffer sbLotNumber = new StringBuffer();
        String splitSign = this.lotRule.getSplitSign();
        LotRuleEntryCollection entrys = this.lotRule.getEntry();
        int entryCount = entrys.size();
        for (int i = 0; i < entryCount; ++i) {
            boolean needSplit;
            LotRuleEntryInfo entry = entrys.get(i);
            SectTypeEnum sectType = entry.getSectType();
            if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
                int format = entry.getFormat();
                sbLotNumber.append(TimeFormatUtil.getTimeFormat(this.sysDate)[format]);
            } else if (sectType.equals((Object)SectTypeEnum.CONST)) {
                String constValue = entry.getConstValue();
                sbLotNumber.append(constValue);
            } else if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
                ValueAttributeEnum valueAttribute = entry.getValueAttribute();
                int length = entry.getLength();
                String fillSign = entry.getFillSign();
                FillSignDirectionEnum direction = entry.getFillSignDirection();
                String attribute = "";
                if (valueAttribute.equals((Object)ValueAttributeEnum.BILL_NUMBER)) {
                    attribute = this.billNumber;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.MAIN_BIZ_ORG)) {
                    attribute = this.mainBizOrg;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.SUPPLIER)) {
                    attribute = this.supplier;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.SUPPLIERLOTNO)) {
                    attribute = this.supplierlotno;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.CUSTOMER)) {
                    attribute = this.customer;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.MATERIAL)) {
                    attribute = this.material;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.WAREHOUSE)) {
                    attribute = this.warehouse;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.DEPARTMENT)) {
                    attribute = this.department;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.BIZDATE) && this.bizDate != null) {
                    attribute = TimeFormatUtil.getTimeFormat(this.bizDate)[entry.getFormat()];
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.MFG) && this.mfg != null) {
                    attribute = TimeFormatUtil.getTimeFormat(this.mfg)[entry.getFormat()];
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.EXP) && this.exp != null) {
                    attribute = TimeFormatUtil.getTimeFormat(this.exp)[entry.getFormat()];
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP1)) {
                    attribute = this.freeProp1;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP2)) {
                    attribute = this.freeProp2;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP3)) {
                    attribute = this.freeProp3;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP4)) {
                    attribute = this.freeProp4;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP5)) {
                    attribute = this.freeProp5;
                }
                sbLotNumber.append(this.fillSign(attribute, length, fillSign, direction));
            } else if (sectType.equals((Object)SectTypeEnum.SERIAL)) {
                int length = entry.getLength();
                sbLotNumber.append(this.fillSign(String.valueOf(this.currentSerial), length, "0", FillSignDirectionEnum.FORWARD));
            }
            if (i == entryCount - 1 || !(needSplit = entry.isNeedSplit())) continue;
            sbLotNumber.append(splitSign);
        }
        return sbLotNumber.toString();
    }

    public String fillSign(String str, int totalLength, Object fillSign, FillSignDirectionEnum direction) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= totalLength) {
            if ((fillSign == null || fillSign.toString().trim().length() == 0) && str.length() > totalLength && totalLength > 0) {
                str = str.substring(0, totalLength);
            }
            return str;
        }
        StringBuffer sbStr = new StringBuffer();
        StringBuffer sbFill = new StringBuffer();
        sbStr.append(str);
        if (null != fillSign) {
            for (int i = 0; i < totalLength - str.length(); ++i) {
                sbFill.append(fillSign);
            }
        }
        if (direction.equals((Object)FillSignDirectionEnum.FORWARD)) {
            return sbFill.append(sbStr).toString();
        }
        return sbStr.append(sbFill).toString();
    }

    public List getLotAttributes() {
        ArrayList<String> laList = new ArrayList<String>();
        LotRuleEntryCollection entrys = this.lotRule.getEntry();
        int entryCount = entrys.size();
        ValueAttributeEnum valueAttribute = null;
        LotRuleEntryInfo entry = null;
        SectTypeEnum sectType = null;
        for (int i = 0; i < entryCount; ++i) {
            entry = entrys.get(i);
            if (entry == null || !(sectType = entry.getSectType()).equals((Object)SectTypeEnum.ATTRIBUTE) || (valueAttribute = entry.getValueAttribute()) == null || valueAttribute.getName() == null) continue;
            laList.add(valueAttribute.getName());
        }
        return laList;
    }

    public long getCurrentSerial() {
        return this.currentSerial;
    }

    public LotRuleInfo getLotRule() {
        return this.lotRule;
    }

    public Date getSysDate() {
        return this.sysDate;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public void setDepartment(String dept) {
        this.department = dept;
    }

    public void setMainBizOrg(String mainBizOrg) {
        this.mainBizOrg = mainBizOrg;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setCurrentSerial(long currentSerial) {
        this.currentSerial = currentSerial;
    }

    public void setLotRule(LotRuleInfo lotRule) {
        this.lotRule = lotRule;
    }

    public void setSysDate(Date sysDate) {
        this.sysDate = sysDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public void setExp(Date exp) {
        this.exp = exp;
    }

    public void setMfg(Date mfg) {
        this.mfg = mfg;
    }

    public void setFreeProp1(String userProp1) {
        this.freeProp1 = userProp1;
    }

    public void setFreeProp2(String userProp2) {
        this.freeProp2 = userProp2;
    }

    public void setFreeProp3(String userProp3) {
        this.freeProp3 = userProp3;
    }

    public void setFreeProp4(String userProp4) {
        this.freeProp4 = userProp4;
    }

    public void setFreeProp5(String userProp5) {
        this.freeProp5 = userProp5;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public int getSeq() {
        return this.seq;
    }

    public String getMainBizOrg() {
        return this.mainBizOrg;
    }

    public String getMaterial() {
        return this.material;
    }

    public String getEntryID() {
        return this.entryID;
    }

    public void setEntryID(String entryID) {
        this.entryID = entryID;
    }

    public String getSupplierlotno() {
        return this.supplierlotno;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public String getLotRuleAssign() {
        if (this.lotRule == null) {
            return null;
        }
        StringBuffer sbLotNumber = new StringBuffer();
        LotRuleEntryCollection entrys = this.lotRule.getEntry();
        String split = "_split_";
        int entryCount = entrys.size();
        boolean isClassify = false;
        for (int i = 0; i < entryCount; ++i) {
            LotRuleEntryInfo entry = entrys.get(i);
            isClassify = entry.isIsClassify();
            SectTypeEnum sectType = entry.getSectType();
            if (sectType.equals((Object)SectTypeEnum.SYSTIME) && isClassify) {
                int format = entry.getFormat();
                if (sbLotNumber.length() > 0) {
                    sbLotNumber.append(split);
                }
                sbLotNumber.append(TimeFormatUtil.getTimeFormat(this.sysDate)[format]);
                continue;
            }
            if (!sectType.equals((Object)SectTypeEnum.ATTRIBUTE) || !isClassify) continue;
            ValueAttributeEnum valueAttribute = entry.getValueAttribute();
            String attribute = "";
            if (valueAttribute.equals((Object)ValueAttributeEnum.BILL_NUMBER)) {
                attribute = this.billNumber;
            } else if (ValueAttributeEnum.MAIN_BIZ_ORG.equals((Object)valueAttribute)) {
                attribute = this.mainBizOrg;
            } else if (ValueAttributeEnum.SUPPLIER.equals((Object)valueAttribute)) {
                attribute = this.supplier;
            } else if (ValueAttributeEnum.SUPPLIERLOTNO.equals((Object)valueAttribute)) {
                attribute = this.supplierlotno;
            } else if (ValueAttributeEnum.CUSTOMER.equals((Object)valueAttribute)) {
                attribute = this.customer;
            } else if (ValueAttributeEnum.MATERIAL.equals((Object)valueAttribute)) {
                attribute = this.material;
            } else if (ValueAttributeEnum.WAREHOUSE.equals((Object)valueAttribute)) {
                attribute = this.warehouse;
            } else if (ValueAttributeEnum.DEPARTMENT.equals((Object)valueAttribute)) {
                attribute = this.department;
            } else if (ValueAttributeEnum.BIZDATE.equals((Object)valueAttribute) && this.bizDate != null) {
                attribute = TimeFormatUtil.getTimeFormat(this.bizDate)[entry.getFormat()];
            } else if (ValueAttributeEnum.MFG.equals((Object)valueAttribute) && this.mfg != null) {
                attribute = TimeFormatUtil.getTimeFormat(this.mfg)[entry.getFormat()];
            } else if (ValueAttributeEnum.EXP.equals((Object)valueAttribute) && this.exp != null) {
                attribute = TimeFormatUtil.getTimeFormat(this.exp)[entry.getFormat()];
            } else if (ValueAttributeEnum.USER_PROP1.equals((Object)valueAttribute)) {
                attribute = this.freeProp1;
            } else if (ValueAttributeEnum.USER_PROP2.equals((Object)valueAttribute)) {
                attribute = this.freeProp2;
            } else if (ValueAttributeEnum.USER_PROP3.equals((Object)valueAttribute)) {
                attribute = this.freeProp3;
            } else if (ValueAttributeEnum.USER_PROP4.equals((Object)valueAttribute)) {
                attribute = this.freeProp4;
            } else if (ValueAttributeEnum.USER_PROP5.equals((Object)valueAttribute)) {
                attribute = this.freeProp5;
            }
            if (sbLotNumber.length() > 0) {
                sbLotNumber.append(split);
            }
            sbLotNumber.append(attribute);
        }
        if (sbLotNumber.length() == 0) {
            return null;
        }
        return sbLotNumber.toString();
    }

    public String getLotNumber(Context ctx) {
        if (this.lotRule == null) {
            return null;
        }
        StringBuffer sbLotNumber = new StringBuffer();
        String splitSign = this.lotRule.getSplitSign();
        LotRuleEntryCollection entrys = this.lotRule.getEntry();
        int entryCount = entrys.size();
        for (int i = 0; i < entryCount; ++i) {
            boolean needSplit;
            LotRuleEntryInfo entry = entrys.get(i);
            SectTypeEnum sectType = entry.getSectType();
            if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
                int format = entry.getFormat();
                sbLotNumber.append(TimeFormatUtil.getTimeFormat(ctx, this.sysDate)[format]);
            } else if (sectType.equals((Object)SectTypeEnum.CONST)) {
                String constValue = entry.getConstValue();
                sbLotNumber.append(constValue);
            } else if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
                ValueAttributeEnum valueAttribute = entry.getValueAttribute();
                int length = entry.getLength();
                String fillSign = entry.getFillSign();
                FillSignDirectionEnum direction = entry.getFillSignDirection();
                String attribute = "";
                if (valueAttribute.equals((Object)ValueAttributeEnum.BILL_NUMBER)) {
                    attribute = this.billNumber;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.MAIN_BIZ_ORG)) {
                    attribute = this.mainBizOrg;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.SUPPLIER)) {
                    attribute = this.supplier;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.SUPPLIERLOTNO)) {
                    attribute = this.supplierlotno;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.CUSTOMER)) {
                    attribute = this.customer;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.MATERIAL)) {
                    attribute = this.material;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.WAREHOUSE)) {
                    attribute = this.warehouse;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.DEPARTMENT)) {
                    attribute = this.department;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.BIZDATE) && this.bizDate != null) {
                    attribute = TimeFormatUtil.getTimeFormat(this.bizDate)[entry.getFormat()];
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.MFG) && this.mfg != null) {
                    attribute = TimeFormatUtil.getTimeFormat(this.mfg)[entry.getFormat()];
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.EXP) && this.exp != null) {
                    attribute = TimeFormatUtil.getTimeFormat(this.exp)[entry.getFormat()];
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP1)) {
                    attribute = this.freeProp1;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP2)) {
                    attribute = this.freeProp2;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP3)) {
                    attribute = this.freeProp3;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP4)) {
                    attribute = this.freeProp4;
                } else if (valueAttribute.equals((Object)ValueAttributeEnum.USER_PROP5)) {
                    attribute = this.freeProp5;
                }
                sbLotNumber.append(this.fillSign(attribute, length, fillSign, direction));
            } else if (sectType.equals((Object)SectTypeEnum.SERIAL)) {
                int length = entry.getLength();
                sbLotNumber.append(this.fillSign(String.valueOf(this.currentSerial), length, "0", FillSignDirectionEnum.FORWARD));
            }
            if (i == entryCount - 1 || !(needSplit = entry.isNeedSplit())) continue;
            sbLotNumber.append(splitSign);
        }
        return sbLotNumber.toString();
    }
}

