/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.im.inv.BomEntryFactory;
import com.kingdee.eas.basedata.scm.im.inv.BomFactory;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractBomListUI;
import com.kingdee.eas.basedata.scm.im.inv.client.BomEditUI;
import com.kingdee.eas.basedata.scm.im.inv.client.BomFilterUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class BomListUI
extends AbstractBomListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BomListUI.class);
    private BomFilterUI filterUI = null;

    public String[] getMergeColumnKeys() {
        String[] mergeColumnKeys = new String[]{"id", "number", "name", "storageOrgUnit.name", "storageOrgUnit.number", "bomType", "baseStatus", "material.number", "material.name", "material.model", "unit.name", "qty", "auditor.name", "auditTime", "creator.name", "creatTime"};
        return mergeColumnKeys;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, BomFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, BomEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entries.id", "number", "entry.seq", "storageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNAUDIT, (ItemAction)this.actionUnAudit, (String)"unAudit");
        this.actionManager.registerBatchAction(actionProxy, "actionUnAudit");
        actionProxy.bindTo((AbstractButton)this.btnUnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemUnAudit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("DISCARD"), (ItemAction)this.actionDiscard, (String)"discard");
        this.actionManager.registerBatchAction(actionProxy, "actionDiscard");
        actionProxy.bindTo((AbstractButton)this.btnDiscard);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.AUDIT, (ItemAction)this.actionAudit, (String)"audit");
        this.actionManager.registerBatchAction(actionProxy, "actionAudit");
        actionProxy.bindTo((AbstractButton)this.btnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemAudit);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnReservationQuery.setVisible(false);
        this.menuItemExportData.setVisible(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 1013, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 629));
        this.tblMain.setBounds(new Rectangle(10, 10, 996, 605));
        this.add((Component)this.tblMain, new KDLayout.Constraints(10, 10, 996, 605, 15));
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID));
        if (!this.getBizInterface().exists((IObjectPK)pk)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("baseStatus"));
        CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)o;
        if (!aSCMBillBaseInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !aSCMBillBaseInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.SCMInvResource", (String)"bill_not_save_status"));
            SysUtil.abort();
        } else {
            aSCMBillBaseInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        }
        if (aSCMBillBaseInfo.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.NotAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        String[] idListArray = new String[]{aSCMBillBaseInfo.getId().toString()};
        BomFactory.getRemoteInstance().audit((IObjectPK)pk, null);
        this.refresh(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BomFactory.getRemoteInstance();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return BomEditUI.class.getName();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected OrgType getOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BomFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setWidth(500);
        dialog.setHeight(260);
        return dialog;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.Bom";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30im.Bom";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter() == null ? new FilterInfo() : this.mainQuery.getFilter());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean innerCheckPartSum() {
        return false;
    }
}

