/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.IInvUpdateType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractInvUpdateTypeEditUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InvUpdateTypeEditUI
extends AbstractInvUpdateTypeEditUI {
    private static final long serialVersionUID = 1L;
    private boolean isScheduled = false;
    private String currentCUID;
    private UseStatusEnum state;
    private ChangeListener existingQtyPreListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            InvUpdateTypeEditUI.this.existingQtyPreChange(true);
        }
    };
    private ChangeListener existingQtyListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            InvUpdateTypeEditUI.this.existingQtyChange(true);
        }
    };
    private ChangeListener notUpdateInvListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            InvUpdateTypeEditUI.this.notUpdateInvChange(true);
        }
    };

    public InvUpdateTypeEditUI() throws Exception {
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void existingQtyChange(boolean isEnabled) {
        if (this.chkExistingQty.isSelected() && !this.isScheduled) {
            this.prmtStoreType.setEnabled(isEnabled);
            this.prmtStoreState.setEnabled(isEnabled);
        } else {
            this.prmtStoreType.setEnabled(false);
            this.prmtStoreState.setEnabled(false);
        }
    }

    private void existingQtyPreChange(boolean isEnabled) {
        if (this.chkExistingQtyPre.isSelected() && !this.isScheduled) {
            this.prmtStoreTypePre.setEnabled(isEnabled);
            this.prmtStoreStatePre.setEnabled(isEnabled);
        } else {
            this.prmtStoreTypePre.setEnabled(false);
            this.prmtStoreStatePre.setEnabled(false);
        }
    }

    private void notUpdateInvChange(boolean isEnabled) {
        if (this.chkNotUpdateInv.isSelected()) {
            this.chkExistingQty.setEnabled(false);
            this.chkExistingQty.setEditable(false);
            this.chkExistingQty.setSelected(false);
            this.chkExistingQtyPre.setEnabled(false);
            this.chkExistingQtyPre.setEditable(false);
            this.chkExistingQtyPre.setSelected(false);
            this.prmtStoreType.setValue(null);
            this.prmtStoreState.setValue(null);
            this.prmtStoreTypePre.setValue(null);
            this.prmtStoreStatePre.setValue(null);
        } else {
            this.chkExistingQty.setEnabled(isEnabled);
            this.chkExistingQty.setEditable(isEnabled);
            this.chkExistingQtyPre.setEnabled(isEnabled);
            this.chkExistingQtyPre.setEditable(isEnabled);
        }
    }

    private void addListener() {
        this.chkExistingQtyPre.addChangeListener(this.existingQtyPreListener);
        this.chkExistingQty.addChangeListener(this.existingQtyListener);
        this.chkNotUpdateInv.addChangeListener(this.notUpdateInvListener);
    }

    private void removeListener() {
        this.chkExistingQtyPre.removeChangeListener(this.existingQtyPreListener);
        this.chkExistingQty.removeChangeListener(this.existingQtyListener);
        this.chkNotUpdateInv.removeChangeListener(this.notUpdateInvListener);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        InvUpdateTypeInfo info = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = info.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (this.editData.getStatus().getValue() == 1) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"ActiveInvUpdateType_Cannt_Modify");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        InvUpdateTypeInfo info = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = info.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanRemove((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (this.editData.getStatus().getValue() != 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"UnSaveInvUpdateType_Cannt_Remove");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        InvUpdateTypeInfo info = new InvUpdateTypeInfo();
        return info;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InvUpdateTypeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        InvUpdateTypeInfo info = (InvUpdateTypeInfo)dataObject;
        this.isScheduled = info.isScheduled();
        this.state = info.getStatus();
        super.setDataObject(dataObject);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String message = null;
        IInvUpdateType iFactory = InvUpdateTypeFactory.getRemoteInstance();
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup(this.editData);
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getEditor().getItem().toString().trim());
            this.txtName.requestFocus();
            iFactory.checkNameDup(this.editData);
        }
        this.checkInvUpdateTypeValidate();
    }

    protected void initDataStatus() {
        if ("EDIT".equals(this.getOprtState())) {
            this.setUIStatus(!this.isScheduled);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.setUIStatus(true);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUIStatus(true);
        }
        this.txtName.setMaxLength(255);
        this.txtNumber.setMaxLength(80);
        this.txtDescription.setMaxLength(255);
        super.initDataStatus();
    }

    private void setUIStatus(Boolean isEnable) {
        this.unLockUI();
        this.removeListener();
        this.txtName.setEnabled(true);
        this.txtName.setEditable(true);
        this.txtDescription.setEnabled(true);
        this.txtDescription.setEditable(true);
        this.comboStatus.setEnabled(false);
        this.comboStatus.setEditable(false);
        this.chkScheduled.setEnabled(false);
        this.chkScheduled.setEditable(false);
        this.txtNumber.setEnabled(isEnable.booleanValue());
        this.txtNumber.setEditable(isEnable.booleanValue());
        boolean isEnabled = UseStatusEnum.SAVED.equals((Object)this.state) && isEnable != false;
        this.chkExistingQtyPre.setEnabled(isEnabled);
        this.chkExistingQtyPre.setEditable(isEnabled);
        this.chkExistingQty.setEnabled(isEnabled);
        this.chkExistingQty.setEditable(isEnabled);
        this.prmtStoreTypePre.setEnabled(isEnabled);
        this.prmtStoreTypePre.setEditable(isEnabled);
        this.prmtStoreType.setEnabled(isEnabled);
        this.prmtStoreType.setEditable(isEnabled);
        this.prmtStoreStatePre.setEnabled(isEnabled);
        this.prmtStoreStatePre.setEditable(isEnabled);
        this.prmtStoreState.setEnabled(isEnabled);
        this.prmtStoreState.setEditable(isEnabled);
        this.chkNotUpdateInv.setEnabled(isEnabled);
        this.chkNotUpdateInv.setEditable(isEnabled);
        this.existingQtyChange(isEnabled);
        this.existingQtyPreChange(isEnabled);
        this.notUpdateInvChange(isEnabled);
        this.addListener();
    }

    private void checkInvUpdateTypeValidate() {
        boolean isValidate = false;
        String msg = "";
        if (!this.chkExistingQtyPre.isSelected()) {
            this.prmtStoreTypePre.setValue(null);
            this.prmtStoreStatePre.setValue(null);
        } else if (this.prmtStoreTypePre.getValue() == null || this.prmtStoreStatePre.getValue() == null) {
            isValidate = true;
            msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.InvUpdateType_CheckExistingQtyPre");
        }
        if (!this.chkExistingQty.isSelected()) {
            this.prmtStoreType.setValue(null);
            this.prmtStoreState.setValue(null);
        } else if (this.prmtStoreType.getValue() == null || this.prmtStoreState.getValue() == null) {
            isValidate = true;
            msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.InvUpdateType_CheckExistingQty");
        }
        if (!this.chkExistingQtyPre.isSelected() && !this.chkExistingQty.isSelected()) {
            this.chkNotUpdateInv.setSelected(true);
        }
        if (isValidate) {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        InvUpdateTypeInfo info = (InvUpdateTypeInfo)newData;
        info.setNumber(null);
        info.setName(null, new Locale("L1"));
        info.setName(null, new Locale("L2"));
        info.setName(null, new Locale("L3"));
        info.setStatus(UseStatusEnum.SAVED);
        info.setDescription(null);
        info.setScheduled(false);
    }
}

