/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractInvUpdateTypeListUI;
import com.kingdee.eas.basedata.scm.im.inv.client.InvUpdateTypeEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class InvUpdateTypeListUI
extends AbstractInvUpdateTypeListUI {
    private static final long serialVersionUID = 1L;
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String currentCUID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            InvUpdateTypeInfo info = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(strId), this.getSelector());
            String cuid = info.getCU().getId().toString();
            if (cuid != null) {
                EntityControlTypeUtil.checkCanRemove((String)"S3", (String)this.currentCUID, (String)cuid);
            }
            if (info.getStatus().getValue() != 0) {
                String msg = EASResource.getString((String)this.bdScmImRes, (String)"UnSaveInvUpdateType_Cannt_Remove");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            InvUpdateTypeInfo info = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(strId), this.getSelector());
            String cuid = info.getCU().getId().toString();
            if (cuid != null) {
                EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
            }
            if (info.getStatus().getValue() == 1) {
                String msg = EASResource.getString((String)this.bdScmImRes, (String)"ActiveInvUpdateType_Cannt_Modify");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.INACTIVE, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.ACTIVE, e);
    }

    private void setStatus(UseStatusEnum status, ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        boolean isNotCUEnable = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        InvUpdateTypeCollection col = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeCollection(view);
        InvUpdateTypeInfo invUpdateType = null;
        HashMap<String, String> numberList = new HashMap<String, String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                invUpdateType = col.get(i);
                String cu = invUpdateType.getCU() != null ? invUpdateType.getCU().getId().toString() : null;
                numberList.put(invUpdateType.getNumber(), invUpdateType.getName());
                if (this.currentCUID.equals(cu)) continue;
                isNotCUEnable = true;
                pks.remove(invUpdateType.getId().toString());
            }
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)this.bdScmImRes, (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        ArrayList errors = InvUpdateTypeFactory.getRemoteInstance().setStatus(pks, status);
        String logItemName = null;
        String methodName = null;
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            logItemName = "invupdatetype_enable";
            methodName = ResourceUtil.getMessage(null, (String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"enable", null);
        } else {
            logItemName = "invupdatetype_disable";
            methodName = ResourceUtil.getMessage(null, (String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"disable", null);
        }
        SCMUtil.setLog(null, numberList, (String)logItemName, (String)methodName, (String)"C2EF7ADF");
        StringBuffer errMsg = new StringBuffer();
        String msg = null;
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.refresh(null);
        this.setMessageText(msg);
        this.showMessage();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void initKeyStroke() {
        super.initKeyStroke();
        InputMap inputMap = this.tblMain.getInputMap(2);
        ActionMap actionMap = this.tblMain.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(77, 3), "actionShowUpgradeBtn");
        actionMap.put("actionShowUpgradeBtn", (Action)((Object)this.actionShowBtnUpgrade));
        this.actionShowBtnUpgrade.setEnabled(true);
    }

    @Override
    public void actionShowBtnUpgrade_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnUpgrade.isVisible()) {
            this.btnUpgrade.setVisible(false);
        } else {
            this.btnUpgrade.setVisible(true);
        }
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.scm.im.inv.client.InvBillInvUpdateTypeUpgradeUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected String getEditUIName() {
        return InvUpdateTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InvUpdateTypeFactory.getRemoteInstance();
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("cu.id"));
        selector.add(new SelectorItemInfo("status"));
        return selector;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("status"));
        return sic;
    }

    protected boolean isLazyMode() {
        return true;
    }
}

