/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationGroupInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractLocationEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LocationEditUI
extends AbstractLocationEditUI {
    public static final Color NECESSARYCOLOR = SCMConstant.NECESSARYCOLOR;
    private String currentCUID;
    private static final Logger logger = CoreUIObject.getLogger(LocationEditUI.class);

    public String getUITitle() {
        String strTitle = null;
        if ("ADDNEW".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationAddNew");
        } else if ("EDIT".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationEdit");
        } else if ("VIEW".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationView");
        }
        return strTitle;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.prmtWarehouse.requestFocus();
    }

    public void onLoad() throws Exception {
        this.currentCUID = ((CtrlUnitInfo)this.getUIContext().get("orgCu")).getId().toString();
        super.onLoad();
        this.btnRemove.setVisible(true);
        EntityViewInfo entityView = this.prmtWarehouse.getEntityViewInfo();
        FilterInfo filter = entityView.getFilter();
        filter.appendFilterItem("whState", (Object)"1");
        entityView.setFilter(filter);
        entityView.getSelector().remove(new SelectorItemInfo("defaultLocationGroup.id"));
        this.prmtWarehouse.setEntityViewInfo(entityView);
        this.prmtLocationGroup.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.LocationGroupQuery");
        EntityViewInfo locationEvi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        String wareId = ((WarehouseInfo)this.prmtWarehouse.getValue()).getId().toString();
        fil.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)wareId));
        locationEvi.setFilter(fil);
        this.prmtLocationGroup.setEntityViewInfo(locationEvi);
        this.prmtWarehouse.getEditor().setBackground(NECESSARYCOLOR);
        this.txtNumber.setBackground(NECESSARYCOLOR);
        this.txtName.setBackground(NECESSARYCOLOR);
        this.TransState.setBackground(NECESSARYCOLOR);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("HASLOCATION", (Object)new Boolean(true), CompareType.EQUALS));
        evi.setFilter(fi);
        this.prmtWarehouse.setEntityViewInfo(evi);
        this.setControlState();
        this.setNumberEnabled();
        this.TransState.setEnabled(false);
    }

    private void setControlState() {
        this.prmtWarehouse.setAccessAuthority(0);
        this.prmtLocationGroup.setAccessAuthority(0);
        this.TransState.setAccessAuthority(0);
        boolean hasLocationLevel = ((WarehouseInfo)this.prmtWarehouse.getValue()).getBoolean("hasLocationLevel");
        if (hasLocationLevel) {
            if ("VIEW".equals(this.getOprtState())) {
                this.prmtLocationGroup.setEnabled(true);
            }
        } else {
            this.prmtLocationGroup.setEnabled(false);
            this.prmtLocationGroup.setEditable(false);
        }
        this.prmtWarehouse.setEnabled(false);
        this.prmtWarehouse.setEditable(false);
        this.TransState.setEnabled(false);
        this.TransState.setEditable(false);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            LocationGroupInfo lo = (LocationGroupInfo)this.getUIContext().get("locatioinGroup");
            dataObject.put("warehouse", (Object)lo.getWarehouse());
            dataObject.put("State", this.getUIContext().get("State"));
            dataObject.put("locationGroup", (Object)lo);
        }
        super.setDataObject(dataObject);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return LocationEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LocationFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        LocationInfo objectValue = new LocationInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setTransState(TransStateEnum.GENERAL);
        objectValue.setCU((CtrlUnitInfo)this.getUIContext().get("orgCu"));
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String message = null;
        if (this.prmtWarehouse.getText().trim().equals("") || this.prmtWarehouse.getValue() == null) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationEditUI_WarehouseIsNull");
            this.prmtWarehouse.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (((WarehouseInfo)this.prmtWarehouse.getValue()).getBoolean("hasLocationLevel") && (this.prmtLocationGroup.getText().trim() == "" || this.prmtLocationGroup.getValue() == null)) {
            this.prmtLocationGroup.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationEditUI_LocationGroupIsNull"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0 && this.isCheckNumber()) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationEditUI_LocationNumberIsNull");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            if (this.checkNumberIsDup(this.editData)) {
                message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NUMERISDUP");
                this.txtNumber.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.LocationEditUI_LocationNameIsNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getEditor().getItem().toString().trim());
            this.txtName.requestFocus();
            if (this.checkNameIsDup(this.editData)) {
                message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NAMEISDUP");
                this.txtName.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
        }
        if (this.TransState.getSelectedIndex() < 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_TransStateIsNull");
            this.TransState.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }

    private boolean checkNumberIsDup(LocationInfo editData) throws BOSException, EASBizException {
        if (editData.getWarehouse() != null) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("Warehouse", (Object)editData.getWarehouse().getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)editData.getNumber(), CompareType.EQUALS));
            if (editData.getId() != null) {
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)editData.getId().toString(), CompareType.NOTEQUALS));
            }
            ILocation il = LocationFactory.getRemoteInstance();
            return il.exists(fi);
        }
        return false;
    }

    private boolean checkNameIsDup(LocationInfo editData) throws BOSException, EASBizException {
        if (editData.getWarehouse() != null) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("Warehouse", (Object)editData.getWarehouse().getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("name", (Object)editData.getName(), CompareType.EQUALS));
            if (editData.getId() != null) {
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)editData.getId().toString(), CompareType.NOTEQUALS));
            }
            ILocation il = LocationFactory.getRemoteInstance();
            return il.exists(fi);
        }
        return false;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        EntityControlTypeUtil.checkCanAddnew((String)"S3", (String)this.currentCUID);
        super.actionAddNew_actionPerformed(e);
        this.setNumberEnabled();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        ILocation il = LocationFactory.getRemoteInstance();
        LocationInfo li = il.getLocationInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = li.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        super.actionEdit_actionPerformed(e);
        this.setControlState();
        this.setNumberEnabled();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ILocation il = LocationFactory.getRemoteInstance();
        LocationInfo li = il.getLocationInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = BDInvClientUtils.getCUID(li);
        if (cuid != null) {
            EntityControlTypeUtil.checkCanRemove((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (this.editData.getState() == WHStateEnum.ACTIVE || this.editData.getState() == WHStateEnum.INACTIVE) {
            String message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.DeleteLocationNotSave");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText("");
        this.setNumberEnabled();
    }

    public void setNumberEnabled() {
        if (this.editData == null) {
            return;
        }
        try {
            boolean isAddView;
            boolean isAutoNumber = this.isAutoNumber();
            if (this.getOprtState().equals("ADDNEW") && isAutoNumber && (isAddView = this.isAddView()) && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.setText(FrameWorkUtils.getCodeRuleClient((CoreBaseInfo)this.editData, (String)this.editData.getCU().getId().toString()));
                this.editData.setNumber(this.txtNumber.getText());
                this.initOldData((IObjectValue)this.editData);
            }
            this.txtNumber.setEditable(!isAutoNumber);
            this.txtNumber.setRequired(!isAutoNumber);
            if (isAutoNumber) {
                this.txtNumber.requestFocus();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean isAddView() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isAddView((IObjectValue)this.editData, this.currentCUID);
    }

    protected boolean isAutoNumber() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist((IObjectValue)this.editData, this.currentCUID.toString());
    }

    private boolean isCheckNumber() throws CodingRuleException, EASBizException, BOSException {
        return !this.isAutoNumber() || this.isAddView();
    }
}

