/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationGroupFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationGroupInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractLocationGroupEditUI;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LocationGroupEditUI
extends AbstractLocationGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LocationGroupEditUI.class);
    private LocationGroupInfo defaultGroupInfo = null;
    private LocationGroupInfo groupInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtParent.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.LocationGroupQuery");
        EntityViewInfo locationEvi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        String wareId = ((WarehouseInfo)this.prmtWarehouse.getValue()).getId().toString();
        fil.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)wareId));
        locationEvi.setFilter(fil);
        this.prmtParent.setEntityViewInfo(locationEvi);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        String status;
        super.loadFields();
        if (this.getUIContext().get("status") != null && (status = (String)this.getUIContext().get("status")).equals("edit")) {
            LocationGroupInfo lo = (LocationGroupInfo)this.getUIContext().get("ParentNode");
            this.txtNumber.setText(lo.getNumber());
            this.txtLocationGroupName.setSelectedItemData((Object)lo.getName().toString());
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        CtrlUnitInfo curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        LocationGroupInfo locationGroupInfo = new LocationGroupInfo();
        LocationGroupInfo parentInfo = (LocationGroupInfo)this.getUIContext().get("ParentNode");
        WarehouseInfo warehouseInfo = null;
        try {
            warehouseInfo = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(parentInfo.getWarehouse().getId()));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtWarehouse.setEnabled(false);
        this.prmtParent.setEnabled(false);
        this.prmtParent.setData((Object)parentInfo);
        locationGroupInfo.setWarehouse(warehouseInfo);
        locationGroupInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        locationGroupInfo.setCU(curCtrlUnitInfo);
        return locationGroupInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LocationGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState()) && ((LocationGroupInfo)dataObject).getParent() == null) {
            ((LocationGroupInfo)dataObject).setParent((LocationGroupInfo)this.getUIContext().get("ParentNode"));
        } else if ("EDIT".equals(this.getOprtState()) && (LocationGroupInfo)dataObject != null) {
            try {
                LocationGroupInfo editGroupInfo = (LocationGroupInfo)this.getUIContext().get("ParentNode");
                ((LocationGroupInfo)dataObject).setWarehouse(editGroupInfo.getWarehouse());
                ((LocationGroupInfo)dataObject).setCU(CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(editGroupInfo.getCU().getId())));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if ("VIEW".equals(this.getOprtState()) && (LocationGroupInfo)dataObject != null) {
            try {
                LocationGroupInfo editGroupInfo = (LocationGroupInfo)this.getUIContext().get("ParentNode");
                ((LocationGroupInfo)dataObject).setParent(LocationGroupFactory.getRemoteInstance().getLocationGroupInfo((IObjectPK)new ObjectUuidPK(editGroupInfo.getParent().getId())));
                ((LocationGroupInfo)dataObject).setWarehouse(editGroupInfo.getWarehouse());
                ((LocationGroupInfo)dataObject).setCU(CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(editGroupInfo.getCU().getId())));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        super.setDataObject(dataObject);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber == null || this.txtNumber.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NumberNotNull"));
            SysUtil.abort();
        }
        if (this.txtLocationGroupName.getSelectedItem().toString().trim().equals("") || this.txtLocationGroupName.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull"));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.txtNumber.setText(((LocationGroupInfo)this.editData).getNumber());
        this.txtLocationGroupName.setSelectedItemData((Object)((LocationGroupInfo)this.editData).getName());
        this.prmtParent.setData((Object)((LocationGroupInfo)this.editData).getParent());
        this.prmtWarehouse.setData((Object)((LocationGroupInfo)this.editData).getWarehouse());
    }
}

